/*
 * Decompiled with CFR 0.152.
 */
package bayesnet.jayes.io.jbif;

import bayesnet.jayes.BayesNet;
import bayesnet.jayes.BayesNode;
import bayesnet.jayes.io.IBayesNetWriter;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import org.apache.commons.io.IOUtils;

public class JayesBifWriter
implements IBayesNetWriter {
    private static final int HEADER_BYTES = 8;
    private OutputStream out;

    public JayesBifWriter(OutputStream out) {
        this.out = out;
    }

    @Override
    public void write(BayesNet bayesNet) throws IOException {
        IOUtils.write((byte[])this.writeToArray(bayesNet), (OutputStream)this.out);
    }

    private byte[] writeToArray(BayesNet bayesNet) {
        ByteBuffer buffer = ByteBuffer.allocate(this.estimateBinarySize(bayesNet));
        this.putHeader(buffer);
        this.putBayesNet(bayesNet, buffer);
        byte[] out = new byte[buffer.position()];
        System.arraycopy(buffer.array(), 0, out, 0, buffer.position());
        return out;
    }

    private int estimateBinarySize(BayesNet bayesNet) {
        int size = 8;
        size += this.estimateBinarySize(bayesNet.getName());
        size += 4;
        for (BayesNode node : bayesNet.getNodes()) {
            size += this.estimateBinarySize(node);
        }
        return size;
    }

    private int estimateBinarySize(String string) {
        return 2 + string.length() * 4;
    }

    private int estimateBinarySize(BayesNode node) {
        int size = 0;
        size += this.estimateBinarySize(node.getName());
        size += 4;
        for (String outcome : node.getOutcomes()) {
            size += this.estimateBinarySize(outcome);
        }
        size += 1 + 4 * node.getParents().size();
        return size += 4 + 8 * node.getProbabilities().length;
    }

    private void putHeader(ByteBuffer buffer) {
        buffer.putInt(-1166124257);
        buffer.putInt(1);
    }

    private void putBayesNet(BayesNet bayesNet, ByteBuffer buffer) {
        this.putName(bayesNet.getName(), buffer);
        buffer.putInt(bayesNet.getNodes().size());
        for (BayesNode node : bayesNet.getNodes()) {
            this.putNodeDeclaration(node, buffer);
        }
        for (BayesNode node : bayesNet.getNodes()) {
            this.putNodeDefinition(node, buffer);
        }
    }

    private void putName(String string, ByteBuffer buffer) {
        byte[] utf8 = string.getBytes(Charsets.UTF_8);
        Preconditions.checkArgument((utf8.length < 131072 ? 1 : 0) != 0);
        short byteCount = (short)utf8.length;
        buffer.putShort(byteCount);
        buffer.put(utf8);
    }

    private void putNodeDeclaration(BayesNode node, ByteBuffer buffer) {
        this.putName(node.getName(), buffer);
        buffer.putInt(node.getOutcomeCount());
        for (String outcome : node.getOutcomes()) {
            this.putName(outcome, buffer);
        }
    }

    private void putNodeDefinition(BayesNode node, ByteBuffer buffer) {
        this.putParents(node, buffer);
        this.putCpt(node, buffer);
    }

    private void putParents(BayesNode node, ByteBuffer buffer) {
        int parentCount = node.getParents().size();
        Preconditions.checkArgument((parentCount < 512 ? 1 : 0) != 0);
        buffer.put((byte)parentCount);
        for (BayesNode p : node.getParents()) {
            buffer.putInt(p.getId());
        }
    }

    private void putCpt(BayesNode node, ByteBuffer buffer) {
        buffer.putInt(node.getProbabilities().length);
        DoubleBuffer asDoubleBuffer = buffer.asDoubleBuffer();
        asDoubleBuffer.put(node.getProbabilities());
        buffer.position(buffer.position() + asDoubleBuffer.position() * 8);
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

