/*
 * Decompiled with CFR 0.152.
 */
package bayesnet.jayes.factor;

import bayesnet.jayes.factor.Cut;
import bayesnet.jayes.factor.arraywrapper.DoubleArrayWrapper;
import bayesnet.jayes.factor.arraywrapper.IArrayWrapper;
import bayesnet.jayes.factor.opcache.DivisionCache;
import bayesnet.jayes.factor.opcache.ModuloCache;
import bayesnet.jayes.util.MathUtils;
import java.util.Arrays;

public abstract class AbstractFactor
implements Cloneable {
    protected int[] dimensions = new int[0];
    protected int[] dimensionIDs = new int[0];
    protected IArrayWrapper values = new DoubleArrayWrapper(0.0);
    protected int[] selections = new int[0];
    protected Cut cut = new Cut(this);
    private boolean isCutValid = false;
    private boolean isLogScale = false;

    public abstract void copyValues(IArrayWrapper var1);

    public abstract int[] prepareMultiplication(AbstractFactor var1);

    protected abstract int getRealPosition(int var1);

    public abstract void fill(double var1);

    public void setValues(IArrayWrapper values) {
        this.values = values;
        assert (MathUtils.product(this.dimensions) == values.length());
    }

    public IArrayWrapper getValues() {
        return this.values;
    }

    public double getValue(int i) {
        return this.values.getDouble(this.getRealPosition(i));
    }

    public void setDimensions(int ... dimensions) {
        this.dimensions = Arrays.copyOf(dimensions, dimensions.length);
        this.selections = new int[dimensions.length];
        this.resetSelections();
        int length = MathUtils.product(dimensions);
        if (length > this.values.length()) {
            this.values.newArray(length);
        }
        this.dimensionIDs = Arrays.copyOf(this.dimensionIDs, dimensions.length);
    }

    public int[] getDimensions() {
        return this.dimensions;
    }

    public void setDimensionIDs(int ... ids) {
        this.dimensionIDs = (int[])ids.clone();
    }

    public int[] getDimensionIDs() {
        return this.dimensionIDs;
    }

    protected int getDimensionFromID(int id) {
        for (int i = 0; i < this.dimensionIDs.length; ++i) {
            if (this.dimensionIDs[i] != id) continue;
            return i;
        }
        return -1;
    }

    public void select(int dimensionID, int index) {
        int dim = this.getDimensionFromID(dimensionID);
        if (this.selections[dim] != index) {
            this.selections[dim] = index;
            this.isCutValid = false;
        }
    }

    public void resetSelections() {
        Arrays.fill(this.selections, -1);
        this.isCutValid = false;
    }

    public void setLogScale(boolean isLogScale) {
        this.isLogScale = isLogScale;
    }

    public boolean isLogScale() {
        return this.isLogScale;
    }

    @Deprecated
    public double[] marginalizeAllBut(int sumDimensionID) {
        this.validateCut();
        if (sumDimensionID == -1) {
            sumDimensionID = this.dimensionIDs[this.dimensionIDs.length - 1];
        }
        int sumDimension = this.getDimensionFromID(sumDimensionID);
        double[] result = new double[this.dimensions[sumDimension]];
        int divisor = MathUtils.productOfRange(this.dimensions, sumDimension + 1, this.dimensions.length);
        DivisionCache division = new DivisionCache(divisor);
        this.sumToBucket(this.cut, 0, division, new ModuloCache(result.length), result);
        return result;
    }

    private void sumToBucket(Cut cut, int offset, DivisionCache division, ModuloCache modulo, double[] result) {
        if (cut.getSubCut() == null) {
            int last = cut.getEnd() + offset;
            for (int i = cut.getStart() + offset; i < last; i += cut.getStepSize()) {
                int targetPos;
                int j = this.getRealPosition(i);
                int n = targetPos = modulo.apply(division.apply(i));
                result[n] = result[n] + this.values.getDouble(j);
            }
        } else {
            Cut c = cut.getSubCut();
            for (int i = 0; i < cut.getLength(); i += cut.getSubtreeStepsize()) {
                this.sumToBucket(c, offset + i, division, modulo, result);
            }
        }
    }

    public void multiplyCompatible(AbstractFactor compatible) {
        int[] positions = this.prepareMultiplication(compatible);
        this.multiplyPrepared(compatible.values, positions);
    }

    public void multiplyPrepared(IArrayWrapper compatibleValues, int[] positions) {
        this.validateCut();
        if (!this.isLogScale) {
            this.multiplyPrepared(this.cut, 0, compatibleValues, positions);
        } else {
            this.multiplyPreparedLog(this.cut, 0, compatibleValues, positions);
        }
    }

    private void multiplyPrepared(Cut cut, int offset, IArrayWrapper compatibleValues, int[] positions) {
        if (cut.getSubCut() == null) {
            int last = cut.getEnd() + offset;
            for (int i = cut.getStart() + offset; i < last; i += cut.getStepSize()) {
                int j = this.getRealPosition(i);
                this.values.mulAssign(j, compatibleValues, positions[j]);
            }
        } else {
            Cut c = cut.getSubCut();
            for (int i = 0; i < cut.getLength(); i += cut.getSubtreeStepsize()) {
                this.multiplyPrepared(c, offset + i, compatibleValues, positions);
            }
        }
    }

    public void sumPrepared(IArrayWrapper compatibleFactorValues, int[] preparedOperation) {
        this.validateCut();
        compatibleFactorValues.fill(0.0f);
        if (!this.isLogScale) {
            this.sumPrepared(this.cut, 0, compatibleFactorValues, preparedOperation);
        } else {
            this.sumPreparedLog(compatibleFactorValues, preparedOperation);
        }
    }

    private void sumPrepared(Cut cut, int offset, IArrayWrapper compatibleFactorValues, int[] positions) {
        if (cut.getSubCut() == null) {
            int last = cut.getEnd() + offset;
            for (int i = cut.getStart() + offset; i < last; i += cut.getStepSize()) {
                int j = this.getRealPosition(i);
                compatibleFactorValues.addAssign(positions[j], this.values, j);
            }
        } else {
            Cut c = cut.getSubCut();
            for (int i = 0; i < cut.getLength(); i += cut.getSubtreeStepsize()) {
                this.sumPrepared(c, offset + i, compatibleFactorValues, positions);
            }
        }
    }

    private void sumPreparedLog(IArrayWrapper compatibleFactorValues, int[] positions) {
        double max = this.findMax(this.cut, 0, 0.0);
        this.sumPreparedLog(this.cut, 0, compatibleFactorValues, positions, max);
        for (int i = 0; i < compatibleFactorValues.length(); ++i) {
            compatibleFactorValues.set(i, Math.log(compatibleFactorValues.getDouble(i)) + max);
        }
    }

    private double findMax(Cut cut, int offset, double max) {
        if (cut.getSubCut() == null) {
            int last = cut.getEnd() + offset;
            for (int i = cut.getStart() + offset; i < last; i += cut.getStepSize()) {
                int j = this.getRealPosition(i);
                if (this.values.getDouble(j) == Double.NEGATIVE_INFINITY || !(Math.abs(this.values.getDouble(j)) > Math.abs(max))) continue;
                max = this.values.getDouble(j);
            }
        } else {
            Cut c = cut.getSubCut();
            for (int i = 0; i < cut.getLength(); i += cut.getSubtreeStepsize()) {
                double pot = this.findMax(c, offset + i, max);
                if (pot == Double.NEGATIVE_INFINITY || !(Math.abs(pot) > Math.abs(max))) continue;
                max = pot;
            }
        }
        return max;
    }

    private void sumPreparedLog(Cut cut, int offset, IArrayWrapper compatibleFactorValues, int[] positions, double max) {
        if (cut.getSubCut() == null) {
            int last = cut.getEnd() + offset;
            for (int i = cut.getStart() + offset; i < last; i += cut.getStepSize()) {
                int j = this.getRealPosition(i);
                compatibleFactorValues.addAssign(positions[j], Math.exp(this.values.getDouble(j) - max));
            }
        } else {
            Cut c = cut.getSubCut();
            for (int i = 0; i < cut.getLength(); i += cut.getSubtreeStepsize()) {
                this.sumPreparedLog(c, offset + i, compatibleFactorValues, positions, max);
            }
        }
    }

    private void multiplyPreparedLog(Cut cut, int offset, IArrayWrapper compatibleValues, int[] positions) {
        if (cut.getSubCut() == null) {
            int last = cut.getEnd() + offset;
            for (int i = cut.getStart() + offset; i < last; i += cut.getStepSize()) {
                int j = this.getRealPosition(i);
                this.values.addAssign(j, compatibleValues, positions[j]);
            }
        } else {
            Cut c = cut.getSubCut();
            for (int i = 0; i < cut.getLength(); i += cut.getSubtreeStepsize()) {
                this.multiplyPreparedLog(c, offset + i, compatibleValues, positions);
            }
        }
    }

    protected void validateCut() {
        if (!this.isCutValid) {
            this.cut.initialize();
            this.isCutValid = true;
        }
    }

    public AbstractFactor clone() {
        AbstractFactor f = null;
        try {
            f = (AbstractFactor)super.clone();
        }
        catch (CloneNotSupportedException x) {
            throw new RuntimeException(x);
        }
        f.values = this.values.clone();
        f.selections = (int[])this.selections.clone();
        f.cut = new Cut(f);
        f.isCutValid = false;
        return f;
    }

    public void multiplyCompatibleToLog(AbstractFactor factor) {
        int[] positions = this.prepareMultiplication(factor);
        for (int i = 0; i < this.values.length(); ++i) {
            this.values.addAssign(i, Math.log(factor.values.getDouble(positions[i])));
        }
    }

    public abstract int getOverhead();
}

