/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.jblas.complex;

import org.nd4j.linalg.api.complex.IComplexDouble;
import org.nd4j.linalg.api.complex.IComplexFloat;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.factory.Nd4j;

public class ComplexFloat
extends org.jblas.ComplexFloat
implements IComplexFloat {
    public static final ComplexFloat UNIT = new ComplexFloat(1.0f, 0.0f);
    public static final ComplexFloat NEG = new ComplexFloat(-1.0f, 0.0f);
    public static final ComplexFloat ZERO = new ComplexFloat(0.0f, 0.0f);

    public ComplexFloat(org.jblas.ComplexFloat c) {
        super(c.real(), c.imag());
    }

    public ComplexFloat(float real, float imag) {
        super(real, imag);
    }

    public ComplexFloat(float real) {
        super(real);
    }

    @Override
    public float arg() {
        return super.arg();
    }

    @Override
    public float abs() {
        return super.abs();
    }

    @Override
    public IComplexDouble asDouble() {
        return Nd4j.createDouble(this.realComponent().floatValue(), this.imaginaryComponent().floatValue());
    }

    @Override
    public ComplexFloat asFloat() {
        return this;
    }

    @Override
    public ComplexFloat dup() {
        return new ComplexFloat(this.realComponent().floatValue(), this.imaginaryComponent().floatValue());
    }

    @Override
    public ComplexFloat conji() {
        super.set(this.realComponent().floatValue(), -this.imaginaryComponent().floatValue());
        return this;
    }

    @Override
    public ComplexFloat conj() {
        return this.dup().conji();
    }

    @Override
    public IComplexNumber set(Number real, Number imag) {
        super.set(real.floatValue(), imag.floatValue());
        return this;
    }

    @Override
    public IComplexNumber copy(IComplexNumber other) {
        return null;
    }

    @Override
    public IComplexNumber addi(IComplexNumber c, IComplexNumber result) {
        if (this == result) {
            this.set(this.real() + c.realComponent().floatValue(), this.imag() + result.imaginaryComponent().floatValue());
        } else {
            result.set(Float.valueOf(result.realComponent().floatValue() + c.realComponent().floatValue()), Float.valueOf(result.imaginaryComponent().floatValue() + c.imaginaryComponent().floatValue()));
        }
        return this;
    }

    @Override
    public IComplexNumber addi(IComplexNumber c) {
        return this.addi(c, (IComplexNumber)this);
    }

    @Override
    public IComplexNumber add(IComplexNumber c) {
        return this.dup().addi(c);
    }

    @Override
    public IComplexNumber addi(Number a, IComplexNumber result) {
        if (this == result) {
            this.set(this.real() + a.floatValue(), this.imag() + a.floatValue());
        } else {
            result.set(Float.valueOf(result.realComponent().floatValue() + a.floatValue()), Float.valueOf(this.imaginaryComponent().floatValue() + a.floatValue()));
        }
        return result;
    }

    @Override
    public IComplexNumber addi(Number c) {
        return this.addi(c, (IComplexNumber)this);
    }

    @Override
    public IComplexNumber add(Number c) {
        return this.dup().addi(c);
    }

    @Override
    public IComplexNumber subi(IComplexNumber c, IComplexNumber result) {
        if (this == result) {
            this.set(this.real() - c.realComponent().floatValue(), this.imag() - result.imaginaryComponent().floatValue());
        } else {
            result.set(Float.valueOf(result.realComponent().floatValue() - c.realComponent().floatValue()), Float.valueOf(result.imaginaryComponent().floatValue() - c.imaginaryComponent().floatValue()));
        }
        return this;
    }

    @Override
    public IComplexNumber subi(IComplexNumber c) {
        return this.subi(c, (IComplexNumber)this);
    }

    @Override
    public IComplexNumber sub(IComplexNumber c) {
        return this.dup().subi(c);
    }

    @Override
    public IComplexNumber subi(Number a, IComplexNumber result) {
        if (this == result) {
            this.set(this.real() - a.floatValue(), this.imag() - a.floatValue());
        } else {
            result.set(Float.valueOf(result.realComponent().floatValue() - a.floatValue()), Float.valueOf(this.imaginaryComponent().floatValue() - a.floatValue()));
        }
        return result;
    }

    @Override
    public IComplexNumber subi(Number a) {
        return this.subi(a, (IComplexNumber)this);
    }

    @Override
    public IComplexNumber sub(Number r) {
        return this.dup().subi(r);
    }

    @Override
    public IComplexNumber muli(IComplexNumber c, IComplexNumber result) {
        float newR = this.real() * c.realComponent().floatValue() - this.imag() * c.imaginaryComponent().floatValue();
        float newI = this.real() * c.imaginaryComponent().floatValue() + this.imag() * c.realComponent().floatValue();
        result.set(Float.valueOf(newR), Float.valueOf(newI));
        return result;
    }

    @Override
    public IComplexNumber muli(IComplexNumber c) {
        return this.muli(c, (IComplexNumber)this);
    }

    @Override
    public IComplexNumber mul(IComplexNumber c) {
        return this.dup().muli(c);
    }

    @Override
    public IComplexNumber mul(Number v) {
        return this.dup().muli(v);
    }

    @Override
    public IComplexNumber muli(Number v, IComplexNumber result) {
        if (this == result) {
            this.set(this.real() * v.floatValue(), this.imag() * v.floatValue());
        } else {
            result.set(Float.valueOf(result.realComponent().floatValue() * v.floatValue()), Float.valueOf(this.imaginaryComponent().floatValue() * v.floatValue()));
        }
        return result;
    }

    @Override
    public IComplexNumber muli(Number v) {
        return this.muli(v, (IComplexNumber)this);
    }

    @Override
    public IComplexNumber div(IComplexNumber c) {
        return this.dup().divi(c);
    }

    @Override
    public IComplexNumber divi(IComplexNumber c, IComplexNumber result) {
        float d = c.realComponent().floatValue() * c.realComponent().floatValue() + c.imaginaryComponent().floatValue() * c.imaginaryComponent().floatValue();
        float newR = (this.real() * c.realComponent().floatValue() + this.imag() * c.imaginaryComponent().floatValue()) / d;
        float newI = (this.imag() * c.realComponent().floatValue() - this.real() * c.imaginaryComponent().floatValue()) / d;
        result.set(Float.valueOf(newR), Float.valueOf(newI));
        return result;
    }

    @Override
    public IComplexNumber divi(IComplexNumber c) {
        return this.divi(c, (IComplexNumber)this);
    }

    @Override
    public IComplexNumber divi(Number v, IComplexNumber result) {
        if (this == result) {
            this.set(this.real() / v.floatValue(), this.imag());
        } else {
            result.set(Float.valueOf(result.realComponent().floatValue() / v.floatValue()), this.imaginaryComponent());
        }
        return result;
    }

    @Override
    public IComplexNumber divi(Number v) {
        return this.divi(v, (IComplexNumber)this);
    }

    @Override
    public IComplexNumber div(Number v) {
        return this.dup().divi(v);
    }

    @Override
    public boolean eq(IComplexNumber c) {
        return false;
    }

    @Override
    public boolean ne(IComplexNumber c) {
        return false;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public org.jblas.ComplexFloat set(float real, float imag) {
        return super.set(real, imag);
    }

    @Override
    public float real() {
        return super.real();
    }

    @Override
    public float imag() {
        return super.imag();
    }

    @Override
    public Float realComponent() {
        return Float.valueOf(super.real());
    }

    @Override
    public Float imaginaryComponent() {
        return Float.valueOf(super.imag());
    }

    @Override
    public org.jblas.ComplexFloat copy(org.jblas.ComplexFloat other) {
        return super.copy(other);
    }

    @Override
    public org.jblas.ComplexFloat addi(org.jblas.ComplexFloat c, org.jblas.ComplexFloat result) {
        return super.addi(c, result);
    }

    @Override
    public org.jblas.ComplexFloat addi(org.jblas.ComplexFloat c) {
        return super.addi(c);
    }

    @Override
    public org.jblas.ComplexFloat add(org.jblas.ComplexFloat c) {
        return super.add(c);
    }

    @Override
    public org.jblas.ComplexFloat addi(float a, org.jblas.ComplexFloat result) {
        return super.addi(a, result);
    }

    @Override
    public org.jblas.ComplexFloat addi(float c) {
        return super.addi(c);
    }

    @Override
    public org.jblas.ComplexFloat add(float c) {
        return super.add(c);
    }

    @Override
    public org.jblas.ComplexFloat subi(org.jblas.ComplexFloat c, org.jblas.ComplexFloat result) {
        return super.subi(c, result);
    }

    @Override
    public org.jblas.ComplexFloat subi(org.jblas.ComplexFloat c) {
        return super.subi(c);
    }

    @Override
    public org.jblas.ComplexFloat sub(org.jblas.ComplexFloat c) {
        return super.sub(c);
    }

    @Override
    public org.jblas.ComplexFloat subi(float a, org.jblas.ComplexFloat result) {
        return super.subi(a, result);
    }

    @Override
    public org.jblas.ComplexFloat subi(float a) {
        return super.subi(a);
    }

    @Override
    public org.jblas.ComplexFloat sub(float r) {
        return super.sub(r);
    }

    @Override
    public org.jblas.ComplexFloat muli(org.jblas.ComplexFloat c, org.jblas.ComplexFloat result) {
        return super.muli(c, result);
    }

    @Override
    public org.jblas.ComplexFloat muli(org.jblas.ComplexFloat c) {
        return super.muli(c);
    }

    @Override
    public org.jblas.ComplexFloat mul(org.jblas.ComplexFloat c) {
        return super.mul(c);
    }

    @Override
    public org.jblas.ComplexFloat mul(float v) {
        return super.mul(v);
    }

    @Override
    public org.jblas.ComplexFloat muli(float v, org.jblas.ComplexFloat result) {
        return super.muli(v, result);
    }

    @Override
    public org.jblas.ComplexFloat muli(float v) {
        return super.muli(v);
    }

    @Override
    public ComplexFloat div(org.jblas.ComplexFloat c) {
        return this.dup().divi(c);
    }

    @Override
    public org.jblas.ComplexFloat divi(org.jblas.ComplexFloat c, org.jblas.ComplexFloat result) {
        return super.divi(c, result);
    }

    @Override
    public ComplexFloat divi(org.jblas.ComplexFloat c) {
        super.divi(c);
        return this;
    }

    @Override
    public ComplexFloat divi(float v, org.jblas.ComplexFloat result) {
        super.divi(v, result);
        return this;
    }

    @Override
    public ComplexFloat divi(float v) {
        super.divi(v);
        return this;
    }

    @Override
    public ComplexFloat div(float v) {
        super.div(v);
        return this;
    }

    @Override
    public Float absoluteValue() {
        return Float.valueOf(super.abs());
    }

    @Override
    public Float complexArgument() {
        return Float.valueOf((float)Math.acos(this.realComponent().floatValue() / this.absoluteValue().floatValue()));
    }

    @Override
    public ComplexFloat invi() {
        float d = this.realComponent().floatValue() * this.realComponent().floatValue() + this.imaginaryComponent().floatValue() * this.imaginaryComponent().floatValue();
        this.set(this.realComponent().floatValue() / d, -this.imaginaryComponent().floatValue() / d);
        return this;
    }

    @Override
    public ComplexFloat inv() {
        return this.dup().invi();
    }

    @Override
    public ComplexFloat neg() {
        return this.dup().negi();
    }

    @Override
    public ComplexFloat negi() {
        this.set(-this.realComponent().floatValue(), -this.imaginaryComponent().floatValue());
        return this;
    }

    @Override
    public ComplexFloat sqrt() {
        float a = this.absoluteValue().floatValue();
        float s2 = (float)Math.sqrt(2.0);
        float p = (float)Math.sqrt(a + this.realComponent().floatValue()) / s2;
        float q = (float)Math.sqrt(a - this.realComponent().floatValue()) / s2 * Math.signum(this.imaginaryComponent().floatValue());
        return new ComplexFloat(p, q);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public boolean eq(org.jblas.ComplexFloat c) {
        return super.eq(c);
    }

    @Override
    public boolean ne(org.jblas.ComplexFloat c) {
        return super.ne(c);
    }

    @Override
    public boolean isZero() {
        return super.isZero();
    }

    @Override
    public boolean isReal() {
        return (double)this.imaginaryComponent().floatValue() == 0.0;
    }

    @Override
    public boolean isImag() {
        return (double)this.realComponent().floatValue() == 0.0;
    }
}

