/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.jblas.complex;

import org.nd4j.linalg.api.complex.IComplexDouble;
import org.nd4j.linalg.api.complex.IComplexFloat;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.factory.Nd4j;

public class ComplexDouble
extends org.jblas.ComplexDouble
implements IComplexDouble {
    public static final ComplexDouble UNIT = new ComplexDouble(1.0, 0.0);
    public static final ComplexDouble NEG = new ComplexDouble(-1.0, 0.0);
    public static final ComplexDouble ZERO = new ComplexDouble(0.0, 0.0);

    public ComplexDouble(org.jblas.ComplexDouble c) {
        super(c.real(), c.imag());
    }

    public ComplexDouble(double real, double imag) {
        super(real, imag);
    }

    public ComplexDouble(double real) {
        super(real);
    }

    @Override
    public double arg() {
        return super.arg();
    }

    @Override
    public double abs() {
        return super.abs();
    }

    @Override
    public IComplexFloat asFloat() {
        return Nd4j.createFloat((float)this.real(), (float)this.imag());
    }

    @Override
    public IComplexDouble asDouble() {
        return this;
    }

    @Override
    public ComplexDouble dup() {
        return new ComplexDouble(this.realComponent(), this.imaginaryComponent());
    }

    @Override
    public ComplexDouble conji() {
        super.set(this.realComponent(), -this.imaginaryComponent().doubleValue());
        return this;
    }

    @Override
    public ComplexDouble conj() {
        return this.dup().conji();
    }

    @Override
    public IComplexNumber set(Number real, Number imag) {
        super.set(real.doubleValue(), imag.doubleValue());
        return this;
    }

    @Override
    public IComplexNumber copy(IComplexNumber other) {
        return null;
    }

    @Override
    public IComplexNumber addi(IComplexNumber c, IComplexNumber result) {
        if (this == result) {
            this.set(this.real() + c.realComponent().doubleValue(), this.imag() + c.imaginaryComponent().doubleValue());
        } else {
            result.set(result.realComponent().doubleValue() + c.realComponent().doubleValue(), result.imaginaryComponent().doubleValue() + c.imaginaryComponent().doubleValue());
        }
        return this;
    }

    @Override
    public IComplexNumber addi(IComplexNumber c) {
        return this.addi(c, (IComplexNumber)this);
    }

    @Override
    public IComplexNumber add(IComplexNumber c) {
        return this.dup().addi(c);
    }

    @Override
    public IComplexNumber addi(Number a, IComplexNumber result) {
        if (this == result) {
            this.set(this.real() + a.doubleValue(), this.imag() + a.doubleValue());
        } else {
            result.set(result.realComponent().doubleValue() + a.doubleValue(), result.imaginaryComponent().doubleValue() + a.doubleValue());
        }
        return result;
    }

    @Override
    public IComplexNumber addi(Number c) {
        return this.addi(c, (IComplexNumber)this);
    }

    @Override
    public IComplexNumber add(Number c) {
        return this.dup().addi(c);
    }

    @Override
    public IComplexNumber subi(IComplexNumber c, IComplexNumber result) {
        if (this == result) {
            this.set(this.real() - c.realComponent().doubleValue(), this.imag() - c.imaginaryComponent().doubleValue());
        } else {
            result.set(result.realComponent().doubleValue() - c.realComponent().doubleValue(), result.imaginaryComponent().doubleValue() - c.imaginaryComponent().doubleValue());
        }
        return this;
    }

    @Override
    public IComplexNumber subi(IComplexNumber c) {
        return this.subi(c, (IComplexNumber)this);
    }

    @Override
    public IComplexNumber sub(IComplexNumber c) {
        return this.dup().subi(c);
    }

    @Override
    public IComplexNumber subi(Number a, IComplexNumber result) {
        if (this == result) {
            this.set(this.real() - a.doubleValue(), this.imag() - a.doubleValue());
        } else {
            result.set(result.realComponent().doubleValue() - a.doubleValue(), this.imaginaryComponent() - a.doubleValue());
        }
        return result;
    }

    @Override
    public IComplexNumber subi(Number a) {
        return this.subi(a, (IComplexNumber)this);
    }

    @Override
    public IComplexNumber sub(Number r) {
        return this.dup().subi(r);
    }

    @Override
    public IComplexNumber muli(IComplexNumber c, IComplexNumber result) {
        double newR = this.real() * c.realComponent().doubleValue() - this.imag() * c.imaginaryComponent().doubleValue();
        double newI = this.real() * c.imaginaryComponent().doubleValue() + this.imag() * c.realComponent().doubleValue();
        result.set(newR, newI);
        return result;
    }

    @Override
    public IComplexNumber muli(IComplexNumber c) {
        return this.muli(c, (IComplexNumber)this);
    }

    @Override
    public IComplexNumber mul(IComplexNumber c) {
        return this.dup().muli(c);
    }

    @Override
    public IComplexNumber mul(Number v) {
        return this.dup().muli(v);
    }

    @Override
    public IComplexNumber muli(Number v, IComplexNumber result) {
        if (this == result) {
            this.set(this.real() * v.doubleValue(), this.imag() * v.doubleValue());
        } else {
            result.set(result.realComponent().doubleValue() * v.doubleValue(), this.imaginaryComponent() * v.doubleValue());
        }
        return result;
    }

    @Override
    public IComplexNumber muli(Number v) {
        return this.muli(v, (IComplexNumber)this);
    }

    @Override
    public IComplexNumber div(IComplexNumber c) {
        return this.dup().divi(c);
    }

    @Override
    public IComplexNumber divi(IComplexNumber c, IComplexNumber result) {
        double d = c.realComponent().doubleValue() * c.realComponent().doubleValue() + c.imaginaryComponent().doubleValue() * c.imaginaryComponent().doubleValue();
        double newR = (this.real() * c.realComponent().doubleValue() + this.imag() * c.imaginaryComponent().doubleValue()) / d;
        double newI = (this.imag() * c.realComponent().doubleValue() - this.real() * c.imaginaryComponent().doubleValue()) / d;
        result.set(newR, newI);
        return result;
    }

    @Override
    public IComplexNumber divi(IComplexNumber c) {
        return this.divi(c, (IComplexNumber)this);
    }

    @Override
    public IComplexNumber divi(Number v, IComplexNumber result) {
        if (this == result) {
            this.set(this.real() / v.doubleValue(), this.imag());
        } else {
            result.set(result.realComponent().doubleValue() / v.doubleValue(), this.imaginaryComponent());
        }
        return result;
    }

    @Override
    public IComplexNumber divi(Number v) {
        return this.divi(v, (IComplexNumber)this);
    }

    @Override
    public IComplexNumber div(Number v) {
        return this.dup().divi(v);
    }

    @Override
    public boolean eq(IComplexNumber c) {
        return false;
    }

    @Override
    public boolean ne(IComplexNumber c) {
        return false;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public org.jblas.ComplexDouble set(double real, double imag) {
        return super.set(real, imag);
    }

    @Override
    public double real() {
        return super.real();
    }

    @Override
    public double imag() {
        return super.imag();
    }

    @Override
    public Double realComponent() {
        return super.real();
    }

    @Override
    public Double imaginaryComponent() {
        return super.imag();
    }

    @Override
    public org.jblas.ComplexDouble copy(org.jblas.ComplexDouble other) {
        return super.copy(other);
    }

    @Override
    public org.jblas.ComplexDouble addi(org.jblas.ComplexDouble c, org.jblas.ComplexDouble result) {
        return super.addi(c, result);
    }

    @Override
    public org.jblas.ComplexDouble addi(org.jblas.ComplexDouble c) {
        return super.addi(c);
    }

    @Override
    public org.jblas.ComplexDouble add(org.jblas.ComplexDouble c) {
        return super.add(c);
    }

    @Override
    public org.jblas.ComplexDouble addi(double a, org.jblas.ComplexDouble result) {
        return super.addi(a, result);
    }

    @Override
    public org.jblas.ComplexDouble addi(double c) {
        return super.addi(c);
    }

    @Override
    public org.jblas.ComplexDouble add(double c) {
        return super.add(c);
    }

    @Override
    public org.jblas.ComplexDouble subi(org.jblas.ComplexDouble c, org.jblas.ComplexDouble result) {
        return super.subi(c, result);
    }

    @Override
    public org.jblas.ComplexDouble subi(org.jblas.ComplexDouble c) {
        return super.subi(c);
    }

    @Override
    public org.jblas.ComplexDouble sub(org.jblas.ComplexDouble c) {
        return super.sub(c);
    }

    @Override
    public org.jblas.ComplexDouble subi(double a, org.jblas.ComplexDouble result) {
        return super.subi(a, result);
    }

    @Override
    public org.jblas.ComplexDouble subi(double a) {
        return super.subi(a);
    }

    @Override
    public org.jblas.ComplexDouble sub(double r) {
        return super.sub(r);
    }

    @Override
    public org.jblas.ComplexDouble muli(org.jblas.ComplexDouble c, org.jblas.ComplexDouble result) {
        return super.muli(c, result);
    }

    @Override
    public org.jblas.ComplexDouble muli(org.jblas.ComplexDouble c) {
        return super.muli(c);
    }

    @Override
    public org.jblas.ComplexDouble mul(org.jblas.ComplexDouble c) {
        return super.mul(c);
    }

    @Override
    public org.jblas.ComplexDouble mul(double v) {
        return super.mul(v);
    }

    @Override
    public org.jblas.ComplexDouble muli(double v, org.jblas.ComplexDouble result) {
        return super.muli(v, result);
    }

    @Override
    public org.jblas.ComplexDouble muli(double v) {
        return super.muli(v);
    }

    @Override
    public ComplexDouble div(org.jblas.ComplexDouble c) {
        return this.dup().divi(c);
    }

    @Override
    public org.jblas.ComplexDouble divi(org.jblas.ComplexDouble c, org.jblas.ComplexDouble result) {
        return super.divi(c, result);
    }

    @Override
    public ComplexDouble divi(org.jblas.ComplexDouble c) {
        super.divi(c);
        return this;
    }

    @Override
    public ComplexDouble divi(double v, org.jblas.ComplexDouble result) {
        super.divi(v, result);
        return this;
    }

    @Override
    public ComplexDouble divi(double v) {
        super.divi(v);
        return this;
    }

    @Override
    public ComplexDouble div(double v) {
        super.div(v);
        return this;
    }

    @Override
    public Double absoluteValue() {
        return super.abs();
    }

    @Override
    public Double complexArgument() {
        return Math.acos(this.realComponent() / this.absoluteValue());
    }

    @Override
    public ComplexDouble invi() {
        double d = this.realComponent() * this.realComponent() + this.imaginaryComponent() * this.imaginaryComponent();
        this.set(this.realComponent() / d, -this.imaginaryComponent().doubleValue() / d);
        return this;
    }

    @Override
    public ComplexDouble inv() {
        return this.dup().invi();
    }

    @Override
    public ComplexDouble neg() {
        return this.dup().negi();
    }

    @Override
    public ComplexDouble negi() {
        this.set(-this.realComponent().doubleValue(), -this.imaginaryComponent().doubleValue());
        return this;
    }

    @Override
    public ComplexDouble sqrt() {
        double a = this.absoluteValue();
        double s2 = Math.sqrt(2.0);
        double p = Math.sqrt(a + this.realComponent()) / s2;
        double q = Math.sqrt(a - this.realComponent()) / s2 * Math.signum(this.imaginaryComponent());
        return new ComplexDouble(p, q);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public boolean eq(org.jblas.ComplexDouble c) {
        return super.eq(c);
    }

    @Override
    public boolean ne(org.jblas.ComplexDouble c) {
        return super.ne(c);
    }

    @Override
    public boolean isZero() {
        return super.isZero();
    }

    @Override
    public boolean isReal() {
        return this.imaginaryComponent() == 0.0;
    }

    @Override
    public boolean isImag() {
        return this.realComponent() == 0.0;
    }
}

