/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.DistPoolThread;
import edu.jas.util.ExecutableChannels;
import edu.jas.util.ShutdownRequest;
import edu.jas.util.StrategyEnumeration;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class DistThreadPool {
    private final String mfile;
    private static final String DEFAULT_MFILE = "examples/machines.test";
    protected final int threads;
    static final int DEFAULT_SIZE = 3;
    final ExecutableChannels ec;
    protected DistPoolThread[] workers;
    protected int idleworkers = 0;
    protected LinkedList<Runnable> jobstack;
    protected StrategyEnumeration strategy = StrategyEnumeration.LIFO;
    private static final Logger logger = Logger.getLogger(DistThreadPool.class);
    private final boolean debug = true;

    public DistThreadPool() {
        this(StrategyEnumeration.FIFO, 3, null);
    }

    public DistThreadPool(StrategyEnumeration strategy) {
        this(strategy, 3, null);
    }

    public DistThreadPool(int size) {
        this(StrategyEnumeration.FIFO, size, null);
    }

    public DistThreadPool(int size, String mfile) {
        this(StrategyEnumeration.FIFO, size, mfile);
    }

    public DistThreadPool(StrategyEnumeration strategy, int size, String mfile) {
        this.strategy = strategy;
        this.threads = size < 0 ? 0 : size;
        this.mfile = mfile == null || mfile.length() == 0 ? DEFAULT_MFILE : mfile;
        this.jobstack = new LinkedList();
        try {
            this.ec = new ExecutableChannels(this.mfile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("DistThreadPool " + e);
        }
        logger.info((Object)("ec = " + this.ec));
        try {
            this.ec.open(this.threads);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("DistThreadPool " + e);
        }
        logger.info((Object)("ec = " + this.ec));
        this.workers = new DistPoolThread[0];
    }

    public String toString() {
        StringBuffer s = new StringBuffer("DistThreadPool(");
        s.append("threads=" + this.threads);
        s.append(", strategy=" + this.strategy);
        s.append(", exchan=" + this.ec);
        s.append(", workers=" + this.workers.length);
        s.append(")");
        return s.toString();
    }

    public void init() {
        if (this.workers == null || this.workers.length == 0) {
            this.workers = new DistPoolThread[this.threads];
            for (int i = 0; i < this.workers.length; ++i) {
                this.workers[i] = new DistPoolThread(this, this.ec, i);
                this.workers[i].start();
            }
            logger.info((Object)("init: " + this.toString()));
        }
    }

    public int getNumber() {
        if (this.workers == null || this.workers.length < this.threads) {
            this.init();
        }
        return this.workers.length;
    }

    public StrategyEnumeration getStrategy() {
        return this.strategy;
    }

    public ExecutableChannels getEC() {
        return this.ec;
    }

    public void terminate(boolean shutDown) {
        if (shutDown) {
            ShutdownRequest sdr = new ShutdownRequest();
            for (int i = 0; i < this.workers.length; ++i) {
                this.addJob(sdr);
            }
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            logger.info((Object)("remaining jobs = " + this.jobstack.size()));
            try {
                for (int i = 0; i < this.workers.length; ++i) {
                    while (this.workers[i].isAlive()) {
                        this.workers[i].interrupt();
                        this.workers[i].join(100L);
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        } else {
            this.terminate();
        }
    }

    public void terminate() {
        while (this.hasJobs()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        for (int i = 0; i < this.workers.length; ++i) {
            try {
                while (this.workers[i].isAlive()) {
                    this.workers[i].interrupt();
                    this.workers[i].join(100L);
                }
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.ec.close();
    }

    public synchronized void addJob(Runnable job) {
        if (this.workers == null || this.workers.length < this.threads) {
            this.init();
        }
        this.jobstack.addLast(job);
        logger.debug((Object)"adding job");
        if (this.idleworkers > 0) {
            logger.debug((Object)"notifying a jobless worker");
            this.notifyAll();
        }
    }

    protected synchronized Runnable getJob() throws InterruptedException {
        while (this.jobstack.isEmpty()) {
            ++this.idleworkers;
            logger.debug((Object)"waiting");
            this.wait();
            --this.idleworkers;
        }
        if (this.strategy == StrategyEnumeration.LIFO) {
            return this.jobstack.removeLast();
        }
        return this.jobstack.removeFirst();
    }

    public boolean hasJobs() {
        if (this.jobstack.size() > 0) {
            return true;
        }
        for (int i = 0; i < this.workers.length; ++i) {
            if (!this.workers[i].working) continue;
            return true;
        }
        return false;
    }

    public boolean hasJobs(int n) {
        int j = this.jobstack.size();
        if (j > 0 && j + this.workers.length > n) {
            return true;
        }
        int x = 0;
        for (int i = 0; i < this.workers.length; ++i) {
            if (!this.workers[i].working) continue;
            ++x;
        }
        return j + x > n;
    }
}

