/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.DHTTransport;
import edu.jas.util.DHTTransportClear;
import edu.jas.util.SocketChannel;
import java.io.IOException;
import java.util.SortedMap;
import org.apache.log4j.Logger;

class DHTListener<K, V>
extends Thread {
    private static final Logger logger = Logger.getLogger(DHTListener.class);
    private static boolean debug = logger.isDebugEnabled();
    private final SocketChannel channel;
    private final SortedMap<K, V> theList;
    private boolean goon;

    DHTListener(SocketChannel s, SortedMap<K, V> list) {
        this.channel = s;
        this.theList = list;
        this.goon = true;
    }

    boolean isDone() {
        return !this.goon;
    }

    void setDone() {
        this.goon = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.debug((Object)"running ");
        while (this.goon) {
            DHTTransport tc = null;
            Object o = null;
            try {
                Object key;
                o = this.channel.receive();
                if (debug) {
                    logger.debug((Object)("receive(" + o + ")"));
                }
                if (this.isInterrupted()) {
                    this.goon = false;
                    break;
                }
                if (o == null) {
                    this.goon = false;
                    break;
                }
                if (o instanceof DHTTransportClear) {
                    logger.debug((Object)"receive, clear");
                    SortedMap<K, V> sortedMap = this.theList;
                    synchronized (sortedMap) {
                        this.theList.clear();
                        this.theList.notifyAll();
                        continue;
                    }
                }
                if (!(o instanceof DHTTransport) || (key = (tc = (DHTTransport)o).key()) == null) continue;
                logger.info((Object)("receive, put(key=" + key + ")"));
                Object val = tc.value();
                SortedMap<K, V> sortedMap = this.theList;
                synchronized (sortedMap) {
                    this.theList.put(key, val);
                    this.theList.notifyAll();
                }
            }
            catch (IOException e) {
                this.goon = false;
                logger.info((Object)("receive, IO exception " + e));
            }
            catch (ClassNotFoundException e) {
                this.goon = false;
                logger.info((Object)("receive, CNF exception " + e));
                e.printStackTrace();
            }
            catch (Exception e) {
                this.goon = false;
                logger.info((Object)("receive, exception " + e));
                e.printStackTrace();
            }
        }
    }
}

