/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.gb.GroebnerBaseSeq;
import edu.jas.gb.ReductionSeq;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.Monomial;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.Element;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.Power;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import edu.jas.ufd.SquarefreeFieldCharP;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class SquarefreeInfiniteAlgebraicFieldCharP<C extends GcdRingElem<C>>
extends SquarefreeFieldCharP<AlgebraicNumber<C>> {
    private static final Logger logger = Logger.getLogger(SquarefreeInfiniteAlgebraicFieldCharP.class);
    protected final SquarefreeAbstract<C> aengine;

    public SquarefreeInfiniteAlgebraicFieldCharP(RingFactory<AlgebraicNumber<C>> fac) {
        super(fac);
        if (fac.isFinite()) {
            throw new IllegalArgumentException("fac must be in-finite");
        }
        AlgebraicNumberRing afac = (AlgebraicNumberRing)fac;
        GenPolynomialRing rfac = afac.ring;
        this.aengine = SquarefreeFactory.getImplementation(rfac);
    }

    @Override
    public SortedMap<AlgebraicNumber<C>, Long> squarefreeFactors(AlgebraicNumber<C> P) {
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        TreeMap<AlgebraicNumber<C>, Long> factors = new TreeMap<AlgebraicNumber<C>, Long>();
        if (P.isZERO()) {
            return factors;
        }
        if (P.isONE()) {
            factors.put(P, 1L);
            return factors;
        }
        GenPolynomial an = P.val;
        AlgebraicNumberRing pfac = P.ring;
        if (!an.isONE()) {
            SortedMap nfac = this.aengine.squarefreeFactors(an);
            for (Map.Entry me : nfac.entrySet()) {
                GenPolynomial nfp = me.getKey();
                AlgebraicNumber nf = new AlgebraicNumber(pfac, nfp);
                factors.put(nf, me.getValue());
            }
        }
        if (factors.size() == 0) {
            factors.put(P, 1L);
        }
        return factors;
    }

    public SortedMap<AlgebraicNumber<C>, Long> rootCharacteristic(AlgebraicNumber<C> P) {
        ReductionSeq red;
        GroebnerBaseSeq bb;
        int z;
        GcdRingElem pc;
        GcdRingElem cc;
        ExpVector e;
        GenPolynomial ap;
        AlgebraicNumber a;
        ExpVector f;
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        BigInteger c = P.ring.characteristic();
        if (c.signum() == 0) {
            return null;
        }
        TreeMap<AlgebraicNumber<C>, Long> root = new TreeMap<AlgebraicNumber<C>, Long>();
        if (P.isZERO()) {
            return root;
        }
        if (P.isONE()) {
            root.put(P, 1L);
            return root;
        }
        AlgebraicNumberRing afac = P.ring;
        long deg = afac.modul.degree(0);
        int d = (int)deg;
        String[] vn = GenPolynomialRing.newVars("c", d);
        GenPolynomialRing pfac = new GenPolynomialRing(afac, d, vn);
        List uv = pfac.univariateList();
        GenPolynomial cp = pfac.getZERO();
        GenPolynomialRing apfac = afac.ring;
        long i = 0L;
        for (GenPolynomial genPolynomial : uv) {
            GenPolynomial ca = apfac.univariate(0, i++);
            GenPolynomial pb = genPolynomial.multiply(new AlgebraicNumber(afac, ca));
            cp = cp.sum(pb);
        }
        GenPolynomial cpp = (GenPolynomial)Power.positivePower(cp, c);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("cp   = " + cp));
            logger.info((Object)("cp^p = " + cpp));
            logger.info((Object)("P    = " + P));
        }
        GenPolynomialRing genPolynomialRing = new GenPolynomialRing(apfac.coFac, pfac);
        List gl = new ArrayList();
        if (deg == c.longValue() && afac.modul.length() == 2) {
            logger.info((Object)("deg(" + deg + ") == char_p(" + c.longValue() + ")"));
            for (Monomial m : cpp) {
                f = m.e;
                a = (AlgebraicNumber)m.c;
                ap = a.val;
                for (Monomial ma : ap) {
                    e = ma.e;
                    cc = (GcdRingElem)ma.c;
                    pc = (GcdRingElem)P.val.coefficient(e);
                    GcdRingElem cc1 = (GcdRingElem)((RingFactory)pc.factory()).getONE();
                    GcdRingElem pc1 = (GcdRingElem)((RingFactory)pc.factory()).getZERO();
                    if (cc instanceof AlgebraicNumber && pc instanceof AlgebraicNumber) {
                        throw new UnsupportedOperationException("case multiple algebraic extensions not implemented");
                    }
                    if (!(cc instanceof Quotient) || !(pc instanceof Quotient)) continue;
                    Quotient ccp = (Quotient)cc;
                    Quotient pcp = (Quotient)pc;
                    if (pcp.isConstant()) {
                        throw new ArithmeticException("finite field not allowed here " + afac.toScript());
                    }
                    Quotient dcp = ccp.divide(pcp);
                    if (dcp.isConstant()) {
                        cc1 = cc;
                        pc1 = pc;
                    }
                    GenPolynomial<GcdRingElem> r = new GenPolynomial<GcdRingElem>(genPolynomialRing, cc1, f);
                    r = r.subtract(pc1);
                    gl.add(r);
                }
            }
        } else {
            for (Monomial m : cpp) {
                f = m.e;
                a = (AlgebraicNumber)m.c;
                ap = a.val;
                for (Monomial ma : ap) {
                    e = ma.e;
                    cc = (GcdRingElem)ma.c;
                    pc = (GcdRingElem)P.val.coefficient(e);
                    GenPolynomial<GcdRingElem> r = new GenPolynomial<GcdRingElem>(genPolynomialRing, cc, f);
                    r = r.subtract(pc);
                    gl.add(r);
                }
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("equations = " + gl));
        }
        if ((z = (bb = new GroebnerBaseSeq()).commonZeroTest(gl = (red = new ReductionSeq()).irreducibleSet(gl))) < 0) {
            return null;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("solution = " + gl));
        }
        GenPolynomial car = apfac.getZERO();
        for (GenPolynomial pl : gl) {
            SortedMap<GcdRingElem, Long> br;
            if (pl.length() <= 1) continue;
            if (pl.length() > 2) {
                throw new IllegalArgumentException("dim > 0 not implemented " + pl);
            }
            ExpVector e2 = pl.leadingExpVector();
            int[] v = e2.dependencyOnVariables();
            if (v == null || v.length == 0) continue;
            int vi = v[0];
            GenPolynomial<GcdRingElem> ca = apfac.univariate(0, deg - 1L - (long)vi);
            GcdRingElem tc = (GcdRingElem)pl.trailingBaseCoefficient();
            tc = (GcdRingElem)tc.negate();
            if (e2.maxDeg() == c.longValue() && (br = this.aengine.squarefreeFactors(tc)) != null && br.size() > 0) {
                GcdRingElem cc2 = (GcdRingElem)apfac.coFac.getONE();
                for (Map.Entry<GcdRingElem, Long> me : br.entrySet()) {
                    GcdRingElem bc = me.getKey();
                    long ll = me.getValue();
                    if (ll % c.longValue() == 0L) {
                        long fl = ll / c.longValue();
                        cc2 = cc2.multiply(Power.positivePower(bc, fl));
                        continue;
                    }
                    cc2 = cc2.multiply(bc);
                }
                tc = cc2;
            }
            ca = ca.multiply(tc);
            car = car.sum(ca);
        }
        AlgebraicNumber rr = new AlgebraicNumber(afac, car);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("solution AN = " + rr));
        }
        root.put(rr, 1L);
        return root;
    }

    public GenPolynomial<AlgebraicNumber<C>> rootCharacteristic(GenPolynomial<AlgebraicNumber<C>> P) {
        if (P == null || P.isZERO()) {
            return P;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            GenPolynomialRing cfac = pfac.contract(1);
            GenPolynomialRing rfac = new GenPolynomialRing(cfac, 1);
            GenPolynomial<GenPolynomial<AlgebraicNumber<C>>> Pr = PolyUtil.recursive(rfac, P);
            GenPolynomial Prc = this.recursiveUnivariateRootCharacteristic(Pr);
            if (Prc == null) {
                return null;
            }
            GenPolynomial<AlgebraicNumber<C>> D = PolyUtil.distribute(pfac, Prc);
            return D;
        }
        RingFactory rf = pfac.coFac;
        if (rf.characteristic().signum() != 1) {
            throw new IllegalArgumentException(P.getClass().getName() + " only for ModInteger polynomials " + rf);
        }
        long mp = rf.characteristic().longValue();
        Element d = ((GenPolynomial)pfac.getZERO()).copy();
        for (Monomial<AlgebraicNumber<C>> monomial : P) {
            ExpVector f = monomial.e;
            long fl = f.getVal(0);
            if (fl % mp != 0L) {
                return null;
            }
            fl /= mp;
            SortedMap<AlgebraicNumber<C>, Long> sm = this.rootCharacteristic((AlgebraicNumber)monomial.c);
            if (sm == null) {
                return null;
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)("sm_alg,root = " + sm));
            }
            AlgebraicNumber<AlgebraicNumber<AlgebraicNumber<C>>> r = (AlgebraicNumber<AlgebraicNumber<AlgebraicNumber<C>>>)rf.getONE();
            for (Map.Entry<AlgebraicNumber<C>, Long> me : sm.entrySet()) {
                AlgebraicNumber<C> rp = me.getKey();
                long gl = me.getValue();
                if (gl > 1L) {
                    rp = Power.positivePower(rp, gl);
                }
                r = r.multiply((AlgebraicNumber<AlgebraicNumber<C>>)rp);
            }
            ExpVector e = ExpVector.create(1, 0, fl);
            ((GenPolynomial)d).doPutToMap(e, r);
        }
        logger.info((Object)("sm_alg,root,d = " + d));
        return d;
    }

    @Override
    public GenPolynomial<AlgebraicNumber<C>> baseRootCharacteristic(GenPolynomial<AlgebraicNumber<C>> P) {
        if (P == null || P.isZERO()) {
            return P;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException(P.getClass().getName() + " only for univariate polynomials");
        }
        RingFactory rf = pfac.coFac;
        if (rf.characteristic().signum() != 1) {
            throw new IllegalArgumentException(P.getClass().getName() + " only for char p > 0 " + rf);
        }
        long mp = rf.characteristic().longValue();
        Element d = ((GenPolynomial)pfac.getZERO()).copy();
        for (Monomial<AlgebraicNumber<C>> monomial : P) {
            ExpVector f = monomial.e;
            long fl = f.getVal(0);
            if (fl % mp != 0L) {
                return null;
            }
            fl /= mp;
            SortedMap<AlgebraicNumber<C>, Long> sm = this.rootCharacteristic((AlgebraicNumber)monomial.c);
            if (sm == null) {
                return null;
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)("sm_alg,base,root = " + sm));
            }
            AlgebraicNumber<AlgebraicNumber<AlgebraicNumber<C>>> r = (AlgebraicNumber<AlgebraicNumber<AlgebraicNumber<C>>>)rf.getONE();
            for (Map.Entry<AlgebraicNumber<C>, Long> me : sm.entrySet()) {
                AlgebraicNumber<C> rp = me.getKey();
                long gl = me.getValue();
                AlgebraicNumber<C> re = rp;
                if (gl > 1L) {
                    re = Power.positivePower(rp, gl);
                }
                r = r.multiply((AlgebraicNumber<AlgebraicNumber<C>>)re);
            }
            ExpVector e = ExpVector.create(1, 0, fl);
            ((GenPolynomial)d).doPutToMap(e, r);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("sm_alg,base,d = " + d));
        }
        return d;
    }

    @Override
    public GenPolynomial<GenPolynomial<AlgebraicNumber<C>>> recursiveUnivariateRootCharacteristic(GenPolynomial<GenPolynomial<AlgebraicNumber<C>>> P) {
        if (P == null || P.isZERO()) {
            return P;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException(P.getClass().getName() + " only for univariate recursive polynomials");
        }
        RingFactory rf = pfac.coFac;
        if (rf.characteristic().signum() != 1) {
            throw new IllegalArgumentException(P.getClass().getName() + " only for char p > 0 " + rf);
        }
        long mp = rf.characteristic().longValue();
        Element d = ((GenPolynomial)pfac.getZERO()).copy();
        for (Monomial<GenPolynomial<AlgebraicNumber<C>>> monomial : P) {
            ExpVector f = monomial.e;
            long fl = f.getVal(0);
            if (fl % mp != 0L) {
                return null;
            }
            fl /= mp;
            GenPolynomial<AlgebraicNumber<C>> r = this.rootCharacteristic((GenPolynomial)monomial.c);
            if (r == null) {
                return null;
            }
            ExpVector e = ExpVector.create(1, 0, fl);
            ((GenPolynomial)d).doPutToMap(e, r);
        }
        return d;
    }
}

