/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.GcdRingElem;
import edu.jas.ufd.Factors;
import java.io.Serializable;
import java.util.SortedMap;

public class FactorsMap<C extends GcdRingElem<C>>
implements Serializable {
    public final GenPolynomial<C> poly;
    public final SortedMap<GenPolynomial<C>, Long> factors;
    public final SortedMap<Factors<C>, Long> afactors;

    public FactorsMap(GenPolynomial<C> p, SortedMap<GenPolynomial<C>, Long> map) {
        this(p, map, null);
    }

    public FactorsMap(GenPolynomial<C> p, SortedMap<GenPolynomial<C>, Long> map, SortedMap<Factors<C>, Long> amap) {
        this.poly = p;
        this.factors = map;
        this.afactors = amap;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.poly.toString());
        sb.append(" =\n");
        boolean first = true;
        for (GenPolynomial<C> genPolynomial : this.factors.keySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(",\n ");
            }
            sb.append(genPolynomial.toString());
            long e = (Long)this.factors.get(genPolynomial);
            if (e <= 1L) continue;
            sb.append("**" + e);
        }
        if (this.afactors == null) {
            return sb.toString();
        }
        for (Factors factors : this.afactors.keySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(",\n ");
            }
            sb.append(factors.toString());
            Long e = (Long)this.afactors.get(factors);
            if (e == null || e <= 1L) continue;
            sb.append("**" + e);
        }
        return sb.toString();
    }

    public String toScript() {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (GenPolynomial<C> genPolynomial : this.factors.keySet()) {
            if (first) {
                first = false;
            } else {
                sb.append("\n * ");
            }
            sb.append(genPolynomial.toScript());
            long e = (Long)this.factors.get(genPolynomial);
            if (e <= 1L) continue;
            sb.append("**" + e);
        }
        if (this.afactors == null) {
            return sb.toString();
        }
        for (Factors factors : this.afactors.keySet()) {
            if (first) {
                first = false;
            } else {
                sb.append("\n * ");
            }
            Long e = (Long)this.afactors.get(factors);
            if (e == null) {
                System.out.println("f = " + factors);
                System.out.println("afactors = " + this.afactors);
                throw new RuntimeException("this should not happen");
            }
            if (e == 1L) {
                sb.append(factors.toScript());
                continue;
            }
            sb.append("(\n");
            sb.append(factors.toScript());
            sb.append("\n)**" + e);
        }
        return sb.toString();
    }

    public AlgebraicNumberRing<C> findExtensionField() {
        if (this.afactors == null) {
            return null;
        }
        AlgebraicNumberRing<C> ar = null;
        int depth = 0;
        for (Factors<C> f : this.afactors.keySet()) {
            int d;
            AlgebraicNumberRing<C> aring = f.findExtensionField();
            if (aring == null || (d = aring.depth()) <= depth) continue;
            depth = d;
            ar = aring;
        }
        return ar;
    }
}

