/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.Power;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import edu.jas.ufd.Factors;
import edu.jas.ufd.FactorsList;
import edu.jas.ufd.FactorsMap;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.GreatestCommonDivisorSubres;
import edu.jas.ufd.PartialFraction;
import edu.jas.ufd.PolyUfdUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public abstract class FactorAbsolute<C extends GcdRingElem<C>>
extends FactorAbstract<C> {
    private static final Logger logger = Logger.getLogger(FactorAbsolute.class);
    private final boolean debug = logger.isDebugEnabled();

    protected FactorAbsolute() {
        throw new IllegalArgumentException("don't use this constructor");
    }

    public FactorAbsolute(RingFactory<C> cfac) {
        super(cfac);
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }

    public boolean isAbsoluteIrreducible(GenPolynomial<C> P) {
        if (!this.isIrreducible(P)) {
            return false;
        }
        Factors<C> F = this.factorsAbsoluteIrreducible(P);
        if (F.afac == null) {
            return true;
        }
        if (F.afactors.size() > 2) {
            return false;
        }
        boolean cnst = false;
        for (GenPolynomial p : F.afactors) {
            if (!p.isConstant()) continue;
            cnst = true;
        }
        return cnst;
    }

    public FactorsMap<C> baseFactorsAbsolute(GenPolynomial<C> P) {
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        TreeMap factors = new TreeMap();
        if (P.isZERO()) {
            return new FactorsMap<C>(P, factors);
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException("only for univariate polynomials");
        }
        if (!pfac.coFac.isField()) {
            throw new IllegalArgumentException("only for field coefficients");
        }
        if (P.degree(0) <= 1L) {
            factors.put(P, 1L);
            return new FactorsMap<C>(P, factors);
        }
        SortedMap<GenPolynomial<C>, Long> facs = this.baseFactors(P);
        if (this.debug && !this.isFactorization(P, facs)) {
            System.out.println("facs   = " + facs);
            throw new ArithmeticException("isFactorization = false");
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("all K factors = " + facs));
        }
        TreeMap afactors = new TreeMap();
        for (Map.Entry<GenPolynomial<C>, Long> me : facs.entrySet()) {
            GenPolynomial<C> p = me.getKey();
            Long e = me.getValue();
            if (p.degree(0) <= 1L) {
                factors.put(p, e);
                continue;
            }
            Factors<C> afacs = this.baseFactorsAbsoluteIrreducible(p);
            afactors.put(afacs, e);
        }
        return new FactorsMap<C>(P, factors, afactors);
    }

    public FactorsList<C> baseFactorsAbsoluteSquarefree(GenPolynomial<C> P) {
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        ArrayList factors = new ArrayList();
        if (P.isZERO()) {
            return new FactorsList<C>(P, factors);
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException("only for univariate polynomials");
        }
        if (!pfac.coFac.isField()) {
            throw new IllegalArgumentException("only for field coefficients");
        }
        if (P.degree(0) <= 1L) {
            factors.add(P);
            return new FactorsList<C>(P, factors);
        }
        List<GenPolynomial<C>> facs = this.baseFactorsSquarefree(P);
        if (this.debug && !this.isFactorization(P, facs)) {
            throw new ArithmeticException("isFactorization = false");
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("all K factors = " + facs));
        }
        ArrayList afactors = new ArrayList();
        for (GenPolynomial<C> p : facs) {
            if (p.degree(0) <= 1L) {
                factors.add(p);
                continue;
            }
            Factors<C> afacs = this.baseFactorsAbsoluteIrreducible(p);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("K(alpha) factors = " + afacs));
            }
            afactors.add(afacs);
        }
        return new FactorsList<C>(P, factors, afactors);
    }

    public Factors<C> baseFactorsAbsoluteIrreducible(GenPolynomial<C> P) {
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        if (P.isZERO()) {
            return new Factors<C>(P);
        }
        GenPolynomialRing<C> pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException("only for univariate polynomials");
        }
        if (!pfac.coFac.isField()) {
            throw new IllegalArgumentException("only for field coefficients");
        }
        if (P.degree(0) <= 1L) {
            return new Factors<C>(P);
        }
        String[] vars = pfac.newVars("z_");
        pfac = pfac.copy();
        vars = pfac.setVars(vars);
        GenPolynomial aP = pfac.copy(P);
        AlgebraicNumberRing afac = new AlgebraicNumberRing(aP, true);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("K(alpha) = " + afac));
            logger.info((Object)("K(alpha) = " + afac.toScript()));
        }
        GenPolynomialRing pafac = new GenPolynomialRing(afac, aP.ring.nvar, aP.ring.tord, vars);
        GenPolynomial Pa = PolyUtil.convertToAlgebraicCoefficients(pafac, P);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("P over K(alpha) = " + Pa));
        }
        FactorAbstract engine = FactorFactory.getImplementation(afac);
        List factors = engine.baseFactorsSquarefree(Pa);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("factors over K(alpha) = " + factors));
        }
        ArrayList faca = new ArrayList(factors.size());
        ArrayList facar = new ArrayList();
        for (GenPolynomial fi : factors) {
            if (fi.degree(0) <= 1L) {
                faca.add(fi);
                continue;
            }
            FactorAbsolute aengine = (FactorAbsolute)FactorFactory.getImplementation(afac);
            Factors fif = aengine.baseFactorsAbsoluteIrreducible(fi);
            facar.add(fif);
        }
        if (facar.size() == 0) {
            facar = null;
        }
        return new Factors<C>(P, afac, Pa, faca, facar);
    }

    public PartialFraction<C> baseAlgebraicPartialFraction(GenPolynomial<C> A, GenPolynomial<C> P) {
        if (P == null || P.isZERO()) {
            throw new IllegalArgumentException(" P == null or P == 0");
        }
        if (A == null || A.isZERO()) {
            throw new IllegalArgumentException(" A == null or A == 0");
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException("only for univariate polynomials");
        }
        if (!pfac.coFac.isField()) {
            throw new IllegalArgumentException("only for field coefficients");
        }
        ArrayList cfactors = new ArrayList();
        ArrayList cdenom = new ArrayList();
        ArrayList afactors = new ArrayList();
        ArrayList adenom = new ArrayList();
        if (P.degree(0) <= 1L) {
            cfactors.add(A.leadingBaseCoefficient());
            cdenom.add(P);
            return new PartialFraction<C>(A, P, cfactors, cdenom, afactors, adenom);
        }
        List<GenPolynomial<C>> Pfac = this.baseFactorsSquarefree(P);
        List<GenPolynomial<C>> Afac = this.engine.basePartialFraction(A, Pfac);
        GenPolynomial<C> A0 = Afac.remove(0);
        if (!A0.isZERO()) {
            throw new ArithmeticException(" A0 != 0: deg(A)>= deg(P)");
        }
        int i = 0;
        for (GenPolynomial<C> pi : Pfac) {
            GenPolynomial<C> ai = Afac.get(i++);
            if (pi.degree(0) <= 1L) {
                cfactors.add(ai.leadingBaseCoefficient());
                cdenom.add(pi);
                continue;
            }
            PartialFraction<C> pf = this.baseAlgebraicPartialFractionIrreducibleAbsolute(ai, pi);
            cfactors.addAll(pf.cfactors);
            cdenom.addAll(pf.cdenom);
            afactors.addAll(pf.afactors);
            adenom.addAll(pf.adenom);
        }
        return new PartialFraction<C>(A, P, cfactors, cdenom, afactors, adenom);
    }

    @Deprecated
    public PartialFraction<C> baseAlgebraicPartialFractionIrreducible(GenPolynomial<C> A, GenPolynomial<C> P) {
        if (P == null || P.isZERO()) {
            throw new IllegalArgumentException(" P == null or P == 0");
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException("only for univariate polynomials");
        }
        if (!pfac.coFac.isField()) {
            throw new IllegalArgumentException("only for field coefficients");
        }
        ArrayList<C> cfactors = new ArrayList<C>();
        ArrayList cdenom = new ArrayList();
        ArrayList afactors = new ArrayList();
        ArrayList adenom = new ArrayList();
        if (P.degree(0) <= 1L) {
            cfactors.add(A.leadingBaseCoefficient());
            cdenom.add(P);
            return new PartialFraction<C>(A, P, cfactors, cdenom, afactors, adenom);
        }
        GenPolynomial<C> Pp = PolyUtil.baseDeriviative(P);
        String[] vars = new String[]{"t"};
        GenPolynomialRing cfac = new GenPolynomialRing(pfac.coFac, 1, pfac.tord, vars);
        GenPolynomial t = cfac.univariate(0);
        GenPolynomialRing rfac = new GenPolynomialRing(pfac, cfac);
        GenPolynomial Ac = PolyUfdUtil.introduceLowerVariable(rfac, A);
        GenPolynomial Pc = PolyUfdUtil.introduceLowerVariable(rfac, P);
        GenPolynomial Pcp = PolyUfdUtil.introduceLowerVariable(rfac, Pp);
        GenPolynomialRing rfac1 = Pc.ring;
        GenPolynomial tc = ((GenPolynomial)rfac1.getONE()).multiply(t);
        GenPolynomial At = Ac.subtract(tc.multiply(Pcp));
        GreatestCommonDivisorSubres engine = new GreatestCommonDivisorSubres();
        GreatestCommonDivisorAbstract aengine = null;
        GenPolynomial Rc = engine.recursiveUnivariateResultant(Pc, At);
        GenPolynomial res = Rc.leadingBaseCoefficient();
        SortedMap resfac = this.baseFactors(res);
        for (GenPolynomial r : resfac.keySet()) {
            GenPolynomial Ga;
            if (r.isConstant()) continue;
            vars = pfac.newVars("z_");
            pfac = pfac.copy();
            pfac.setVars(vars);
            r = pfac.copy(r);
            AlgebraicNumberRing afac = new AlgebraicNumberRing(r, true);
            logger.debug((Object)("afac = " + afac.toScript()));
            AlgebraicNumber a = afac.getGenerator();
            GenPolynomialRing pafac = new GenPolynomialRing(afac, Pc.ring);
            GenPolynomial Pa = PolyUtil.convertToAlgebraicCoefficients(pafac, P);
            GenPolynomial Pap = PolyUtil.convertToAlgebraicCoefficients(pafac, Pp);
            GenPolynomial Aa = PolyUtil.convertToAlgebraicCoefficients(pafac, A);
            GenPolynomial Ap = Aa.subtract(Pap.multiply(a));
            if (aengine == null) {
                aengine = GCDFactory.getImplementation(afac);
            }
            if ((Ga = aengine.baseGcd(Pa, Ap)).isConstant()) continue;
            afactors.add(a);
            adenom.add(Ga);
            if (P.degree(0) != 2L || Ga.degree(0) != 1L) continue;
            GenPolynomial<GenPolynomial<AlgebraicNumber<C>>>[] qra = PolyUtil.basePseudoQuotientRemainder(Pa, Ga);
            GenPolynomial Qa = qra[0];
            if (!qra[1].isZERO()) {
                throw new ArithmeticException("remainder not zero");
            }
            afactors.add(a.negate());
            adenom.add(Qa);
        }
        return new PartialFraction<C>(A, P, cfactors, cdenom, afactors, adenom);
    }

    public PartialFraction<C> baseAlgebraicPartialFractionIrreducibleAbsolute(GenPolynomial<C> A, GenPolynomial<C> P) {
        if (P == null || P.isZERO()) {
            throw new IllegalArgumentException(" P == null or P == 0");
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException("only for univariate polynomials");
        }
        if (!pfac.coFac.isField()) {
            throw new IllegalArgumentException("only for field coefficients");
        }
        ArrayList<C> cfactors = new ArrayList<C>();
        ArrayList cdenom = new ArrayList();
        ArrayList afactors = new ArrayList();
        ArrayList adenom = new ArrayList();
        if (P.degree(0) <= 1L) {
            cfactors.add(A.leadingBaseCoefficient());
            cdenom.add(P);
            return new PartialFraction<C>(A, P, cfactors, cdenom, afactors, adenom);
        }
        Factors afacs = this.factorsAbsoluteIrreducible(P);
        List fact = afacs.getFactors();
        GenPolynomial Pa = afacs.apoly;
        GenPolynomial Aa = PolyUtil.convertToRecAlgebraicCoefficients(1, Pa.ring, A);
        GreatestCommonDivisorAbstract aengine = GCDFactory.getProxy(afacs.afac);
        List numers = aengine.basePartialFraction(Aa, fact);
        GenPolynomial A0 = numers.remove(0);
        if (!A0.isZERO()) {
            throw new ArithmeticException(" A0 != 0: deg(A)>= deg(P)");
        }
        int i = 0;
        for (GenPolynomial genPolynomial : fact) {
            GenPolynomial an = numers.get(i++);
            if (genPolynomial.degree(0) <= 1L) {
                afactors.add(an.leadingBaseCoefficient());
                adenom.add(genPolynomial);
                continue;
            }
            System.out.println("fa = " + genPolynomial);
            Factors<AlgebraicNumber<C>> faf = afacs.getFactor(genPolynomial);
            System.out.println("faf = " + faf);
            List fafact = faf.getFactors();
            GenPolynomial Aaa = PolyUtil.convertToRecAlgebraicCoefficients(1, faf.apoly.ring, an);
            GreatestCommonDivisorAbstract aaengine = GCDFactory.getImplementation(faf.afac);
            List anumers = aaengine.basePartialFraction(Aaa, fafact);
            System.out.println("algeb part frac = " + anumers);
            GenPolynomial A0a = anumers.remove(0);
            if (!A0a.isZERO()) {
                throw new ArithmeticException(" A0 != 0: deg(A)>= deg(P)");
            }
            int k = 0;
            for (GenPolynomial faa : fafact) {
                GenPolynomial ana = anumers.get(k++);
                System.out.println("faa = " + faa);
                System.out.println("ana = " + ana);
                if (faa.degree(0) > 1L) {
                    throw new ArithmeticException(" faa not linear");
                }
                GenPolynomial ana1 = ana;
                GenPolynomial faa1 = faa;
                afactors.add(ana1.leadingBaseCoefficient());
                adenom.add(faa1);
            }
        }
        return new PartialFraction<C>(A, P, cfactors, cdenom, afactors, adenom);
    }

    public FactorsMap<C> factorsAbsolute(GenPolynomial<C> P) {
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        TreeMap factors = new TreeMap();
        if (P.isZERO()) {
            return new FactorsMap<C>(P, factors);
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar <= 1) {
            return this.baseFactorsAbsolute(P);
        }
        if (!pfac.coFac.isField()) {
            throw new IllegalArgumentException("only for field coefficients");
        }
        if (P.degree() <= 1L) {
            factors.put(P, 1L);
            return new FactorsMap<C>(P, factors);
        }
        SortedMap<GenPolynomial<C>, Long> facs = this.factors(P);
        if (this.debug && !this.isFactorization(P, facs)) {
            throw new ArithmeticException("isFactorization = false");
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("all K factors = " + facs));
        }
        TreeMap afactors = new TreeMap();
        for (Map.Entry<GenPolynomial<C>, Long> me : facs.entrySet()) {
            GenPolynomial<C> p = me.getKey();
            Long e = me.getValue();
            if (p.degree() <= 1L) {
                factors.put(p, e);
                continue;
            }
            Factors<C> afacs = this.factorsAbsoluteIrreducible(p);
            if (afacs.afac == null) {
                factors.put(p, e);
                continue;
            }
            afactors.put(afacs, e);
        }
        return new FactorsMap<C>(P, factors, afactors);
    }

    public FactorsList<C> factorsAbsoluteSquarefree(GenPolynomial<C> P) {
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        ArrayList factors = new ArrayList();
        if (P.isZERO()) {
            return new FactorsList<C>(P, factors);
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar <= 1) {
            return this.baseFactorsAbsoluteSquarefree(P);
        }
        if (!pfac.coFac.isField()) {
            throw new IllegalArgumentException("only for field coefficients");
        }
        if (P.degree() <= 1L) {
            factors.add(P);
            return new FactorsList<C>(P, factors);
        }
        List<GenPolynomial<C>> facs = this.factorsSquarefree(P);
        if (this.debug && !this.isFactorization(P, facs)) {
            throw new ArithmeticException("isFactorization = false");
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("all K factors = " + facs));
        }
        ArrayList afactors = new ArrayList();
        for (GenPolynomial<C> p : facs) {
            if (p.degree() <= 1L) {
                factors.add(p);
                continue;
            }
            Factors<C> afacs = this.factorsAbsoluteIrreducible(p);
            if (this.debug) {
                logger.info((Object)("K(alpha) factors = " + afacs));
            }
            if (afacs.afac == null) {
                factors.add(p);
                continue;
            }
            afactors.add(afacs);
        }
        return new FactorsList<C>(P, factors, afactors);
    }

    public Factors<C> factorsAbsoluteIrreducible(GenPolynomial<C> P) {
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        if (P.isZERO()) {
            return new Factors<C>(P);
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar <= 1) {
            return this.baseFactorsAbsoluteIrreducible(P);
        }
        if (!pfac.coFac.isField()) {
            throw new IllegalArgumentException("only for field coefficients");
        }
        if (P.degree() <= 1L) {
            return new Factors<C>(P);
        }
        GenPolynomial<Object> up = P;
        RingFactory cf = pfac.coFac;
        long cr = cf.characteristic().longValue();
        if (cr == 0L) {
            cr = Long.MAX_VALUE;
        }
        long rp = 0L;
        for (int i = 0; i < pfac.nvar - 1; ++i) {
            GenPolynomial<GcdRingElem> ep;
            rp = 0L;
            GenPolynomialRing nfac = pfac.contract(1);
            String[] vn = new String[]{pfac.getVars()[pfac.nvar - 1]};
            GenPolynomialRing rfac = new GenPolynomialRing(nfac, 1, pfac.tord, vn);
            GenPolynomial upr = PolyUtil.recursive(rfac, up);
            do {
                if (rp >= cr) {
                    throw new ArithmeticException("elements of prime field exhausted: " + cr);
                }
                GcdRingElem r = (GcdRingElem)cf.fromInteger(rp);
                ep = PolyUtil.evaluateMainRecursive(nfac, upr, r);
                ++rp;
            } while (!this.isSquarefree(ep));
            up = ep;
            pfac = nfac;
        }
        up = up.monic();
        if (this.debug) {
            logger.info((Object)("P(" + rp + ") = " + up));
        }
        if (this.debug && !this.isSquarefree(up)) {
            throw new ArithmeticException("not irreducible up = " + up);
        }
        if (up.degree(0) <= 1L) {
            return new Factors<C>(P);
        }
        List<GenPolynomial<C>> UF = this.baseFactorsSquarefree(up);
        FactorsList<C> aUF = this.baseFactorsAbsoluteSquarefree(up);
        AlgebraicNumberRing<C> arfac = aUF.findExtensionField();
        long e = up.degree(0);
        for (int i = 0; i < UF.size(); ++i) {
            GenPolynomial<C> upi = UF.get(i);
            long d = upi.degree(0);
            if (1L > d || d > e) continue;
            up = upi;
            e = up.degree(0);
        }
        if (up.degree(0) <= 1L) {
            return new Factors<C>(P);
        }
        if (this.debug) {
            logger.info((Object)("field extension by " + up));
        }
        List<Object> afactors = new ArrayList();
        String[] vars = pfac.newVars("z_");
        pfac = pfac.copy();
        pfac.setVars(vars);
        AlgebraicNumberRing<C> afac = arfac;
        int depth = afac.depth();
        GenPolynomialRing pafac = new GenPolynomialRing(afac, P.ring.nvar, P.ring.tord, P.ring.getVars());
        GenPolynomial Pa = PolyUtil.convertToRecAlgebraicCoefficients(depth, pafac, P);
        FactorAbstract engine = FactorFactory.getImplementation(afac);
        afactors = engine.factorsSquarefree(Pa);
        if (this.debug) {
            logger.info((Object)("K(alpha) factors multi = " + afactors));
        }
        if (afactors.size() <= 1) {
            return new Factors<C>(P);
        }
        GenPolynomial<AlgebraicNumber> p1 = (GenPolynomial<AlgebraicNumber>)afactors.get(0);
        AlgebraicNumber p1c = (AlgebraicNumber)p1.leadingBaseCoefficient();
        if (!p1c.isONE()) {
            GenPolynomial<AlgebraicNumber> p2 = (GenPolynomial<AlgebraicNumber>)afactors.get(1);
            afactors.remove(p1);
            afactors.remove(p2);
            p1 = p1.divide(p1c);
            p2 = p2.multiply(p1c);
            afactors.add(p1);
            afactors.add(p2);
        }
        return new Factors<C>(P, afac, Pa, afactors);
    }

    public boolean isAbsoluteFactorization(Factors<C> facs) {
        boolean b;
        if (facs == null) {
            throw new IllegalArgumentException("facs may not be null");
        }
        if (facs.afac == null) {
            return true;
        }
        GenPolynomial fa = facs.apoly;
        GenPolynomialRing pafac = fa.ring;
        GenPolynomial t = pafac.getONE();
        for (GenPolynomial f : facs.afactors) {
            t = t.multiply(f);
        }
        boolean bl = b = fa.equals(t) || fa.equals(t.negate());
        if (b) {
            return b;
        }
        if (facs.arfactors == null) {
            return false;
        }
        for (Factors arp : facs.arfactors) {
            t = t.multiply(arp.poly);
        }
        boolean bl2 = b = fa.equals(t) || fa.equals(t.negate());
        if (!b) {
            System.out.println("\nFactors: " + facs);
            System.out.println("fa = " + fa);
            System.out.println("t = " + t);
        }
        return b;
    }

    public boolean isAbsoluteFactorization(FactorsList<C> facs) {
        boolean b;
        if (facs == null) {
            throw new IllegalArgumentException("facs may not be null");
        }
        GenPolynomial P = facs.poly;
        GenPolynomial t = P.ring.getONE();
        for (GenPolynomial genPolynomial : facs.factors) {
            t = t.multiply(genPolynomial);
        }
        if (P.equals(t) || P.equals(t.negate())) {
            return true;
        }
        if (facs.afactors == null) {
            return false;
        }
        for (Factors factors : facs.afactors) {
            if (!this.isAbsoluteFactorization(factors)) {
                return false;
            }
            t = t.multiply(facs.poly);
        }
        boolean bl = b = P.equals(t) || P.equals(t.negate());
        if (!b) {
            System.out.println("\nFactorsList: " + facs);
            System.out.println("P = " + P);
            System.out.println("t = " + t);
        }
        return b;
    }

    public boolean isAbsoluteFactorization(FactorsMap<C> facs) {
        boolean b;
        GenPolynomial g;
        long e;
        if (facs == null) {
            throw new IllegalArgumentException("facs may not be null");
        }
        GenPolynomial P = facs.poly;
        GenPolynomial t = P.ring.getONE();
        for (Map.Entry entry : facs.factors.entrySet()) {
            GenPolynomial f = entry.getKey();
            e = entry.getValue();
            g = Power.positivePower(f, e);
            t = t.multiply(g);
        }
        if (P.equals(t) || P.equals(t.negate())) {
            return true;
        }
        if (facs.afactors == null) {
            return false;
        }
        for (Map.Entry entry : facs.afactors.entrySet()) {
            Factors fs = (Factors)entry.getKey();
            if (!this.isAbsoluteFactorization(fs)) {
                return false;
            }
            e = entry.getValue();
            g = Power.positivePower(fs.poly, e);
            t = t.multiply(g);
        }
        boolean bl = b = P.equals(t) || P.equals(t.negate());
        if (!b) {
            System.out.println("\nFactorsMap: " + facs);
            System.out.println("P = " + P);
            System.out.println("t = " + t);
        }
        return b;
    }
}

