/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.Rational;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.Complex;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.root.AlgFromRealCoeff;
import edu.jas.root.CoeffToComplex;
import edu.jas.root.CoeffToComplexFromComplex;
import edu.jas.root.CoeffToReAlg;
import edu.jas.root.CoeffToReal;
import edu.jas.root.CoeffToRecReAlg;
import edu.jas.root.ComplexAlgebraicNumber;
import edu.jas.root.ComplexAlgebraicRing;
import edu.jas.root.PolyToReAlg;
import edu.jas.root.RealAlgebraicNumber;
import edu.jas.root.RealAlgebraicRing;
import edu.jas.root.RealFromAlgCoeff;
import edu.jas.structure.GcdRingElem;
import org.apache.log4j.Logger;

public class PolyUtilRoot {
    private static final Logger logger = Logger.getLogger(PolyUtilRoot.class);
    private static boolean debug = logger.isDebugEnabled();

    public static <C extends GcdRingElem<C> & Rational> GenPolynomial<RealAlgebraicNumber<C>> convertToAlgebraicCoefficients(GenPolynomialRing<RealAlgebraicNumber<C>> pfac, GenPolynomial<C> A) {
        RealAlgebraicRing afac = (RealAlgebraicRing)pfac.coFac;
        if (debug) {
            logger.info((Object)("afac = " + afac));
        }
        return PolyUtil.map(pfac, A, new CoeffToReAlg(afac));
    }

    public static <C extends GcdRingElem<C> & Rational> GenPolynomial<RealAlgebraicNumber<C>> convertToRecAlgebraicCoefficients(int depth, GenPolynomialRing<RealAlgebraicNumber<C>> pfac, GenPolynomial<C> A) {
        RealAlgebraicRing afac = (RealAlgebraicRing)pfac.coFac;
        return PolyUtil.map(pfac, A, new CoeffToRecReAlg(depth, afac));
    }

    public static <C extends GcdRingElem<C> & Rational> GenPolynomial<RealAlgebraicNumber<C>> convertRecursiveToAlgebraicCoefficients(GenPolynomialRing<RealAlgebraicNumber<C>> pfac, GenPolynomial<GenPolynomial<C>> A) {
        RealAlgebraicRing afac = (RealAlgebraicRing)pfac.coFac;
        return PolyUtil.map(pfac, A, new PolyToReAlg(afac));
    }

    public static <C extends GcdRingElem<C> & Rational> GenPolynomial<AlgebraicNumber<C>> algebraicFromRealCoefficients(GenPolynomialRing<AlgebraicNumber<C>> afac, GenPolynomial<RealAlgebraicNumber<C>> A) {
        AlgebraicNumberRing cfac = (AlgebraicNumberRing)afac.coFac;
        return PolyUtil.map(afac, A, new AlgFromRealCoeff(cfac));
    }

    public static <C extends GcdRingElem<C> & Rational> GenPolynomial<RealAlgebraicNumber<C>> realFromAlgebraicCoefficients(GenPolynomialRing<RealAlgebraicNumber<C>> rfac, GenPolynomial<AlgebraicNumber<C>> A) {
        RealAlgebraicRing cfac = (RealAlgebraicRing)rfac.coFac;
        return PolyUtil.map(rfac, A, new RealFromAlgCoeff(cfac));
    }

    public static <C extends GcdRingElem<C> & Rational> GenPolynomial<RealAlgebraicNumber<C>> convertToRealCoefficients(GenPolynomialRing<RealAlgebraicNumber<C>> pfac, GenPolynomial<C> A) {
        RealAlgebraicRing afac = (RealAlgebraicRing)pfac.coFac;
        return PolyUtil.map(pfac, A, new CoeffToReal(afac));
    }

    public static <C extends GcdRingElem<C> & Rational> GenPolynomial<ComplexAlgebraicNumber<C>> convertToComplexCoefficients(GenPolynomialRing<ComplexAlgebraicNumber<C>> pfac, GenPolynomial<C> A) {
        ComplexAlgebraicRing afac = (ComplexAlgebraicRing)pfac.coFac;
        return PolyUtil.map(pfac, A, new CoeffToComplex(afac));
    }

    public static <C extends GcdRingElem<C> & Rational> GenPolynomial<ComplexAlgebraicNumber<C>> convertToComplexCoefficientsFromComplex(GenPolynomialRing<ComplexAlgebraicNumber<C>> pfac, GenPolynomial<Complex<C>> A) {
        ComplexAlgebraicRing afac = (ComplexAlgebraicRing)pfac.coFac;
        return PolyUtil.map(pfac, A, new CoeffToComplexFromComplex(afac));
    }
}

