/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.Rational;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.root.RealAlgebraicNumber;
import edu.jas.root.RealAlgebraicRing;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.UnaryFunctor;

class CoeffToReal<C extends GcdRingElem<C> & Rational>
implements UnaryFunctor<C, RealAlgebraicNumber<C>> {
    protected final RealAlgebraicRing<C> rfac;
    protected final AlgebraicNumber<C> zero;

    public CoeffToReal(RealAlgebraicRing<C> fac) {
        if (fac == null) {
            throw new IllegalArgumentException("fac must not be null");
        }
        this.rfac = fac;
        AlgebraicNumberRing afac = this.rfac.algebraic;
        this.zero = afac.getZERO();
    }

    @Override
    public RealAlgebraicNumber<C> eval(C c) {
        if (c == null) {
            return this.rfac.getZERO();
        }
        return new RealAlgebraicNumber<C>(this.rfac, this.zero.sum(c));
    }
}

