/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ps;

import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.ps.ExpVectorIterable;
import edu.jas.ps.MultiVarPowerSeriesRing;
import edu.jas.structure.Element;
import edu.jas.structure.RingElem;
import java.io.Serializable;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;

public abstract class MultiVarCoefficients<C extends RingElem<C>>
implements Serializable {
    public final GenPolynomialRing<C> pfac;
    public final HashMap<Long, GenPolynomial<C>> coeffCache;
    public final BitSet homCheck;
    public final HashSet<ExpVector> zeroCache;

    public MultiVarCoefficients(MultiVarPowerSeriesRing<C> pf) {
        this(pf.polyRing(), new HashMap<Long, GenPolynomial<C>>(), new HashSet<ExpVector>());
    }

    public MultiVarCoefficients(MultiVarPowerSeriesRing<C> pf, BitSet hc) {
        this(pf.polyRing(), new HashMap<Long, GenPolynomial<C>>(), new HashSet<ExpVector>(), hc);
    }

    public MultiVarCoefficients(GenPolynomialRing<C> pf) {
        this(pf, new HashMap<Long, GenPolynomial<C>>(), new HashSet<ExpVector>());
    }

    public MultiVarCoefficients(GenPolynomialRing<C> pf, HashMap<Long, GenPolynomial<C>> cache) {
        this(pf, cache, new HashSet<ExpVector>());
    }

    public MultiVarCoefficients(GenPolynomialRing<C> pf, HashMap<Long, GenPolynomial<C>> cache, HashSet<ExpVector> zeros) {
        this(pf, cache, zeros, new BitSet());
    }

    public MultiVarCoefficients(GenPolynomialRing<C> pf, BitSet hc) {
        this(pf, new HashMap<Long, GenPolynomial<C>>(), new HashSet<ExpVector>(), hc);
    }

    public MultiVarCoefficients(GenPolynomialRing<C> pf, HashMap<Long, GenPolynomial<C>> cache, BitSet hc) {
        this(pf, cache, new HashSet<ExpVector>(), hc);
    }

    public MultiVarCoefficients(GenPolynomialRing<C> pf, HashMap<Long, GenPolynomial<C>> cache, HashSet<ExpVector> zeros, BitSet hc) {
        this.pfac = pf;
        this.coeffCache = cache;
        this.zeroCache = zeros;
        this.homCheck = hc;
    }

    public C get(ExpVector index) {
        C c;
        long tdeg = index.totalDeg();
        Element<GenPolynomial<C>> p = this.coeffCache.get(tdeg);
        if (p == null) {
            p = ((GenPolynomial)this.pfac.getZERO()).copy();
            this.coeffCache.put(tdeg, (GenPolynomial<C>)p);
        }
        if (!(c = ((GenPolynomial)p).coefficient(index)).isZERO()) {
            return c;
        }
        if (this.homCheck.get((int)tdeg)) {
            return c;
        }
        if (this.zeroCache.contains(index)) {
            return c;
        }
        C g = this.generate(index);
        if (g.isZERO()) {
            this.zeroCache.add(index);
        } else {
            ((GenPolynomial)p).doPutToMap(index, (GenPolynomial<C>)g);
        }
        return g;
    }

    public GenPolynomial<C> getHomPart(long tdeg) {
        if (this.coeffCache == null) {
            throw new IllegalArgumentException("null cache not allowed");
        }
        Element<GenPolynomial<C>> p = this.coeffCache.get(tdeg);
        if (p == null) {
            p = ((GenPolynomial)this.pfac.getZERO()).copy();
            this.coeffCache.put(tdeg, (GenPolynomial<C>)p);
        }
        if (this.homCheck.get((int)tdeg)) {
            return p;
        }
        ExpVectorIterable eiter = new ExpVectorIterable(this.pfac.nvar, tdeg);
        for (ExpVector e : eiter) {
            C g;
            if (this.zeroCache.contains(e)) {
                if (this.zeroCache.remove(e)) continue;
                System.out.println("not removed e = " + e);
                continue;
            }
            if (!((GenPolynomial)p).coefficient(e).isZERO() || (g = this.generate(e)).isZERO()) continue;
            ((GenPolynomial)p).doPutToMap(e, (GenPolynomial<C>)g);
        }
        this.homCheck.set((int)tdeg);
        return p;
    }

    protected abstract C generate(ExpVector var1);
}

