/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.kern.Scripting;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.OrderedModuleList;
import edu.jas.poly.PolynomialList;
import edu.jas.structure.RingElem;
import edu.jas.vector.GenVector;
import edu.jas.vector.GenVectorModul;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ModuleList<C extends RingElem<C>>
implements Serializable {
    public final GenPolynomialRing<C> ring;
    public final List<List<GenPolynomial<C>>> list;
    public final int rows;
    public final int cols;
    private static final Logger logger = Logger.getLogger(ModuleList.class);

    public ModuleList(GenPolynomialRing<C> r, List<List<GenPolynomial<C>>> l) {
        this.ring = r;
        this.list = ModuleList.padCols(r, l);
        if (this.list == null) {
            this.rows = -1;
            this.cols = -1;
        } else {
            this.rows = this.list.size();
            this.cols = this.rows > 0 ? this.list.get(0).size() : -1;
        }
    }

    public ModuleList(GenSolvablePolynomialRing<C> r, List<List<GenSolvablePolynomial<C>>> l) {
        this((GenPolynomialRing<C>)r, ModuleList.castToList(l));
    }

    public ModuleList(GenVectorModul<GenPolynomial<C>> r, List<GenVector<GenPolynomial<C>>> l) {
        this((GenPolynomialRing)r.coFac, ModuleList.vecToList(l));
    }

    public boolean equals(Object m) {
        List<List<GenPolynomial<C>>> oml;
        if (!(m instanceof ModuleList)) {
            return false;
        }
        ModuleList ml = null;
        try {
            ml = (ModuleList)m;
        }
        catch (ClassCastException ignored) {
            // empty catch block
        }
        if (ml == null) {
            return false;
        }
        if (!this.ring.equals(ml.ring)) {
            return false;
        }
        if (this.list == ml.list) {
            return true;
        }
        if (this.list == null || ml.list == null) {
            return false;
        }
        if (this.list.size() != ml.list.size()) {
            return false;
        }
        List<List<GenPolynomial<C>>> otl = OrderedModuleList.sort(this.ring, this.list);
        return otl.equals(oml = OrderedModuleList.sort(this.ring, ml.list));
    }

    public int hashCode() {
        int h = this.ring.hashCode();
        h = 37 * h + (this.list == null ? 0 : this.list.hashCode());
        return h;
    }

    public String toString() {
        StringBuffer erg = new StringBuffer();
        String[] vars = null;
        if (this.ring != null) {
            erg.append(this.ring.toString());
            vars = this.ring.getVars();
        }
        if (this.list == null) {
            erg.append(")");
            return erg.toString();
        }
        boolean first = true;
        erg.append("(\n");
        for (List<GenPolynomial<C>> row : this.list) {
            if (first) {
                first = false;
            } else {
                erg.append(",\n");
            }
            boolean ifirst = true;
            erg.append(" ( ");
            for (GenPolynomial<C> oa : row) {
                String os = oa == null ? "0" : (vars != null ? oa.toString(vars) : oa.toString());
                if (ifirst) {
                    ifirst = false;
                } else {
                    erg.append(", ");
                    if (os.length() > 100) {
                        erg.append("\n");
                    }
                }
                erg.append(os);
            }
            erg.append(" )");
        }
        erg.append("\n)");
        return erg.toString();
    }

    public String toScript() {
        StringBuffer s = new StringBuffer();
        if (this.ring instanceof GenSolvablePolynomialRing) {
            s.append("Solvable");
        }
        switch (Scripting.getLang()) {
            case Ruby: {
                s.append("SubModule.new(");
                break;
            }
            default: {
                s.append("SubModule(");
            }
        }
        if (this.ring != null) {
            s.append(this.ring.toScript());
        }
        if (this.list == null) {
            s.append(")");
            return s.toString();
        }
        switch (Scripting.getLang()) {
            case Ruby: {
                s.append(",\"\",[");
                break;
            }
            default: {
                s.append(",list=[");
            }
        }
        boolean first = true;
        for (List<GenPolynomial<C>> row : this.list) {
            if (first) {
                first = false;
            } else {
                s.append(",");
            }
            boolean ifirst = true;
            s.append(" ( ");
            for (GenPolynomial<C> oa : row) {
                String os = oa == null ? "0" : oa.toScript();
                if (ifirst) {
                    ifirst = false;
                } else {
                    s.append(", ");
                }
                s.append(os);
            }
            s.append(" )");
        }
        s.append(" ])");
        return s.toString();
    }

    public static <C extends RingElem<C>> List<List<GenPolynomial<C>>> padCols(GenPolynomialRing<C> ring, List<List<GenPolynomial<C>>> l) {
        if (l == null) {
            return l;
        }
        int mcols = 0;
        int rs = 0;
        for (List<GenPolynomial<C>> row : l) {
            if (row == null) continue;
            ++rs;
            if (row.size() <= mcols) continue;
            mcols = row.size();
        }
        ArrayList<List<GenPolynomial<C>>> norm = new ArrayList<List<GenPolynomial<C>>>(rs);
        for (List<GenPolynomial<C>> row : l) {
            if (row == null) continue;
            ArrayList<GenPolynomial<C>> rn = new ArrayList<GenPolynomial<C>>(row);
            while (rn.size() < mcols) {
                rn.add((GenPolynomial<C>)ring.getZERO());
            }
            norm.add(rn);
        }
        return norm;
    }

    public PolynomialList<C> getPolynomialList() {
        GenPolynomialRing<C> pfac = this.ring.extend(this.cols);
        logger.debug((Object)("extended ring = " + pfac));
        ArrayList pols = null;
        if (this.list == null) {
            return new PolynomialList<C>(pfac, pols);
        }
        pols = new ArrayList(this.rows);
        if (this.rows == 0) {
            return new PolynomialList<C>(pfac, pols);
        }
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> zero = pfac.getZERO();
        GenPolynomial<C> d = null;
        for (List<GenPolynomial<C>> r : this.list) {
            GenPolynomial<GenPolynomial<GenPolynomial<C>>> ext = zero;
            int m = 0;
            for (GenPolynomial<C> c : r) {
                d = c.extend(pfac, m, 1L);
                ext = ext.sum((GenPolynomial<GenPolynomial<C>>)d);
                ++m;
            }
            pols.add(ext);
        }
        return new PolynomialList<C>(pfac, pols);
    }

    public List<List<GenSolvablePolynomial<C>>> castToSolvableList() {
        ArrayList<List<GenSolvablePolynomial<C>>> slist = null;
        if (this.list == null) {
            return slist;
        }
        slist = new ArrayList<List<GenSolvablePolynomial<C>>>(this.list.size());
        for (List<GenPolynomial<C>> row : this.list) {
            ArrayList<GenSolvablePolynomial> srow = new ArrayList<GenSolvablePolynomial>(row.size());
            for (GenPolynomial<C> p : row) {
                if (!(p instanceof GenSolvablePolynomial)) {
                    throw new RuntimeException("no solvable polynomial " + p);
                }
                GenSolvablePolynomial s = (GenSolvablePolynomial)p;
                srow.add(s);
            }
            slist.add(srow);
        }
        return slist;
    }

    public static <C extends RingElem<C>> List<List<GenPolynomial<C>>> castToList(List<List<GenSolvablePolynomial<C>>> slist) {
        ArrayList<List<GenPolynomial<C>>> list = null;
        if (slist == null) {
            return list;
        }
        list = new ArrayList<List<GenPolynomial<C>>>(slist.size());
        for (List<GenSolvablePolynomial<C>> srow : slist) {
            ArrayList<GenSolvablePolynomial<C>> row = new ArrayList<GenSolvablePolynomial<C>>(srow.size());
            for (GenSolvablePolynomial<C> s : srow) {
                row.add(s);
            }
            list.add(row);
        }
        return list;
    }

    public static <C extends RingElem<C>> List<List<GenPolynomial<C>>> vecToList(List<GenVector<GenPolynomial<C>>> vlist) {
        ArrayList<List<GenPolynomial<C>>> list = null;
        if (vlist == null) {
            return list;
        }
        list = new ArrayList<List<GenPolynomial<C>>>(vlist.size());
        for (GenVector<GenPolynomial<C>> srow : vlist) {
            List row = srow.val;
            list.add(row);
        }
        return list;
    }
}

