/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.kern.PreemptingException;
import edu.jas.kern.PrettyPrint;
import edu.jas.poly.AlgebraicNotInvertibleException;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.Monomial;
import edu.jas.poly.PolyIterator;
import edu.jas.poly.TermOrder;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.Element;
import edu.jas.structure.NotInvertibleException;
import edu.jas.structure.RingElem;
import edu.jas.structure.UnaryFunctor;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class GenPolynomial<C extends RingElem<C>>
implements RingElem<GenPolynomial<C>>,
Iterable<Monomial<C>> {
    public final GenPolynomialRing<C> ring;
    protected final SortedMap<ExpVector, C> val;
    private static final Logger logger = Logger.getLogger(GenPolynomial.class);
    private final boolean debug = logger.isDebugEnabled();

    private GenPolynomial(GenPolynomialRing<C> r, TreeMap<ExpVector, C> t) {
        this.ring = r;
        this.val = t;
        if (this.ring.checkPreempt && Thread.currentThread().isInterrupted()) {
            logger.debug((Object)"throw PreemptingException");
            throw new PreemptingException();
        }
    }

    public GenPolynomial(GenPolynomialRing<C> r) {
        this(r, (C)new TreeMap(r.tord.getDescendComparator()));
    }

    public GenPolynomial(GenPolynomialRing<C> r, C c, ExpVector e) {
        this(r);
        if (!c.isZERO()) {
            this.val.put(e, c);
        }
    }

    public GenPolynomial(GenPolynomialRing<C> r, C c) {
        this(r, c, r.evzero);
    }

    public GenPolynomial(GenPolynomialRing<C> r, ExpVector e) {
        this(r, (RingElem)r.coFac.getONE(), e);
    }

    protected GenPolynomial(GenPolynomialRing<C> r, SortedMap<ExpVector, C> v) {
        this(r);
        this.val.putAll(v);
    }

    @Override
    public GenPolynomialRing<C> factory() {
        return this.ring;
    }

    @Override
    public GenPolynomial<C> copy() {
        return new GenPolynomial<C>(this.ring, this.val);
    }

    public int length() {
        return this.val.size();
    }

    public SortedMap<ExpVector, C> getMap() {
        return Collections.unmodifiableSortedMap(this.val);
    }

    public void doPutToMap(ExpVector e, C c) {
        RingElem a;
        if (this.debug && (a = (RingElem)this.val.get(e)) != null) {
            logger.error((Object)("map entry exists " + e + " to " + a + " new " + c));
        }
        if (!c.isZERO()) {
            this.val.put(e, c);
        }
    }

    public void doRemoveFromMap(ExpVector e, C c) {
        RingElem b = (RingElem)this.val.remove(e);
        if (this.debug) {
            if (c == null) {
                return;
            }
            if (!c.equals(b)) {
                logger.error((Object)("map entry wrong " + e + " to " + c + " old " + b));
            }
        }
    }

    public void doPutToMap(SortedMap<ExpVector, C> vals) {
        for (Map.Entry<ExpVector, C> me : vals.entrySet()) {
            RingElem c;
            RingElem a;
            ExpVector e = me.getKey();
            if (this.debug && (a = (RingElem)this.val.get(e)) != null) {
                logger.error((Object)("map entry exists " + e + " to " + a + " new " + me.getValue()));
            }
            if ((c = (RingElem)me.getValue()).isZERO()) continue;
            this.val.put(e, c);
        }
    }

    public String toString() {
        if (this.ring.vars != null) {
            return this.toString(this.ring.vars);
        }
        StringBuffer s = new StringBuffer();
        s.append(this.getClass().getSimpleName() + ":");
        s.append(this.ring.coFac.getClass().getSimpleName());
        if (this.ring.coFac.characteristic().signum() != 0) {
            s.append("(" + this.ring.coFac.characteristic() + ")");
        }
        s.append("[ ");
        boolean first = true;
        for (Map.Entry<ExpVector, C> m : this.val.entrySet()) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            s.append(((RingElem)m.getValue()).toString());
            s.append(" ");
            s.append(m.getKey().toString());
        }
        s.append(" ] ");
        return s.toString();
    }

    public String toString(String[] v) {
        StringBuffer s = new StringBuffer();
        if (PrettyPrint.isTrue()) {
            if (this.val.size() == 0) {
                s.append("0");
            } else {
                boolean first = true;
                for (Map.Entry<ExpVector, C> m : this.val.entrySet()) {
                    RingElem c = (RingElem)m.getValue();
                    if (first) {
                        first = false;
                    } else if (c.signum() < 0) {
                        s.append(" - ");
                        c = (RingElem)c.negate();
                    } else {
                        s.append(" + ");
                    }
                    ExpVector e = m.getKey();
                    if (!c.isONE() || e.isZERO()) {
                        String cs = c.toString();
                        if (cs.indexOf("-") >= 0 || cs.indexOf("+") >= 0) {
                            s.append("( ");
                            s.append(cs);
                            s.append(" )");
                        } else {
                            s.append(cs);
                        }
                        s.append(" ");
                    }
                    if (e != null && v != null) {
                        s.append(e.toString(v));
                        continue;
                    }
                    s.append(e);
                }
            }
        } else {
            s.append(this.getClass().getSimpleName() + "[ ");
            if (this.val.size() == 0) {
                s.append("0");
            } else {
                boolean first = true;
                for (Map.Entry<ExpVector, C> m : this.val.entrySet()) {
                    RingElem c = (RingElem)m.getValue();
                    if (first) {
                        first = false;
                    } else if (c.signum() < 0) {
                        s.append(" - ");
                        c = (RingElem)c.negate();
                    } else {
                        s.append(" + ");
                    }
                    ExpVector e = m.getKey();
                    if (!c.isONE() || e.isZERO()) {
                        s.append(c.toString());
                        s.append(" ");
                    }
                    s.append(e.toString(v));
                }
            }
            s.append(" ] ");
        }
        return s.toString();
    }

    @Override
    public String toScript() {
        String[] v;
        if (this.isZERO()) {
            return "0";
        }
        StringBuffer s = new StringBuffer();
        if (this.val.size() > 1) {
            s.append("( ");
        }
        if ((v = this.ring.vars) == null) {
            v = GenPolynomialRing.newVars("x", this.ring.nvar);
        }
        boolean first = true;
        for (Map.Entry<ExpVector, C> m : this.val.entrySet()) {
            boolean parenthesis;
            RingElem c = (RingElem)m.getValue();
            if (first) {
                first = false;
            } else if (c.signum() < 0) {
                s.append(" - ");
                c = (RingElem)c.negate();
            } else {
                s.append(" + ");
            }
            ExpVector e = m.getKey();
            String cs = c.toScript();
            boolean bl = parenthesis = cs.indexOf("-") >= 0 || cs.indexOf("+") >= 0;
            if (!c.isONE() || e.isZERO()) {
                if (parenthesis) {
                    s.append("( ");
                }
                s.append(cs);
                if (parenthesis) {
                    s.append(" )");
                }
                if (!e.isZERO()) {
                    s.append(" * ");
                }
            }
            s.append(e.toScript(v));
        }
        if (this.val.size() > 1) {
            s.append(" )");
        }
        return s.toString();
    }

    @Override
    public String toScriptFactory() {
        return ((GenPolynomialRing)this.factory()).toScript();
    }

    @Override
    public boolean isZERO() {
        return this.val.size() == 0;
    }

    @Override
    public boolean isONE() {
        if (this.val.size() != 1) {
            return false;
        }
        RingElem c = (RingElem)this.val.get(this.ring.evzero);
        if (c == null) {
            return false;
        }
        return c.isONE();
    }

    @Override
    public boolean isUnit() {
        if (this.val.size() != 1) {
            return false;
        }
        RingElem c = (RingElem)this.val.get(this.ring.evzero);
        if (c == null) {
            return false;
        }
        return c.isUnit();
    }

    public boolean isConstant() {
        if (this.val.size() != 1) {
            return false;
        }
        RingElem c = (RingElem)this.val.get(this.ring.evzero);
        return c != null;
    }

    public boolean isHomogeneous() {
        if (this.val.size() <= 1) {
            return true;
        }
        long deg = -1L;
        for (ExpVector e : this.val.keySet()) {
            if (deg < 0L) {
                deg = e.totalDeg();
                continue;
            }
            if (deg == e.totalDeg()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object B) {
        if (!(B instanceof GenPolynomial)) {
            return false;
        }
        GenPolynomial a = null;
        try {
            a = (GenPolynomial)B;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (a == null) {
            return false;
        }
        return this.compareTo(a) == 0;
    }

    @Override
    public int hashCode() {
        int h = this.ring.hashCode() << 27;
        return h += this.val.hashCode();
    }

    @Override
    public int compareTo(GenPolynomial<C> b) {
        if (b == null) {
            return 1;
        }
        SortedMap<ExpVector, C> av = this.val;
        SortedMap<ExpVector, C> bv = b.val;
        Iterator<Map.Entry<ExpVector, C>> ai = av.entrySet().iterator();
        Iterator<Map.Entry<ExpVector, C>> bi = bv.entrySet().iterator();
        int s = 0;
        int c = 0;
        while (ai.hasNext() && bi.hasNext()) {
            ExpVector be;
            Map.Entry<ExpVector, C> aie = ai.next();
            Map.Entry<ExpVector, C> bie = bi.next();
            ExpVector ae = aie.getKey();
            s = ae.compareTo(be = bie.getKey());
            if (s != 0) {
                return s;
            }
            if (c != 0) continue;
            RingElem ac = (RingElem)aie.getValue();
            RingElem bc = (RingElem)bie.getValue();
            c = ac.compareTo(bc);
        }
        if (ai.hasNext()) {
            return 1;
        }
        if (bi.hasNext()) {
            return -1;
        }
        return c;
    }

    @Override
    public int signum() {
        if (this.isZERO()) {
            return 0;
        }
        ExpVector t = this.val.firstKey();
        RingElem c = (RingElem)this.val.get(t);
        return c.signum();
    }

    public int numberOfVariables() {
        return this.ring.nvar;
    }

    public Map.Entry<ExpVector, C> leadingMonomial() {
        if (this.val.size() == 0) {
            return null;
        }
        Iterator<Map.Entry<ExpVector, C>> ai = this.val.entrySet().iterator();
        return ai.next();
    }

    public ExpVector leadingExpVector() {
        if (this.val.size() == 0) {
            return null;
        }
        return this.val.firstKey();
    }

    public ExpVector trailingExpVector() {
        if (this.val.size() == 0) {
            return this.ring.evzero;
        }
        return this.val.lastKey();
    }

    public C leadingBaseCoefficient() {
        if (this.val.size() == 0) {
            return (C)((RingElem)this.ring.coFac.getZERO());
        }
        return (C)((RingElem)this.val.get(this.val.firstKey()));
    }

    public C trailingBaseCoefficient() {
        RingElem c = (RingElem)this.val.get(this.ring.evzero);
        if (c == null) {
            return (C)((RingElem)this.ring.coFac.getZERO());
        }
        return (C)c;
    }

    public C coefficient(ExpVector e) {
        RingElem c = (RingElem)this.val.get(e);
        if (c == null) {
            c = (RingElem)this.ring.coFac.getZERO();
        }
        return (C)c;
    }

    public GenPolynomial<C> reductum() {
        if (this.val.size() <= 1) {
            return this.ring.getZERO();
        }
        Iterator<ExpVector> ai = this.val.keySet().iterator();
        ExpVector lt = ai.next();
        lt = ai.next();
        SortedMap<ExpVector, C> red = this.val.tailMap(lt);
        Element r = ((GenPolynomial)this.ring.getZERO()).copy();
        ((GenPolynomial)r).doPutToMap(red);
        return r;
    }

    public long degree(int i) {
        if (this.val.size() == 0) {
            return 0L;
        }
        int j = i >= 0 ? this.ring.nvar - 1 - i : this.ring.nvar + i;
        long deg = 0L;
        for (ExpVector e : this.val.keySet()) {
            long d = e.getVal(j);
            if (d <= deg) continue;
            deg = d;
        }
        return deg;
    }

    public long degree() {
        if (this.val.size() == 0) {
            return 0L;
        }
        long deg = 0L;
        for (ExpVector e : this.val.keySet()) {
            long d = e.maxDeg();
            if (d <= deg) continue;
            deg = d;
        }
        return deg;
    }

    public long totalDegree() {
        if (this.val.size() == 0) {
            return 0L;
        }
        long deg = 0L;
        for (ExpVector e : this.val.keySet()) {
            long d = e.totalDeg();
            if (d <= deg) continue;
            deg = d;
        }
        return deg;
    }

    public ExpVector degreeVector() {
        ExpVector deg = this.ring.evzero;
        if (this.val.size() == 0) {
            return deg;
        }
        for (ExpVector e : this.val.keySet()) {
            deg = deg.lcm(e);
        }
        return deg;
    }

    public C maxNorm() {
        RingElem n = this.ring.getZEROCoefficient();
        for (RingElem c : this.val.values()) {
            RingElem x = (RingElem)c.abs();
            if (n.compareTo((RingElem)x) >= 0) continue;
            n = x;
        }
        return (C)n;
    }

    public C sumNorm() {
        RingElem n = this.ring.getZEROCoefficient();
        for (RingElem c : this.val.values()) {
            RingElem x = (RingElem)c.abs();
            n = n.sum((RingElem)x);
        }
        return (C)n;
    }

    @Override
    public GenPolynomial<C> sum(GenPolynomial<C> S) {
        if (S == null) {
            return this;
        }
        if (S.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return S;
        }
        assert (this.ring.nvar == S.ring.nvar);
        Element n = this.copy();
        SortedMap<ExpVector, C> nv = ((GenPolynomial)n).val;
        SortedMap<ExpVector, C> sv = S.val;
        for (Map.Entry<ExpVector, C> me : sv.entrySet()) {
            ExpVector e = me.getKey();
            RingElem y = (RingElem)me.getValue();
            RingElem x = (RingElem)nv.get(e);
            if (x != null) {
                if (!(x = x.sum(y)).isZERO()) {
                    nv.put(e, x);
                    continue;
                }
                nv.remove(e);
                continue;
            }
            nv.put(e, y);
        }
        return n;
    }

    public GenPolynomial<C> sum(C a, ExpVector e) {
        if (a == null) {
            return this;
        }
        if (a.isZERO()) {
            return this;
        }
        Element n = this.copy();
        SortedMap<ExpVector, C> nv = ((GenPolynomial)n).val;
        RingElem x = (RingElem)nv.get(e);
        if (x != null) {
            if (!(x = (RingElem)x.sum(a)).isZERO()) {
                nv.put(e, x);
            } else {
                nv.remove(e);
            }
        } else {
            nv.put(e, a);
        }
        return n;
    }

    @Override
    public GenPolynomial<C> sum(C a) {
        return this.sum(a, this.ring.evzero);
    }

    @Override
    public GenPolynomial<C> subtract(GenPolynomial<C> S) {
        if (S == null) {
            return this;
        }
        if (S.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return S.negate();
        }
        assert (this.ring.nvar == S.ring.nvar);
        Element n = this.copy();
        SortedMap<ExpVector, C> nv = ((GenPolynomial)n).val;
        SortedMap<ExpVector, C> sv = S.val;
        for (Map.Entry<ExpVector, C> me : sv.entrySet()) {
            ExpVector e = me.getKey();
            RingElem y = (RingElem)me.getValue();
            RingElem x = (RingElem)nv.get(e);
            if (x != null) {
                if (!(x = x.subtract(y)).isZERO()) {
                    nv.put(e, x);
                    continue;
                }
                nv.remove(e);
                continue;
            }
            nv.put(e, y.negate());
        }
        return n;
    }

    public GenPolynomial<C> subtract(C a, ExpVector e) {
        if (a == null) {
            return this;
        }
        if (a.isZERO()) {
            return this;
        }
        Element n = this.copy();
        SortedMap<ExpVector, C> nv = ((GenPolynomial)n).val;
        RingElem x = (RingElem)nv.get(e);
        if (x != null) {
            if (!(x = (RingElem)x.subtract(a)).isZERO()) {
                nv.put(e, x);
            } else {
                nv.remove(e);
            }
        } else {
            nv.put(e, a.negate());
        }
        return n;
    }

    @Override
    public GenPolynomial<C> subtract(C a) {
        return this.subtract(a, this.ring.evzero);
    }

    public GenPolynomial<C> subtractMultiple(C a, GenPolynomial<C> S) {
        if (a == null) {
            return this;
        }
        if (a.isZERO()) {
            return this;
        }
        if (S == null) {
            return this;
        }
        if (S.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return S.multiply((RingElem)a.negate());
        }
        assert (this.ring.nvar == S.ring.nvar);
        Element n = this.copy();
        SortedMap<ExpVector, C> nv = ((GenPolynomial)n).val;
        SortedMap<ExpVector, C> sv = S.val;
        for (Map.Entry<ExpVector, C> me : sv.entrySet()) {
            ExpVector f = me.getKey();
            RingElem y = (RingElem)me.getValue();
            y = a.multiply((RingElem)y);
            RingElem x = (RingElem)nv.get(f);
            if (x != null) {
                if (!(x = x.subtract(y)).isZERO()) {
                    nv.put(f, x);
                    continue;
                }
                nv.remove(f);
                continue;
            }
            if (y.isZERO()) continue;
            nv.put(f, y.negate());
        }
        return n;
    }

    public GenPolynomial<C> subtractMultiple(C a, ExpVector e, GenPolynomial<C> S) {
        if (a == null) {
            return this;
        }
        if (a.isZERO()) {
            return this;
        }
        if (S == null) {
            return this;
        }
        if (S.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return S.multiply((RingElem)a.negate(), e);
        }
        assert (this.ring.nvar == S.ring.nvar);
        Element n = this.copy();
        SortedMap<ExpVector, C> nv = ((GenPolynomial)n).val;
        SortedMap<ExpVector, C> sv = S.val;
        for (Map.Entry<ExpVector, C> me : sv.entrySet()) {
            ExpVector f = me.getKey();
            f = e.sum(f);
            RingElem y = (RingElem)me.getValue();
            y = a.multiply((RingElem)y);
            RingElem x = (RingElem)nv.get(f);
            if (x != null) {
                if (!(x = x.subtract(y)).isZERO()) {
                    nv.put(f, x);
                    continue;
                }
                nv.remove(f);
                continue;
            }
            if (y.isZERO()) continue;
            nv.put(f, y.negate());
        }
        return n;
    }

    public GenPolynomial<C> scaleSubtractMultiple(C b, C a, ExpVector e, GenPolynomial<C> S) {
        if (a == null || S == null) {
            return this.multiply(b);
        }
        if (a.isZERO() || S.isZERO()) {
            return this.multiply(b);
        }
        if (this.isZERO() || b == null || b.isZERO()) {
            return S.multiply((RingElem)a.negate(), e);
        }
        if (b.isONE()) {
            return this.subtractMultiple(a, e, S);
        }
        assert (this.ring.nvar == S.ring.nvar);
        GenPolynomial<C> n = this.multiply(b);
        SortedMap<ExpVector, C> nv = n.val;
        SortedMap<ExpVector, C> sv = S.val;
        for (Map.Entry<ExpVector, C> me : sv.entrySet()) {
            ExpVector f = me.getKey();
            f = e.sum(f);
            RingElem y = (RingElem)me.getValue();
            y = a.multiply((RingElem)y);
            RingElem x = (RingElem)nv.get(f);
            if (x != null) {
                if (!(x = x.subtract(y)).isZERO()) {
                    nv.put(f, x);
                    continue;
                }
                nv.remove(f);
                continue;
            }
            if (y.isZERO()) continue;
            nv.put(f, y.negate());
        }
        return n;
    }

    public GenPolynomial<C> scaleSubtractMultiple(C b, ExpVector g, C a, ExpVector e, GenPolynomial<C> S) {
        if (a == null || S == null) {
            return this.multiply(b, g);
        }
        if (a.isZERO() || S.isZERO()) {
            return this.multiply(b, g);
        }
        if (this.isZERO() || b == null || b.isZERO()) {
            return S.multiply((RingElem)a.negate(), e);
        }
        if (b.isONE() && g.isZERO()) {
            return this.subtractMultiple(a, e, S);
        }
        assert (this.ring.nvar == S.ring.nvar);
        GenPolynomial<C> n = this.multiply(b, g);
        SortedMap<ExpVector, C> nv = n.val;
        SortedMap<ExpVector, C> sv = S.val;
        for (Map.Entry<ExpVector, C> me : sv.entrySet()) {
            ExpVector f = me.getKey();
            f = e.sum(f);
            RingElem y = (RingElem)me.getValue();
            y = a.multiply((RingElem)y);
            RingElem x = (RingElem)nv.get(f);
            if (x != null) {
                if (!(x = x.subtract(y)).isZERO()) {
                    nv.put(f, x);
                    continue;
                }
                nv.remove(f);
                continue;
            }
            if (y.isZERO()) continue;
            nv.put(f, y.negate());
        }
        return n;
    }

    @Override
    public GenPolynomial<C> negate() {
        Element n = ((GenPolynomial)this.ring.getZERO()).copy();
        SortedMap<ExpVector, C> v = ((GenPolynomial)n).val;
        for (Map.Entry<ExpVector, C> m : this.val.entrySet()) {
            RingElem x = (RingElem)m.getValue();
            v.put(m.getKey(), x.negate());
        }
        return n;
    }

    @Override
    public GenPolynomial<C> abs() {
        if (this.leadingBaseCoefficient().signum() < 0) {
            return this.negate();
        }
        return this;
    }

    @Override
    public GenPolynomial<C> multiply(GenPolynomial<C> S) {
        if (S == null) {
            return this.ring.getZERO();
        }
        if (S.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        assert (this.ring.nvar == S.ring.nvar);
        if (this instanceof GenSolvablePolynomial || S instanceof GenSolvablePolynomial) {
            logger.debug((Object)"warn: wrong method dispatch in JRE multiply(S) - trying to fix");
            GenSolvablePolynomial T = (GenSolvablePolynomial)this;
            GenSolvablePolynomial Sp = (GenSolvablePolynomial)S;
            return T.multiply(Sp);
        }
        Element p = ((GenPolynomial)this.ring.getZERO()).copy();
        SortedMap<ExpVector, C> pv = ((GenPolynomial)p).val;
        for (Map.Entry<ExpVector, C> m1 : this.val.entrySet()) {
            RingElem c1 = (RingElem)m1.getValue();
            ExpVector e1 = m1.getKey();
            for (Map.Entry<ExpVector, C> m2 : S.val.entrySet()) {
                RingElem c2 = (RingElem)m2.getValue();
                ExpVector e2 = m2.getKey();
                RingElem c = c1.multiply(c2);
                if (c.isZERO()) continue;
                ExpVector e = e1.sum(e2);
                RingElem c0 = (RingElem)pv.get(e);
                if (c0 == null) {
                    pv.put(e, c);
                    continue;
                }
                if (!(c0 = c0.sum(c)).isZERO()) {
                    pv.put(e, c0);
                    continue;
                }
                pv.remove(e);
            }
        }
        return p;
    }

    @Override
    public GenPolynomial<C> multiply(C s) {
        if (s == null) {
            return this.ring.getZERO();
        }
        if (s.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        Element p = ((GenPolynomial)this.ring.getZERO()).copy();
        SortedMap<ExpVector, C> pv = ((GenPolynomial)p).val;
        for (Map.Entry<ExpVector, C> m1 : this.val.entrySet()) {
            RingElem c1 = (RingElem)m1.getValue();
            ExpVector e1 = m1.getKey();
            RingElem c = (RingElem)c1.multiply(s);
            if (c.isZERO()) continue;
            pv.put(e1, c);
        }
        return p;
    }

    public GenPolynomial<C> monic() {
        if (this.isZERO()) {
            return this;
        }
        C lc = this.leadingBaseCoefficient();
        if (!lc.isUnit()) {
            return this;
        }
        RingElem lm = (RingElem)lc.inverse();
        return this.multiply((C)lm);
    }

    public GenPolynomial<C> multiply(C s, ExpVector e) {
        if (s == null) {
            return this.ring.getZERO();
        }
        if (s.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        if (this instanceof GenSolvablePolynomial) {
            logger.debug((Object)"warn: wrong method dispatch in JRE multiply(s,e) - trying to fix");
            GenSolvablePolynomial T = (GenSolvablePolynomial)this;
            return T.multiply((RingElem)s, e);
        }
        Element p = ((GenPolynomial)this.ring.getZERO()).copy();
        SortedMap<ExpVector, C> pv = ((GenPolynomial)p).val;
        for (Map.Entry<ExpVector, C> m1 : this.val.entrySet()) {
            RingElem c1 = (RingElem)m1.getValue();
            ExpVector e1 = m1.getKey();
            RingElem c = (RingElem)c1.multiply(s);
            if (c.isZERO()) continue;
            ExpVector e2 = e1.sum(e);
            pv.put(e2, c);
        }
        return p;
    }

    @Override
    public GenPolynomial<C> multiply(ExpVector e) {
        if (this.isZERO()) {
            return this;
        }
        if (this instanceof GenSolvablePolynomial) {
            logger.debug((Object)"warn: wrong method dispatch in JRE multiply(e) - trying to fix");
            GenSolvablePolynomial T = (GenSolvablePolynomial)this;
            return T.multiply(e);
        }
        Element p = ((GenPolynomial)this.ring.getZERO()).copy();
        SortedMap<ExpVector, C> pv = ((GenPolynomial)p).val;
        for (Map.Entry<ExpVector, C> m1 : this.val.entrySet()) {
            RingElem c1 = (RingElem)m1.getValue();
            ExpVector e1 = m1.getKey();
            ExpVector e2 = e1.sum(e);
            pv.put(e2, c1);
        }
        return p;
    }

    @Override
    public GenPolynomial<C> multiply(Map.Entry<ExpVector, C> m) {
        if (m == null) {
            return this.ring.getZERO();
        }
        return this.multiply((RingElem)m.getValue(), m.getKey());
    }

    @Override
    public GenPolynomial<C> divide(C s) {
        if (s == null || s.isZERO()) {
            throw new ArithmeticException("division by zero");
        }
        if (this.isZERO()) {
            return this;
        }
        Element p = ((GenPolynomial)this.ring.getZERO()).copy();
        SortedMap<ExpVector, C> pv = ((GenPolynomial)p).val;
        for (Map.Entry<ExpVector, C> m : this.val.entrySet()) {
            RingElem x;
            ExpVector e = m.getKey();
            RingElem c1 = (RingElem)m.getValue();
            RingElem c = (RingElem)c1.divide(s);
            if (this.debug && !(x = (RingElem)c1.remainder(s)).isZERO()) {
                logger.info((Object)("divide x = " + x));
                throw new ArithmeticException("no exact division: " + c1 + "/" + s);
            }
            if (c.isZERO()) {
                throw new ArithmeticException("no exact division: " + c1 + "/" + s + ", in " + this);
            }
            pv.put(e, c);
        }
        return p;
    }

    public GenPolynomial<C>[] quotientRemainder(GenPolynomial<C> S) {
        ExpVector f;
        if (S == null || S.isZERO()) {
            throw new ArithmeticException("division by zero");
        }
        C c = S.leadingBaseCoefficient();
        if (!c.isUnit()) {
            throw new ArithmeticException("lbcf not invertible " + c);
        }
        RingElem ci = (RingElem)c.inverse();
        assert (this.ring.nvar == S.ring.nvar);
        ExpVector e = S.leadingExpVector();
        GenPolynomial<C> q = ((GenPolynomial)this.ring.getZERO()).copy();
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> r = this.copy();
        while (!r.isZERO() && (f = r.leadingExpVector()).multipleOf(e)) {
            RingElem a = r.leadingBaseCoefficient();
            f = f.subtract(e);
            a = a.multiply((RingElem)ci);
            q = q.sum(a, f);
            GenPolynomial<C> h = S.multiply(a, f);
            r = r.subtract((GenPolynomial<GenPolynomial<C>>)h);
        }
        GenPolynomial[] ret = new GenPolynomial[]{q, r};
        return ret;
    }

    @Deprecated
    public GenPolynomial<C>[] divideAndRemainder(GenPolynomial<C> S) {
        return this.quotientRemainder(S);
    }

    @Override
    public GenPolynomial<C> divide(GenPolynomial<C> S) {
        if (this instanceof GenSolvablePolynomial || S instanceof GenSolvablePolynomial) {
            GenSolvablePolynomial T = (GenSolvablePolynomial)this;
            GenSolvablePolynomial Sp = (GenSolvablePolynomial)S;
            return T.quotientRemainder(Sp)[0];
        }
        return this.quotientRemainder(S)[0];
    }

    @Override
    public GenPolynomial<C> remainder(GenPolynomial<C> S) {
        ExpVector f;
        if (this instanceof GenSolvablePolynomial || S instanceof GenSolvablePolynomial) {
            GenSolvablePolynomial T = (GenSolvablePolynomial)this;
            GenSolvablePolynomial Sp = (GenSolvablePolynomial)S;
            return T.quotientRemainder(Sp)[1];
        }
        if (S == null || S.isZERO()) {
            throw new ArithmeticException("division by zero");
        }
        C c = S.leadingBaseCoefficient();
        if (!c.isUnit()) {
            throw new ArithmeticException("lbc not invertible " + c);
        }
        RingElem ci = (RingElem)c.inverse();
        assert (this.ring.nvar == S.ring.nvar);
        ExpVector e = S.leadingExpVector();
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> r = this.copy();
        while (!r.isZERO() && (f = r.leadingExpVector()).multipleOf(e)) {
            RingElem a = r.leadingBaseCoefficient();
            f = f.subtract(e);
            a = a.multiply((RingElem)ci);
            GenPolynomial<C> h = S.multiply(a, f);
            r = r.subtract((GenPolynomial<GenPolynomial<C>>)h);
        }
        return r;
    }

    @Override
    public GenPolynomial<C> gcd(GenPolynomial<C> S) {
        if (S == null || S.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return S;
        }
        if (this.ring.nvar != 1) {
            throw new IllegalArgumentException("not univariate polynomials" + this.ring);
        }
        GenPolynomial<C> q = this;
        GenPolynomial<C> r = S;
        while (!r.isZERO()) {
            GenPolynomial<C> x = q.remainder(r);
            q = r;
            r = x;
        }
        return q.monic();
    }

    public GenPolynomial<C>[] egcd(GenPolynomial<C> S) {
        GenPolynomial[] ret = new GenPolynomial[]{null, null, null};
        if (S == null || S.isZERO()) {
            ret[0] = this;
            ret[1] = this.ring.getONE();
            ret[2] = this.ring.getZERO();
            return ret;
        }
        if (this.isZERO()) {
            ret[0] = S;
            ret[1] = this.ring.getZERO();
            ret[2] = this.ring.getONE();
            return ret;
        }
        if (this.ring.nvar != 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " not univariate polynomials" + this.ring);
        }
        if (this.isConstant() && S.isConstant()) {
            C t = this.leadingBaseCoefficient();
            C s = S.leadingBaseCoefficient();
            RingElem[] gg = t.egcd(s);
            AbelianGroupElem z = this.ring.getZERO();
            ret[0] = ((GenPolynomial)z).sum((C)gg[0]);
            ret[1] = ((GenPolynomial)z).sum((C)gg[1]);
            ret[2] = ((GenPolynomial)z).sum((C)gg[2]);
            return ret;
        }
        GenPolynomial q = this;
        GenPolynomial<C> r = S;
        GenPolynomial<RingElem<Object>> c1 = ((GenPolynomial)this.ring.getONE()).copy();
        GenPolynomial<GenPolynomial<Element>> d1 = ((GenPolynomial)this.ring.getZERO()).copy();
        GenPolynomial<RingElem<Object>> c2 = ((GenPolynomial)this.ring.getZERO()).copy();
        GenPolynomial<GenPolynomial<Element>> d2 = ((GenPolynomial)this.ring.getONE()).copy();
        while (!r.isZERO()) {
            GenPolynomial<C>[] qr = q.quotientRemainder(r);
            q = qr[0];
            GenPolynomial<GenPolynomial<Element>> x1 = c1.subtract((RingElem<Object>)q.multiply((C)d1));
            GenPolynomial<GenPolynomial<Element>> x2 = c2.subtract((RingElem<Object>)q.multiply((C)d2));
            c1 = d1;
            c2 = d2;
            d1 = x1;
            d2 = x2;
            q = r;
            r = qr[1];
        }
        C g = q.leadingBaseCoefficient();
        if (g.isUnit()) {
            RingElem h = (RingElem)g.inverse();
            q = q.multiply((C)h);
            c1 = c1.multiply(h);
            c2 = c2.multiply(h);
        }
        ret[0] = q;
        ret[1] = c1;
        ret[2] = c2;
        return ret;
    }

    public GenPolynomial<C>[] hegcd(GenPolynomial<C> S) {
        GenPolynomial[] ret = new GenPolynomial[]{null, null};
        if (S == null || S.isZERO()) {
            ret[0] = this;
            ret[1] = this.ring.getONE();
            return ret;
        }
        if (this.isZERO()) {
            ret[0] = S;
            return ret;
        }
        if (this.ring.nvar != 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " not univariate polynomials" + this.ring);
        }
        GenPolynomial<RingElem> q = this;
        GenPolynomial<C> r = S;
        GenPolynomial<RingElem> c1 = ((GenPolynomial)this.ring.getONE()).copy();
        GenPolynomial<GenPolynomial<Element>> d1 = ((GenPolynomial)this.ring.getZERO()).copy();
        while (!r.isZERO()) {
            GenPolynomial<C>[] qr = q.quotientRemainder(r);
            q = qr[0];
            GenPolynomial<GenPolynomial<Element>> x1 = c1.subtract(q.multiply(d1));
            c1 = d1;
            d1 = x1;
            q = r;
            r = qr[1];
        }
        C g = q.leadingBaseCoefficient();
        if (g.isUnit()) {
            RingElem h = (RingElem)g.inverse();
            q = q.multiply(h);
            c1 = c1.multiply(h);
        }
        ret[0] = q;
        ret[1] = c1;
        return ret;
    }

    @Override
    public GenPolynomial<C> inverse() {
        if (this.isUnit()) {
            RingElem c = (RingElem)this.leadingBaseCoefficient().inverse();
            return ((GenPolynomial)this.ring.getONE()).multiply((C)c);
        }
        throw new NotInvertibleException("element not invertible " + this + " :: " + this.ring);
    }

    public GenPolynomial<C> modInverse(GenPolynomial<C> m) {
        if (this.isZERO()) {
            throw new NotInvertibleException("zero is not invertible");
        }
        GenPolynomial<C>[] hegcd = this.hegcd(m);
        GenPolynomial<C> a = hegcd[0];
        if (!a.isUnit()) {
            throw new AlgebraicNotInvertibleException("element not invertible, gcd != 1", m, a, m.divide(a));
        }
        GenPolynomial<C> b = hegcd[1];
        if (b.isZERO()) {
            throw new NotInvertibleException("element not invertible, divisible by modul");
        }
        return b;
    }

    public GenPolynomial<C> extend(GenPolynomialRing<C> pfac, int j, long k) {
        if (this.ring.equals(pfac)) {
            return this;
        }
        Element Cp = ((GenPolynomial)pfac.getZERO()).copy();
        if (this.isZERO()) {
            return Cp;
        }
        int i = pfac.nvar - this.ring.nvar;
        SortedMap<ExpVector, C> C = ((GenPolynomial)Cp).val;
        SortedMap<ExpVector, C> A = this.val;
        for (Map.Entry y : A.entrySet()) {
            ExpVector e = (ExpVector)y.getKey();
            RingElem a = (RingElem)y.getValue();
            ExpVector f = e.extend(i, j, k);
            C.put(f, a);
        }
        return Cp;
    }

    public GenPolynomial<C> extendLower(GenPolynomialRing<C> pfac, int j, long k) {
        if (this.ring.equals(pfac)) {
            return this;
        }
        Element Cp = ((GenPolynomial)pfac.getZERO()).copy();
        if (this.isZERO()) {
            return Cp;
        }
        int i = pfac.nvar - this.ring.nvar;
        SortedMap<ExpVector, C> C = ((GenPolynomial)Cp).val;
        SortedMap<ExpVector, C> A = this.val;
        for (Map.Entry y : A.entrySet()) {
            ExpVector e = (ExpVector)y.getKey();
            RingElem a = (RingElem)y.getValue();
            ExpVector f = e.extendLower(i, j, k);
            C.put(f, a);
        }
        return Cp;
    }

    public Map<ExpVector, GenPolynomial<C>> contract(GenPolynomialRing<C> pfac) {
        AbelianGroupElem zero = pfac.getZERO();
        TermOrder t = new TermOrder(2);
        TreeMap<ExpVector, GenPolynomial<C>> B = new TreeMap<ExpVector, GenPolynomial<C>>(t.getAscendComparator());
        if (this.isZERO()) {
            return B;
        }
        int i = this.ring.nvar - pfac.nvar;
        SortedMap<ExpVector, C> A = this.val;
        for (Map.Entry y : A.entrySet()) {
            ExpVector e = (ExpVector)y.getKey();
            RingElem a = (RingElem)y.getValue();
            ExpVector f = e.contract(0, i);
            ExpVector g = e.contract(i, e.length() - i);
            GenPolynomial p = (GenPolynomial)B.get(f);
            if (p == null) {
                p = zero;
            }
            p = p.sum(a, g);
            B.put(f, p);
        }
        return B;
    }

    public GenPolynomial<C> contractCoeff(GenPolynomialRing<C> pfac) {
        Map<ExpVector, GenPolynomial<C>> ms = this.contract(pfac);
        GenPolynomial<C> c = pfac.getZERO();
        for (Map.Entry<ExpVector, GenPolynomial<C>> m : ms.entrySet()) {
            if (m.getKey().isZERO()) {
                c = m.getValue();
                continue;
            }
            throw new RuntimeException("wrong coefficient contraction " + m + ", pol =  " + c);
        }
        return c;
    }

    public GenPolynomial<C> extendUnivariate(GenPolynomialRing<C> pfac, int i) {
        if (i < 0 || pfac.nvar < i) {
            throw new IllegalArgumentException("index " + i + "out of range " + pfac.nvar);
        }
        if (this.ring.nvar != 1) {
            throw new IllegalArgumentException("polynomial not univariate " + this.ring.nvar);
        }
        if (this.isONE()) {
            return pfac.getONE();
        }
        int j = pfac.nvar - 1 - i;
        Element Cp = ((GenPolynomial)pfac.getZERO()).copy();
        if (this.isZERO()) {
            return Cp;
        }
        SortedMap<ExpVector, C> C = ((GenPolynomial)Cp).val;
        SortedMap<ExpVector, C> A = this.val;
        for (Map.Entry y : A.entrySet()) {
            ExpVector e = (ExpVector)y.getKey();
            long n = e.getVal(0);
            RingElem a = (RingElem)y.getValue();
            ExpVector f = ExpVector.create(pfac.nvar, j, n);
            C.put(f, a);
        }
        return Cp;
    }

    public GenPolynomial<C> homogenize(GenPolynomialRing<C> pfac) {
        if (this.ring.equals(pfac)) {
            throw new UnsupportedOperationException("case with same ring not implemented");
        }
        Element Cp = ((GenPolynomial)pfac.getZERO()).copy();
        if (this.isZERO()) {
            return Cp;
        }
        long deg = this.totalDegree();
        SortedMap<ExpVector, C> C = ((GenPolynomial)Cp).val;
        SortedMap<ExpVector, C> A = this.val;
        for (Map.Entry y : A.entrySet()) {
            ExpVector e = (ExpVector)y.getKey();
            RingElem a = (RingElem)y.getValue();
            long d = deg - e.totalDeg();
            ExpVector f = e.extend(1, 0, d);
            C.put(f, a);
        }
        return Cp;
    }

    public GenPolynomial<C> deHomogenize(GenPolynomialRing<C> pfac) {
        if (this.ring.equals(pfac)) {
            throw new UnsupportedOperationException("case with same ring not implemented");
        }
        Element Cp = ((GenPolynomial)pfac.getZERO()).copy();
        if (this.isZERO()) {
            return Cp;
        }
        SortedMap<ExpVector, C> C = ((GenPolynomial)Cp).val;
        SortedMap<ExpVector, C> A = this.val;
        for (Map.Entry y : A.entrySet()) {
            ExpVector e = (ExpVector)y.getKey();
            RingElem a = (RingElem)y.getValue();
            ExpVector f = e.contract(1, pfac.nvar);
            C.put(f, a);
        }
        return Cp;
    }

    public GenPolynomial<C> reverse(GenPolynomialRing<C> oring) {
        Element Cp = ((GenPolynomial)oring.getZERO()).copy();
        if (this.isZERO()) {
            return Cp;
        }
        int k = -1;
        if (oring.tord.getEvord2() != 0 && oring.partial) {
            k = oring.tord.getSplit();
        }
        SortedMap<ExpVector, C> C = ((GenPolynomial)Cp).val;
        SortedMap<ExpVector, C> A = this.val;
        for (Map.Entry y : A.entrySet()) {
            ExpVector e = (ExpVector)y.getKey();
            ExpVector f = k >= 0 ? e.reverse(k) : e.reverse();
            RingElem a = (RingElem)y.getValue();
            C.put(f, a);
        }
        return Cp;
    }

    public Iterator<C> coefficientIterator() {
        return this.val.values().iterator();
    }

    public Iterator<ExpVector> exponentIterator() {
        return this.val.keySet().iterator();
    }

    @Override
    public Iterator<Monomial<C>> iterator() {
        return new PolyIterator<C>(this.val);
    }

    public GenPolynomial<C> map(UnaryFunctor<? super C, C> f) {
        Element n = ((GenPolynomial)this.ring.getZERO()).copy();
        SortedMap<ExpVector, C> nv = ((GenPolynomial)n).val;
        for (Monomial<C> m : this) {
            RingElem c = (RingElem)f.eval(m.c);
            if (c == null || c.isZERO()) continue;
            nv.put(m.e, c);
        }
        return n;
    }
}

