/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.ExpVector;
import java.util.ArrayList;
import java.util.Arrays;

public final class ExpVectorLong
extends ExpVector {
    final long[] val;

    public ExpVectorLong(int n) {
        this(new long[n]);
    }

    public ExpVectorLong(int n, int i, long e) {
        this(new long[n]);
        this.val[i] = e;
    }

    public ExpVectorLong(long[] v) {
        if (v == null) {
            throw new IllegalArgumentException("null val not allowed");
        }
        this.val = Arrays.copyOf(v, v.length);
    }

    public ExpVectorLong(String s) throws NumberFormatException {
        ArrayList<Long> exps = new ArrayList<Long>();
        s = s.trim();
        int b = s.indexOf(40);
        int e = s.indexOf(41, b + 1);
        if (b >= 0 && e >= 0) {
            long a;
            String teil;
            int k;
            ++b;
            while ((k = s.indexOf(44, b)) >= 0) {
                teil = s.substring(b, k);
                a = Long.parseLong(teil);
                exps.add(a);
                b = k + 1;
            }
            if (b <= e) {
                teil = s.substring(b, e);
                a = Long.parseLong(teil);
                exps.add(a);
            }
            int length = exps.size();
            this.val = new long[length];
            for (int j = 0; j < length; ++j) {
                this.val[j] = (Long)exps.get(j);
            }
        } else {
            this.val = null;
        }
    }

    @Override
    public ExpVectorLong copy() {
        long[] w = new long[this.val.length];
        System.arraycopy(this.val, 0, w, 0, this.val.length);
        return new ExpVectorLong(w);
    }

    @Override
    long[] getVal() {
        return this.val;
    }

    @Override
    public long getVal(int i) {
        return this.val[i];
    }

    @Override
    protected long setVal(int i, long e) {
        long x = this.val[i];
        this.val[i] = e;
        this.hash = 0;
        return x;
    }

    @Override
    public int length() {
        return this.val.length;
    }

    @Override
    public ExpVectorLong extend(int i, int j, long e) {
        long[] w = new long[this.val.length + i];
        System.arraycopy(this.val, 0, w, i, this.val.length);
        if (j >= i) {
            throw new IllegalArgumentException("i " + i + " <= j " + j + " invalid");
        }
        w[j] = e;
        return new ExpVectorLong(w);
    }

    @Override
    public ExpVectorLong extendLower(int i, int j, long e) {
        long[] w = new long[this.val.length + i];
        System.arraycopy(this.val, 0, w, 0, this.val.length);
        if (j >= i) {
            throw new IllegalArgumentException("i " + i + " <= j " + j + " invalid");
        }
        w[this.val.length + j] = e;
        return new ExpVectorLong(w);
    }

    @Override
    public ExpVectorLong contract(int i, int len) {
        if (i + len > this.val.length) {
            throw new IllegalArgumentException("len " + len + " > val.len " + this.val.length);
        }
        long[] w = new long[len];
        System.arraycopy(this.val, i, w, 0, len);
        return new ExpVectorLong(w);
    }

    @Override
    public ExpVectorLong reverse() {
        long[] w = new long[this.val.length];
        for (int i = 0; i < this.val.length; ++i) {
            w[i] = this.val[this.val.length - 1 - i];
        }
        return new ExpVectorLong(w);
    }

    @Override
    public ExpVectorLong reverse(int j) {
        int i;
        if (j <= 0 || j > this.val.length) {
            return this;
        }
        long[] w = new long[this.val.length];
        for (i = 0; i < j; ++i) {
            w[i] = this.val[j - 1 - i];
        }
        for (i = j; i < this.val.length; ++i) {
            w[i] = this.val[i];
        }
        return new ExpVectorLong(w);
    }

    @Override
    public ExpVectorLong combine(ExpVector V) {
        if (V == null || V.length() == 0) {
            return this;
        }
        ExpVectorLong Vl = (ExpVectorLong)V;
        if (this.val.length == 0) {
            return Vl;
        }
        long[] w = new long[this.val.length + Vl.val.length];
        System.arraycopy(this.val, 0, w, 0, this.val.length);
        System.arraycopy(Vl.val, 0, w, this.val.length, Vl.val.length);
        return new ExpVectorLong(w);
    }

    @Override
    public String toString() {
        return super.toString() + ":long";
    }

    @Override
    public boolean equals(Object B) {
        if (!(B instanceof ExpVectorLong)) {
            return false;
        }
        ExpVectorLong b = (ExpVectorLong)B;
        int t = this.invLexCompareTo(b);
        return 0 == t;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public ExpVectorLong abs() {
        long[] u = this.val;
        long[] w = new long[u.length];
        for (int i = 0; i < u.length; ++i) {
            w[i] = u[i] >= 0L ? u[i] : -u[i];
        }
        return new ExpVectorLong(w);
    }

    @Override
    public ExpVectorLong negate() {
        long[] u = this.val;
        long[] w = new long[u.length];
        for (int i = 0; i < u.length; ++i) {
            w[i] = -u[i];
        }
        return new ExpVectorLong(w);
    }

    @Override
    public ExpVectorLong sum(ExpVector V) {
        long[] u = this.val;
        long[] v = ((ExpVectorLong)V).val;
        long[] w = new long[u.length];
        for (int i = 0; i < u.length; ++i) {
            w[i] = u[i] + v[i];
        }
        return new ExpVectorLong(w);
    }

    @Override
    public ExpVectorLong subtract(ExpVector V) {
        long[] u = this.val;
        long[] v = ((ExpVectorLong)V).val;
        long[] w = new long[u.length];
        for (int i = 0; i < u.length; ++i) {
            w[i] = u[i] - v[i];
        }
        return new ExpVectorLong(w);
    }

    @Override
    public ExpVectorLong subst(int i, long d) {
        ExpVectorLong V = this.copy();
        V.setVal(i, d);
        return V;
    }

    @Override
    public int signum() {
        int t = 0;
        long[] u = this.val;
        for (int i = 0; i < u.length; ++i) {
            if (u[i] < 0L) {
                return -1;
            }
            if (u[i] <= 0L) continue;
            t = 1;
        }
        return t;
    }

    @Override
    public long totalDeg() {
        long t = 0L;
        long[] u = this.val;
        for (int i = 0; i < u.length; ++i) {
            t += u[i];
        }
        return t;
    }

    @Override
    public long maxDeg() {
        long t = 0L;
        long[] u = this.val;
        for (int i = 0; i < u.length; ++i) {
            if (u[i] <= t) continue;
            t = u[i];
        }
        return t;
    }

    @Override
    public long weightDeg(long[][] w) {
        if (w == null || w.length == 0) {
            return this.totalDeg();
        }
        long t = 0L;
        long[] u = this.val;
        for (int j = 0; j < w.length; ++j) {
            long[] wj = w[j];
            for (int i = 0; i < u.length; ++i) {
                t += wj[i] * u[i];
            }
        }
        return t;
    }

    @Override
    public ExpVectorLong lcm(ExpVector V) {
        long[] u = this.val;
        long[] v = ((ExpVectorLong)V).val;
        long[] w = new long[u.length];
        for (int i = 0; i < u.length; ++i) {
            w[i] = u[i] >= v[i] ? u[i] : v[i];
        }
        return new ExpVectorLong(w);
    }

    @Override
    public ExpVectorLong gcd(ExpVector V) {
        long[] u = this.val;
        long[] v = ((ExpVectorLong)V).val;
        long[] w = new long[u.length];
        for (int i = 0; i < u.length; ++i) {
            w[i] = u[i] <= v[i] ? u[i] : v[i];
        }
        return new ExpVectorLong(w);
    }

    @Override
    public int[] dependencyOnVariables() {
        long[] u = this.val;
        int l = 0;
        for (int i = 0; i < u.length; ++i) {
            if (u[i] <= 0L) continue;
            ++l;
        }
        int[] dep = new int[l];
        if (l == 0) {
            return dep;
        }
        int j = 0;
        for (int i = 0; i < u.length; ++i) {
            if (u[i] <= 0L) continue;
            dep[j] = i;
            ++j;
        }
        return dep;
    }

    @Override
    public boolean multipleOf(ExpVector V) {
        long[] u = this.val;
        long[] v = ((ExpVectorLong)V).val;
        boolean t = true;
        for (int i = 0; i < u.length; ++i) {
            if (u[i] >= v[i]) continue;
            return false;
        }
        return t;
    }

    @Override
    public int compareTo(ExpVector V) {
        return this.invLexCompareTo(V);
    }

    @Override
    public int invLexCompareTo(ExpVector V) {
        long[] u = this.val;
        long[] v = ((ExpVectorLong)V).val;
        int t = 0;
        for (int i = 0; i < u.length; ++i) {
            if (u[i] > v[i]) {
                return 1;
            }
            if (u[i] >= v[i]) continue;
            return -1;
        }
        return t;
    }

    @Override
    public int invLexCompareTo(ExpVector V, int begin, int end) {
        long[] u = this.val;
        long[] v = ((ExpVectorLong)V).val;
        int t = 0;
        for (int i = begin; i < end; ++i) {
            if (u[i] > v[i]) {
                return 1;
            }
            if (u[i] >= v[i]) continue;
            return -1;
        }
        return t;
    }

    @Override
    public int invGradCompareTo(ExpVector V) {
        long[] u = this.val;
        long[] v = ((ExpVectorLong)V).val;
        int t = 0;
        for (int i = 0; i < u.length; ++i) {
            if (u[i] > v[i]) {
                t = 1;
                break;
            }
            if (u[i] >= v[i]) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        long up = 0L;
        long vp = 0L;
        for (int j = i; j < u.length; ++j) {
            up += u[j];
            vp += v[j];
        }
        if (up > vp) {
            t = 1;
        } else if (up < vp) {
            t = -1;
        }
        return t;
    }

    @Override
    public int invGradCompareTo(ExpVector V, int begin, int end) {
        long[] u = this.val;
        long[] v = ((ExpVectorLong)V).val;
        int t = 0;
        for (int i = begin; i < end; ++i) {
            if (u[i] > v[i]) {
                t = 1;
                break;
            }
            if (u[i] >= v[i]) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        long up = 0L;
        long vp = 0L;
        for (int j = i; j < end; ++j) {
            up += u[j];
            vp += v[j];
        }
        if (up > vp) {
            t = 1;
        } else if (up < vp) {
            t = -1;
        }
        return t;
    }

    @Override
    public int revInvLexCompareTo(ExpVector V) {
        long[] u = this.val;
        long[] v = ((ExpVectorLong)V).val;
        int t = 0;
        for (int i = u.length - 1; i >= 0; --i) {
            if (u[i] > v[i]) {
                return 1;
            }
            if (u[i] >= v[i]) continue;
            return -1;
        }
        return t;
    }

    @Override
    public int revInvLexCompareTo(ExpVector V, int begin, int end) {
        long[] u = this.val;
        long[] v = ((ExpVectorLong)V).val;
        int t = 0;
        for (int i = end - 1; i >= begin; --i) {
            if (u[i] > v[i]) {
                return 1;
            }
            if (u[i] >= v[i]) continue;
            return -1;
        }
        return t;
    }

    @Override
    public int revInvGradCompareTo(ExpVector V) {
        long[] u = this.val;
        long[] v = ((ExpVectorLong)V).val;
        int t = 0;
        for (int i = u.length - 1; i >= 0; --i) {
            if (u[i] > v[i]) {
                t = 1;
                break;
            }
            if (u[i] >= v[i]) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        long up = 0L;
        long vp = 0L;
        for (int j = i; j >= 0; --j) {
            up += u[j];
            vp += v[j];
        }
        if (up > vp) {
            t = 1;
        } else if (up < vp) {
            t = -1;
        }
        return t;
    }

    @Override
    public int revInvGradCompareTo(ExpVector V, int begin, int end) {
        long[] u = this.val;
        long[] v = ((ExpVectorLong)V).val;
        int t = 0;
        for (int i = end - 1; i >= begin; --i) {
            if (u[i] > v[i]) {
                t = 1;
                break;
            }
            if (u[i] >= v[i]) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        long up = 0L;
        long vp = 0L;
        for (int j = i; j >= begin; --j) {
            up += u[j];
            vp += v[j];
        }
        if (up > vp) {
            t = 1;
        } else if (up < vp) {
            t = -1;
        }
        return t;
    }

    @Override
    public int invWeightCompareTo(long[][] w, ExpVector V) {
        long[] u = this.val;
        long[] v = ((ExpVectorLong)V).val;
        int t = 0;
        for (int i = 0; i < u.length; ++i) {
            if (u[i] > v[i]) {
                t = 1;
                break;
            }
            if (u[i] >= v[i]) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        for (int k = 0; k < w.length; ++k) {
            long[] wk = w[k];
            long up = 0L;
            long vp = 0L;
            for (int j = i; j < u.length; ++j) {
                up += wk[j] * u[j];
                vp += wk[j] * v[j];
            }
            if (up > vp) {
                return 1;
            }
            if (up >= vp) continue;
            return -1;
        }
        return t;
    }

    @Override
    public int invWeightCompareTo(long[][] w, ExpVector V, int begin, int end) {
        long[] u = this.val;
        long[] v = ((ExpVectorLong)V).val;
        int t = 0;
        for (int i = begin; i < end; ++i) {
            if (u[i] > v[i]) {
                t = 1;
                break;
            }
            if (u[i] >= v[i]) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        for (int k = 0; k < w.length; ++k) {
            long[] wk = w[k];
            long up = 0L;
            long vp = 0L;
            for (int j = i; j < end; ++j) {
                up += wk[j] * u[j];
                vp += wk[j] * v[j];
            }
            if (up > vp) {
                return 1;
            }
            if (up >= vp) continue;
            return -1;
        }
        return t;
    }
}

