/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.integrate;

import edu.jas.arith.BigRational;
import edu.jas.integrate.ElementaryIntegration;
import edu.jas.integrate.Integral;
import edu.jas.integrate.QuotIntegral;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.structure.Element;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import java.util.List;

public class Examples {
    public static void main(String[] args) {
        Examples.example1();
        Examples.example2();
        Examples.example3();
    }

    public static void example1() {
        BigRational br = new BigRational(0L);
        String[] vars = new String[]{"x"};
        GenPolynomialRing<BigRational> fac = new GenPolynomialRing<BigRational>(br, vars.length, new TermOrder(2), vars);
        ElementaryIntegration<BigRational> eIntegrator = new ElementaryIntegration<BigRational>(br);
        Element a = fac.parse("x^7 - 24 x^4 - 4 x^2 + 8 x - 8");
        System.out.println("A: " + ((GenPolynomial)a).toString());
        Element d = fac.parse("x^8 + 6 x^6 + 12 x^4 + 8 x^2");
        System.out.println("D: " + ((GenPolynomial)d).toString());
        GenPolynomial gcd = ((GenPolynomial)a).gcd(d);
        System.out.println("GCD: " + gcd.toString());
        List<GenPolynomial<BigRational>>[] ret = eIntegrator.integrateHermite((GenPolynomial<BigRational>)a, (GenPolynomial<BigRational>)d);
        System.out.println("Result: " + ret[0] + " , " + ret[1]);
        System.out.println("-----");
        a = fac.parse("10 x^2 - 63 x + 29");
        System.out.println("A: " + ((GenPolynomial)a).toString());
        d = fac.parse("x^3 - 11 x^2 + 40 x -48");
        System.out.println("D: " + ((GenPolynomial)d).toString());
        gcd = ((GenPolynomial)a).gcd(d);
        System.out.println("GCD: " + gcd.toString());
        ret = eIntegrator.integrateHermite((GenPolynomial<BigRational>)a, (GenPolynomial<BigRational>)d);
        System.out.println("Result: " + ret[0] + " , " + ret[1]);
        System.out.println("-----");
        a = fac.parse("x+3");
        System.out.println("A: " + ((GenPolynomial)a).toString());
        d = fac.parse("x^2 - 3 x - 40");
        System.out.println("D: " + ((GenPolynomial)d).toString());
        gcd = ((GenPolynomial)a).gcd(d);
        System.out.println("GCD: " + gcd.toString());
        ret = eIntegrator.integrateHermite((GenPolynomial<BigRational>)a, (GenPolynomial<BigRational>)d);
        System.out.println("Result: " + ret[0] + " , " + ret[1]);
        System.out.println("-----");
        a = fac.parse("10 x^2+12 x + 20");
        System.out.println("A: " + ((GenPolynomial)a).toString());
        d = fac.parse("x^3 - 8");
        System.out.println("D: " + ((GenPolynomial)d).toString());
        gcd = ((GenPolynomial)a).gcd(d);
        System.out.println("GCD: " + gcd.toString());
        ret = eIntegrator.integrateHermite((GenPolynomial<BigRational>)a, (GenPolynomial<BigRational>)d);
        System.out.println("Result: " + ret[0] + " , " + ret[1]);
        System.out.println("------------------------------------------------------\n");
        ComputerThreads.terminate();
    }

    public static void example2() {
        BigRational br = new BigRational(0L);
        String[] vars = new String[]{"x"};
        GenPolynomialRing<BigRational> fac = new GenPolynomialRing<BigRational>(br, vars.length, new TermOrder(2), vars);
        ElementaryIntegration<BigRational> eIntegrator = new ElementaryIntegration<BigRational>(br);
        GenPolynomial<Element> a = fac.parse("x^7 - 24 x^4 - 4 x^2 + 8 x - 8");
        System.out.println("A: " + a.toString());
        Element d = fac.parse("x^8 + 6 x^6 + 12 x^4 + 8 x^2");
        System.out.println("D: " + ((GenPolynomial)d).toString());
        GenPolynomial<Object> gcd = a.gcd((GenPolynomial<Element>)d);
        System.out.println("GCD: " + gcd.toString());
        Integral<BigRational> ret = eIntegrator.integrate((GenPolynomial<BigRational>)a, (GenPolynomial<BigRational>)d);
        System.out.println("Result: " + ret);
        System.out.println("-----");
        a = fac.parse("10 x^2 - 63 x + 29");
        System.out.println("A: " + a.toString());
        d = fac.parse("x^3 - 11 x^2 + 40 x -48");
        System.out.println("D: " + ((GenPolynomial)d).toString());
        gcd = a.gcd((GenPolynomial<Element>)d);
        System.out.println("GCD: " + gcd.toString());
        ret = eIntegrator.integrate((GenPolynomial<BigRational>)a, (GenPolynomial<BigRational>)d);
        System.out.println("Result: " + ret);
        System.out.println("-----");
        a = fac.parse("x+3");
        System.out.println("A: " + a.toString());
        d = fac.parse("x^2 - 3 x - 40");
        System.out.println("D: " + ((GenPolynomial)d).toString());
        gcd = a.gcd((GenPolynomial<Element>)d);
        System.out.println("GCD: " + gcd.toString());
        ret = eIntegrator.integrate((GenPolynomial<BigRational>)a, (GenPolynomial<BigRational>)d);
        System.out.println("Result: " + ret);
        System.out.println("-----");
        a = fac.parse("10 x^2+12 x + 20");
        System.out.println("A: " + a.toString());
        d = fac.parse("x^3 - 8");
        System.out.println("D: " + ((GenPolynomial)d).toString());
        gcd = a.gcd((GenPolynomial<Element>)d);
        System.out.println("GCD: " + gcd.toString());
        ret = eIntegrator.integrate((GenPolynomial<BigRational>)a, (GenPolynomial<BigRational>)d);
        System.out.println("Result: " + ret);
        System.out.println("-----");
        a = fac.parse("1");
        System.out.println("A: " + a.toString());
        d = fac.parse("(x**5 + x - 7)");
        System.out.println("D: " + ((GenPolynomial)d).toString());
        gcd = a.gcd((GenPolynomial<Element>)d);
        System.out.println("GCD: " + gcd.toString());
        ret = eIntegrator.integrate((GenPolynomial<BigRational>)a, (GenPolynomial<BigRational>)d);
        System.out.println("Result: " + ret);
        System.out.println("-----");
        a = fac.parse("1");
        d = fac.parse("(x**5 + x - 7)");
        a = a.sum(d);
        System.out.println("A: " + a.toString());
        System.out.println("D: " + ((GenPolynomial)d).toString());
        gcd = a.gcd((GenPolynomial<Element>)d);
        System.out.println("GCD: " + gcd.toString());
        ret = eIntegrator.integrate(a, (GenPolynomial<BigRational>)d);
        System.out.println("Result: " + ret);
        System.out.println("-----");
        ComputerThreads.terminate();
    }

    public static void example3() {
        BigRational br = new BigRational(0L);
        String[] vars = new String[]{"x"};
        GenPolynomialRing<BigRational> fac = new GenPolynomialRing<BigRational>(br, vars.length, new TermOrder(2), vars);
        QuotientRing<BigRational> qfac = new QuotientRing<BigRational>(fac);
        ElementaryIntegration<BigRational> eIntegrator = new ElementaryIntegration<BigRational>(br);
        GenPolynomial<Element> a = fac.parse("x^7 - 24 x^4 - 4 x^2 + 8 x - 8");
        Element d = fac.parse("x^8 + 6 x^6 + 12 x^4 + 8 x^2");
        Quotient<Element<BigRational>> q = new Quotient<BigRational>(qfac, (GenPolynomial<BigRational>)a, (GenPolynomial<BigRational>)d);
        System.out.println("q =  " + q);
        QuotIntegral<BigRational> ret = eIntegrator.integrate(q);
        System.out.println("Result: " + ret);
        System.out.println("-----");
        a = fac.parse("10 x^2 - 63 x + 29");
        d = fac.parse("x^3 - 11 x^2 + 40 x -48");
        q = new Quotient<BigRational>(qfac, (GenPolynomial<BigRational>)a, (GenPolynomial<BigRational>)d);
        System.out.println("q =  " + q);
        ret = eIntegrator.integrate(q);
        System.out.println("Result: " + ret);
        System.out.println("-----");
        a = fac.parse("x+3");
        d = fac.parse("x^2 - 3 x - 40");
        q = new Quotient<BigRational>(qfac, (GenPolynomial<BigRational>)a, (GenPolynomial<BigRational>)d);
        System.out.println("q =  " + q);
        ret = eIntegrator.integrate(q);
        System.out.println("Result: " + ret);
        System.out.println("-----");
        a = fac.parse("10 x^2+12 x + 20");
        d = fac.parse("x^3 - 8");
        q = new Quotient<BigRational>(qfac, (GenPolynomial<BigRational>)a, (GenPolynomial<BigRational>)d);
        System.out.println("q =  " + q);
        ret = eIntegrator.integrate(q);
        System.out.println("Result: " + ret);
        System.out.println("-----");
        a = fac.parse("1");
        d = fac.parse("(x**5 + x - 7)");
        q = new Quotient<BigRational>(qfac, (GenPolynomial<BigRational>)a, (GenPolynomial<BigRational>)d);
        System.out.println("q =  " + q);
        ret = eIntegrator.integrate(q);
        System.out.println("Result: " + ret);
        System.out.println("-----");
        a = fac.parse("1");
        d = fac.parse("(x**5 + x - 7)");
        a = a.sum(d);
        q = new Quotient<Element>((QuotientRing<Element>)qfac, a, (GenPolynomial<Element>)d);
        System.out.println("q =  " + q);
        ret = eIntegrator.integrate(q);
        System.out.println("Result: " + ret);
        System.out.println("-----");
        Element qi = qfac.random(7);
        q = eIntegrator.deriviative((Quotient<BigRational>)qi);
        System.out.println("qi =  " + qi);
        System.out.println("q  =  " + q);
        ret = eIntegrator.integrate(q);
        System.out.println("Result: " + ret);
        boolean t = eIntegrator.isIntegral(ret);
        System.out.println("isIntegral = " + t);
        System.out.println("-----");
        ComputerThreads.terminate();
    }
}

