/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gbufd.GroebnerBasePseudoParallel;
import edu.jas.gbufd.GroebnerBasePseudoSeq;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class GroebnerBaseRational<C extends BigRational>
extends GroebnerBaseAbstract<BigRational> {
    private static final Logger logger = Logger.getLogger(GroebnerBaseRational.class);
    private final boolean debug = logger.isDebugEnabled();
    public final GroebnerBaseAbstract<BigInteger> bba;

    public GroebnerBaseRational() {
        this.bba = new GroebnerBasePseudoSeq<BigInteger>(new BigInteger());
    }

    public GroebnerBaseRational(int threads) {
        this.bba = new GroebnerBasePseudoParallel<BigInteger>(threads, new BigInteger());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.bba.toString() + ")";
    }

    @Override
    public List<GenPolynomial<BigRational>> GB(int modv, List<GenPolynomial<BigRational>> F) {
        List<GenPolynomial<BigRational>> G = F;
        if (F == null || F.isEmpty()) {
            return G;
        }
        GenPolynomialRing rring = F.get((int)0).ring;
        BigInteger cf = new BigInteger();
        GenPolynomialRing<BigInteger> iring = new GenPolynomialRing<BigInteger>(cf, rring);
        List Fi = PolyUtil.integerFromRationalCoefficients(iring, F);
        logger.info((Object)("#Fi = " + Fi.size()));
        List<GenPolynomial<BigInteger>> Gi = this.bba.GB(modv, Fi);
        logger.info((Object)("#Gi = " + Gi.size()));
        G = PolyUtil.fromIntegerCoefficients(rring, Gi);
        G = PolyUtil.monic(G);
        return G;
    }

    @Override
    public List<GenPolynomial<BigRational>> minimalGB(List<GenPolynomial<BigRational>> Gp) {
        if (Gp == null || Gp.size() <= 1) {
            return Gp;
        }
        List<GenPolynomial<BigRational>> G = new ArrayList<GenPolynomial<BigRational>>(Gp.size());
        for (GenPolynomial<BigRational> a : Gp) {
            if (a == null || a.isZERO()) continue;
            G.add(a);
        }
        if (G.size() <= 1) {
            return G;
        }
        ArrayList<GenPolynomial<BigRational>> F = new ArrayList<GenPolynomial<BigRational>>(G.size());
        while (G.size() > 0) {
            GenPolynomial a = (GenPolynomial)G.remove(0);
            if (this.red.isTopReducible(G, a) || this.red.isTopReducible(F, a)) {
                if (!this.debug) continue;
                System.out.println("dropped " + a);
                ArrayList ff = new ArrayList(G);
                ff.addAll(F);
                if ((a = this.red.normalform(ff, a)).isZERO()) continue;
                System.out.println("error, nf(a) " + a);
                continue;
            }
            F.add(a);
        }
        G = F;
        if (G.size() <= 1) {
            return G;
        }
        GenPolynomialRing rring = ((GenPolynomial)G.get((int)0)).ring;
        BigInteger cf = new BigInteger();
        GenPolynomialRing<BigInteger> iring = new GenPolynomialRing<BigInteger>(cf, rring);
        List Fi = PolyUtil.integerFromRationalCoefficients(iring, F);
        logger.info((Object)("#Fi = " + Fi.size()));
        List<GenPolynomial<BigInteger>> Gi = this.bba.minimalGB(Fi);
        logger.info((Object)("#Gi = " + Gi.size()));
        G = PolyUtil.fromIntegerCoefficients(rring, Gi);
        G = PolyUtil.monic(G);
        return G;
    }

    @Override
    public void terminate() {
        this.bba.terminate();
    }

    @Override
    public int cancel() {
        return this.bba.cancel();
    }
}

