/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbmod;

import edu.jas.gbmod.SolvableQuotientRing;
import edu.jas.gbufd.PolyGBUtil;
import edu.jas.kern.PrettyPrint;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.QuotPair;
import edu.jas.structure.RingElem;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class SolvableQuotient<C extends GcdRingElem<C>>
implements GcdRingElem<SolvableQuotient<C>>,
QuotPair<GenPolynomial<C>> {
    private static final Logger logger = Logger.getLogger(SolvableQuotient.class);
    private final boolean debug = logger.isDebugEnabled();
    public final SolvableQuotientRing<C> ring;
    public final GenSolvablePolynomial<C> num;
    public final GenSolvablePolynomial<C> den;

    public SolvableQuotient(SolvableQuotientRing<C> r) {
        this(r, (GenSolvablePolynomial<C>)r.ring.getZERO());
    }

    public SolvableQuotient(SolvableQuotientRing<C> r, GenSolvablePolynomial<C> n) {
        this(r, n, (GenSolvablePolynomial<C>)r.ring.getONE(), true);
    }

    public SolvableQuotient(SolvableQuotientRing<C> r, GenSolvablePolynomial<C> n, GenSolvablePolynomial<C> d) {
        this(r, n, d, false);
    }

    protected SolvableQuotient(SolvableQuotientRing<C> r, GenSolvablePolynomial<C> n, GenSolvablePolynomial<C> d, boolean isred) {
        if (d == null || ((GenPolynomial)d).isZERO()) {
            throw new IllegalArgumentException("denominator may not be zero");
        }
        this.ring = r;
        if (((GenPolynomial)d).signum() < 0) {
            n = (GenSolvablePolynomial)((GenPolynomial)n).negate();
            d = (GenSolvablePolynomial)((GenPolynomial)d).negate();
        }
        if (isred) {
            this.num = n;
            this.den = d;
            return;
        }
        GcdRingElem lc = (GcdRingElem)((GenPolynomial)d).leadingBaseCoefficient();
        if (!lc.isONE() && lc.isUnit()) {
            lc = (GcdRingElem)lc.inverse();
            n = ((GenSolvablePolynomial)n).multiply(lc);
            d = ((GenSolvablePolynomial)d).multiply(lc);
        }
        if (((GenPolynomial)n).compareTo(d) == 0) {
            this.num = this.ring.ring.getONE();
            this.den = this.ring.ring.getONE();
            return;
        }
        if (((GenPolynomial)((GenPolynomial)n).negate()).compareTo(d) == 0) {
            this.num = (GenSolvablePolynomial)this.ring.ring.getONE().negate();
            this.den = this.ring.ring.getONE();
            return;
        }
        if (((GenPolynomial)n).isZERO()) {
            this.num = n;
            this.den = this.ring.ring.getONE();
            return;
        }
        if (((GenPolynomial)n).isONE() || ((GenPolynomial)d).isONE()) {
            this.num = n;
            this.den = d;
            return;
        }
        Object[] gcd = PolyGBUtil.syzGcdCofactors(r.ring, n, d);
        if (!gcd[0].isONE()) {
            logger.info((Object)("constructor: gcd = " + Arrays.toString(gcd)));
            n = gcd[1];
            d = gcd[2];
        }
        Object[] simp = this.ring.engine.leftSimplifier(n, d);
        logger.info((Object)("simp: " + Arrays.toString(simp) + ", " + n + ", " + d));
        this.num = simp[0];
        this.den = simp[1];
    }

    @Override
    public SolvableQuotientRing<C> factory() {
        return this.ring;
    }

    @Override
    public GenSolvablePolynomial<C> numerator() {
        return this.num;
    }

    @Override
    public GenSolvablePolynomial<C> denominator() {
        return this.den;
    }

    @Override
    public SolvableQuotient<C> copy() {
        return new SolvableQuotient<C>(this.ring, this.num, this.den, true);
    }

    @Override
    public boolean isZERO() {
        return this.num.isZERO();
    }

    @Override
    public boolean isONE() {
        return this.num.compareTo(this.den) == 0;
    }

    @Override
    public boolean isUnit() {
        return !this.num.isZERO();
    }

    @Override
    public boolean isConstant() {
        return this.num.isConstant() && this.den.isConstant();
    }

    public String toString() {
        if (PrettyPrint.isTrue()) {
            String s = "{ " + this.num.toString(this.ring.ring.getVars());
            if (!this.den.isONE()) {
                s = s + " | " + this.den.toString(this.ring.ring.getVars());
            }
            return s + " }";
        }
        return "SolvableQuotient[ " + this.num.toString() + " | " + this.den.toString() + " ]";
    }

    @Override
    public String toScript() {
        if (this.den.isONE()) {
            return this.num.toScript();
        }
        return this.num.toScript() + " / " + this.den.toScript();
    }

    @Override
    public String toScriptFactory() {
        return ((SolvableQuotientRing)this.factory()).toScript();
    }

    @Override
    public int compareTo(SolvableQuotient<C> b) {
        int s2;
        if (b == null || b.isZERO()) {
            return this.signum();
        }
        if (this.isZERO()) {
            return -b.signum();
        }
        int s1 = this.num.signum();
        int t = (s1 - (s2 = b.num.signum())) / 2;
        if (t != 0) {
            return t;
        }
        if (this.den.compareTo(b.den) == 0) {
            return this.num.compareTo(b.num);
        }
        GenSolvablePolynomial<C>[] oc = this.ring.engine.leftOreCond(this.den, b.den);
        if (this.debug) {
            System.out.println("oc[0] den =<>= oc[1] b.den: (" + oc[0] + ") (" + this.den + ") = (" + oc[1] + ") (" + b.den + ")");
        }
        GenSolvablePolynomial<GenSolvablePolynomial<GenSolvablePolynomial<C>>> r = oc[0].multiply(this.num);
        GenSolvablePolynomial<GenSolvablePolynomial<C>> s = oc[1].multiply(b.num);
        return r.compareTo((GenPolynomial<GenSolvablePolynomial<GenSolvablePolynomial<C>>>)s);
    }

    @Override
    public boolean equals(Object b) {
        if (!(b instanceof SolvableQuotient)) {
            return false;
        }
        SolvableQuotient a = null;
        try {
            a = (SolvableQuotient)b;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (a == null) {
            return false;
        }
        return this.compareTo(a) == 0;
    }

    @Override
    public int hashCode() {
        int h = this.ring.hashCode();
        h = 37 * h + this.num.hashCode();
        h = 37 * h + this.den.hashCode();
        return h;
    }

    public SolvableQuotient<C> rightFraction() {
        if (this.isZERO() || this.isONE()) {
            return this;
        }
        GenSolvablePolynomial<C>[] oc = this.ring.engine.rightOreCond(this.num, this.den);
        return new SolvableQuotient<C>(this.ring, oc[1], oc[0], true);
    }

    public boolean isRightFraction(SolvableQuotient<C> s) {
        GenSolvablePolynomial<GenSolvablePolynomial<C>> y;
        if (this.isZERO()) {
            return s.isZERO();
        }
        if (this.isONE()) {
            return s.isONE();
        }
        GenSolvablePolynomial<GenSolvablePolynomial<GenSolvablePolynomial<C>>> x = this.den.multiply(s.num);
        return x.compareTo((GenPolynomial<GenSolvablePolynomial<GenSolvablePolynomial<C>>>)(y = this.num.multiply(s.den))) == 0;
    }

    @Override
    public SolvableQuotient<C> abs() {
        return new SolvableQuotient<C>(this.ring, (GenSolvablePolynomial)this.num.abs(), this.den, true);
    }

    @Override
    public SolvableQuotient<C> sum(SolvableQuotient<C> S) {
        if (S == null || S.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return S;
        }
        if (this.den.isONE() && S.den.isONE()) {
            GenSolvablePolynomial n = (GenSolvablePolynomial)this.num.sum(S.num);
            return new SolvableQuotient<C>(this.ring, n, this.den, true);
        }
        if (this.den.compareTo(S.den) == 0) {
            GenSolvablePolynomial n = (GenSolvablePolynomial)this.num.sum(S.num);
            return new SolvableQuotient<C>(this.ring, n, this.den, false);
        }
        GenSolvablePolynomial<C>[] oc = this.ring.engine.leftOreCond(this.den, S.den);
        if (this.debug) {
            System.out.println("oc[0] den =sum= oc[1] S.den: (" + oc[0] + ") (" + this.den + ") = (" + oc[1] + ") (" + S.den + ")");
        }
        GenSolvablePolynomial<GenSolvablePolynomial<C>> d = oc[0].multiply(this.den);
        GenSolvablePolynomial<GenSolvablePolynomial<GenSolvablePolynomial<GenSolvablePolynomial<C>>>> n1 = oc[0].multiply(this.num);
        GenSolvablePolynomial<GenSolvablePolynomial<C>> n2 = oc[1].multiply(S.num);
        GenSolvablePolynomial n = (GenSolvablePolynomial)n1.sum(n2);
        return new SolvableQuotient<GenSolvablePolynomial<C>>(this.ring, n, d, false);
    }

    @Override
    public SolvableQuotient<C> negate() {
        return new SolvableQuotient<C>(this.ring, (GenSolvablePolynomial)this.num.negate(), this.den, true);
    }

    @Override
    public int signum() {
        return this.num.signum();
    }

    @Override
    public SolvableQuotient<C> subtract(SolvableQuotient<C> S) {
        return this.sum((SolvableQuotient<C>)S.negate());
    }

    @Override
    public SolvableQuotient<C> divide(SolvableQuotient<C> S) {
        return this.multiply((C)S.inverse());
    }

    @Override
    public SolvableQuotient<C> inverse() {
        if (this.num.isZERO()) {
            throw new ArithmeticException("element not invertible " + this);
        }
        return new SolvableQuotient<C>(this.ring, this.den, this.num, true);
    }

    @Override
    public SolvableQuotient<C> remainder(SolvableQuotient<C> S) {
        if (S.isZERO()) {
            throw new ArithmeticException("element not invertible " + S);
        }
        return this.ring.getZERO();
    }

    public SolvableQuotient<C>[] quotientRemainder(SolvableQuotient<C> S) {
        return new SolvableQuotient[]{this.divide(S), this.remainder(S)};
    }

    @Override
    public SolvableQuotient<C> multiply(SolvableQuotient<C> S) {
        if (S == null || S.isZERO()) {
            return S;
        }
        if (this.num.isZERO()) {
            return this;
        }
        if (S.isONE()) {
            return this;
        }
        if (this.isONE()) {
            return S;
        }
        if (this.den.isONE() && S.den.isONE()) {
            GenSolvablePolynomial<GenSolvablePolynomial<C>> n = this.num.multiply(S.num);
            return new SolvableQuotient<GenSolvablePolynomial<C>>(this.ring, n, this.den, true);
        }
        GenSolvablePolynomial<C>[] oc = this.ring.engine.leftOreCond(this.num, S.den);
        GenSolvablePolynomial<GenSolvablePolynomial<C>> n = oc[1].multiply(S.num);
        GenSolvablePolynomial<GenSolvablePolynomial<C>> d = oc[0].multiply(this.den);
        if (this.debug) {
            System.out.println("oc[0] num =mult= oc[1] S.den: (" + oc[0] + ") (" + this.num + ") = (" + oc[1] + ") (" + S.den + ")");
        }
        return new SolvableQuotient<GenSolvablePolynomial<C>>(this.ring, n, d, false);
    }

    @Override
    public SolvableQuotient<C> multiply(GenSolvablePolynomial<C> b) {
        if (b == null || b.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.num.isZERO()) {
            return this;
        }
        if (b.isONE()) {
            return this;
        }
        GenSolvablePolynomial<GenSolvablePolynomial<C>> n = this.num.multiply(b);
        return new SolvableQuotient<GenSolvablePolynomial<C>>(this.ring, n, this.den, false);
    }

    @Override
    public SolvableQuotient<C> multiply(C b) {
        if (b == null || b.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.num.isZERO()) {
            return this;
        }
        if (b.isONE()) {
            return this;
        }
        GenPolynomial n = this.num.multiply((RingElem)b);
        return new SolvableQuotient<C>(this.ring, n, this.den, false);
    }

    @Override
    public SolvableQuotient<C> multiply(ExpVector e) {
        if (e == null || e.isZERO()) {
            return this;
        }
        if (this.num.isZERO()) {
            return this;
        }
        GenPolynomial n = this.num.multiply(e);
        return new SolvableQuotient<C>(this.ring, n, this.den, false);
    }

    public SolvableQuotient<C> monic() {
        if (this.num.isZERO()) {
            return this;
        }
        GcdRingElem lbc = (GcdRingElem)this.num.leadingBaseCoefficient();
        if (!lbc.isUnit()) {
            return this;
        }
        lbc = (GcdRingElem)lbc.inverse();
        GenPolynomial n = this.num.multiply(lbc);
        return new SolvableQuotient<C>(this.ring, n, this.den, true);
    }

    @Override
    public SolvableQuotient<C> gcd(SolvableQuotient<C> b) {
        if (b == null || b.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return b;
        }
        return this.ring.getONE();
    }

    public SolvableQuotient<C>[] egcd(SolvableQuotient<C> b) {
        SolvableQuotient[] ret = new SolvableQuotient[]{null, null, null};
        if (b == null || b.isZERO()) {
            ret[0] = this;
            return ret;
        }
        if (this.isZERO()) {
            ret[0] = b;
            return ret;
        }
        GenPolynomial two = this.ring.ring.fromInteger(2L);
        ret[0] = this.ring.getONE();
        ret[1] = this.multiply((C)two).inverse();
        ret[2] = b.multiply(two).inverse();
        return ret;
    }
}

