/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.SolvableReduction;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class SolvableReductionAbstract<C extends RingElem<C>>
implements SolvableReduction<C> {
    private static final Logger logger = Logger.getLogger(SolvableReductionAbstract.class);
    private final boolean debug = logger.isDebugEnabled();

    @Override
    public GenSolvablePolynomial<C> leftSPolynomial(GenSolvablePolynomial<C> Ap, GenSolvablePolynomial<C> Bp) {
        if (logger.isInfoEnabled()) {
            if (Bp == null || Bp.isZERO()) {
                if (Ap != null) {
                    return Ap.ring.getZERO();
                }
                return null;
            }
            if (Ap == null || Ap.isZERO()) {
                return Bp.ring.getZERO();
            }
            if (!Ap.ring.equals(Bp.ring)) {
                logger.error((Object)"rings not equal");
            }
        }
        Map.Entry ma = Ap.leadingMonomial();
        Map.Entry mb = Bp.leadingMonomial();
        ExpVector e = ma.getKey();
        ExpVector f = mb.getKey();
        ExpVector g = e.lcm(f);
        ExpVector e1 = g.subtract(e);
        ExpVector f1 = g.subtract(f);
        RingElem a = (RingElem)ma.getValue();
        RingElem b = (RingElem)mb.getValue();
        GenSolvablePolynomial<RingElem> App = Ap.multiplyLeft(b, e1);
        GenSolvablePolynomial<RingElem> Bpp = Bp.multiplyLeft(a, f1);
        GenSolvablePolynomial Cp = (GenSolvablePolynomial)App.subtract(Bpp);
        return Cp;
    }

    @Override
    public GenSolvablePolynomial<C> leftSPolynomial(List<GenSolvablePolynomial<C>> S, int i, GenSolvablePolynomial<C> Ap, int j, GenSolvablePolynomial<C> Bp) {
        if (this.debug) {
            if (Bp == null || Bp.isZERO()) {
                throw new ArithmeticException("Spol B is zero");
            }
            if (Ap == null || Ap.isZERO()) {
                throw new ArithmeticException("Spol A is zero");
            }
            if (!Ap.ring.equals(Bp.ring)) {
                logger.error((Object)"rings not equal");
            }
        }
        Map.Entry ma = Ap.leadingMonomial();
        Map.Entry mb = Bp.leadingMonomial();
        ExpVector e = ma.getKey();
        ExpVector f = mb.getKey();
        ExpVector g = e.lcm(f);
        ExpVector e1 = g.subtract(e);
        ExpVector f1 = g.subtract(f);
        RingElem a = (RingElem)ma.getValue();
        RingElem b = (RingElem)mb.getValue();
        GenSolvablePolynomial<RingElem> App = Ap.multiplyLeft(b, e1);
        GenSolvablePolynomial<RingElem> Bpp = Bp.multiplyLeft(a, f1);
        GenSolvablePolynomial Cp = (GenSolvablePolynomial)App.subtract(Bpp);
        GenPolynomial zero = Ap.ring.getZERO();
        GenSolvablePolynomial As = (GenSolvablePolynomial)zero.sum((RingElem)b.negate(), e1);
        GenSolvablePolynomial Bs = (GenSolvablePolynomial)zero.sum(a, f1);
        S.set(i, As);
        S.set(j, Bs);
        return Cp;
    }

    @Override
    public List<GenSolvablePolynomial<C>> leftNormalform(List<GenSolvablePolynomial<C>> Pp, List<GenSolvablePolynomial<C>> Ap) {
        if (Pp == null || Pp.isEmpty()) {
            return Ap;
        }
        if (Ap == null || Ap.isEmpty()) {
            return Ap;
        }
        ArrayList<GenSolvablePolynomial<C>> red = new ArrayList<GenSolvablePolynomial<C>>();
        for (GenSolvablePolynomial<C> A : Ap) {
            A = this.leftNormalform(Pp, A);
            red.add(A);
        }
        return red;
    }

    @Override
    public List<GenSolvablePolynomial<C>> leftIrreducibleSet(List<GenSolvablePolynomial<C>> Pp) {
        ArrayList<GenSolvablePolynomial<C>> P = new ArrayList<GenSolvablePolynomial<C>>();
        for (GenPolynomial a : Pp) {
            if (a.length() == 0) continue;
            a = a.monic();
            P.add((GenSolvablePolynomial<C>)a);
        }
        int l = P.size();
        if (l <= 1) {
            return P;
        }
        int irr = 0;
        logger.debug((Object)"irr = ");
        while (irr != l) {
            ListIterator<GenSolvablePolynomial<C>> it = P.listIterator();
            GenPolynomial a = (GenSolvablePolynomial<C>)it.next();
            P.remove(0);
            ExpVector e = a.leadingExpVector();
            a = this.leftNormalform(P, a);
            logger.debug((Object)String.valueOf(irr));
            if (a.length() == 0) {
                if (--l > 1) continue;
                return P;
            }
            ExpVector f = a.leadingExpVector();
            if (f.signum() == 0) {
                P = new ArrayList();
                P.add((GenSolvablePolynomial<C>)a.monic());
                return P;
            }
            if (e.equals(f)) {
                ++irr;
            } else {
                irr = 0;
                a = a.monic();
            }
            P.add((GenSolvablePolynomial<C>)a);
        }
        return P;
    }

    @Override
    public boolean isLeftReductionNF(List<GenSolvablePolynomial<C>> row, List<GenSolvablePolynomial<C>> Pp, GenSolvablePolynomial<C> Ap, GenSolvablePolynomial<C> Np) {
        if (row == null && Pp == null) {
            if (Ap == null) {
                return Np == null;
            }
            return Ap.equals(Np);
        }
        if (row == null || Pp == null) {
            return false;
        }
        if (row.size() != Pp.size()) {
            return false;
        }
        GenSolvablePolynomial t = Np;
        for (int m = 0; m < Pp.size(); ++m) {
            GenSolvablePolynomial<GenSolvablePolynomial<C>> r = row.get(m);
            GenSolvablePolynomial<C> p = Pp.get(m);
            if (r == null || p == null) continue;
            t = t == null ? r.multiply(p) : (GenSolvablePolynomial)t.sum(r.multiply(p));
        }
        if (this.debug) {
            logger.info((Object)("t = " + t));
            logger.info((Object)("a = " + Ap));
        }
        if (t == null) {
            if (Ap == null) {
                return true;
            }
            return Ap.isZERO();
        }
        t = (GenSolvablePolynomial)t.subtract(Ap);
        return t.isZERO();
    }

    @Override
    public GenSolvablePolynomial<C> rightSPolynomial(GenSolvablePolynomial<C> Ap, GenSolvablePolynomial<C> Bp) {
        if (logger.isInfoEnabled()) {
            if (Bp == null || Bp.isZERO()) {
                if (Ap != null) {
                    return Ap.ring.getZERO();
                }
                return null;
            }
            if (Ap == null || Ap.isZERO()) {
                return Bp.ring.getZERO();
            }
            if (!Ap.ring.equals(Bp.ring)) {
                logger.error((Object)"rings not equal");
            }
        }
        ExpVector e = Ap.leadingExpVector();
        ExpVector f = Bp.leadingExpVector();
        ExpVector g = e.lcm(f);
        ExpVector e1 = g.subtract(e);
        ExpVector f1 = g.subtract(f);
        GenPolynomial App = Ap.multiply(e1);
        GenPolynomial Bpp = Bp.multiply(f1);
        Object a = App.leadingBaseCoefficient();
        Object b = Bpp.leadingBaseCoefficient();
        App = ((GenSolvablePolynomial)App).multiply((RingElem)b);
        Bpp = ((GenSolvablePolynomial)Bpp).multiply((RingElem)a);
        GenSolvablePolynomial Cp = (GenSolvablePolynomial)App.subtract(Bpp);
        return Cp;
    }
}

