/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.CriticalPair;
import edu.jas.gb.CriticalPairList;
import edu.jas.gb.ReductionPar;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.RingElem;
import edu.jas.util.Terminator;
import java.util.List;
import org.apache.log4j.Logger;

class ReducerSeqPair<C extends RingElem<C>>
implements Runnable {
    private final List<GenPolynomial<C>> G;
    private final CriticalPairList<C> pairlist;
    private final Terminator fin;
    private final ReductionPar<C> red;
    private static final Logger logger = Logger.getLogger(ReducerSeqPair.class);

    ReducerSeqPair(Terminator fin, List<GenPolynomial<C>> G, CriticalPairList<C> L) {
        this.fin = fin;
        this.G = G;
        this.pairlist = L;
        this.red = new ReductionPar();
    }

    public String toString() {
        return "ReducerSeqPair";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean set = false;
        int reduction = 0;
        int sleeps = 0;
        while (this.pairlist.hasNext() || this.fin.hasJobs()) {
            List<GenPolynomial<C>> list;
            GenPolynomial S;
            while (!this.pairlist.hasNext()) {
                this.pairlist.update();
                this.fin.beIdle();
                set = true;
                try {
                    if (++sleeps % 10 == 0) {
                        logger.info((Object)" reducer is sleeping");
                    } else {
                        logger.debug((Object)"r");
                    }
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    this.fin.allIdle();
                    logger.info((Object)("shutdown " + this.fin + " after: " + e));
                    break;
                }
                if (Thread.currentThread().isInterrupted()) {
                    this.fin.allIdle();
                    logger.info((Object)("shutdown after .isInterrupted(): " + this.fin));
                    break;
                }
                if (this.fin.hasJobs()) continue;
            }
            if (!this.pairlist.hasNext() && !this.fin.hasJobs()) break;
            if (set) {
                this.fin.notIdle();
                set = false;
            }
            CriticalPair<C> pair = this.pairlist.getNext();
            if (Thread.currentThread().isInterrupted()) {
                throw new RuntimeException("interrupt after getNext");
            }
            if (pair == null) {
                this.pairlist.update();
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("pi = " + pair.pi));
                logger.debug((Object)("pj = " + pair.pj));
            }
            if ((S = this.red.SPolynomial(pair.pi, pair.pj)).isZERO()) {
                this.pairlist.record(pair, S);
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("ht(S) = " + S.leadingExpVector()));
            }
            GenPolynomial<C> H = this.red.normalform(this.G, S);
            ++reduction;
            if (H.isZERO()) {
                this.pairlist.record(pair, H);
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("ht(H) = " + H.leadingExpVector()));
            }
            if ((H = H.monic()).isONE()) {
                this.pairlist.putOne();
                list = this.G;
                synchronized (list) {
                    this.G.clear();
                    this.G.add(H);
                }
                this.fin.allIdle();
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("H = " + H));
            }
            list = this.G;
            synchronized (list) {
                this.G.add(H);
            }
            this.pairlist.update(pair, H);
        }
        logger.info((Object)("terminated, done " + reduction + " reductions"));
    }
}

