/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.Pair;
import edu.jas.gb.PairList;
import edu.jas.gb.ReductionPar;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.RingElem;
import edu.jas.util.Terminator;
import java.util.List;
import org.apache.log4j.Logger;

class Reducer<C extends RingElem<C>>
implements Runnable {
    private final List<GenPolynomial<C>> G;
    private final PairList<C> pairlist;
    private final Terminator fin;
    private final ReductionPar<C> red;
    private static final Logger logger = Logger.getLogger(Reducer.class);

    Reducer(Terminator fin, List<GenPolynomial<C>> G, PairList<C> L) {
        this.fin = fin;
        this.fin.initIdle(1);
        this.G = G;
        this.pairlist = L;
        this.red = new ReductionPar();
    }

    public String toString() {
        return "Reducer";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int reduction = 0;
        int sleeps = 0;
        while (this.pairlist.hasNext() || this.fin.hasJobs()) {
            List<GenPolynomial<C>> list;
            GenPolynomial S;
            while (!this.pairlist.hasNext()) {
                try {
                    if (++sleeps % 10 == 0) {
                        logger.info((Object)" reducer is sleeping");
                    } else {
                        logger.debug((Object)"r");
                    }
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    this.fin.allIdle();
                    logger.info((Object)("shutdown " + this.fin + " after: " + e));
                    break;
                }
                if (Thread.currentThread().isInterrupted()) {
                    this.fin.allIdle();
                    logger.info((Object)("shutdown after .isInterrupted(): " + this.fin));
                    break;
                }
                if (this.fin.hasJobs()) continue;
            }
            if (!this.pairlist.hasNext() && !this.fin.hasJobs()) break;
            this.fin.notIdle();
            Pair<C> pair = this.pairlist.removeNext();
            if (Thread.currentThread().isInterrupted()) {
                this.fin.initIdle(1);
                throw new RuntimeException("interrupt after removeNext");
            }
            if (pair == null) {
                this.fin.initIdle(1);
                continue;
            }
            GenPolynomial pi = pair.pi;
            GenPolynomial pj = pair.pj;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("pi    = " + pi));
                logger.debug((Object)("pj    = " + pj));
            }
            if ((S = this.red.SPolynomial(pi, pj)).isZERO()) {
                pair.setZero();
                this.fin.initIdle(1);
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("ht(S) = " + S.leadingExpVector()));
            }
            GenPolynomial<C> H = this.red.normalform(this.G, S);
            ++reduction;
            if (H.isZERO()) {
                pair.setZero();
                this.fin.initIdle(1);
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.info((Object)("ht(H) = " + H.leadingExpVector()));
            }
            if ((H = H.monic()).isONE()) {
                this.pairlist.put(H);
                list = this.G;
                synchronized (list) {
                    this.G.clear();
                    this.G.add(H);
                }
                this.fin.allIdle();
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("H = " + H));
            }
            list = this.G;
            synchronized (list) {
                this.G.add(H);
            }
            this.pairlist.put(H);
            this.fin.initIdle(1);
        }
        this.fin.allIdle();
        logger.info((Object)("terminated, done " + reduction + " reductions"));
    }
}

