/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.GBExerClient;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.MiReducerServerEC;
import edu.jas.gb.OrderedPairlist;
import edu.jas.gb.PairList;
import edu.jas.gb.ReducerClientEC;
import edu.jas.gb.ReducerServerEC;
import edu.jas.gb.ReductionPar;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.RingElem;
import edu.jas.util.ChannelFactory;
import edu.jas.util.DistHashTable;
import edu.jas.util.DistHashTableServer;
import edu.jas.util.DistThreadPool;
import edu.jas.util.SocketChannel;
import edu.jas.util.Terminator;
import edu.jas.util.ThreadPool;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;

public class GroebnerBaseDistributedEC<C extends RingElem<C>>
extends GroebnerBaseAbstract<C> {
    private static final Logger logger = Logger.getLogger(GroebnerBaseDistributedEC.class);
    protected final int threads;
    protected static final int DEFAULT_THREADS = 2;
    protected final transient ThreadPool pool;
    protected static final int DEFAULT_PORT = 55711;
    protected final int DHT_PORT;
    protected final int port;
    protected final String mfile;
    private final transient DistThreadPool dtp;
    private final transient DistHashTableServer<Integer> dhts;

    public GroebnerBaseDistributedEC(String mfile) {
        this(mfile, 2, 55711);
    }

    public GroebnerBaseDistributedEC(String mfile, int threads) {
        this(mfile, threads, new ThreadPool(threads), 55711);
    }

    public GroebnerBaseDistributedEC(String mfile, int threads, int port) {
        this(mfile, threads, new ThreadPool(threads), port);
    }

    public GroebnerBaseDistributedEC(String mfile, int threads, ThreadPool pool, int port) {
        this(mfile, threads, pool, new OrderedPairlist(), port);
    }

    public GroebnerBaseDistributedEC(String mfile, int threads, PairList<C> pl, int port) {
        this(mfile, threads, new ThreadPool(threads), pl, port);
    }

    public GroebnerBaseDistributedEC(String mfile, int threads, ThreadPool pool, PairList<C> pl, int port) {
        super(new ReductionPar(), pl);
        this.threads = threads;
        this.mfile = mfile == null || mfile.length() == 0 ? "../util/machines" : mfile;
        if (threads < 1) {
            threads = 1;
        }
        if (pool == null) {
            pool = new ThreadPool(threads);
        }
        this.pool = pool;
        this.port = port;
        logger.info((Object)("machine file " + mfile + ", port = " + port));
        this.dtp = new DistThreadPool(this.threads, this.mfile);
        logger.info((Object)("running " + this.dtp));
        this.DHT_PORT = this.dtp.getEC().getMasterPort() + 100;
        this.dhts = new DistHashTableServer(this.DHT_PORT);
        this.dhts.init();
        logger.info((Object)("running " + this.dhts));
    }

    @Override
    public void terminate() {
        this.terminate(true);
    }

    public void terminate(boolean shutDown) {
        this.pool.terminate();
        this.dtp.terminate(shutDown);
        logger.info((Object)"dhts.terminate()");
        this.dhts.terminate();
    }

    @Override
    public List<GenPolynomial<C>> GB(int modv, List<GenPolynomial<C>> F) {
        String master = this.dtp.getEC().getMasterHost();
        GBExerClient gbc = new GBExerClient(master, this.port, this.DHT_PORT);
        for (int i = 0; i < this.threads; ++i) {
            this.dtp.addJob(gbc);
        }
        List<GenPolynomial<C>> G = this.GBMaster(modv, F);
        return G;
    }

    public List<GenPolynomial<C>> GBMaster(int modv, List<GenPolynomial<C>> F) {
        ChannelFactory cf = new ChannelFactory(this.port);
        cf.init();
        logger.info((Object)("GBMaster on " + cf));
        List G = new ArrayList();
        PairList<C> pairlist = null;
        boolean oneInGB = false;
        int l = F.size();
        ListIterator<GenPolynomial<C>> it = F.listIterator();
        while (it.hasNext()) {
            GenPolynomial<C> p = it.next();
            if (p.length() > 0) {
                int unused;
                if ((p = p.monic()).isONE()) {
                    oneInGB = true;
                    G.clear();
                    G.add(p);
                }
                if (!oneInGB) {
                    G.add(p);
                }
                if (pairlist == null) {
                    pairlist = this.strategy.create(modv, p.ring);
                    if (!p.ring.coFac.isField()) {
                        throw new IllegalArgumentException("coefficients not from a field");
                    }
                }
                if (p.isONE()) {
                    unused = pairlist.putOne();
                    continue;
                }
                unused = pairlist.put(p);
                continue;
            }
            --l;
        }
        logger.info((Object)("start " + pairlist));
        logger.debug((Object)"looking for clients");
        DistHashTable theList = new DistHashTable("localhost", this.DHT_PORT);
        theList.init();
        List al = pairlist.getList();
        for (int i = 0; i < al.size(); ++i) {
            GenPolynomial nn = theList.put(i, al.get(i));
            if (nn == null) continue;
            logger.info((Object)("double polynomials " + i + ", nn = " + nn + ", al(i) = " + al.get(i)));
        }
        while (theList.size() < al.size()) {
            logger.info((Object)("#distributed list = " + theList.size() + " #pairlist list = " + al.size()));
            GenPolynomial nn = theList.getWait(al.size() - 1);
        }
        Terminator fin = new Terminator(this.threads);
        for (int i = 0; i < this.threads; ++i) {
            ReducerServerEC R = new ReducerServerEC(fin, cf, theList, G, pairlist);
            this.pool.addJob(R);
        }
        logger.debug((Object)"main loop waiting");
        fin.waitDone();
        int ps = theList.size();
        logger.debug((Object)("#distributed list = " + ps));
        G = pairlist.getList();
        if (ps != G.size()) {
            logger.warn((Object)("#distributed list = " + theList.size() + " #pairlist list = " + G.size()));
        }
        long time = System.currentTimeMillis();
        List Gp = this.minimalGB(G);
        time = System.currentTimeMillis() - time;
        logger.debug((Object)("parallel gbmi = " + time));
        G = Gp;
        logger.debug((Object)"cf.terminate()");
        cf.terminate();
        logger.debug((Object)"theList.terminate()");
        theList.clear();
        theList.terminate();
        logger.info((Object)("" + pairlist));
        return G;
    }

    public static <C extends RingElem<C>> void clientPart(String host, int port, int dhtport) throws IOException {
        ChannelFactory cf = new ChannelFactory(port + 10);
        cf.init();
        logger.info((Object)("clientPart connecting to " + host + ", port = " + port + ", dhtport = " + dhtport));
        SocketChannel pairChannel = cf.getChannel(host, port);
        DistHashTable theList = new DistHashTable(host, dhtport);
        theList.init();
        ReducerClientEC R = new ReducerClientEC(pairChannel, theList);
        logger.info((Object)("clientPart running on " + host + ", pairChannel = " + pairChannel));
        R.run();
        pairChannel.close();
        theList.terminate();
        cf.terminate();
    }

    @Override
    public List<GenPolynomial<C>> minimalGB(List<GenPolynomial<C>> Fp) {
        GenPolynomial<C> a;
        ArrayList<GenPolynomial<C>> G = new ArrayList<GenPolynomial<C>>(Fp.size());
        ListIterator<GenPolynomial<Object>> it = Fp.listIterator();
        while (it.hasNext()) {
            a = it.next();
            if (a.length() == 0) continue;
            G.add(a);
        }
        if (G.size() <= 1) {
            return G;
        }
        ArrayList<GenPolynomial<C>> F = new ArrayList<GenPolynomial<C>>(G.size());
        while (G.size() > 0) {
            ExpVector f;
            GenPolynomial<Object> p;
            a = G.remove(0);
            ExpVector e = a.leadingExpVector();
            it = G.listIterator();
            boolean mt = false;
            while (it.hasNext() && !mt) {
                p = it.next();
                f = p.leadingExpVector();
                mt = e.multipleOf(f);
            }
            it = F.listIterator();
            while (it.hasNext() && !mt) {
                p = it.next();
                f = p.leadingExpVector();
                mt = e.multipleOf(f);
            }
            if (mt) continue;
            F.add(a);
        }
        G = F;
        if (G.size() <= 1) {
            return G;
        }
        Collections.reverse(G);
        MiReducerServerEC[] mirs = new MiReducerServerEC[G.size()];
        int i = 0;
        F = new ArrayList(G.size());
        while (G.size() > 0) {
            a = G.remove(0);
            ArrayList R = new ArrayList(G.size() + F.size());
            R.addAll(G);
            R.addAll(F);
            mirs[i] = new MiReducerServerEC(R, a);
            this.pool.addJob(mirs[i]);
            ++i;
            F.add(a);
        }
        G = F;
        F = new ArrayList(G.size());
        for (i = 0; i < mirs.length; ++i) {
            a = mirs[i].getNF();
            F.add(a);
        }
        return F;
    }
}

