/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.OptimizedPolynomialList;
import edu.jas.poly.TermOrderOptimization;
import edu.jas.structure.GcdRingElem;
import java.util.List;
import org.apache.log4j.Logger;

public class GBOptimized<C extends GcdRingElem<C>>
extends GroebnerBaseAbstract<C> {
    private static final Logger logger = Logger.getLogger(GBOptimized.class);
    private final boolean debug = logger.isDebugEnabled();
    public final GroebnerBaseAbstract<C> e1;
    public final boolean retPermuted;

    public GBOptimized(GroebnerBaseAbstract<C> e1) {
        this(e1, false);
    }

    public GBOptimized(GroebnerBaseAbstract<C> e1, boolean rP) {
        this.e1 = e1;
        this.retPermuted = rP;
    }

    @Override
    public String toString() {
        return "GBOptimized[ " + this.e1.toString() + " ]";
    }

    @Override
    public void terminate() {
        this.e1.terminate();
    }

    @Override
    public int cancel() {
        int s = this.e1.cancel();
        return s;
    }

    @Override
    public List<GenPolynomial<C>> GB(int modv, List<GenPolynomial<C>> F) {
        if (F == null || F.isEmpty()) {
            return F;
        }
        if (modv != 0) {
            throw new UnsupportedOperationException("implemented only for modv = 0, not " + modv);
        }
        GenPolynomialRing pfac = F.get((int)0).ring;
        OptimizedPolynomialList opt = TermOrderOptimization.optimizeTermOrder(pfac, F);
        List P = opt.list;
        if (this.debug) {
            logger.info((Object)("optimized polynomials: " + P));
        }
        List<Integer> iperm = TermOrderOptimization.inversePermutation(opt.perm);
        logger.info((Object)("optimize perm: " + opt.perm + ", de-optimize perm: " + iperm));
        List G = this.e1.GB(modv, P);
        if (this.retPermuted || G.isEmpty()) {
            return G;
        }
        List iopt = TermOrderOptimization.permutation(iperm, pfac, G);
        if (this.debug) {
            logger.info((Object)("de-optimized polynomials: " + iopt));
        }
        if (iopt.size() == 1) {
            return iopt;
        }
        logger.warn((Object)"recomputing GB");
        G = this.e1.GB(modv, iopt);
        return G;
    }
}

