/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.BigInteger;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongIterator;
import edu.jas.arith.ModularRingFactory;
import edu.jas.kern.StringUtil;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public final class ModLongRing
implements ModularRingFactory<ModLong>,
Iterable<ModLong> {
    public final long modul;
    private static final Random random = new Random();
    private int isField = -1;
    public static final java.math.BigInteger MAX_LONG = new java.math.BigInteger(String.valueOf(Integer.MAX_VALUE));

    public ModLongRing(long m) {
        this.modul = m;
    }

    public ModLongRing(long m, boolean isField) {
        this.modul = m;
        this.isField = isField ? 1 : 0;
    }

    public ModLongRing(Long m) {
        this((long)m);
    }

    public ModLongRing(Long m, boolean isField) {
        this((long)m, isField);
    }

    public ModLongRing(java.math.BigInteger m) {
        this(m.longValue());
        if (MAX_LONG.compareTo(m) < 0) {
            System.out.println("modul to large for long " + m + ",max=" + MAX_LONG);
            throw new IllegalArgumentException("modul to large for long " + m);
        }
    }

    public ModLongRing(java.math.BigInteger m, boolean isField) {
        this(m.longValue(), isField);
        if (MAX_LONG.compareTo(m) < 0) {
            System.out.println("modul to large for long " + m + ",max=" + MAX_LONG);
            throw new IllegalArgumentException("modul to large for long " + m);
        }
    }

    public ModLongRing(String m) {
        this(new Long(m.trim()));
    }

    public ModLongRing(String m, boolean isField) {
        this(new Long(m.trim()), isField);
    }

    public java.math.BigInteger getModul() {
        return new java.math.BigInteger(Long.toString(this.modul));
    }

    public long getLongModul() {
        return this.modul;
    }

    @Override
    public BigInteger getIntegerModul() {
        return new BigInteger(this.modul);
    }

    public ModLong create(java.math.BigInteger c) {
        return new ModLong(this, c);
    }

    public ModLong create(long c) {
        return new ModLong(this, c);
    }

    public ModLong create(String c) {
        return this.parse(c);
    }

    @Override
    public ModLong copy(ModLong c) {
        return new ModLong(this, c.val);
    }

    @Override
    public ModLong getZERO() {
        return new ModLong(this, 0L);
    }

    @Override
    public ModLong getONE() {
        return new ModLong(this, 1L);
    }

    @Override
    public List<ModLong> generators() {
        ArrayList<ModLong> g = new ArrayList<ModLong>(1);
        g.add(this.getONE());
        return g;
    }

    @Override
    public boolean isFinite() {
        return true;
    }

    @Override
    public boolean isCommutative() {
        return true;
    }

    @Override
    public boolean isAssociative() {
        return true;
    }

    @Override
    public boolean isField() {
        if (this.isField > 0) {
            return true;
        }
        if (this.isField == 0) {
            return false;
        }
        java.math.BigInteger m = new java.math.BigInteger(Long.toString(this.modul));
        if (m.isProbablePrime(m.bitLength())) {
            this.isField = 1;
            return true;
        }
        this.isField = 0;
        return false;
    }

    @Override
    public java.math.BigInteger characteristic() {
        return new java.math.BigInteger(Long.toString(this.modul));
    }

    @Override
    public ModLong fromInteger(java.math.BigInteger a) {
        return new ModLong(this, a);
    }

    @Override
    public ModLong fromInteger(long a) {
        return new ModLong(this, a);
    }

    public String toString() {
        return " mod(" + this.modul + ")";
    }

    @Override
    public String toScript() {
        if (this.isField()) {
            return "GFL(" + this.modul + ")";
        }
        return "ZL(" + this.modul + ")";
    }

    public boolean equals(Object b) {
        if (!(b instanceof ModLongRing)) {
            return false;
        }
        ModLongRing m = (ModLongRing)b;
        return this.modul == m.modul;
    }

    public int hashCode() {
        return (int)this.modul;
    }

    @Override
    public ModLong random(int n) {
        return this.random(n, random);
    }

    @Override
    public ModLong random(int n, Random rnd) {
        java.math.BigInteger v = new java.math.BigInteger(n, rnd);
        return new ModLong(this, v);
    }

    @Override
    public ModLong parse(String s) {
        return new ModLong(this, s);
    }

    @Override
    public ModLong parse(Reader r) {
        return this.parse(StringUtil.nextString(r));
    }

    @Override
    public ModLong chineseRemainder(ModLong c, ModLong ci, ModLong a) {
        ModLong b;
        ModLong d;
        if (c.ring.modul < a.ring.modul) {
            System.out.println("ModLong error " + c.ring + ", " + a.ring);
        }
        if ((d = a.subtract(b = a.ring.fromInteger(c.val))).isZERO()) {
            return new ModLong(this, c.val);
        }
        b = d.multiply(ci);
        long s = c.ring.modul * b.val;
        return new ModLong(this, s += c.val);
    }

    @Override
    public Iterator<ModLong> iterator() {
        return new ModLongIterator(this);
    }
}

