/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.SolvableLocalResidueRing;
import edu.jas.gbufd.PolyGBUtil;
import edu.jas.kern.PrettyPrint;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.QuotPair;
import edu.jas.structure.RingElem;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class SolvableLocalResidue<C extends GcdRingElem<C>>
implements GcdRingElem<SolvableLocalResidue<C>>,
QuotPair<GenPolynomial<C>> {
    private static final Logger logger = Logger.getLogger(SolvableLocalResidue.class);
    private final boolean debug = logger.isDebugEnabled();
    public final SolvableLocalResidueRing<C> ring;
    public final GenSolvablePolynomial<C> num;
    public final GenSolvablePolynomial<C> den;

    public SolvableLocalResidue(SolvableLocalResidueRing<C> r) {
        this(r, (GenSolvablePolynomial<C>)r.ring.getZERO());
    }

    public SolvableLocalResidue(SolvableLocalResidueRing<C> r, GenSolvablePolynomial<C> n) {
        this(r, n, (GenSolvablePolynomial<C>)r.ring.getONE(), false);
    }

    public SolvableLocalResidue(SolvableLocalResidueRing<C> r, GenSolvablePolynomial<C> n, GenSolvablePolynomial<C> d) {
        this(r, n, d, false);
    }

    protected SolvableLocalResidue(SolvableLocalResidueRing<C> r, GenSolvablePolynomial<C> n, GenSolvablePolynomial<C> d, boolean isred) {
        if (d == null || ((GenPolynomial)d).isZERO()) {
            throw new IllegalArgumentException("denominator may not be zero");
        }
        this.ring = r;
        if (((GenPolynomial)d).signum() < 0) {
            n = (GenSolvablePolynomial)((GenPolynomial)n).negate();
            d = (GenSolvablePolynomial)((GenPolynomial)d).negate();
        }
        if (isred) {
            this.num = n;
            this.den = d;
            return;
        }
        GenSolvablePolynomial p = this.ring.ideal.normalform(d);
        if (p.isZERO()) {
            throw new IllegalArgumentException("denominator may not be in ideal, d = " + d);
        }
        GenSolvablePolynomial nr = this.ring.ideal.normalform(n);
        if (nr.isZERO()) {
            this.num = nr;
            this.den = this.ring.ring.getONE();
            return;
        }
        GcdRingElem lc = (GcdRingElem)((GenPolynomial)d).leadingBaseCoefficient();
        if (!lc.isONE() && lc.isUnit()) {
            lc = (GcdRingElem)lc.inverse();
            n = ((GenSolvablePolynomial)n).multiply(lc);
            d = ((GenSolvablePolynomial)d).multiply(lc);
        }
        if (((GenPolynomial)n).compareTo(d) == 0) {
            this.num = this.ring.ring.getONE();
            this.den = this.ring.ring.getONE();
            return;
        }
        if (((GenPolynomial)((GenPolynomial)n).negate()).compareTo(d) == 0) {
            this.num = (GenSolvablePolynomial)this.ring.ring.getONE().negate();
            this.den = this.ring.ring.getONE();
            return;
        }
        if (((GenPolynomial)n).isZERO()) {
            this.num = n;
            this.den = this.ring.ring.getONE();
            return;
        }
        if (((GenPolynomial)n).isONE()) {
            this.num = n;
            this.den = d;
            return;
        }
        Object[] gcd = PolyGBUtil.syzGcdCofactors(r.ring, n, d);
        if (!gcd[0].isONE()) {
            logger.info((Object)("constructor: gcd = " + Arrays.toString(gcd)));
            n = gcd[1];
            d = gcd[2];
        }
        Object[] simp = this.ring.engine.leftSimplifier(n, d);
        logger.info((Object)("simp: " + Arrays.toString(simp) + ", " + n + ", " + d));
        this.num = simp[0];
        this.den = simp[1];
    }

    @Override
    public SolvableLocalResidueRing<C> factory() {
        return this.ring;
    }

    @Override
    public GenSolvablePolynomial<C> numerator() {
        return this.num;
    }

    @Override
    public GenSolvablePolynomial<C> denominator() {
        return this.den;
    }

    @Override
    public SolvableLocalResidue<C> copy() {
        return new SolvableLocalResidue<C>(this.ring, this.num, this.den, true);
    }

    @Override
    public boolean isZERO() {
        return this.num.isZERO();
    }

    @Override
    public boolean isONE() {
        return this.num.compareTo(this.den) == 0;
    }

    @Override
    public boolean isUnit() {
        return !this.num.isZERO();
    }

    @Override
    public boolean isConstant() {
        return this.num.isConstant() && this.den.isConstant();
    }

    public String toString() {
        if (PrettyPrint.isTrue()) {
            String s = "{ " + this.num.toString(this.ring.ring.getVars());
            if (!this.den.isONE()) {
                s = s + " | " + this.den.toString(this.ring.ring.getVars());
            }
            return s + " }";
        }
        return "SolvableLocalResidue[ " + this.num.toString() + " | " + this.den.toString() + " ]";
    }

    @Override
    public String toScript() {
        if (this.den.isONE()) {
            return this.num.toScript();
        }
        return this.num.toScript() + " / " + this.den.toScript();
    }

    @Override
    public String toScriptFactory() {
        return ((SolvableLocalResidueRing)this.factory()).toScript();
    }

    @Override
    public int compareTo(SolvableLocalResidue<C> b) {
        if (b == null || b.isZERO()) {
            return this.signum();
        }
        if (this.isZERO()) {
            return -b.signum();
        }
        return this.subtract(b).signum();
    }

    @Override
    public boolean equals(Object b) {
        if (!(b instanceof SolvableLocalResidue)) {
            return false;
        }
        SolvableLocalResidue a = null;
        try {
            a = (SolvableLocalResidue)b;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (a == null) {
            return false;
        }
        return this.compareTo(a) == 0;
    }

    @Override
    public int hashCode() {
        int h = this.ring.hashCode();
        h = 37 * h + this.num.hashCode();
        h = 37 * h + this.den.hashCode();
        return h;
    }

    @Override
    public SolvableLocalResidue<C> abs() {
        return new SolvableLocalResidue<C>(this.ring, (GenSolvablePolynomial)this.num.abs(), this.den, true);
    }

    @Override
    public SolvableLocalResidue<C> sum(SolvableLocalResidue<C> S) {
        if (S == null || S.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return S;
        }
        if (this.den.isONE() && S.den.isONE()) {
            GenSolvablePolynomial n = (GenSolvablePolynomial)this.num.sum(S.num);
            return new SolvableLocalResidue<C>(this.ring, n, this.den, false);
        }
        if (this.den.compareTo(S.den) == 0) {
            GenSolvablePolynomial n = (GenSolvablePolynomial)this.num.sum(S.num);
            return new SolvableLocalResidue<C>(this.ring, n, this.den, false);
        }
        GenSolvablePolynomial<C>[] oc = this.ring.engine.leftOreCond(this.den, S.den);
        if (this.debug) {
            logger.info((Object)("oc[0] den =sum= oc[1] S.den: (" + oc[0] + ") (" + this.den + ") = (" + oc[1] + ") (" + S.den + ")"));
        }
        GenSolvablePolynomial<GenSolvablePolynomial<C>> d = oc[0].multiply(this.den);
        GenSolvablePolynomial<GenSolvablePolynomial<GenSolvablePolynomial<GenSolvablePolynomial<C>>>> n1 = oc[0].multiply(this.num);
        GenSolvablePolynomial<GenSolvablePolynomial<C>> n2 = oc[1].multiply(S.num);
        GenSolvablePolynomial n = (GenSolvablePolynomial)n1.sum(n2);
        return new SolvableLocalResidue<GenSolvablePolynomial<C>>(this.ring, n, d, false);
    }

    @Override
    public SolvableLocalResidue<C> negate() {
        return new SolvableLocalResidue<C>(this.ring, (GenSolvablePolynomial)this.num.negate(), this.den, true);
    }

    @Override
    public int signum() {
        return this.num.signum();
    }

    @Override
    public SolvableLocalResidue<C> subtract(SolvableLocalResidue<C> S) {
        return this.sum((SolvableLocalResidue<C>)S.negate());
    }

    @Override
    public SolvableLocalResidue<C> divide(SolvableLocalResidue<C> S) {
        return this.multiply((C)S.inverse());
    }

    @Override
    public SolvableLocalResidue<C> inverse() {
        if (this.num.isZERO()) {
            throw new ArithmeticException("element not invertible " + this);
        }
        return new SolvableLocalResidue<C>(this.ring, this.den, this.num, false);
    }

    @Override
    public SolvableLocalResidue<C> remainder(SolvableLocalResidue<C> S) {
        if (S.isZERO()) {
            throw new ArithmeticException("element not invertible " + S);
        }
        return this.ring.getZERO();
    }

    @Override
    public SolvableLocalResidue<C> multiply(SolvableLocalResidue<C> S) {
        if (S == null || S.isZERO()) {
            return S;
        }
        if (this.num.isZERO()) {
            return this;
        }
        if (S.isONE()) {
            return this;
        }
        if (this.isONE()) {
            return S;
        }
        if (this.den.isONE() && S.den.isONE()) {
            GenSolvablePolynomial<GenSolvablePolynomial<C>> n = this.num.multiply(S.num);
            return new SolvableLocalResidue<GenSolvablePolynomial<C>>(this.ring, n, this.den, false);
        }
        GenSolvablePolynomial<C>[] oc = this.ring.engine.leftOreCond(this.num, S.den);
        if (this.debug) {
            System.out.println("oc[0] num =mult= oc[1] S.den: (" + oc[0] + ") (" + this.num + ") = (" + oc[1] + ") (" + S.den + ")");
        }
        GenSolvablePolynomial<GenSolvablePolynomial<C>> n = oc[1].multiply(S.num);
        GenSolvablePolynomial<GenSolvablePolynomial<C>> d = oc[0].multiply(this.den);
        return new SolvableLocalResidue<GenSolvablePolynomial<C>>(this.ring, n, d, false);
    }

    @Override
    public SolvableLocalResidue<C> multiply(GenSolvablePolynomial<C> b) {
        if (b == null || b.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.num.isZERO()) {
            return this;
        }
        if (b.isONE()) {
            return this;
        }
        SolvableLocalResidue<C> B = new SolvableLocalResidue<C>(this.ring, b);
        return this.multiply((C)B);
    }

    @Override
    public SolvableLocalResidue<C> multiply(C b) {
        if (b == null || b.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.num.isZERO()) {
            return this;
        }
        if (b.isONE()) {
            return this;
        }
        GenPolynomial B = ((GenSolvablePolynomial)this.ring.ring.getONE()).multiply((RingElem)b);
        return this.multiply((C)B);
    }

    @Override
    public SolvableLocalResidue<C> multiply(ExpVector e) {
        if (e == null || e.isZERO()) {
            return this;
        }
        if (this.num.isZERO()) {
            return this;
        }
        GenPolynomial B = ((GenSolvablePolynomial)this.ring.ring.getONE()).multiply(e);
        return this.multiply((C)B);
    }

    public SolvableLocalResidue<C> monic() {
        if (this.num.isZERO()) {
            return this;
        }
        return this;
    }

    @Override
    public SolvableLocalResidue<C> gcd(SolvableLocalResidue<C> b) {
        if (b == null || b.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return b;
        }
        return this.ring.getONE();
    }

    public SolvableLocalResidue<C>[] egcd(SolvableLocalResidue<C> b) {
        SolvableLocalResidue[] ret = new SolvableLocalResidue[]{null, null, null};
        if (b == null || b.isZERO()) {
            ret[0] = this;
            return ret;
        }
        if (this.isZERO()) {
            ret[0] = b;
            return ret;
        }
        GenPolynomial two = this.ring.ring.fromInteger(2L);
        ret[0] = this.ring.getONE();
        ret[1] = this.multiply((C)two).inverse();
        ret[2] = b.multiply(two).inverse();
        return ret;
    }
}

