/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.Dimension;
import edu.jas.application.Ideal;
import edu.jas.gb.SolvableExtendedGB;
import edu.jas.gb.SolvableGroebnerBaseAbstract;
import edu.jas.gb.SolvableGroebnerBaseSeq;
import edu.jas.gb.SolvableReduction;
import edu.jas.gb.SolvableReductionSeq;
import edu.jas.gbmod.SolvableSyzygyAbstract;
import edu.jas.gbufd.PolyGBUtil;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.PolynomialList;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.NotInvertibleException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class SolvableIdeal<C extends GcdRingElem<C>>
implements Comparable<SolvableIdeal<C>>,
Serializable {
    private static final Logger logger = Logger.getLogger(SolvableIdeal.class);
    private final boolean debug = logger.isDebugEnabled();
    protected PolynomialList<C> list;
    protected boolean isGB;
    protected boolean testGB;
    protected boolean isTopt;
    protected final SolvableGroebnerBaseAbstract<C> bb;
    protected final SolvableReduction<C> red;

    public SolvableIdeal(GenSolvablePolynomialRing<C> ring) {
        this(ring, new ArrayList<GenSolvablePolynomial<C>>());
    }

    public SolvableIdeal(GenSolvablePolynomialRing<C> ring, List<GenSolvablePolynomial<C>> F) {
        this(new PolynomialList<C>(ring, F));
    }

    public SolvableIdeal(GenSolvablePolynomialRing<C> ring, List<GenSolvablePolynomial<C>> F, boolean gb) {
        this(new PolynomialList<C>(ring, F), gb);
    }

    public SolvableIdeal(GenSolvablePolynomialRing<C> ring, List<GenSolvablePolynomial<C>> F, boolean gb, boolean topt) {
        this(new PolynomialList<C>(ring, F), gb, topt);
    }

    public SolvableIdeal(PolynomialList<C> list) {
        this(list, false);
    }

    public SolvableIdeal(PolynomialList<C> list, SolvableGroebnerBaseAbstract<C> bb, SolvableReduction<C> red) {
        this(list, false, bb, red);
    }

    public SolvableIdeal(PolynomialList<C> list, boolean gb) {
        this(list, gb, new SolvableGroebnerBaseSeq(), new SolvableReductionSeq());
    }

    public SolvableIdeal(PolynomialList<C> list, boolean gb, boolean topt) {
        this(list, gb, topt, new SolvableGroebnerBaseSeq(), new SolvableReductionSeq());
    }

    public SolvableIdeal(PolynomialList<C> list, boolean gb, SolvableGroebnerBaseAbstract<C> bb, SolvableReduction<C> red) {
        this(list, gb, false, bb, red);
    }

    public SolvableIdeal(PolynomialList<C> list, boolean gb, SolvableGroebnerBaseAbstract<C> bb) {
        this(list, gb, false, bb, bb.sred);
    }

    public SolvableIdeal(PolynomialList<C> list, boolean gb, boolean topt, SolvableGroebnerBaseAbstract<C> bb) {
        this(list, gb, topt, bb, bb.sred);
    }

    public SolvableIdeal(PolynomialList<C> list, boolean gb, boolean topt, SolvableGroebnerBaseAbstract<C> bb, SolvableReduction<C> red) {
        if (list == null || list.list == null) {
            throw new IllegalArgumentException("list and list.list may not be null");
        }
        this.list = list;
        this.isGB = gb;
        this.isTopt = topt;
        this.testGB = gb;
        this.bb = bb;
        this.red = red;
    }

    public SolvableIdeal<C> copy() {
        return new SolvableIdeal<C>(this.list.copy(), this.isGB, this.isTopt, this.bb, this.red);
    }

    public List<GenSolvablePolynomial<C>> getList() {
        return this.list.getSolvableList();
    }

    public GenSolvablePolynomialRing<C> getRing() {
        return this.list.getSolvableRing();
    }

    public SolvableIdeal<C> getZERO() {
        ArrayList z = new ArrayList(0);
        PolynomialList<C> pl = new PolynomialList<C>(this.getRing(), z);
        return new SolvableIdeal<C>(pl, true, this.isTopt, this.bb, this.red);
    }

    public SolvableIdeal<C> getONE() {
        ArrayList one = new ArrayList(1);
        one.add(this.getRing().getONE());
        PolynomialList<C> pl = new PolynomialList<C>(this.getRing(), one);
        return new SolvableIdeal<C>(pl, true, this.isTopt, this.bb, this.red);
    }

    public String toString() {
        return this.list.toString();
    }

    public String toScript() {
        return this.list.toScript();
    }

    public boolean equals(Object b) {
        if (!(b instanceof SolvableIdeal)) {
            logger.warn((Object)"equals no Ideal");
            return false;
        }
        SolvableIdeal B = null;
        try {
            B = (SolvableIdeal)b;
        }
        catch (ClassCastException ignored) {
            return false;
        }
        return this.contains(B) && B.contains(this);
    }

    @Override
    public int compareTo(SolvableIdeal<C> L) {
        return this.list.compareTo(L.list);
    }

    public int hashCode() {
        int h = this.list.hashCode();
        if (this.isGB) {
            h <<= 1;
        }
        if (this.testGB) {
            ++h;
        }
        return h;
    }

    public boolean isZERO() {
        return this.list.isZERO();
    }

    public boolean isONE() {
        return this.list.isONE();
    }

    public boolean isGB() {
        if (this.testGB) {
            return this.isGB;
        }
        logger.warn((Object)"isGB computing");
        this.isGB = this.bb.isLeftGB(this.getList());
        this.testGB = true;
        return this.isGB;
    }

    public void doGB() {
        if (this.isGB && this.testGB) {
            return;
        }
        List<GenSolvablePolynomial<C>> G = this.getList();
        logger.info((Object)("GB computing = " + G));
        G = this.bb.leftGB(G);
        this.list = new PolynomialList<C>(this.getRing(), G);
        this.isGB = true;
        this.testGB = true;
    }

    public SolvableIdeal<C> GB() {
        if (this.isGB) {
            return this;
        }
        this.doGB();
        return this;
    }

    public boolean contains(SolvableIdeal<C> B) {
        if (B == null || B.isZERO()) {
            return true;
        }
        return this.contains(B.getList());
    }

    public boolean contains(GenSolvablePolynomial<C> b) {
        GenSolvablePolynomial<C> z;
        if (b == null || b.isZERO()) {
            return true;
        }
        if (this.isONE()) {
            return true;
        }
        if (this.isZERO()) {
            return false;
        }
        if (!this.isGB) {
            this.doGB();
        }
        return (z = this.red.leftNormalform(this.getList(), b)) == null || z.isZERO();
    }

    public boolean contains(List<GenSolvablePolynomial<C>> B) {
        if (B == null || B.size() == 0) {
            return true;
        }
        if (this.isONE()) {
            return true;
        }
        if (!this.isGB) {
            this.doGB();
        }
        List<GenSolvablePolynomial<C>> si = this.getList();
        for (GenSolvablePolynomial<C> b : B) {
            GenSolvablePolynomial<C> z;
            if (b == null || (z = this.red.leftNormalform(si, b)).isZERO()) continue;
            System.out.println("contains nf(b) != 0: " + b + ", z = " + z + ", si = " + si);
            return false;
        }
        return true;
    }

    public SolvableIdeal<C> sum(SolvableIdeal<C> B) {
        if (B == null || B.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return B;
        }
        int s = this.getList().size() + B.getList().size();
        ArrayList<GenSolvablePolynomial<C>> c = new ArrayList<GenSolvablePolynomial<C>>(s);
        c.addAll(this.getList());
        c.addAll(B.getList());
        SolvableIdeal<C> I = new SolvableIdeal<C>(this.getRing(), c, false);
        if (this.isGB && B.isGB) {
            I.doGB();
        }
        return I;
    }

    public SolvableIdeal<C> sum(GenSolvablePolynomial<C> b) {
        if (b == null || b.isZERO()) {
            return this;
        }
        int s = this.getList().size() + 1;
        ArrayList<GenSolvablePolynomial<C>> c = new ArrayList<GenSolvablePolynomial<C>>(s);
        c.addAll(this.getList());
        c.add(b);
        SolvableIdeal<C> I = new SolvableIdeal<C>(this.getRing(), c, false);
        if (this.isGB) {
            I.doGB();
        }
        return I;
    }

    public SolvableIdeal<C> sum(List<GenSolvablePolynomial<C>> L) {
        if (L == null || L.isEmpty()) {
            return this;
        }
        int s = this.getList().size() + L.size();
        ArrayList<GenSolvablePolynomial<C>> c = new ArrayList<GenSolvablePolynomial<C>>(s);
        c.addAll(this.getList());
        c.addAll(L);
        SolvableIdeal<C> I = new SolvableIdeal<C>(this.getRing(), c, false);
        if (this.isGB) {
            I.doGB();
        }
        return I;
    }

    public SolvableIdeal<C> product(SolvableIdeal<C> B) {
        if (B == null || B.isZERO()) {
            return B;
        }
        if (this.isZERO()) {
            return this;
        }
        int s = this.getList().size() * B.getList().size();
        ArrayList<GenSolvablePolynomial<C>> c = new ArrayList<GenSolvablePolynomial<C>>(s);
        for (GenSolvablePolynomial<GenSolvablePolynomial<C>> genSolvablePolynomial : this.getList()) {
            for (GenSolvablePolynomial<Object> q : B.getList()) {
                q = genSolvablePolynomial.multiply(q);
                c.add(q);
            }
        }
        SolvableIdeal<C> I = new SolvableIdeal<C>(this.getRing(), c, false);
        if (this.isGB && B.isGB) {
            I.doGB();
        }
        return I;
    }

    public SolvableIdeal<C> product(GenSolvablePolynomial<C> b) {
        if (b == null || b.isZERO()) {
            return this.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        ArrayList<GenSolvablePolynomial<C>> c = new ArrayList<GenSolvablePolynomial<C>>(this.getList().size());
        for (GenSolvablePolynomial<GenSolvablePolynomial<C>> genSolvablePolynomial : this.getList()) {
            GenSolvablePolynomial<GenSolvablePolynomial<C>> q = genSolvablePolynomial.multiply(b);
            c.add(q);
        }
        SolvableIdeal<C> I = new SolvableIdeal<C>(this.getRing(), c, false);
        if (this.isGB) {
            I.doGB();
        }
        return I;
    }

    public SolvableIdeal<C> intersect(List<SolvableIdeal<C>> Bl) {
        if (Bl == null || Bl.size() == 0) {
            return this.getZERO();
        }
        SolvableIdeal<C> I = null;
        for (SolvableIdeal<C> B : Bl) {
            if (I == null) {
                I = B;
                continue;
            }
            if (I.isONE()) {
                return I;
            }
            I = I.intersect(B);
        }
        return I;
    }

    public SolvableIdeal<C> intersect(SolvableIdeal<C> B) {
        if (B == null || B.isZERO()) {
            return B;
        }
        if (this.isZERO()) {
            return this;
        }
        List<GenSolvablePolynomial<C>> c = PolyGBUtil.intersect(this.getRing(), this.getList(), B.getList());
        SolvableIdeal<C> I = new SolvableIdeal<C>(this.getRing(), c, true);
        return I;
    }

    public SolvableIdeal<C> intersect(GenSolvablePolynomialRing<C> R) {
        if (R == null) {
            throw new IllegalArgumentException("R may not be null");
        }
        List<GenSolvablePolynomial<C>> H = PolyUtil.intersect(R, this.getList());
        return new SolvableIdeal<C>(R, H, this.isGB, this.isTopt);
    }

    public SolvableIdeal<C> eliminate(GenSolvablePolynomialRing<C> R) {
        if (R == null) {
            throw new IllegalArgumentException("R may not be null");
        }
        if (this.getRing().equals(R)) {
            return this;
        }
        return this.intersect(R);
    }

    public SolvableIdeal<C> quotient(GenSolvablePolynomial<C> h) {
        if (h == null) {
            return this;
        }
        if (h.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return this;
        }
        ArrayList<GenSolvablePolynomial<C>> H = new ArrayList<GenSolvablePolynomial<C>>(1);
        H.add(h);
        SolvableIdeal<C> Hi = new SolvableIdeal<C>(this.getRing(), H, true);
        SolvableIdeal<C> I = this.intersect(Hi);
        ArrayList<GenSolvablePolynomial<C>> Q = new ArrayList<GenSolvablePolynomial<C>>(I.getList().size());
        for (GenSolvablePolynomial<C> genSolvablePolynomial : I.getList()) {
            GenSolvablePolynomial genSolvablePolynomial2 = (GenSolvablePolynomial)genSolvablePolynomial.divide(h);
            Q.add(genSolvablePolynomial2);
        }
        return new SolvableIdeal<C>(this.getRing(), Q, true);
    }

    public SolvableIdeal<C> quotient(SolvableIdeal<C> H) {
        if (H == null || H.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return this;
        }
        SolvableIdeal<C> Q = null;
        for (GenSolvablePolynomial<C> h : H.getList()) {
            SolvableIdeal<C> Hi = this.quotient(h);
            if (Q == null) {
                Q = Hi;
                continue;
            }
            Q = Q.intersect(Hi);
        }
        return Q;
    }

    public SolvableIdeal<C> infiniteQuotientRab(GenSolvablePolynomial<C> h) {
        if (h == null || h.isZERO()) {
            return this.getONE();
        }
        if (h.isONE()) {
            return this;
        }
        if (this.isZERO()) {
            return this;
        }
        if (!this.getRing().isCommutative()) {
            throw new UnsupportedOperationException("Rabinowich trick only for commutative polynomial rings");
        }
        SolvableIdeal<C> I = this.GB();
        List<GenSolvablePolynomial<C>> a = I.getList();
        ArrayList c = new ArrayList(a.size() + 1);
        GenPolynomialRing tfac = this.getRing().extend(1);
        for (GenSolvablePolynomial<C> genSolvablePolynomial : a) {
            GenSolvablePolynomial genSolvablePolynomial2 = (GenSolvablePolynomial)genSolvablePolynomial.extend(tfac, 0, 0L);
            c.add(genSolvablePolynomial2);
        }
        GenSolvablePolynomial q = (GenSolvablePolynomial)h.extend(tfac, 0, 1L);
        GenPolynomial genPolynomial = ((GenSolvablePolynomialRing)tfac).getONE();
        GenSolvablePolynomial hs = (GenSolvablePolynomial)q.subtract(genPolynomial);
        c.add(hs);
        logger.warn((Object)"infiniteQuotientRab computing GB ");
        List<GenSolvablePolynomial<C>> g = this.bb.leftGB(c);
        if (this.debug) {
            logger.info((Object)("infiniteQuotientRab    = " + tfac + ", c = " + c));
            logger.info((Object)("infiniteQuotientRab GB = " + g));
        }
        SolvableIdeal<C> E = new SolvableIdeal<C>(tfac, g, true);
        SolvableIdeal<C> Is = E.intersect(this.getRing());
        return Is;
    }

    public int infiniteQuotientExponent(GenSolvablePolynomial<C> h, SolvableIdeal<C> Q) {
        int s = 0;
        if (h == null) {
            return s;
        }
        if (h.isZERO() || h.isONE()) {
            return s;
        }
        if (this.isZERO() || this.isONE()) {
            return s;
        }
        GenSolvablePolynomial<GenSolvablePolynomial<GenSolvablePolynomial<C>>> p = this.getRing().getONE();
        for (GenSolvablePolynomial<GenSolvablePolynomial<GenSolvablePolynomial<GenSolvablePolynomial<C>>>> genSolvablePolynomial : Q.getList()) {
            if (this.contains(genSolvablePolynomial)) continue;
            GenSolvablePolynomial<GenPolynomial> qp = genSolvablePolynomial.multiply(p);
            while (!this.contains(qp)) {
                p = p.multiply((GenSolvablePolynomial<GenSolvablePolynomial<C>>)h);
                ++s;
                qp = genSolvablePolynomial.multiply(p);
            }
        }
        return s;
    }

    public SolvableIdeal<C> infiniteQuotient(GenSolvablePolynomial<C> h) {
        if (h == null) {
            return this;
        }
        if (h.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return this;
        }
        int s = 0;
        SolvableIdeal<C> I = this.GB();
        GenSolvablePolynomial<C> hs = h;
        SolvableIdeal<C> Is = I;
        boolean eq = false;
        while (!eq) {
            Is = I.quotient(hs);
            Is = Is.GB();
            logger.info((Object)("infiniteQuotient s = " + s));
            eq = Is.contains(I);
            if (eq) continue;
            I = Is;
            ++s;
        }
        return Is;
    }

    public boolean isRadicalMember(GenSolvablePolynomial<C> h) {
        if (h == null) {
            return true;
        }
        if (h.isZERO()) {
            return true;
        }
        if (this.isZERO()) {
            return true;
        }
        SolvableIdeal<C> x = this.infiniteQuotientRab(h);
        if (this.debug) {
            logger.debug((Object)("infiniteQuotientRab = " + x));
        }
        return x.isONE();
    }

    public SolvableIdeal<C> infiniteQuotient(SolvableIdeal<C> H) {
        if (H == null) {
            return this;
        }
        if (H.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return this;
        }
        SolvableIdeal<C> Q = null;
        for (GenSolvablePolynomial<C> h : H.getList()) {
            SolvableIdeal<C> Hi = this.infiniteQuotient(h);
            if (Q == null) {
                Q = Hi;
                continue;
            }
            Q = Q.intersect(Hi);
        }
        return Q;
    }

    public SolvableIdeal<C> infiniteQuotientRab(SolvableIdeal<C> H) {
        if (H == null) {
            return this;
        }
        if (H.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return this;
        }
        SolvableIdeal<C> Q = null;
        for (GenSolvablePolynomial<C> h : H.getList()) {
            SolvableIdeal<C> Hi = this.infiniteQuotientRab(h);
            if (Q == null) {
                Q = Hi;
                continue;
            }
            Q = Q.intersect(Hi);
        }
        return Q;
    }

    public SolvableIdeal<C> power(int d) {
        if (d <= 0) {
            return this.getONE();
        }
        if (this.isZERO() || this.isONE()) {
            return this;
        }
        SolvableIdeal<C> c = this;
        for (int i = 1; i < d; ++i) {
            c = c.product(this);
        }
        return c;
    }

    public GenSolvablePolynomial<C> normalform(GenSolvablePolynomial<C> h) {
        if (h == null) {
            return h;
        }
        if (h.isZERO()) {
            return h;
        }
        if (this.isZERO()) {
            return h;
        }
        GenSolvablePolynomial<C> r = this.red.leftNormalform(this.getList(), h);
        return r;
    }

    public List<GenSolvablePolynomial<C>> normalform(List<GenSolvablePolynomial<C>> L) {
        if (L == null) {
            return L;
        }
        if (L.size() == 0) {
            return L;
        }
        if (this.isZERO()) {
            return L;
        }
        ArrayList<GenSolvablePolynomial<C>> M = new ArrayList<GenSolvablePolynomial<C>>(L.size());
        for (GenSolvablePolynomial<C> h : L) {
            GenSolvablePolynomial<C> r = this.normalform(h);
            if (r == null || r.isZERO()) continue;
            M.add(r);
        }
        return M;
    }

    public SolvableIdeal<C> annihilator(GenSolvablePolynomial<C> h) {
        if (h == null || h.isZERO()) {
            return this.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        this.doGB();
        ArrayList F = new ArrayList(1 + this.getList().size());
        F.add(h);
        F.addAll(this.getList());
        SolvableSyzygyAbstract syz = new SolvableSyzygyAbstract();
        List S = syz.leftZeroRelationsArbitrary(F);
        ArrayList<GenSolvablePolynomial<C>> gen = new ArrayList<GenSolvablePolynomial<C>>(S.size());
        for (List rel : S) {
            GenSolvablePolynomial p;
            if (rel == null || rel.isEmpty() || (p = rel.get(0)) == null || p.isZERO()) continue;
            gen.add(p);
        }
        SolvableIdeal<C> ann = new SolvableIdeal<C>(this.getRing(), gen);
        return ann;
    }

    public boolean isAnnihilator(GenSolvablePolynomial<C> h, SolvableIdeal<C> A) {
        SolvableIdeal<C> B = A.product(h);
        return this.contains(B);
    }

    public SolvableIdeal<C> annihilator(SolvableIdeal<C> H) {
        if (H == null || H.isZERO()) {
            return this.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        SolvableIdeal<C> ann = null;
        for (GenSolvablePolynomial<C> h : H.getList()) {
            SolvableIdeal<C> Hi = this.annihilator(h);
            if (ann == null) {
                ann = Hi;
                continue;
            }
            ann = ann.intersect(Hi);
        }
        return ann;
    }

    public boolean isAnnihilator(SolvableIdeal<C> H, SolvableIdeal<C> A) {
        SolvableIdeal<C> B = A.product(H);
        return this.contains(B);
    }

    public GenSolvablePolynomial<C> inverse(GenSolvablePolynomial<C> h) {
        if (h == null || h.isZERO()) {
            throw new NotInvertibleException("zero not invertible");
        }
        if (this.isZERO()) {
            throw new NotInvertibleException("zero ideal");
        }
        if (h.isUnit()) {
            return (GenSolvablePolynomial)h.inverse();
        }
        this.doGB();
        ArrayList F = new ArrayList(1 + this.list.list.size());
        F.add(h);
        F.addAll(this.getList());
        SolvableExtendedGB<C> x = this.bb.extLeftGB(F);
        List G = x.G;
        GenSolvablePolynomial one = null;
        int i = -1;
        for (GenSolvablePolynomial p : G) {
            ++i;
            if (p == null || !p.isUnit()) continue;
            one = p;
            break;
        }
        if (one == null) {
            throw new NotInvertibleException("one == null: h = " + h);
        }
        List row = x.G2F.get(i);
        GenPolynomial g = row.get(0);
        if (g == null || g.isZERO()) {
            throw new NotInvertibleException("g == 0: h = " + h);
        }
        GenSolvablePolynomial<C> gp = this.red.leftNormalform((List<GenSolvablePolynomial<GenSolvablePolynomial<C>>>)this.getList(), (GenSolvablePolynomial<GenSolvablePolynomial<C>>)g);
        if (gp.isZERO()) {
            throw new NotInvertibleException("solv|gp == 0: h = " + h + ", g = " + g);
        }
        GenSolvablePolynomial<GenSolvablePolynomial<C>> f = g.multiply(h);
        GenSolvablePolynomial<GenSolvablePolynomial<C>> k = this.red.leftNormalform(this.getList(), f);
        if (!k.isONE()) {
            GcdRingElem lbc = (GcdRingElem)k.leadingBaseCoefficient();
            lbc = (GcdRingElem)lbc.inverse();
            g = g.multiply(lbc);
        }
        if (this.debug) {
            f = g.multiply(h);
            k = this.red.leftNormalform(this.getList(), f);
            logger.debug((Object)("inv k = " + k));
            if (!k.isUnit()) {
                throw new NotInvertibleException(" k = " + k);
            }
        }
        return g;
    }

    public boolean isUnit(GenSolvablePolynomial<C> h) {
        if (h == null || h.isZERO()) {
            return false;
        }
        if (this.isZERO()) {
            return false;
        }
        ArrayList F = new ArrayList(1 + this.list.list.size());
        F.add(h);
        F.addAll(this.getList());
        List<GenSolvablePolynomial<C>> G = this.bb.leftGB(F);
        for (GenSolvablePolynomial<C> p : G) {
            if (p == null || !p.isUnit()) continue;
            return true;
        }
        return false;
    }

    public int commonZeroTest() {
        if (this.isZERO()) {
            return 1;
        }
        if (!this.isGB) {
            this.doGB();
        }
        if (this.isONE()) {
            return -1;
        }
        return this.bb.commonZeroTest(this.getList());
    }

    public boolean isMaximal() {
        if (this.commonZeroTest() != 0) {
            return false;
        }
        for (Long d : this.univariateDegrees()) {
            if (d <= 1L) continue;
            return false;
        }
        return true;
    }

    public List<Long> univariateDegrees() {
        ArrayList<Long> ud = new ArrayList<Long>();
        if (this.isZERO()) {
            return ud;
        }
        if (!this.isGB) {
            this.doGB();
        }
        if (this.isONE()) {
            return ud;
        }
        return this.bb.univariateDegrees(this.getList());
    }

    public Dimension dimension() {
        Ideal<C> ci = new Ideal<C>(this.list);
        return ci.dimension();
    }

    public List<GenSolvablePolynomial<C>> constructUnivariate() {
        ArrayList<GenSolvablePolynomial<C>> univs = new ArrayList<GenSolvablePolynomial<C>>();
        for (int i = this.getRing().nvar - 1; i >= 0; --i) {
            GenSolvablePolynomial<C> u = this.constructUnivariate(i);
            univs.add(u);
        }
        return univs;
    }

    public GenSolvablePolynomial<C> constructUnivariate(int i) {
        this.doGB();
        return this.bb.constructUnivariate(i, this.getList());
    }
}

