/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.Ideal;
import edu.jas.application.IdealWithRealAlgebraicRoots;
import edu.jas.application.IdealWithUniv;
import edu.jas.application.PolyUtilApp;
import edu.jas.application.RealAlgebraicNumber;
import edu.jas.application.RealAlgebraicRing;
import edu.jas.arith.Rational;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.root.Interval;
import edu.jas.root.RealRootTuple;
import edu.jas.structure.ElemFactory;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import org.apache.log4j.Logger;

public class RootFactory {
    private static final Logger logger = Logger.getLogger(RootFactory.class);
    private static boolean debug = logger.isDebugEnabled();

    public static <C extends GcdRingElem<C> & Rational> boolean isRootRealCoeff(GenPolynomial<C> f, Complex<RealAlgebraicNumber<C>> r) {
        RingFactory cfac = f.ring.coFac;
        ComplexRing ccfac = new ComplexRing(cfac);
        GenPolynomialRing facc = new GenPolynomialRing(ccfac, f.ring);
        GenPolynomial fc = PolyUtil.complexFromAny(facc, f);
        return RootFactory.isRoot(fc, r);
    }

    public static <C extends GcdRingElem<C> & Rational> boolean isRoot(GenPolynomial<Complex<C>> f, Complex<RealAlgebraicNumber<C>> r) {
        GenPolynomialRing cfac;
        GenPolynomial p;
        ElemFactory cr = r.factory();
        Complex<RealAlgebraicNumber<C>> a = PolyUtil.evaluateMain(cr, p = PolyUtilApp.convertToComplexRealCoefficients(cfac = new GenPolynomialRing(cr, (GenPolynomialRing)f.factory()), f), r);
        boolean t = a.isZERO();
        if (!t) {
            logger.info((Object)("f(r) = " + a + ", f = " + f + ", r  = " + r));
            return t;
        }
        RealAlgebraicRing rring = (RealAlgebraicRing)((ComplexRing)cr).ring;
        RealRootTuple rroot = rring.getRoot();
        List rlist = rroot.tuple;
        Interval vr = rlist.get((int)0).ring.getRoot();
        Interval vi = rlist.get((int)1).ring.getRoot();
        ComplexRing ccfac = new ComplexRing((RingFactory)((GcdRingElem)vr.left).factory());
        Complex sw = new Complex(ccfac, vr.left, vi.left);
        Complex ne = new Complex(ccfac, vr.right, vi.right);
        Complex epsw = PolyUtil.evaluateMain(ccfac, f, sw);
        Complex epne = PolyUtil.evaluateMain(ccfac, f, ne);
        int rootre = ((GcdRingElem)epsw.getRe()).signum() * ((GcdRingElem)epne.getRe()).signum();
        int rootim = ((GcdRingElem)epsw.getIm()).signum() * ((GcdRingElem)epne.getIm()).signum();
        t = rootre <= 0 && rootim <= 0;
        return true;
    }

    public static <C extends GcdRingElem<C> & Rational> boolean isRoot(GenPolynomial<Complex<C>> f, List<Complex<RealAlgebraicNumber<C>>> R) {
        for (Complex<RealAlgebraicNumber<C>> r : R) {
            boolean t = RootFactory.isRoot(f, r);
            if (t) continue;
            return false;
        }
        return true;
    }

    public static <C extends GcdRingElem<C> & Rational> List<Complex<RealAlgebraicNumber<C>>> complexAlgebraicNumbersComplex(GenPolynomial<Complex<C>> f) {
        ElemFactory pfac = f.factory();
        if (((GenPolynomialRing)pfac).nvar != 1) {
            throw new IllegalArgumentException("only for univariate polynomials");
        }
        ComplexRing cfac = (ComplexRing)((GenPolynomialRing)pfac).coFac;
        SquarefreeAbstract<GenPolynomial<Complex<C>>> engine = SquarefreeFactory.getImplementation(cfac);
        SortedMap<GenPolynomial<Complex<C>>, Long> F = engine.squarefreeFactors(f.monic());
        Set S = F.keySet();
        ArrayList<Complex<RealAlgebraicNumber<C>>> list = new ArrayList<Complex<RealAlgebraicNumber<C>>>();
        for (GenPolynomial sp : S) {
            if (sp.isConstant() || sp.isZERO()) continue;
            List<Complex<RealAlgebraicNumber<C>>> ls = RootFactory.complexAlgebraicNumbersSquarefree(sp);
            long m = (Long)F.get(sp);
            for (long i = 0L; i < m; ++i) {
                list.addAll(ls);
            }
        }
        return list;
    }

    public static <C extends GcdRingElem<C> & Rational> List<Complex<RealAlgebraicNumber<C>>> complexAlgebraicNumbersSquarefree(GenPolynomial<Complex<C>> f) {
        ElemFactory pfac = f.factory();
        if (((GenPolynomialRing)pfac).nvar != 1) {
            throw new IllegalArgumentException("only for univariate polynomials");
        }
        ComplexRing cfac = (ComplexRing)((GenPolynomialRing)pfac).coFac;
        TermOrder to = new TermOrder(2);
        GenPolynomialRing tfac = new GenPolynomialRing(cfac, 2, to);
        GenPolynomial t = tfac.univariate(1, 1L).sum(tfac.univariate(0, 1L).multiply(cfac.getIMAG()));
        GenPolynomialRing rfac = new GenPolynomialRing(cfac.ring, tfac);
        ArrayList<Complex<RealAlgebraicNumber<C>>> list = new ArrayList<Complex<RealAlgebraicNumber<C>>>();
        GenPolynomial<Complex<C>> sp = f;
        if (sp.isConstant() || sp.isZERO()) {
            return list;
        }
        GenPolynomial su = PolyUtil.substituteUnivariate(sp, t);
        su = su.monic();
        GenPolynomial re = PolyUtil.realPartFromComplex(rfac, su);
        GenPolynomial im = PolyUtil.imaginaryPartFromComplex(rfac, su);
        if (debug) {
            logger.debug((Object)("rfac = " + rfac.toScript()));
            logger.debug((Object)("t  = " + t + ", re = " + re.toScript() + ", im = " + im.toScript()));
        }
        ArrayList li = new ArrayList(2);
        li.add(re);
        li.add(im);
        Ideal id = new Ideal(rfac, li);
        List idul = id.zeroDimRootDecomposition();
        for (IdealWithUniv idu : idul) {
            IdealWithRealAlgebraicRoots idr = PolyUtilApp.realAlgebraicRoots(idu);
            for (List list2 : idr.ran) {
                RealRootTuple root = new RealRootTuple(list2);
                RealAlgebraicRing car = new RealAlgebraicRing(idu, root);
                List gens = car.generators();
                int sg = gens.size();
                RealAlgebraicNumber rre = gens.get(sg - 2);
                RealAlgebraicNumber rim = gens.get(sg - 1);
                ComplexRing cring = new ComplexRing(car);
                Complex crn = new Complex(cring, rre, rim);
                list.add(crn);
            }
        }
        return list;
    }
}

