/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.IdealWithUniv;
import edu.jas.application.RealAlgebraicNumber;
import edu.jas.application.ResidueRing;
import edu.jas.arith.BigRational;
import edu.jas.arith.Rational;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.root.Interval;
import edu.jas.root.PolyUtilRoot;
import edu.jas.root.RealRootTuple;
import edu.jas.structure.ElemFactory;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.Power;
import edu.jas.structure.RingFactory;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;

public class RealAlgebraicRing<C extends GcdRingElem<C> & Rational>
implements RingFactory<RealAlgebraicNumber<C>> {
    final IdealWithUniv<C> univs;
    final ResidueRing<C> algebraic;
    RealRootTuple<C> root;
    public final edu.jas.root.RealAlgebraicRing<edu.jas.root.RealAlgebraicNumber<C>> realRing;
    protected C eps;
    public final int PRECISION = 9;
    private static final Logger logger = Logger.getLogger(RealAlgebraicRing.class);

    public RealAlgebraicRing(IdealWithUniv<C> m, ResidueRing<C> a, RealRootTuple<C> r) {
        this.univs = m;
        this.algebraic = a;
        this.root = r;
        if (this.algebraic.characteristic().signum() > 0) {
            throw new IllegalArgumentException("characteristic not zero");
        }
        GcdRingElem e = (GcdRingElem)m.ideal.list.ring.coFac.fromInteger(10L);
        e = (GcdRingElem)e.inverse();
        e = Power.positivePower(e, 9L);
        this.eps = e;
        ElemFactory rfac1 = this.root.tuple.get(0).factory();
        ElemFactory rfac2 = this.root.tuple.get(1).factory();
        GenPolynomial p0 = PolyUtil.selectWithVariable(this.univs.ideal.list.list, 0);
        if (p0 == null) {
            throw new RuntimeException("no polynomial found in 0 of  " + this.univs.ideal);
        }
        GenPolynomialRing pfac = p0.ring;
        GenPolynomialRing prfac = pfac.recursive(1);
        GenPolynomial p0r = PolyUtil.recursive(prfac, p0);
        GenPolynomialRing parfac = new GenPolynomialRing(rfac1, prfac);
        GenPolynomial p0ar = PolyUtilRoot.convertRecursiveToAlgebraicCoefficients(parfac, p0r);
        Interval r2 = ((edu.jas.root.RealAlgebraicRing)rfac2).getRoot();
        edu.jas.root.RealAlgebraicNumber<GcdRingElem> rleft = ((edu.jas.root.RealAlgebraicNumber)((edu.jas.root.RealAlgebraicRing)rfac1).getZERO()).sum((GcdRingElem)r2.left);
        edu.jas.root.RealAlgebraicNumber<GcdRingElem> rright = ((edu.jas.root.RealAlgebraicNumber)((edu.jas.root.RealAlgebraicRing)rfac1).getZERO()).sum((GcdRingElem)r2.right);
        Interval<edu.jas.root.RealAlgebraicNumber<GcdRingElem>> r2r = new Interval<edu.jas.root.RealAlgebraicNumber<GcdRingElem>>(rleft, rright);
        edu.jas.root.RealAlgebraicRing<edu.jas.root.RealAlgebraicNumber<GcdRingElem>> rr = new edu.jas.root.RealAlgebraicRing<edu.jas.root.RealAlgebraicNumber<GcdRingElem>>(p0ar, r2r);
        logger.info((Object)("realRing = " + rr));
        this.realRing = rr;
    }

    public RealAlgebraicRing(IdealWithUniv<C> m, RealRootTuple<C> root) {
        this(m, new ResidueRing(m.ideal), root);
    }

    public RealAlgebraicRing(IdealWithUniv<C> m, RealRootTuple<C> root, boolean isField) {
        this(m, new ResidueRing(m.ideal, isField), root);
    }

    public synchronized void setRoot(RealRootTuple<C> v) {
        this.root = v;
    }

    public synchronized RealRootTuple<C> getRoot() {
        return this.root;
    }

    public synchronized C getEps() {
        return this.eps;
    }

    public synchronized void setEps(C e) {
        this.eps = e;
    }

    public synchronized void setEps(BigRational e) {
        edu.jas.root.RealAlgebraicRing r = (edu.jas.root.RealAlgebraicRing)this.realRing.algebraic.ring.coFac;
        this.eps = (GcdRingElem)r.algebraic.ring.coFac.parse(e.toString());
    }

    @Override
    public boolean isFinite() {
        return this.realRing.isFinite();
    }

    @Override
    public RealAlgebraicNumber<C> copy(RealAlgebraicNumber<C> c) {
        return new RealAlgebraicNumber(this, c.number);
    }

    @Override
    public RealAlgebraicNumber<C> getZERO() {
        return new RealAlgebraicNumber(this, this.realRing.getZERO());
    }

    @Override
    public RealAlgebraicNumber<C> getONE() {
        return new RealAlgebraicNumber(this, this.realRing.getONE());
    }

    @Override
    public List<RealAlgebraicNumber<C>> generators() {
        List<edu.jas.root.RealAlgebraicNumber<edu.jas.root.RealAlgebraicNumber<C>>> agens = this.realRing.generators();
        ArrayList<RealAlgebraicNumber<C>> gens = new ArrayList<RealAlgebraicNumber<C>>(agens.size());
        for (edu.jas.root.RealAlgebraicNumber<edu.jas.root.RealAlgebraicNumber<C>> a : agens) {
            gens.add(((RealAlgebraicNumber)this.getZERO()).sum(a));
        }
        return gens;
    }

    @Override
    public boolean isCommutative() {
        return this.realRing.isCommutative();
    }

    @Override
    public boolean isAssociative() {
        return this.realRing.isAssociative();
    }

    @Override
    public boolean isField() {
        return this.realRing.isField();
    }

    public void setField(boolean isField) {
        this.realRing.setField(isField);
    }

    @Override
    public BigInteger characteristic() {
        return this.realRing.characteristic();
    }

    @Override
    public RealAlgebraicNumber<C> fromInteger(BigInteger a) {
        return new RealAlgebraicNumber(this, this.realRing.fromInteger(a));
    }

    @Override
    public RealAlgebraicNumber<C> fromInteger(long a) {
        return new RealAlgebraicNumber(this, this.realRing.fromInteger(a));
    }

    public String toString() {
        return "RealAlgebraicRing[ " + this.realRing.toString() + " in " + this.root + " | isField=" + this.realRing.isField() + ", algebraic.ideal=" + this.algebraic.ideal.toString() + " ]";
    }

    @Override
    public String toScript() {
        return "RealRecN( " + this.realRing.toScript() + ", " + this.root.toScript() + " )";
    }

    public boolean equals(Object b) {
        if (!(b instanceof RealAlgebraicRing)) {
            return false;
        }
        RealAlgebraicRing a = null;
        try {
            a = (RealAlgebraicRing)b;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (a == null) {
            return false;
        }
        return this.realRing.equals(a.realRing) && this.root.equals(a.root);
    }

    public int hashCode() {
        return 37 * this.realRing.hashCode() + this.root.hashCode();
    }

    @Override
    public RealAlgebraicNumber<C> random(int n) {
        return new RealAlgebraicNumber(this, this.realRing.random(n));
    }

    @Override
    public RealAlgebraicNumber<C> random(int n, Random rnd) {
        return new RealAlgebraicNumber(this, this.realRing.random(n, rnd));
    }

    @Override
    public RealAlgebraicNumber<C> parse(String s) {
        return new RealAlgebraicNumber(this, this.realRing.parse(s));
    }

    @Override
    public RealAlgebraicNumber<C> parse(Reader r) {
        return new RealAlgebraicNumber(this, this.realRing.parse(r));
    }
}

