/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.CoeffConvertAlg;
import edu.jas.application.CoeffRecConvertAlg;
import edu.jas.application.CoeffToComplexReal;
import edu.jas.application.ColoredSystem;
import edu.jas.application.EvaluateToComplexReal;
import edu.jas.application.GroebnerSystem;
import edu.jas.application.Ideal;
import edu.jas.application.IdealWithComplexAlgebraicRoots;
import edu.jas.application.IdealWithComplexRoots;
import edu.jas.application.IdealWithRealAlgebraicRoots;
import edu.jas.application.IdealWithRealRoots;
import edu.jas.application.IdealWithUniv;
import edu.jas.application.PrimitiveElement;
import edu.jas.application.ReAlgFromRealCoeff;
import edu.jas.application.RealAlgebraicNumber;
import edu.jas.application.RealAlgebraicRing;
import edu.jas.application.RealFromReAlgCoeff;
import edu.jas.application.Residue;
import edu.jas.application.ResidueRing;
import edu.jas.application.RootFactory;
import edu.jas.arith.BigDecimal;
import edu.jas.arith.Product;
import edu.jas.arith.ProductRing;
import edu.jas.arith.Rational;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.TermOrder;
import edu.jas.root.ComplexRootsSturm;
import edu.jas.root.Interval;
import edu.jas.root.InvalidBoundaryException;
import edu.jas.root.RealRootTuple;
import edu.jas.root.RealRootsSturm;
import edu.jas.root.Rectangle;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.Element;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.util.ListUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class PolyUtilApp<C extends RingElem<C>> {
    private static final Logger logger = Logger.getLogger(PolyUtilApp.class);
    private static boolean debug = logger.isDebugEnabled();

    public static <C extends GcdRingElem<C>> List<GenPolynomial<Product<Residue<C>>>> toProductRes(GenPolynomialRing<Product<Residue<C>>> pfac, List<GenPolynomial<GenPolynomial<C>>> L) {
        ArrayList<GenPolynomial<Product<Residue<C>>>> list = new ArrayList<GenPolynomial<Product<Residue<C>>>>();
        if (L == null || L.size() == 0) {
            return list;
        }
        for (GenPolynomial<GenPolynomial<C>> a : L) {
            GenPolynomial<Product<Residue<C>>> b = PolyUtilApp.toProductRes(pfac, a);
            list.add(b);
        }
        return list;
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<Product<Residue<C>>> toProductRes(GenPolynomialRing<Product<Residue<C>>> pfac, GenPolynomial<GenPolynomial<C>> A) {
        Element P = ((GenPolynomial)pfac.getZERO()).copy();
        if (A == null || A.isZERO()) {
            return P;
        }
        RingFactory rpfac = pfac.coFac;
        ProductRing fac = (ProductRing)rpfac;
        for (Map.Entry<ExpVector, GenPolynomial<C>> y : A.getMap().entrySet()) {
            ExpVector e = y.getKey();
            GenPolynomial<C> a = y.getValue();
            Product<Residue<C>> p = PolyUtilApp.toProductRes(fac, a);
            if (p.isZERO()) continue;
            ((GenPolynomial)P).doPutToMap(e, p);
        }
        return P;
    }

    public static <C extends GcdRingElem<C>> Product<Residue<C>> toProductRes(ProductRing<Residue<C>> pfac, GenPolynomial<C> c) {
        TreeMap<Integer, Residue<C>> elem = new TreeMap<Integer, Residue<C>>();
        for (int i = 0; i < pfac.length(); ++i) {
            RingFactory<Residue<C>> rfac = pfac.getFactory(i);
            ResidueRing fac = (ResidueRing)rfac;
            Residue<C> u = new Residue<C>(fac, c);
            if (u.isZERO()) continue;
            elem.put(i, u);
        }
        return new Product<Residue<C>>(pfac, elem);
    }

    public static <C extends GcdRingElem<C>> List<GenPolynomial<Product<Residue<C>>>> toProductRes(List<ColoredSystem<C>> CS) {
        List<GenPolynomial<Product<Residue<C>>>> list = new ArrayList<GenPolynomial<Product<Residue<C>>>>();
        if (CS == null || CS.size() == 0) {
            return list;
        }
        GenPolynomialRing pr = null;
        ArrayList rrl = new ArrayList(CS.size());
        for (ColoredSystem<C> cs : CS) {
            Ideal id = cs.condition.zero;
            ResidueRing r = new ResidueRing(id);
            if (!rrl.contains(r)) {
                rrl.add(r);
            }
            if (pr != null || cs.list.size() <= 0) continue;
            pr = cs.list.get((int)0).green.ring;
        }
        ProductRing pfac = new ProductRing(rrl);
        GenPolynomialRing<Product<Residue<C>>> rf = new GenPolynomialRing<Product<Residue<C>>>(pfac, pr.nvar, pr.tord, pr.getVars());
        GroebnerSystem<C> gs = new GroebnerSystem<C>(CS);
        List<GenPolynomial<GenPolynomial<C>>> F = gs.getCGB();
        list = PolyUtilApp.toProductRes(rf, F);
        return list;
    }

    public static <C extends GcdRingElem<C>> List<GenPolynomial<Residue<C>>> toResidue(GenPolynomialRing<Residue<C>> pfac, List<GenPolynomial<GenPolynomial<C>>> L) {
        ArrayList<GenPolynomial<Residue<C>>> list = new ArrayList<GenPolynomial<Residue<C>>>();
        if (L == null || L.size() == 0) {
            return list;
        }
        for (GenPolynomial<GenPolynomial<C>> a : L) {
            GenPolynomial<Residue<C>> b = PolyUtilApp.toResidue(pfac, a);
            if (b.isZERO()) continue;
            list.add(b);
        }
        return list;
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<Residue<C>> toResidue(GenPolynomialRing<Residue<C>> pfac, GenPolynomial<GenPolynomial<C>> A) {
        Element P = ((GenPolynomial)pfac.getZERO()).copy();
        if (A == null || A.isZERO()) {
            return P;
        }
        RingFactory rpfac = pfac.coFac;
        ResidueRing fac = (ResidueRing)rpfac;
        for (Map.Entry<ExpVector, GenPolynomial<C>> y : A.getMap().entrySet()) {
            ExpVector e = y.getKey();
            GenPolynomial<C> a = y.getValue();
            Residue<C> p = new Residue<C>(fac, a);
            if (p.isZERO()) continue;
            ((GenPolynomial)P).doPutToMap(e, p);
        }
        return P;
    }

    public static <C extends GcdRingElem<C>> Map<Ideal<C>, PolynomialList<GenPolynomial<C>>> productSlice(PolynomialList<Product<Residue<C>>> L) {
        RingFactory fpr = L.ring.coFac;
        ProductRing pr = (ProductRing)fpr;
        int s = pr.length();
        TreeMap<Ideal<C>, PolynomialList<GenPolynomial<C>>> map = new TreeMap<Ideal<C>, PolynomialList<GenPolynomial<C>>>();
        List<GenPolynomial<Product<Residue<C>>>> plist = L.list;
        for (int i = 0; i < s; ++i) {
            RingFactory r = pr.getFactory(i);
            ResidueRing rr = (ResidueRing)r;
            Ideal id = rr.ideal;
            GenPolynomialRing cof = rr.ring;
            GenPolynomialRing<GenPolynomial<C>> pfc = new GenPolynomialRing<GenPolynomial<C>>(cof, L.ring);
            List slist = PolyUtilApp.fromProduct(pfc, plist, i);
            PolynomialList<GenPolynomial<C>> spl = new PolynomialList<GenPolynomial<C>>(pfc, slist);
            PolynomialList d = (PolynomialList)map.get(id);
            if (d != null) {
                throw new RuntimeException("ideal exists twice " + id);
            }
            map.put(id, spl);
        }
        return map;
    }

    public static <C extends GcdRingElem<C>> PolynomialList<GenPolynomial<C>> productSlice(PolynomialList<Product<Residue<C>>> L, int i) {
        RingFactory fpr = L.ring.coFac;
        ProductRing pr = (ProductRing)fpr;
        List<GenPolynomial<Product<Residue<C>>>> plist = L.list;
        RingFactory r = pr.getFactory(i);
        ResidueRing rr = (ResidueRing)r;
        GenPolynomialRing cof = rr.ring;
        GenPolynomialRing<GenPolynomial<C>> pfc = new GenPolynomialRing<GenPolynomial<C>>(cof, L.ring);
        List slist = PolyUtilApp.fromProduct(pfc, plist, i);
        PolynomialList<GenPolynomial<C>> spl = new PolynomialList<GenPolynomial<C>>(pfc, slist);
        return spl;
    }

    public static <C extends GcdRingElem<C>> List<GenPolynomial<GenPolynomial<C>>> fromProduct(GenPolynomialRing<GenPolynomial<C>> pfac, List<GenPolynomial<Product<Residue<C>>>> L, int i) {
        ArrayList<GenPolynomial<GenPolynomial<C>>> list = new ArrayList<GenPolynomial<GenPolynomial<C>>>();
        if (L == null || L.size() == 0) {
            return list;
        }
        for (GenPolynomial<Product<Residue<C>>> a : L) {
            AbelianGroupElem<GenPolynomial<C>> b = PolyUtilApp.fromProduct(pfac, a, i);
            if (b.isZERO() || list.contains(b = b.abs())) continue;
            list.add((GenPolynomial<GenPolynomial<C>>)b);
        }
        return list;
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<GenPolynomial<C>> fromProduct(GenPolynomialRing<GenPolynomial<C>> pfac, GenPolynomial<Product<Residue<C>>> P, int i) {
        Element b = ((GenPolynomial)pfac.getZERO()).copy();
        if (P == null || P.isZERO()) {
            return b;
        }
        for (Map.Entry<ExpVector, Product<Residue<C>>> y : P.getMap().entrySet()) {
            GenPolynomial p;
            ExpVector e = y.getKey();
            Product<Residue<C>> a = y.getValue();
            Residue<C> r = a.get(i);
            if (r == null || r.isZERO() || (p = r.val).isZERO()) continue;
            ((GenPolynomial)b).doPutToMap(e, p);
        }
        return b;
    }

    public static <C extends GcdRingElem<C>> String productSliceToString(Map<Ideal<C>, PolynomialList<GenPolynomial<C>>> L) {
        TreeSet sl = new TreeSet();
        PolynomialList<GenPolynomial<C>> pl = null;
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<Ideal<C>, PolynomialList<GenPolynomial<C>>> en : L.entrySet()) {
            sb.append("\n\ncondition == 0:\n");
            sb.append(en.getKey().list.toScript());
            pl = en.getValue();
            sl.addAll(pl.list);
            sb.append("\ncorresponding ideal:\n");
            sb.append(pl.toScript());
        }
        return sb.toString();
    }

    public static <C extends GcdRingElem<C>> String productToString(PolynomialList<Product<Residue<C>>> L) {
        Map<Ideal<C>, PolynomialList<GenPolynomial<C>>> M = PolyUtilApp.productSlice(L);
        String s = PolyUtilApp.productSliceToString(M);
        return s;
    }

    public static <D extends GcdRingElem<D> & Rational> List<List<Complex<BigDecimal>>> complexRootTuples(Ideal<D> I, D eps) {
        List<GenPolynomial<D>> univs = I.constructUnivariate();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("univs = " + univs));
        }
        return PolyUtilApp.complexRoots(I, univs, eps);
    }

    public static <D extends GcdRingElem<D> & Rational> List<List<Complex<BigDecimal>>> complexRoots(Ideal<D> I, List<GenPolynomial<D>> univs, D eps) {
        ArrayList<List<Complex<BigDecimal>>> croots = new ArrayList();
        RingFactory cf = I.list.ring.coFac;
        ComplexRing cr = new ComplexRing(cf);
        ComplexRootsSturm<D> cra = new ComplexRootsSturm<D>(cr);
        ArrayList cunivs = new ArrayList();
        for (GenPolynomial<D> p : univs) {
            GenPolynomialRing pfac = new GenPolynomialRing(cr, p.ring);
            GenPolynomial cp = PolyUtil.toComplex(pfac, p);
            cunivs.add(cp);
        }
        for (int i = 0; i < I.list.ring.nvar; ++i) {
            List<Complex<BigDecimal>> cri = cra.approximateRoots((GenPolynomial)cunivs.get(i), eps);
            croots.add(cri);
        }
        croots = ListUtil.tupleFromList(croots);
        return croots;
    }

    public static <D extends GcdRingElem<D> & Rational> List<List<Complex<BigDecimal>>> complexRootTuples(List<IdealWithUniv<D>> Il, D eps) {
        ArrayList<List<Complex<BigDecimal>>> croots = new ArrayList<List<Complex<BigDecimal>>>();
        for (IdealWithUniv<D> I : Il) {
            List<List<Complex<BigDecimal>>> cr = PolyUtilApp.complexRoots(I.ideal, I.upolys, eps);
            croots.addAll(cr);
        }
        return croots;
    }

    public static <D extends GcdRingElem<D> & Rational> List<IdealWithComplexRoots<D>> complexRoots(List<IdealWithUniv<D>> Il, D eps) {
        ArrayList<IdealWithComplexRoots<D>> Ic = new ArrayList<IdealWithComplexRoots<D>>(Il.size());
        for (IdealWithUniv<D> I : Il) {
            List<List<Complex<BigDecimal>>> cr = PolyUtilApp.complexRoots(I.ideal, I.upolys, eps);
            IdealWithComplexRoots<D> ic = new IdealWithComplexRoots<D>(I, cr);
            Ic.add(ic);
        }
        return Ic;
    }

    public static <D extends GcdRingElem<D> & Rational> List<IdealWithComplexRoots<D>> complexRoots(Ideal<D> G, D eps) {
        List<IdealWithUniv<D>> Il = G.zeroDimDecomposition();
        return PolyUtilApp.complexRoots(Il, eps);
    }

    public static <D extends GcdRingElem<D> & Rational> List<List<BigDecimal>> realRootTuples(Ideal<D> I, D eps) {
        List<GenPolynomial<D>> univs = I.constructUnivariate();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("univs = " + univs));
        }
        return PolyUtilApp.realRoots(I, univs, eps);
    }

    public static <D extends GcdRingElem<D> & Rational> List<List<BigDecimal>> realRoots(Ideal<D> I, List<GenPolynomial<D>> univs, D eps) {
        ArrayList<List<BigDecimal>> roots = new ArrayList();
        RealRootsSturm<D> rra = new RealRootsSturm<D>();
        for (int i = 0; i < I.list.ring.nvar; ++i) {
            List<BigDecimal> rri = rra.approximateRoots(univs.get(i), eps);
            roots.add(rri);
        }
        roots = ListUtil.tupleFromList(roots);
        return roots;
    }

    public static <D extends GcdRingElem<D> & Rational> List<List<BigDecimal>> realRootTuples(List<IdealWithUniv<D>> Il, D eps) {
        ArrayList<List<BigDecimal>> rroots = new ArrayList<List<BigDecimal>>();
        for (IdealWithUniv<D> I : Il) {
            List<List<BigDecimal>> rr = PolyUtilApp.realRoots(I.ideal, I.upolys, eps);
            rroots.addAll(rr);
        }
        return rroots;
    }

    public static <D extends GcdRingElem<D> & Rational> List<IdealWithRealRoots<D>> realRoots(List<IdealWithUniv<D>> Il, D eps) {
        ArrayList<IdealWithRealRoots<D>> Ir = new ArrayList<IdealWithRealRoots<D>>(Il.size());
        for (IdealWithUniv<D> I : Il) {
            List<List<BigDecimal>> rr = PolyUtilApp.realRoots(I.ideal, I.upolys, eps);
            IdealWithRealRoots<D> ir = new IdealWithRealRoots<D>(I, rr);
            Ir.add(ir);
        }
        return Ir;
    }

    public static <D extends GcdRingElem<D> & Rational> List<IdealWithRealRoots<D>> realRoots(Ideal<D> G, D eps) {
        List<IdealWithUniv<D>> Il = G.zeroDimDecomposition();
        return PolyUtilApp.realRoots(Il, eps);
    }

    public static boolean isRealRoots(List<GenPolynomial<BigDecimal>> L, List<List<BigDecimal>> roots, BigDecimal eps) {
        if (L == null || L.size() == 0) {
            return true;
        }
        BigDecimal dc = BigDecimal.ONE;
        GenPolynomialRing dfac = L.get((int)0).ring;
        for (GenPolynomial<BigDecimal> dp : L) {
            for (List<BigDecimal> r : roots) {
                BigDecimal ev = PolyUtil.evaluateAll(dc, dfac, dp, r);
                if (ev.abs().compareTo(eps) <= 0) continue;
                System.out.println("ev = " + ev);
                return false;
            }
        }
        return true;
    }

    public static boolean isComplexRoots(List<GenPolynomial<Complex<BigDecimal>>> L, List<List<Complex<BigDecimal>>> roots, BigDecimal eps) {
        if (L == null || L.size() == 0) {
            return true;
        }
        BigDecimal dc = BigDecimal.ONE;
        ComplexRing<BigDecimal> dcc = new ComplexRing<BigDecimal>(dc);
        GenPolynomialRing dfac = L.get((int)0).ring;
        for (GenPolynomial<Complex<BigDecimal>> dp : L) {
            for (List<Complex<BigDecimal>> r : roots) {
                Complex<BigDecimal> ev = PolyUtil.evaluateAll(dcc, dfac, dp, r);
                if (((BigDecimal)((Complex)ev.norm()).getRe()).compareTo(eps) <= 0) continue;
                System.out.println("ev = " + ev);
                return false;
            }
        }
        return true;
    }

    public static <D extends GcdRingElem<D> & Rational> IdealWithRealAlgebraicRoots<D> realAlgebraicRoots(IdealWithUniv<D> I) {
        int[] dep0;
        ArrayList<List<edu.jas.root.RealAlgebraicNumber<Object>>> ran = new ArrayList();
        if (I == null) {
            throw new IllegalArgumentException("null ideal not permitted");
        }
        if (I.ideal == null || I.upolys == null) {
            throw new IllegalArgumentException("null ideal components not permitted " + I);
        }
        if (I.ideal.isZERO() || I.upolys.size() == 0) {
            return new IdealWithRealAlgebraicRoots<D>(I, ran);
        }
        GenPolynomialRing fac = I.ideal.list.ring;
        GenPolynomial p0 = I.upolys.get(0);
        GenPolynomial p0p = PolyUtil.selectWithVariable(I.ideal.list.list, fac.nvar - 1);
        if (p0p == null) {
            throw new RuntimeException("no polynomial found in " + (fac.nvar - 1) + " of  " + I.ideal);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("p0p = " + p0p));
        }
        if ((dep0 = p0p.degreeVector().dependencyOnVariables()).length != 1) {
            throw new RuntimeException("wrong number of variables " + Arrays.toString(dep0));
        }
        List rra = edu.jas.root.RootFactory.realAlgebraicNumbersIrred(p0);
        if (logger.isInfoEnabled()) {
            ArrayList il = new ArrayList();
            for (edu.jas.root.RealAlgebraicNumber rr : rra) {
                il.add(rr.ring.getRoot());
            }
            logger.info((Object)("roots(p0) = " + il));
        }
        for (edu.jas.root.RealAlgebraicNumber realAlgebraicNumber : rra) {
            ArrayList rl = new ArrayList();
            rl.add(realAlgebraicNumber);
            ran.add(rl);
        }
        for (int i = 1; i < I.upolys.size(); ++i) {
            int[] depi;
            ArrayList arrayList = new ArrayList();
            GenPolynomial pi = I.upolys.get(i);
            GenPolynomial pip = PolyUtil.selectWithVariable(I.ideal.list.list, fac.nvar - 1 - i);
            if (pip == null) {
                throw new RuntimeException("no polynomial found in " + (fac.nvar - 1 - i) + " of  " + I.ideal);
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)("pi  = " + pi));
                logger.info((Object)("pip = " + pip));
            }
            if ((depi = pip.degreeVector().dependencyOnVariables()).length < 1 || depi.length > 2) {
                throw new RuntimeException("wrong number of variables " + Arrays.toString(depi));
            }
            rra = edu.jas.root.RootFactory.realAlgebraicNumbersIrred(pi);
            if (logger.isInfoEnabled()) {
                ArrayList il = new ArrayList();
                for (edu.jas.root.RealAlgebraicNumber rr : rra) {
                    il.add(rr.ring.getRoot());
                }
                logger.info((Object)("roots(pi) = " + il));
            }
            if (depi.length == 1) {
                for (edu.jas.root.RealAlgebraicNumber rr : rra) {
                    for (List list : ran) {
                        ArrayList ry = new ArrayList();
                        ry.addAll(list);
                        ry.add(rr);
                        arrayList.add(ry);
                    }
                }
            } else {
                GenPolynomial pip2 = PolyUtil.removeUnusedUpperVariables(pip);
                GenPolynomialRing ufac = pip2.ring.contract(1);
                TermOrder to = new TermOrder(2);
                GenPolynomialRing genPolynomialRing = new GenPolynomialRing(ufac, 1, to);
                GenPolynomial pip2r = PolyUtil.recursive(genPolynomialRing, pip2);
                int ix = fac.nvar - 1 - depi[depi.length - 1];
                for (edu.jas.root.RealAlgebraicNumber rr : rra) {
                    Interval rroot = rr.ring.getRoot();
                    GenPolynomial pip2el = PolyUtil.evaluateMainRecursive(ufac, pip2r, rroot.left);
                    GenPolynomial pip2er = PolyUtil.evaluateMainRecursive(ufac, pip2r, rroot.right);
                    GenPolynomialRing upfac = I.upolys.get((int)ix).ring;
                    GenPolynomial pip2elc = PolyUtilApp.convert(upfac, pip2el);
                    GenPolynomial pip2erc = PolyUtilApp.convert(upfac, pip2er);
                    for (List list : ran) {
                        int sr;
                        edu.jas.root.RealAlgebraicRing rar = ((edu.jas.root.RealAlgebraicNumber)list.get((int)ix)).ring;
                        edu.jas.root.RealAlgebraicNumber rel = new edu.jas.root.RealAlgebraicNumber(rar, pip2elc);
                        edu.jas.root.RealAlgebraicNumber rer = new edu.jas.root.RealAlgebraicNumber(rar, pip2erc);
                        int sl = rel.signum();
                        if (sl * (sr = rer.signum()) > 0) continue;
                        ArrayList ry = new ArrayList();
                        ry.addAll(list);
                        ry.add(rr);
                        arrayList.add(ry);
                    }
                }
            }
            ran = arrayList;
        }
        if (logger.isInfoEnabled()) {
            for (List list : ran) {
                ArrayList il = new ArrayList();
                for (edu.jas.root.RealAlgebraicNumber rr : list) {
                    il.add(rr.ring.getRoot());
                }
                logger.info((Object)("root-tuple = " + il));
            }
        }
        IdealWithRealAlgebraicRoots<D> Ir = new IdealWithRealAlgebraicRoots<D>(I, ran);
        return Ir;
    }

    public static <D extends GcdRingElem<D> & Rational> List<IdealWithRealAlgebraicRoots<D>> realAlgebraicRoots(List<IdealWithUniv<D>> I) {
        ArrayList<IdealWithRealAlgebraicRoots<D>> lir = new ArrayList<IdealWithRealAlgebraicRoots<D>>(I.size());
        for (IdealWithUniv<D> iu : I) {
            IdealWithRealAlgebraicRoots<D> iur = PolyUtilApp.realAlgebraicRoots(iu);
            lir.add(iur);
        }
        return lir;
    }

    public static <D extends GcdRingElem<D> & Rational> IdealWithComplexAlgebraicRoots<D> complexAlgebraicRootsWrong(IdealWithUniv<D> I) {
        boolean t;
        int[] dep0;
        ArrayList<List<Complex<RealAlgebraicNumber<Object>>>> can = new ArrayList();
        if (I == null) {
            throw new IllegalArgumentException("null ideal not permitted");
        }
        if (I.ideal == null || I.upolys == null) {
            throw new IllegalArgumentException("null ideal components not permitted " + I);
        }
        if (I.ideal.isZERO() || I.upolys.size() == 0) {
            return new IdealWithComplexAlgebraicRoots<D>(I, can);
        }
        GenPolynomialRing fac = I.ideal.list.ring;
        if (fac.nvar == 0) {
            return new IdealWithComplexAlgebraicRoots<D>(I, can);
        }
        if (fac.nvar != I.upolys.size()) {
            throw new IllegalArgumentException("ideal not zero dimnsional: " + I);
        }
        GenPolynomial p0 = I.upolys.get(0);
        GenPolynomial p0p = PolyUtil.selectWithVariable(I.ideal.list.list, fac.nvar - 1);
        if (p0p == null) {
            throw new RuntimeException("no polynomial found in " + (fac.nvar - 1) + " of  " + I.ideal);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("p0  = " + p0));
            logger.info((Object)("p0p = " + p0p));
        }
        if ((dep0 = p0p.degreeVector().dependencyOnVariables()).length != 1) {
            throw new RuntimeException("wrong number of variables " + Arrays.toString(dep0));
        }
        RingFactory cfac = p0.ring.coFac;
        ComplexRing ccfac = new ComplexRing(cfac);
        GenPolynomialRing facc = new GenPolynomialRing(ccfac, p0.ring);
        GenPolynomial p0c = PolyUtil.complexFromAny(facc, p0);
        List cra = RootFactory.complexAlgebraicNumbersSquarefree(p0c);
        logger.info((Object)("#roots(p0c) = " + cra.size()));
        if (debug && !(t = RootFactory.isRoot(p0c, cra))) {
            throw new RuntimeException("no roots of " + p0c);
        }
        for (Complex cr : cra) {
            ArrayList cl = new ArrayList();
            cl.add(cr);
            can.add(cl);
        }
        if (fac.nvar == 1) {
            return new IdealWithComplexAlgebraicRoots<D>(I, can);
        }
        for (int i = 1; i < I.upolys.size(); ++i) {
            boolean t2;
            ArrayList cn = new ArrayList();
            GenPolynomial pi = I.upolys.get(i);
            GenPolynomial pip = PolyUtil.selectWithVariable(I.ideal.list.list, fac.nvar - 1 - i);
            if (pip == null) {
                throw new RuntimeException("no polynomial found in " + (fac.nvar - 1 - i) + " of  " + I.ideal);
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)("pi(" + i + ") = " + pi));
                logger.info((Object)("pip  = " + pip));
            }
            facc = new GenPolynomialRing(ccfac, pi.ring);
            GenPolynomial pic = PolyUtil.complexFromAny(facc, pi);
            int[] depi = pip.degreeVector().dependencyOnVariables();
            if (depi.length < 1 || depi.length > 2) {
                throw new RuntimeException("wrong number of variables " + Arrays.toString(depi) + " for " + pip);
            }
            cra = RootFactory.complexAlgebraicNumbersSquarefree(pic);
            logger.info((Object)("#roots(pic) = " + cra.size()));
            if (debug && !(t2 = RootFactory.isRoot(pic, cra))) {
                throw new RuntimeException("no roots of " + pic);
            }
            if (depi.length == 1) {
                for (Complex cr : cra) {
                    for (List list : can) {
                        ArrayList cy = new ArrayList();
                        cy.addAll(list);
                        cy.add(cr);
                        cn.add(cy);
                    }
                }
            } else {
                GenPolynomial pip2 = PolyUtil.removeUnusedUpperVariables(pip);
                GenPolynomialRing rfac = pip2.ring.recursive(1);
                GenPolynomialRing ufac = pip2.ring.contract(1);
                GenPolynomialRing genPolynomialRing = new GenPolynomialRing(ccfac, ufac);
                GenPolynomialRing c2fac = new GenPolynomialRing(ccfac, pip2.ring);
                GenPolynomial pip2c = PolyUtil.complexFromAny(c2fac, pip2);
                GenPolynomialRing rcfac = new GenPolynomialRing(genPolynomialRing, rfac);
                GenPolynomial pip2cr = PolyUtil.recursive(rcfac, pip2c);
                int ix = fac.nvar - 1 - depi[depi.length - 1];
                for (Complex<RealAlgebraicNumber<D>> complex : cra) {
                    GcdRingElem m;
                    GcdRingElem e;
                    System.out.println("cr = " + PolyUtilApp.toString(complex));
                    RealAlgebraicRing cring = (RealAlgebraicRing)complex.ring.ring;
                    RealRootTuple rroot = cring.getRoot();
                    List rlist = rroot.tuple;
                    Interval<Object> vr = rlist.get((int)0).ring.getRoot();
                    Interval<Object> vi = rlist.get((int)1).ring.getRoot();
                    logger.info((Object)("vr = " + vr + ", vi = " + vi));
                    if (((GcdRingElem)vr.length()).isZERO()) {
                        e = (GcdRingElem)((GcdRingElem)vr.left).factory().parse("1/2");
                        m = (GcdRingElem)vr.left;
                        vr = new Interval<RingElem>(m.subtract(e), m.sum(e));
                        logger.info((Object)("|vr| == 0: " + vr));
                    }
                    if (((GcdRingElem)vi.length()).isZERO()) {
                        e = (GcdRingElem)((GcdRingElem)vi.left).factory().parse("1/2");
                        m = (GcdRingElem)vi.left;
                        vi = new Interval<RingElem>(m.subtract(e), m.sum(e));
                        logger.info((Object)("|vi| == 0: " + vi));
                    }
                    Complex sw = new Complex(ccfac, vr.left, vi.left);
                    Complex ne = new Complex(ccfac, vr.right, vi.right);
                    logger.info((Object)("sw   = " + PolyUtilApp.toString1(sw) + ", ne   = " + PolyUtilApp.toString1(ne)));
                    GenPolynomial pip2cesw = PolyUtil.evaluateMainRecursive(genPolynomialRing, pip2cr, sw);
                    GenPolynomial pip2cene = PolyUtil.evaluateMainRecursive(genPolynomialRing, pip2cr, ne);
                    GenPolynomialRing upfac = I.upolys.get((int)ix).ring;
                    GenPolynomialRing upcfac = new GenPolynomialRing(ccfac, upfac);
                    GenPolynomial pip2eswc = PolyUtilApp.convertComplexComplex(upcfac, pip2cesw);
                    GenPolynomial pip2enec = PolyUtilApp.convertComplexComplex(upcfac, pip2cene);
                    for (List list : can) {
                        Complex cax = (Complex)list.get(ix);
                        ComplexRing car = cax.ring;
                        RealAlgebraicRing rar = (RealAlgebraicRing)car.ring;
                        TermOrder to = new TermOrder(2);
                        String vvr = rar.algebraic.ring.getVars()[0];
                        String vvi = rar.algebraic.ring.getVars()[1];
                        String[] vars = new String[]{vvr, vvi};
                        GenPolynomialRing tfac = new GenPolynomialRing(ccfac, to, vars);
                        GenPolynomial t3 = tfac.univariate(1, 1L).sum(tfac.univariate(0, 1L).multiply(ccfac.getIMAG()));
                        GenPolynomialRing rtfac = new GenPolynomialRing(cfac, tfac);
                        GenPolynomial su = PolyUtil.substituteUnivariate(pip2eswc, t3);
                        GenPolynomial re = PolyUtil.realPartFromComplex(rtfac, su);
                        GenPolynomial im = PolyUtil.imaginaryPartFromComplex(rtfac, su);
                        RealAlgebraicNumber resw = new RealAlgebraicNumber(rar, re);
                        int sswr = resw.signum();
                        RealAlgebraicNumber imsw = new RealAlgebraicNumber(rar, im);
                        int sswi = imsw.signum();
                        su = PolyUtil.substituteUnivariate(pip2enec, t3);
                        re = PolyUtil.realPartFromComplex(rtfac, su);
                        im = PolyUtil.imaginaryPartFromComplex(rtfac, su);
                        RealAlgebraicNumber rene = new RealAlgebraicNumber(rar, re);
                        int sner = rene.signum();
                        RealAlgebraicNumber imne = new RealAlgebraicNumber(rar, im);
                        int snei = imne.signum();
                        if (sswr * sner <= 0 && sswi * snei <= 0) {
                            logger.info((Object)("   hit, cxi = " + PolyUtilApp.toString((Complex)list.get(ix)) + ", cr = " + PolyUtilApp.toString(complex)));
                            ArrayList<Complex<RealAlgebraicNumber<D>>> cy = new ArrayList<Complex<RealAlgebraicNumber<D>>>();
                            cy.addAll(list);
                            cy.add(complex);
                            cn.add(cy);
                            continue;
                        }
                        logger.info((Object)("no hit, cxi = " + PolyUtilApp.toString((Complex)list.get(ix)) + ", cr = " + PolyUtilApp.toString(complex)));
                    }
                }
            }
            can = cn;
        }
        IdealWithComplexAlgebraicRoots<D> Ic = new IdealWithComplexAlgebraicRoots<D>(I, can);
        return Ic;
    }

    public static <D extends GcdRingElem<D> & Rational> IdealWithComplexAlgebraicRoots<D> complexAlgebraicRoots(IdealWithUniv<D> I) {
        int[] dep0;
        ArrayList<List<Complex<RealAlgebraicNumber<Object>>>> can = new ArrayList();
        if (I == null) {
            throw new IllegalArgumentException("null ideal not permitted");
        }
        if (I.ideal == null || I.upolys == null) {
            throw new IllegalArgumentException("null ideal components not permitted " + I);
        }
        if (I.ideal.isZERO() || I.upolys.size() == 0) {
            return new IdealWithComplexAlgebraicRoots<D>(I, can);
        }
        GenPolynomialRing fac = I.ideal.list.ring;
        if (fac.nvar == 0) {
            return new IdealWithComplexAlgebraicRoots<D>(I, can);
        }
        if (fac.nvar != I.upolys.size()) {
            throw new IllegalArgumentException("ideal not zero dimnsional: " + I);
        }
        GenPolynomial p0 = I.upolys.get(0);
        GenPolynomial p0p = PolyUtil.selectWithVariable(I.ideal.list.list, fac.nvar - 1);
        if (p0p == null) {
            throw new RuntimeException("no polynomial found in " + (fac.nvar - 1) + " of  " + I.ideal);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("p0  = " + p0));
            logger.info((Object)("p0p = " + p0p));
        }
        if ((dep0 = p0p.degreeVector().dependencyOnVariables()).length != 1) {
            throw new RuntimeException("wrong number of variables " + Arrays.toString(dep0));
        }
        RingFactory cfac = p0.ring.coFac;
        ComplexRing ccfac = new ComplexRing(cfac);
        GenPolynomialRing facc = new GenPolynomialRing(ccfac, p0.ring);
        GenPolynomial p0c = PolyUtil.complexFromAny(facc, p0);
        List cra = RootFactory.complexAlgebraicNumbersSquarefree(p0c);
        logger.info((Object)("#roots(p0c) = " + cra.size()));
        for (Complex cr : cra) {
            ArrayList cl = new ArrayList();
            cl.add(cr);
            can.add(cl);
        }
        if (fac.nvar == 1) {
            return new IdealWithComplexAlgebraicRoots<D>(I, can);
        }
        for (int i = 1; i < I.upolys.size(); ++i) {
            ArrayList cn = new ArrayList();
            GenPolynomial pi = I.upolys.get(i);
            GenPolynomial pip = PolyUtil.selectWithVariable(I.ideal.list.list, fac.nvar - 1 - i);
            if (pip == null) {
                throw new RuntimeException("no polynomial found in " + (fac.nvar - 1 - i) + " of  " + I.ideal);
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)("pi(" + i + ") = " + pi));
                logger.info((Object)("pip  = " + pip));
            }
            facc = new GenPolynomialRing(ccfac, pi.ring);
            GenPolynomial pic = PolyUtil.complexFromAny(facc, pi);
            int[] depi = pip.degreeVector().dependencyOnVariables();
            if (depi.length < 1 || depi.length > 2) {
                throw new RuntimeException("wrong number of variables " + Arrays.toString(depi) + " for " + pip);
            }
            cra = RootFactory.complexAlgebraicNumbersSquarefree(pic);
            logger.info((Object)("#roots(pic) = " + cra.size()));
            if (depi.length == 1) {
                for (Complex cr : cra) {
                    for (List list : can) {
                        ArrayList cy = new ArrayList();
                        cy.addAll(list);
                        cy.add(cr);
                        cn.add(cy);
                    }
                }
            } else {
                GenPolynomial pip2 = PolyUtil.removeUnusedUpperVariables(pip);
                pip2 = PolyUtil.removeUnusedLowerVariables(pip2);
                pip2 = PolyUtil.removeUnusedMiddleVariables(pip2);
                GenPolynomialRing rfac = pip2.ring.recursive(1);
                GenPolynomialRing ufac = pip2.ring.contract(1);
                GenPolynomialRing genPolynomialRing = new GenPolynomialRing(ccfac, ufac);
                GenPolynomialRing c2fac = new GenPolynomialRing(ccfac, pip2.ring);
                GenPolynomial pip2c = PolyUtil.complexFromAny(c2fac, pip2);
                GenPolynomialRing rcfac = new GenPolynomialRing(genPolynomialRing, rfac);
                GenPolynomial pip2cr = PolyUtil.recursive(rcfac, pip2c);
                int ix = fac.nvar - 1 - depi[depi.length - 1];
                for (Complex<RealAlgebraicNumber<D>> complex : cra) {
                    RealAlgebraicRing cring = (RealAlgebraicRing)complex.ring.ring;
                    RealRootTuple rroot = cring.getRoot();
                    List rlist = rroot.tuple;
                    Interval vr = rlist.get((int)0).ring.getRoot();
                    Interval vi = rlist.get((int)1).ring.getRoot();
                    RealAlgebraicNumber<GcdRingElem> vrl = new RealAlgebraicNumber<GcdRingElem>(cring, (GcdRingElem)vr.left);
                    RealAlgebraicNumber<GcdRingElem> vil = new RealAlgebraicNumber<GcdRingElem>(cring, (GcdRingElem)vi.left);
                    RealAlgebraicNumber<GcdRingElem> vrr = new RealAlgebraicNumber<GcdRingElem>(cring, (GcdRingElem)vr.right);
                    RealAlgebraicNumber<GcdRingElem> vir = new RealAlgebraicNumber<GcdRingElem>(cring, (GcdRingElem)vi.right);
                    ComplexRing crr = new ComplexRing(cring);
                    Complex<RealAlgebraicNumber<GcdRingElem>> csw = new Complex<RealAlgebraicNumber<GcdRingElem>>(crr, vrl, vil);
                    Complex<RealAlgebraicNumber<GcdRingElem>> cne = new Complex<RealAlgebraicNumber<GcdRingElem>>(crr, vrr, vir);
                    Rectangle<RealAlgebraicNumber<GcdRingElem>> rec = new Rectangle<RealAlgebraicNumber<GcdRingElem>>(csw, cne);
                    for (List list : can) {
                        Complex cax = (Complex)list.get(ix);
                        ComplexRing car = cax.ring;
                        GenPolynomialRing pcrfac = new GenPolynomialRing(car, rcfac);
                        GenPolynomial pcr = PolyUtilApp.evaluateToComplexRealCoefficients(pcrfac, pip2cr, cax);
                        ComplexRootsSturm<RealAlgebraicNumber<GcdRingElem>> rengine = new ComplexRootsSturm<RealAlgebraicNumber<GcdRingElem>>(car);
                        long nr = 0L;
                        try {
                            nr = rengine.complexRootCount(rec, pcr);
                        }
                        catch (InvalidBoundaryException e) {
                            e.printStackTrace();
                        }
                        if (nr == 1L) {
                            logger.info((Object)("   hit, cxi = " + PolyUtilApp.toString((Complex)list.get(ix)) + ", cr = " + PolyUtilApp.toString(complex)));
                            ArrayList<Complex<RealAlgebraicNumber<D>>> cy = new ArrayList<Complex<RealAlgebraicNumber<D>>>();
                            cy.addAll(list);
                            cy.add(complex);
                            cn.add(cy);
                            continue;
                        }
                        if (nr > 1L) {
                            logger.error((Object)("to many roots, cxi = " + PolyUtilApp.toString((Complex)list.get(ix)) + ", cr = " + PolyUtilApp.toString(complex)));
                            continue;
                        }
                        logger.info((Object)("no hit, cxi = " + PolyUtilApp.toString((Complex)list.get(ix)) + ", cr = " + PolyUtilApp.toString(complex)));
                    }
                }
            }
            can = cn;
        }
        IdealWithComplexAlgebraicRoots<D> Ic = new IdealWithComplexAlgebraicRoots<D>(I, can);
        return Ic;
    }

    public static <D extends GcdRingElem<D> & Rational> String toString(Complex<RealAlgebraicNumber<D>> c) {
        RealAlgebraicNumber<D> re = c.getRe();
        RealAlgebraicNumber<D> im = c.getIm();
        String s = re.decimalMagnitude().toString();
        if (!im.isZERO()) {
            s = s + "i" + im.decimalMagnitude();
        }
        return s;
    }

    public static <D extends GcdRingElem<D> & Rational> String toString1(Complex<D> c) {
        GcdRingElem re = (GcdRingElem)c.getRe();
        GcdRingElem im = (GcdRingElem)c.getIm();
        String s = new BigDecimal(((Rational)((Object)re)).getRational()).toString();
        if (!im.isZERO()) {
            s = s + "i" + new BigDecimal(((Rational)((Object)im)).getRational());
        }
        return s;
    }

    public static <D extends GcdRingElem<D> & Rational> List<IdealWithComplexAlgebraicRoots<D>> complexAlgebraicRoots(List<IdealWithUniv<D>> I) {
        ArrayList<IdealWithComplexAlgebraicRoots<D>> lic = new ArrayList<IdealWithComplexAlgebraicRoots<D>>();
        for (IdealWithUniv<D> iu : I) {
            IdealWithComplexAlgebraicRoots<D> iuc = PolyUtilApp.complexAlgebraicRoots(iu);
            lic.add(iuc);
        }
        return lic;
    }

    public static <D extends GcdRingElem<D> & Rational> List<IdealWithComplexAlgebraicRoots<D>> complexAlgebraicRoots(Ideal<D> I) {
        List<IdealWithUniv<D>> Ir = I.zeroDimRootDecomposition();
        List<IdealWithComplexAlgebraicRoots<D>> roots = PolyUtilApp.complexAlgebraicRoots(Ir);
        return roots;
    }

    static <C extends RingElem<C>> GenPolynomial<C> convert(GenPolynomialRing<C> fac, GenPolynomial<C> p) {
        if (fac.equals(p.factory())) {
            return p;
        }
        Element q = fac.parse(p.toString());
        if (!((GenPolynomial)q).toString().equals(p.toString())) {
            throw new RuntimeException("convert(" + p + ") = " + q);
        }
        return q;
    }

    static <C extends RingElem<C>> GenPolynomial<Complex<C>> convertComplex(GenPolynomialRing<Complex<C>> fac, GenPolynomial<C> p) {
        Element q = fac.parse(p.toString());
        if (!((GenPolynomial)q).toString().equals(p.toString())) {
            throw new RuntimeException("convert(" + p + ") = " + q);
        }
        return q;
    }

    static <C extends RingElem<C>> GenPolynomial<Complex<C>> convertComplexComplex(GenPolynomialRing<Complex<C>> fac, GenPolynomial<Complex<C>> p) {
        if (fac.equals(p.factory())) {
            return p;
        }
        Element q = fac.parse(p.toString());
        if (!((GenPolynomial)q).toString().equals(p.toString())) {
            throw new RuntimeException("convert(" + p + ") = " + q);
        }
        return q;
    }

    public static <D extends GcdRingElem<D> & Rational> List<IdealWithRealAlgebraicRoots<D>> realAlgebraicRoots(Ideal<D> I) {
        List<IdealWithUniv<D>> Ir = I.zeroDimRootDecomposition();
        List<IdealWithRealAlgebraicRoots<D>> roots = PolyUtilApp.realAlgebraicRoots(Ir);
        return roots;
    }

    public static <C extends GcdRingElem<C>> PrimitiveElement<C> primitiveElement(AlgebraicNumberRing<C> a, AlgebraicNumberRing<C> b) {
        GenPolynomial ap = a.modul;
        GenPolynomial bp = b.modul;
        String[] cv = new String[]{ap.ring.getVars()[0], bp.ring.getVars()[0]};
        TermOrder to = new TermOrder(2);
        GenPolynomialRing cfac = new GenPolynomialRing(ap.ring.coFac, 2, to, cv);
        AbelianGroupElem as = ap.extendUnivariate(cfac, 0);
        AbelianGroupElem bs = bp.extendUnivariate(cfac, 1);
        ArrayList L = new ArrayList(2);
        L.add(as);
        L.add(bs);
        ArrayList Op = new ArrayList();
        Ideal id = new Ideal(cfac, L);
        IdealWithUniv iu = id.normalPositionFor(0, 1, Op);
        List Np = iu.ideal.getList();
        as = PolyUtil.selectWithVariable(Np, 1);
        bs = PolyUtil.selectWithVariable(Np, 0);
        GenPolynomial cs = PolyUtil.selectWithVariable(Np, 2);
        String[] ev = new String[]{cs.ring.getVars()[0]};
        GenPolynomialRing efac = new GenPolynomialRing(ap.ring.coFac, 1, to, ev);
        cs = cs.contractCoeff(efac);
        as = as.reductum().contractCoeff(efac);
        as = as.negate();
        bs = bs.reductum().contractCoeff(efac);
        bs = bs.negate();
        AlgebraicNumberRing c = new AlgebraicNumberRing(cs);
        AlgebraicNumber ab = new AlgebraicNumber(c, as);
        AlgebraicNumber bb = new AlgebraicNumber(c, bs);
        PrimitiveElement pe = new PrimitiveElement(c, ab, bb, a, b);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("primitive element = " + c));
        }
        return pe;
    }

    public static <C extends GcdRingElem<C>> AlgebraicNumber<C> convertToPrimitiveElem(AlgebraicNumberRing<C> cfac, AlgebraicNumber<C> A, AlgebraicNumber<C> a) {
        GenPolynomialRing aufac = a.ring.ring;
        GenPolynomialRing ar = new GenPolynomialRing(cfac, aufac);
        GenPolynomial aps = PolyUtil.convertToAlgebraicCoefficients(ar, a.val);
        AlgebraicNumber<C> ac = PolyUtil.evaluateMain(cfac, aps, A);
        return ac;
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<AlgebraicNumber<C>> convertToPrimitiveElem(AlgebraicNumberRing<C> cfac, AlgebraicNumber<C> A, GenPolynomial<AlgebraicNumber<C>> a) {
        GenPolynomialRing<C> cr = new GenPolynomialRing<C>(cfac, a.ring);
        return PolyUtil.map(cr, a, new CoeffConvertAlg<C>(cfac, A));
    }

    public static <C extends GcdRingElem<C>> AlgebraicNumber<C> convertToPrimitiveElem(AlgebraicNumberRing<C> cfac, AlgebraicNumber<C> A, AlgebraicNumber<C> B, AlgebraicNumber<AlgebraicNumber<C>> a) {
        GenPolynomial<AlgebraicNumber<C>> aps = PolyUtilApp.convertToPrimitiveElem(cfac, A, a.val);
        AlgebraicNumber<C> ac = PolyUtil.evaluateMain(cfac, aps, B);
        return ac;
    }

    public static <C extends GcdRingElem<C>> PrimitiveElement<C> primitiveElement(AlgebraicNumberRing<AlgebraicNumber<C>> b) {
        GenPolynomial bp = b.modul;
        AlgebraicNumberRing a = (AlgebraicNumberRing)b.ring.coFac;
        GenPolynomial ap = a.modul;
        String[] cv = new String[]{ap.ring.getVars()[0], bp.ring.getVars()[0]};
        TermOrder to = new TermOrder(2);
        GenPolynomialRing cfac = new GenPolynomialRing(ap.ring.coFac, 2, to, cv);
        GenPolynomialRing rfac = new GenPolynomialRing(a.ring, 1, bp.ring.getVars());
        AbelianGroupElem as = ap.extendUnivariate(cfac, 0);
        GenPolynomial bss = PolyUtil.fromAlgebraicCoefficients(rfac, bp);
        AbelianGroupElem bs = PolyUtil.distribute(cfac, bss);
        ArrayList L = new ArrayList(2);
        L.add(as);
        L.add(bs);
        ArrayList Op = new ArrayList();
        Ideal id = new Ideal(cfac, L);
        IdealWithUniv iu = id.normalPositionFor(0, 1, Op);
        List Np = iu.ideal.getList();
        as = PolyUtil.selectWithVariable(Np, 1);
        bs = PolyUtil.selectWithVariable(Np, 0);
        GenPolynomial cs = PolyUtil.selectWithVariable(Np, 2);
        String[] ev = new String[]{cs.ring.getVars()[0]};
        GenPolynomialRing efac = new GenPolynomialRing(ap.ring.coFac, 1, to, ev);
        cs = cs.contractCoeff(efac);
        as = as.reductum().contractCoeff(efac);
        as = as.negate();
        bs = bs.reductum().contractCoeff(efac);
        bs = bs.negate();
        AlgebraicNumberRing c = new AlgebraicNumberRing(cs);
        AlgebraicNumber ab = new AlgebraicNumber(c, as);
        AlgebraicNumber bb = new AlgebraicNumber(c, bs);
        PrimitiveElement pe = new PrimitiveElement(c, ab, bb);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("primitive element = " + pe));
        }
        return pe;
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<AlgebraicNumber<C>> convertToPrimitiveElem(AlgebraicNumberRing<C> cfac, AlgebraicNumber<C> A, AlgebraicNumber<C> B, GenPolynomial<AlgebraicNumber<AlgebraicNumber<C>>> a) {
        GenPolynomialRing<C> cr = new GenPolynomialRing<C>(cfac, a.ring);
        return PolyUtil.map(cr, a, new CoeffRecConvertAlg<C>(cfac, A, B));
    }

    public static <C extends GcdRingElem<C> & Rational> GenPolynomial<edu.jas.root.RealAlgebraicNumber<C>> realAlgFromRealCoefficients(GenPolynomialRing<edu.jas.root.RealAlgebraicNumber<C>> afac, GenPolynomial<RealAlgebraicNumber<C>> A) {
        edu.jas.root.RealAlgebraicRing cfac = (edu.jas.root.RealAlgebraicRing)afac.coFac;
        return PolyUtil.map(afac, A, new ReAlgFromRealCoeff(cfac));
    }

    public static <C extends GcdRingElem<C> & Rational> GenPolynomial<RealAlgebraicNumber<C>> realFromRealAlgCoefficients(GenPolynomialRing<RealAlgebraicNumber<C>> rfac, GenPolynomial<edu.jas.root.RealAlgebraicNumber<C>> A) {
        RealAlgebraicRing cfac = (RealAlgebraicRing)rfac.coFac;
        return PolyUtil.map(rfac, A, new RealFromReAlgCoeff(cfac));
    }

    public static <C extends GcdRingElem<C> & Rational> GenPolynomial<Complex<RealAlgebraicNumber<C>>> convertToComplexRealCoefficients(GenPolynomialRing<Complex<RealAlgebraicNumber<C>>> pfac, GenPolynomial<Complex<C>> A) {
        ComplexRing afac = (ComplexRing)pfac.coFac;
        return PolyUtil.map(pfac, A, new CoeffToComplexReal(afac));
    }

    public static <C extends GcdRingElem<C> & Rational> GenPolynomial<Complex<RealAlgebraicNumber<C>>> evaluateToComplexRealCoefficients(GenPolynomialRing<Complex<RealAlgebraicNumber<C>>> pfac, GenPolynomial<GenPolynomial<Complex<C>>> A, Complex<RealAlgebraicNumber<C>> r) {
        return PolyUtil.map(pfac, A, new EvaluateToComplexReal<C>(pfac, r));
    }
}

