/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.LocalSolvablePolynomial;
import edu.jas.application.SolvableLocal;
import edu.jas.application.SolvableLocalRing;
import edu.jas.kern.PrettyPrint;
import edu.jas.kern.Scripting;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.RecSolvablePolynomial;
import edu.jas.poly.RecSolvablePolynomialRing;
import edu.jas.poly.RelationTable;
import edu.jas.poly.TermOrder;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.Logger;

public class LocalSolvablePolynomialRing<C extends GcdRingElem<C>>
extends GenSolvablePolynomialRing<SolvableLocal<C>> {
    public final RecSolvablePolynomialRing<C> polCoeff;
    public final LocalSolvablePolynomial<C> ZERO;
    public final LocalSolvablePolynomial<C> ONE;
    private static final Logger logger = Logger.getLogger(LocalSolvablePolynomialRing.class);

    public LocalSolvablePolynomialRing(RingFactory<SolvableLocal<C>> cf, int n) {
        this(cf, n, new TermOrder(), (String[])null, (RelationTable<SolvableLocal<C>>)null);
    }

    public LocalSolvablePolynomialRing(RingFactory<SolvableLocal<C>> cf, int n, RelationTable<SolvableLocal<C>> rt) {
        this(cf, n, new TermOrder(), (String[])null, rt);
    }

    public LocalSolvablePolynomialRing(RingFactory<SolvableLocal<C>> cf, int n, TermOrder t) {
        this(cf, n, t, (String[])null, (RelationTable<SolvableLocal<C>>)null);
    }

    public LocalSolvablePolynomialRing(RingFactory<SolvableLocal<C>> cf, int n, TermOrder t, RelationTable<SolvableLocal<C>> rt) {
        this(cf, n, t, (String[])null, rt);
    }

    public LocalSolvablePolynomialRing(RingFactory<SolvableLocal<C>> cf, int n, TermOrder t, String[] v) {
        this(cf, n, t, v, (RelationTable<SolvableLocal<C>>)null);
    }

    public LocalSolvablePolynomialRing(RingFactory<SolvableLocal<C>> cf, TermOrder t, String[] v) {
        this(cf, v.length, t, v, (RelationTable<SolvableLocal<C>>)null);
    }

    public LocalSolvablePolynomialRing(RingFactory<SolvableLocal<C>> cf, String[] v) {
        this(cf, v.length, new TermOrder(), v, (RelationTable<SolvableLocal<C>>)null);
    }

    public LocalSolvablePolynomialRing(RingFactory<SolvableLocal<C>> cf, int n, TermOrder t, String[] v, RelationTable<SolvableLocal<C>> rt) {
        super(cf, n, t, v, rt);
        SolvableLocalRing cfring = (SolvableLocalRing)cf;
        this.polCoeff = new RecSolvablePolynomialRing(cfring.ring, n, t, v);
        if (this.table.size() > 0) {
            ExpVector e = null;
            ExpVector f = null;
            GenSolvablePolynomial p = null;
            this.polCoeff.table.update(e, f, p);
        }
        this.ZERO = new LocalSolvablePolynomial(this);
        SolvableLocal coeff = (SolvableLocal)this.coFac.getONE();
        this.ONE = new LocalSolvablePolynomial(this, coeff, this.evzero);
    }

    public LocalSolvablePolynomialRing(RingFactory<SolvableLocal<C>> cf, GenSolvablePolynomialRing o) {
        this(cf, o.nvar, o.tord, o.getVars(), (RelationTable<SolvableLocal<C>>)null);
    }

    public LocalSolvablePolynomialRing(RingFactory<SolvableLocal<C>> cf, LocalSolvablePolynomialRing o) {
        this(cf, (GenSolvablePolynomialRing)o);
    }

    @Override
    public String toString() {
        String res = super.toString();
        res = PrettyPrint.isTrue() ? res + "\n" + this.polCoeff.coeffTable.toString(this.vars) : res + ", #rel = " + this.table.size() + " + " + this.polCoeff.coeffTable.size();
        return res;
    }

    @Override
    public String toScript() {
        String rel;
        StringBuffer s = new StringBuffer();
        switch (Scripting.getLang()) {
            case Ruby: {
                s.append("SolvPolyRing.new(");
                break;
            }
            default: {
                s.append("SolvPolyRing(");
            }
        }
        if (this.coFac instanceof RingElem) {
            s.append(((RingElem)((Object)this.coFac)).toScriptFactory());
        } else {
            s.append(this.coFac.toScript().trim());
        }
        s.append(",\"" + this.varsToString() + "\",");
        String to = this.tord.toString();
        if (this.tord.getEvord() == 2) {
            to = "PolyRing.lex";
        }
        if (this.tord.getEvord() == 4) {
            to = "PolyRing.grad";
        }
        s.append(to);
        if (this.table.size() > 0) {
            rel = this.table.toScript();
            s.append(",rel=");
            s.append(rel);
        }
        if (this.polCoeff.coeffTable.size() > 0) {
            rel = this.polCoeff.coeffTable.toScript();
            s.append(",coeffrel=");
            s.append(rel);
        }
        s.append(")");
        return s.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof LocalSolvablePolynomialRing)) {
            return false;
        }
        LocalSolvablePolynomialRing oring = null;
        try {
            oring = (LocalSolvablePolynomialRing)other;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (oring == null) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        return this.polCoeff.coeffTable.equals(oring.polCoeff.coeffTable);
    }

    @Override
    public int hashCode() {
        int h = super.hashCode();
        h = 37 * h + this.table.hashCode();
        h = 37 * h + this.polCoeff.coeffTable.hashCode();
        return h;
    }

    @Override
    public LocalSolvablePolynomial<C> getZERO() {
        return this.ZERO;
    }

    @Override
    public LocalSolvablePolynomial<C> getONE() {
        return this.ONE;
    }

    @Override
    public boolean isCommutative() {
        if (this.polCoeff.coeffTable.size() == 0) {
            return super.isCommutative();
        }
        return false;
    }

    @Override
    public boolean isAssociative() {
        if (!this.coFac.isAssociative()) {
            return false;
        }
        List gens = this.generators();
        int ngen = gens.size();
        for (int i = 0; i < ngen; ++i) {
            LocalSolvablePolynomial Xi = (LocalSolvablePolynomial)gens.get(i);
            for (int j = i + 1; j < ngen; ++j) {
                LocalSolvablePolynomial Xj = (LocalSolvablePolynomial)gens.get(j);
                for (int k = j + 1; k < ngen; ++k) {
                    LocalSolvablePolynomial q;
                    LocalSolvablePolynomial p;
                    LocalSolvablePolynomial Xk = (LocalSolvablePolynomial)gens.get(k);
                    try {
                        p = Xk.multiply(Xj).multiply(Xi);
                        q = Xk.multiply(Xj.multiply(Xi));
                    }
                    catch (IllegalArgumentException e) {
                        continue;
                    }
                    if (p.equals(q)) continue;
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Xk = " + Xk + ", Xj = " + Xj + ", Xi = " + Xi));
                        logger.info((Object)("p = ( Xk * Xj ) * Xi = " + p));
                        logger.info((Object)("q = Xk * ( Xj * Xi ) = " + q));
                        logger.info((Object)("q-p = " + p.subtract(q)));
                    }
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public LocalSolvablePolynomial<C> fromInteger(long a) {
        return new LocalSolvablePolynomial(this, (SolvableLocal)this.coFac.fromInteger(a), this.evzero);
    }

    @Override
    public LocalSolvablePolynomial<C> fromInteger(BigInteger a) {
        return new LocalSolvablePolynomial(this, (SolvableLocal)this.coFac.fromInteger(a), this.evzero);
    }

    @Override
    public LocalSolvablePolynomial<C> random(int n) {
        return this.random(n, random);
    }

    @Override
    public LocalSolvablePolynomial<C> random(int n, Random rnd) {
        if (this.nvar == 1) {
            return this.random(5, n, n, 0.7f, rnd);
        }
        return this.random(5, n, 3, 0.3f, rnd);
    }

    @Override
    public LocalSolvablePolynomial<C> random(int k, int l, int d, float q) {
        return this.random(k, l, d, q, random);
    }

    @Override
    public LocalSolvablePolynomial<C> random(int k, int l, int d, float q, Random rnd) {
        GenSolvablePolynomial r = this.getZERO();
        for (int i = 0; i < l; ++i) {
            ExpVector e = ExpVector.EVRAND(this.nvar, d, q, rnd);
            SolvableLocal a = (SolvableLocal)this.coFac.random(k, rnd);
            r = (LocalSolvablePolynomial)r.sum(a, e);
        }
        return r;
    }

    @Override
    public LocalSolvablePolynomial<C> copy(LocalSolvablePolynomial<C> c) {
        return new LocalSolvablePolynomial(this, c.getMap());
    }

    @Override
    public LocalSolvablePolynomial<C> parse(String s) {
        return this.parse(new StringReader(s));
    }

    @Override
    public LocalSolvablePolynomial<C> parse(Reader r) {
        GenPolynomialTokenizer pt = new GenPolynomialTokenizer(this, r);
        LocalSolvablePolynomial p = null;
        try {
            GenSolvablePolynomial s = pt.nextSolvablePolynomial();
            p = new LocalSolvablePolynomial(this, s);
        }
        catch (IOException e) {
            logger.error((Object)(e.toString() + " parse " + this));
            p = this.ZERO;
        }
        return p;
    }

    @Override
    public LocalSolvablePolynomial<C> univariate(int i) {
        return (LocalSolvablePolynomial)super.univariate(i);
    }

    @Override
    public LocalSolvablePolynomial<C> univariate(int i, long e) {
        return (LocalSolvablePolynomial)super.univariate(i, e);
    }

    @Override
    public LocalSolvablePolynomial<C> univariate(int modv, int i, long e) {
        return (LocalSolvablePolynomial)super.univariate(modv, i, e);
    }

    public List<LocalSolvablePolynomial<C>> recUnivariateList() {
        return this.univariateList(0, 1L);
    }

    public List<LocalSolvablePolynomial<C>> recUnivariateList(int modv) {
        return this.univariateList(modv, 1L);
    }

    public List<LocalSolvablePolynomial<C>> recUnivariateList(int modv, long e) {
        ArrayList<LocalSolvablePolynomial<C>> pols = new ArrayList<LocalSolvablePolynomial<C>>(this.nvar);
        int nm = this.nvar - modv;
        for (int i = 0; i < nm; ++i) {
            GenSolvablePolynomial p = this.univariate(modv, nm - 1 - i, e);
            pols.add((LocalSolvablePolynomial<C>)p);
        }
        return pols;
    }

    @Override
    public LocalSolvablePolynomialRing<C> extend(int i) {
        GenPolynomialRing pfac = super.extend(i);
        LocalSolvablePolynomialRing<C> spfac = new LocalSolvablePolynomialRing<C>(pfac.coFac, pfac.nvar, pfac.tord, pfac.getVars());
        spfac.table.extend(this.table);
        spfac.polCoeff.coeffTable.extend(this.polCoeff.coeffTable);
        return spfac;
    }

    @Override
    public LocalSolvablePolynomialRing<C> contract(int i) {
        GenPolynomialRing pfac = super.contract(i);
        LocalSolvablePolynomialRing<C> spfac = new LocalSolvablePolynomialRing<C>(pfac.coFac, pfac.nvar, pfac.tord, pfac.getVars());
        spfac.table.contract(this.table);
        spfac.polCoeff.coeffTable.contract(this.polCoeff.coeffTable);
        return spfac;
    }

    @Override
    public LocalSolvablePolynomialRing<C> reverse() {
        return this.reverse(false);
    }

    @Override
    public LocalSolvablePolynomialRing<C> reverse(boolean partial) {
        GenPolynomialRing pfac = super.reverse(partial);
        LocalSolvablePolynomialRing<C> spfac = new LocalSolvablePolynomialRing<C>(pfac.coFac, pfac.nvar, pfac.tord, pfac.getVars());
        spfac.partial = partial;
        spfac.table.reverse(this.table);
        spfac.polCoeff.coeffTable.reverse(this.polCoeff.coeffTable);
        return spfac;
    }

    public LocalSolvablePolynomial<C> fromPolyCoefficients(GenSolvablePolynomial<GenPolynomial<C>> A) {
        GenSolvablePolynomial B = ((LocalSolvablePolynomial)this.getZERO()).copy();
        if (A == null || A.isZERO()) {
            return B;
        }
        RingFactory cfac = this.coFac;
        SolvableLocalRing qfac = (SolvableLocalRing)cfac;
        for (Map.Entry y : A.getMap().entrySet()) {
            ExpVector e = y.getKey();
            GenSolvablePolynomial a = (GenSolvablePolynomial)y.getValue();
            SolvableLocal p = new SolvableLocal(qfac, a);
            if (p.isZERO()) continue;
            B.doPutToMap(e, p);
        }
        return B;
    }

    public RecSolvablePolynomial<C> toPolyCoefficients(LocalSolvablePolynomial<C> A) {
        GenSolvablePolynomial B = ((RecSolvablePolynomial)this.polCoeff.getZERO()).copy();
        if (A == null || A.isZERO()) {
            return B;
        }
        for (Map.Entry y : A.getMap().entrySet()) {
            ExpVector e = y.getKey();
            SolvableLocal a = (SolvableLocal)y.getValue();
            if (!a.den.isONE()) {
                throw new IllegalArgumentException("den != 1 not supported: " + a);
            }
            GenSolvablePolynomial p = a.num;
            if (p.isZERO()) continue;
            B.doPutToMap(e, p);
        }
        return B;
    }

    public RecSolvablePolynomial<C> toPolyCoefficients(GenPolynomial<SolvableLocal<C>> A) {
        GenSolvablePolynomial B = ((RecSolvablePolynomial)this.polCoeff.getZERO()).copy();
        if (A == null || A.isZERO()) {
            return B;
        }
        for (Map.Entry<ExpVector, SolvableLocal<C>> y : A.getMap().entrySet()) {
            ExpVector e = y.getKey();
            SolvableLocal<C> a = y.getValue();
            if (!a.den.isONE()) {
                throw new IllegalArgumentException("den != 1 not supported: " + a);
            }
            GenSolvablePolynomial p = a.num;
            if (p.isZERO()) continue;
            B.doPutToMap(e, p);
        }
        return B;
    }
}

