/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.LocalSolvablePolynomialRing;
import edu.jas.application.SolvableLocal;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.RecSolvablePolynomial;
import edu.jas.poly.TableRelation;
import edu.jas.structure.GcdRingElem;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.log4j.Logger;

public class LocalSolvablePolynomial<C extends GcdRingElem<C>>
extends GenSolvablePolynomial<SolvableLocal<C>> {
    public final LocalSolvablePolynomialRing<C> ring;
    private static final Logger logger = Logger.getLogger(LocalSolvablePolynomial.class);
    private final boolean debug = logger.isDebugEnabled();

    public LocalSolvablePolynomial(LocalSolvablePolynomialRing<C> r) {
        super(r);
        this.ring = r;
    }

    public LocalSolvablePolynomial(LocalSolvablePolynomialRing<C> r, SolvableLocal<C> c, ExpVector e) {
        this(r);
        if (c != null && !c.isZERO()) {
            this.val.put(e, c);
        }
    }

    public LocalSolvablePolynomial(LocalSolvablePolynomialRing<C> r, SolvableLocal<C> c) {
        this(r, c, r.evzero);
    }

    public LocalSolvablePolynomial(LocalSolvablePolynomialRing<C> r, GenSolvablePolynomial<SolvableLocal<C>> S) {
        this(r, S.getMap());
    }

    protected LocalSolvablePolynomial(LocalSolvablePolynomialRing<C> r, SortedMap<ExpVector, SolvableLocal<C>> v) {
        this(r);
        this.val.putAll(v);
    }

    @Override
    public LocalSolvablePolynomialRing<C> factory() {
        return this.ring;
    }

    @Override
    public LocalSolvablePolynomial<C> copy() {
        return new LocalSolvablePolynomial<C>(this.ring, this.val);
    }

    @Override
    public boolean equals(Object B) {
        if (!(B instanceof LocalSolvablePolynomial)) {
            return false;
        }
        return super.equals(B);
    }

    @Override
    public LocalSolvablePolynomial<C> multiply(LocalSolvablePolynomial<C> Bp) {
        if (Bp == null || Bp.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        if (Bp.isONE()) {
            return this;
        }
        if (this.isONE()) {
            return Bp;
        }
        assert (this.ring.nvar == Bp.ring.nvar);
        if (this.debug) {
            logger.debug((Object)("ring = " + this.ring));
        }
        ExpVector Z = this.ring.evzero;
        GenSolvablePolynomial Dp = ((LocalSolvablePolynomial)this.ring.getZERO()).copy();
        GenSolvablePolynomial zero = ((LocalSolvablePolynomial)this.ring.getZERO()).copy();
        SolvableLocal one = (SolvableLocal)this.ring.getONECoefficient();
        Object C1 = null;
        Object C2 = null;
        SortedMap A = this.val;
        SortedMap B = Bp.val;
        Set Bk = B.entrySet();
        for (Map.Entry y : A.entrySet()) {
            SolvableLocal a = (SolvableLocal)y.getValue();
            ExpVector e = (ExpVector)y.getKey();
            if (this.debug) {
                logger.info((Object)("e = " + e + ", a = " + a));
            }
            int[] ep = e.dependencyOnVariables();
            int el1 = this.ring.nvar + 1;
            if (ep.length > 0) {
                el1 = ep[0];
            }
            for (Map.Entry x : Bk) {
                SolvableLocal b = (SolvableLocal)x.getValue();
                ExpVector f = (ExpVector)x.getKey();
                if (this.debug) {
                    logger.info((Object)("f = " + f + ", b = " + b));
                }
                int[] fp = f.dependencyOnVariables();
                int fl1 = 0;
                if (fp.length > 0) {
                    fl1 = fp[fp.length - 1];
                }
                int fl1s = this.ring.nvar + 1 - fl1;
                LocalSolvablePolynomial Cps = ((LocalSolvablePolynomial)this.ring.getZERO()).copy();
                if (this.ring.polCoeff.coeffTable.isEmpty() || b.isConstant() || e.isZERO()) {
                    Cps = new LocalSolvablePolynomial(this.ring, b, e);
                    if (this.debug) {
                        logger.info((Object)("symmetric coeff: b = " + b + ", e = " + e));
                    }
                } else {
                    if (this.debug) {
                        logger.info((Object)("unsymmetric coeff: b = " + b + ", e = " + e));
                    }
                    if (b.den.isONE()) {
                        RecSolvablePolynomial rsp1 = new RecSolvablePolynomial(this.ring.polCoeff, e);
                        RecSolvablePolynomial rsp2 = new RecSolvablePolynomial(this.ring.polCoeff, b.num);
                        RecSolvablePolynomial rsp3 = rsp1.multiply(rsp2);
                        LocalSolvablePolynomial<C> rsp = this.ring.fromPolyCoefficients(rsp3);
                        Cps = rsp;
                    } else {
                        if (this.debug) {
                            logger.info((Object)("coeff-num: Cps = " + Cps + ", num = " + b.num + ", den = " + b.den));
                        }
                        LocalSolvablePolynomial qv = Cps = new LocalSolvablePolynomial<C>(this.ring, b.ring.getONE(), e);
                        SolvableLocal qden = new SolvableLocal(b.ring, b.den);
                        LocalSolvablePolynomial<LocalSolvablePolynomial<C>> v = qv.multiply(qden);
                        LocalSolvablePolynomial<C> vl = qv.multiplyLeft(qden);
                        LocalSolvablePolynomial vr = (LocalSolvablePolynomial)v.subtract(vl);
                        SolvableLocal qdeni = new SolvableLocal(b.ring, b.ring.ring.getONE(), b.den);
                        LocalSolvablePolynomial rq = vr.multiply(qdeni);
                        LocalSolvablePolynomial qp = (LocalSolvablePolynomial)qv.subtract(rq);
                        qp = qp.multiplyLeft(qdeni);
                        Cps = qp;
                        if (!b.num.isONE()) {
                            SolvableLocal qnum = new SolvableLocal(b.ring, b.num);
                            Cps = Cps.multiply(qnum);
                        }
                    }
                }
                if (this.debug) {
                    logger.info((Object)("coeff-den: Cps = " + Cps));
                }
                GenSolvablePolynomial Dps = ((LocalSolvablePolynomial)this.ring.getZERO()).copy();
                LocalSolvablePolynomial<C> Ds = null;
                if (this.ring.table.isEmpty() || Cps.isConstant() || f.isZERO()) {
                    if (this.debug) {
                        logger.info((Object)("symmetric poly: b = " + b + ", e = " + e));
                    }
                    ExpVector g = e.sum(f);
                    Ds = Cps.isConstant() ? new LocalSolvablePolynomial<C>(this.ring, (SolvableLocal)Cps.leadingBaseCoefficient(), g) : this.shift(Cps, f);
                } else {
                    if (this.debug) {
                        logger.info((Object)("unsymmetric poly: Cps = " + Cps + ", f = " + f));
                    }
                    for (Map.Entry z : Cps.val.entrySet()) {
                        int gl1s;
                        SolvableLocal c = (SolvableLocal)z.getValue();
                        ExpVector g = (ExpVector)z.getKey();
                        if (this.debug) {
                            logger.info((Object)("g = " + g + ", c = " + c));
                        }
                        int[] gp = g.dependencyOnVariables();
                        int gl1 = this.ring.nvar + 1;
                        if (gp.length > 0) {
                            gl1 = gp[0];
                        }
                        if ((gl1s = this.ring.nvar + 1 - gl1) <= fl1s) {
                            ExpVector h = g.sum(f);
                            if (this.debug) {
                                logger.info((Object)("disjoint poly: g = " + g + ", f = " + f + ", h = " + h));
                            }
                            Ds = (LocalSolvablePolynomial<C>)zero.sum(one, h);
                        } else {
                            LocalSolvablePolynomial<C> D1;
                            LocalSolvablePolynomial<C> D2;
                            ExpVector g1 = g.subst(gl1, 0L);
                            ExpVector g2 = Z.subst(gl1, g.getVal(gl1));
                            ExpVector f1 = f.subst(fl1, 0L);
                            ExpVector f2 = Z.subst(fl1, f.getVal(fl1));
                            if (this.debug) {
                                logger.info((Object)("poly, g1 = " + g1 + ", f1 = " + f1 + ", Dps = " + Dps));
                                logger.info((Object)("poly, g2 = " + g2 + ", f2 = " + f2));
                            }
                            TableRelation rel = this.ring.table.lookup(g2, f2);
                            if (this.debug) {
                                logger.info((Object)("poly, g  = " + g + ", f  = " + f + ", rel = " + rel));
                            }
                            Ds = new LocalSolvablePolynomial<C>(this.ring, rel.p);
                            if (rel.f != null) {
                                D2 = new LocalSolvablePolynomial<C>(this.ring, one, rel.f);
                                Ds = Ds.multiply(D2);
                                ExpVector g4 = rel.e == null ? g2 : g2.subtract(rel.e);
                                this.ring.table.update(g4, f2, Ds);
                            }
                            if (rel.e != null) {
                                D1 = new LocalSolvablePolynomial<C>(this.ring, one, rel.e);
                                Ds = D1.multiply(Ds);
                                this.ring.table.update(g2, f2, Ds);
                            }
                            if (!f1.isZERO()) {
                                D2 = new LocalSolvablePolynomial<C>(this.ring, one, f1);
                                Ds = Ds.multiply(D2);
                            }
                            if (!g1.isZERO()) {
                                D1 = new LocalSolvablePolynomial<C>(this.ring, one, g1);
                                Ds = D1.multiply(Ds);
                            }
                        }
                        Ds = Ds.multiplyLeft(c);
                        Dps = (LocalSolvablePolynomial)Dps.sum(Ds);
                    }
                    Ds = Dps;
                }
                Ds = Ds.multiplyLeft(a);
                if (this.debug) {
                    logger.debug((Object)("Ds = " + Ds));
                }
                Dp = (LocalSolvablePolynomial)Dp.sum(Ds);
            }
        }
        return Dp;
    }

    @Override
    public LocalSolvablePolynomial<C> multiply(LocalSolvablePolynomial<C> S, LocalSolvablePolynomial<C> T) {
        if (S.isZERO() || T.isZERO() || this.isZERO()) {
            return this.ring.getZERO();
        }
        if (S.isONE()) {
            return this.multiply(T);
        }
        if (T.isONE()) {
            return S.multiply(this);
        }
        return S.multiply(this).multiply(T);
    }

    @Override
    public LocalSolvablePolynomial<C> multiply(SolvableLocal<C> b) {
        LocalSolvablePolynomial<C> Cp = ((LocalSolvablePolynomial)this.ring.getZERO()).copy();
        if (b == null || b.isZERO()) {
            return Cp;
        }
        if (b.isONE()) {
            return this;
        }
        Cp = new LocalSolvablePolynomial<C>(this.ring, b, this.ring.evzero);
        return this.multiply(Cp);
    }

    @Override
    public LocalSolvablePolynomial<C> multiply(SolvableLocal<C> b, SolvableLocal<C> c) {
        LocalSolvablePolynomial<C> Cp = ((LocalSolvablePolynomial)this.ring.getZERO()).copy();
        if (b == null || b.isZERO()) {
            return Cp;
        }
        if (c == null || c.isZERO()) {
            return Cp;
        }
        if (b.isONE() && c.isONE()) {
            return this;
        }
        Cp = new LocalSolvablePolynomial<C>(this.ring, b, this.ring.evzero);
        LocalSolvablePolynomial<C> Dp = new LocalSolvablePolynomial<C>(this.ring, c, this.ring.evzero);
        return this.multiply(Cp, Dp);
    }

    @Override
    public LocalSolvablePolynomial<C> multiply(ExpVector e) {
        if (e == null || e.isZERO()) {
            return this;
        }
        SolvableLocal b = (SolvableLocal)this.ring.getONECoefficient();
        return this.multiply(b, e);
    }

    @Override
    public LocalSolvablePolynomial<C> multiply(ExpVector e, ExpVector f) {
        if (e == null || e.isZERO()) {
            return this;
        }
        if (f == null || f.isZERO()) {
            return this;
        }
        SolvableLocal b = (SolvableLocal)this.ring.getONECoefficient();
        return this.multiply(b, e, b, f);
    }

    @Override
    public LocalSolvablePolynomial<C> multiply(SolvableLocal<C> b, ExpVector e) {
        if (b == null || b.isZERO()) {
            return this.ring.getZERO();
        }
        if (b.isONE() && e.isZERO()) {
            return this;
        }
        LocalSolvablePolynomial<C> Cp = new LocalSolvablePolynomial<C>(this.ring, b, e);
        return this.multiply(Cp);
    }

    @Override
    public LocalSolvablePolynomial<C> multiply(SolvableLocal<C> b, ExpVector e, SolvableLocal<C> c, ExpVector f) {
        if (b == null || b.isZERO()) {
            return this.ring.getZERO();
        }
        if (c == null || c.isZERO()) {
            return this.ring.getZERO();
        }
        if (b.isONE() && e.isZERO() && c.isONE() && f.isZERO()) {
            return this;
        }
        LocalSolvablePolynomial<C> Cp = new LocalSolvablePolynomial<C>(this.ring, b, e);
        LocalSolvablePolynomial<C> Dp = new LocalSolvablePolynomial<C>(this.ring, c, f);
        return this.multiply(Cp, Dp);
    }

    @Override
    public LocalSolvablePolynomial<C> multiplyLeft(SolvableLocal<C> b, ExpVector e) {
        if (b == null || b.isZERO()) {
            return this.ring.getZERO();
        }
        LocalSolvablePolynomial<C> Cp = new LocalSolvablePolynomial<C>(this.ring, b, e);
        return Cp.multiply(this);
    }

    @Override
    public LocalSolvablePolynomial<C> multiplyLeft(ExpVector e) {
        if (e == null || e.isZERO()) {
            return this;
        }
        SolvableLocal b = (SolvableLocal)this.ring.getONECoefficient();
        LocalSolvablePolynomial<C> Cp = new LocalSolvablePolynomial<C>(this.ring, b, e);
        return Cp.multiply(this);
    }

    @Override
    public LocalSolvablePolynomial<C> multiplyLeft(SolvableLocal<C> b) {
        GenSolvablePolynomial Cp = ((LocalSolvablePolynomial)this.ring.getZERO()).copy();
        if (b == null || b.isZERO()) {
            return Cp;
        }
        SortedMap Cm = ((LocalSolvablePolynomial)Cp).val;
        SortedMap Am = this.val;
        for (Map.Entry y : Am.entrySet()) {
            ExpVector e = (ExpVector)y.getKey();
            SolvableLocal a = (SolvableLocal)y.getValue();
            SolvableLocal<SolvableLocal> c = b.multiply(a);
            if (c.isZERO()) continue;
            Cm.put(e, c);
        }
        return Cp;
    }

    @Override
    public LocalSolvablePolynomial<C> multiplyLeft(Map.Entry<ExpVector, SolvableLocal<C>> m) {
        if (m == null) {
            return this.ring.getZERO();
        }
        return this.multiplyLeft(m.getValue(), m.getKey());
    }

    @Override
    public LocalSolvablePolynomial<C> multiply(Map.Entry<ExpVector, SolvableLocal<C>> m) {
        if (m == null) {
            return this.ring.getZERO();
        }
        return this.multiply(m.getValue(), m.getKey());
    }

    protected LocalSolvablePolynomial<C> shift(LocalSolvablePolynomial<C> B, ExpVector f) {
        GenSolvablePolynomial C = ((LocalSolvablePolynomial)this.ring.getZERO()).copy();
        if (B == null || B.isZERO()) {
            return C;
        }
        if (f == null || f.isZERO()) {
            return B;
        }
        SortedMap Cm = ((LocalSolvablePolynomial)C).val;
        SortedMap Bm = B.val;
        for (Map.Entry y : Bm.entrySet()) {
            ExpVector e = (ExpVector)y.getKey();
            SolvableLocal a = (SolvableLocal)y.getValue();
            ExpVector d = e.sum(f);
            if (a.isZERO()) continue;
            Cm.put(d, a);
        }
        return C;
    }
}

