/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.LocalRing;
import edu.jas.kern.PrettyPrint;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.QuotPair;
import edu.jas.structure.RingElem;
import org.apache.log4j.Logger;

public class Local<C extends GcdRingElem<C>>
implements RingElem<Local<C>>,
QuotPair<GenPolynomial<C>> {
    private static final Logger logger = Logger.getLogger(Local.class);
    private final boolean debug = logger.isDebugEnabled();
    public final LocalRing<C> ring;
    protected final GenPolynomial<C> num;
    protected final GenPolynomial<C> den;
    protected int isunit = -1;

    public Local(LocalRing<C> r) {
        this(r, (GenPolynomial<C>)r.ring.getZERO());
    }

    public Local(LocalRing<C> r, GenPolynomial<C> n) {
        this(r, n, (GenPolynomial<C>)r.ring.getONE(), true);
    }

    public Local(LocalRing<C> r, GenPolynomial<C> n, GenPolynomial<C> d) {
        this(r, n, d, false);
    }

    protected Local(LocalRing<C> r, GenPolynomial<C> n, GenPolynomial<C> d, boolean isred) {
        if (d == null || ((GenPolynomial)d).isZERO()) {
            throw new IllegalArgumentException("denominator may not be zero");
        }
        this.ring = r;
        if (((GenPolynomial)d).signum() < 0) {
            n = ((GenPolynomial)n).negate();
            d = ((GenPolynomial)d).negate();
        }
        if (isred) {
            this.num = n;
            this.den = d;
            return;
        }
        GenPolynomial p = this.ring.ideal.normalform((GenPolynomial<GenPolynomial<C>>)d);
        if (p == null || p.isZERO()) {
            throw new IllegalArgumentException("denominator may not be in ideal");
        }
        GcdRingElem lc = (GcdRingElem)((GenPolynomial)d).leadingBaseCoefficient();
        if (!lc.isONE() && lc.isUnit()) {
            lc = (GcdRingElem)lc.inverse();
            n = ((GenPolynomial)n).multiply((GenPolynomial<GcdRingElem>)((Object)lc));
            d = ((GenPolynomial)d).multiply((GenPolynomial<GcdRingElem>)((Object)lc));
        }
        if (((GenPolynomial)n).compareTo((GenPolynomial<GenPolynomial<GcdRingElem>>)d) == 0) {
            this.num = this.ring.ring.getONE();
            this.den = this.ring.ring.getONE();
            return;
        }
        if (((GenPolynomial)((GenPolynomial)n).negate()).compareTo(d) == 0) {
            this.num = ((GenPolynomial)this.ring.ring.getONE()).negate();
            this.den = this.ring.ring.getONE();
            return;
        }
        if (((GenPolynomial)n).isZERO()) {
            this.num = n;
            this.den = this.ring.ring.getONE();
            return;
        }
        GenPolynomial<GenPolynomial<C>> gcd = this.ring.engine.gcd((GenPolynomial<GenPolynomial<GcdRingElem>>)n, (GenPolynomial<GenPolynomial<GcdRingElem>>)d);
        if (this.debug) {
            logger.info((Object)("gcd = " + gcd));
        }
        if (gcd.isONE()) {
            this.num = n;
            this.den = d;
        } else {
            this.num = ((GenPolynomial)n).divide(gcd);
            this.den = ((GenPolynomial)d).divide(gcd);
        }
    }

    @Override
    public LocalRing<C> factory() {
        return this.ring;
    }

    @Override
    public GenPolynomial<C> numerator() {
        return this.num;
    }

    @Override
    public GenPolynomial<C> denominator() {
        return this.den;
    }

    @Override
    public Local<C> copy() {
        return new Local<C>(this.ring, this.num, this.den, true);
    }

    @Override
    public boolean isZERO() {
        return this.num.isZERO();
    }

    @Override
    public boolean isONE() {
        return this.num.equals(this.den);
    }

    @Override
    public boolean isUnit() {
        if (this.isunit > 0) {
            return true;
        }
        if (this.isunit == 0) {
            return false;
        }
        if (this.num.isZERO()) {
            this.isunit = 0;
            return false;
        }
        GenPolynomial p = this.ring.ideal.normalform(this.num);
        boolean u = p != null && !p.isZERO();
        this.isunit = u ? 1 : 0;
        return u;
    }

    @Override
    public boolean isConstant() {
        return this.num.isConstant() && this.den.isConstant();
    }

    public String toString() {
        if (PrettyPrint.isTrue()) {
            String s = "{ " + this.num.toString(this.ring.ring.getVars());
            if (this.den.isONE()) {
                return s + " }";
            }
            return s + "| " + this.den.toString(this.ring.ring.getVars()) + " }";
        }
        return "Local[ " + this.num.toString() + " | " + this.den.toString() + " ]";
    }

    @Override
    public String toScript() {
        if (this.den.isONE()) {
            return this.num.toScript();
        }
        return this.num.toScript() + " / " + this.den.toScript();
    }

    @Override
    public String toScriptFactory() {
        return ((LocalRing)this.factory()).toScript();
    }

    @Override
    public int compareTo(Local<C> b) {
        int s2;
        if (b == null || b.isZERO()) {
            return this.signum();
        }
        if (this.isZERO()) {
            return -b.signum();
        }
        int s1 = this.num.signum();
        int t = (s1 - (s2 = b.num.signum())) / 2;
        if (t != 0) {
            System.out.println("compareTo: t = " + t);
            return t;
        }
        if (this.den.compareTo(b.den) == 0) {
            return this.num.compareTo(b.num);
        }
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> r = this.num.multiply(b.den);
        GenPolynomial<GenPolynomial<C>> s = this.den.multiply(b.num);
        return r.compareTo((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)s);
    }

    @Override
    public boolean equals(Object b) {
        if (!(b instanceof Local)) {
            return false;
        }
        Local a = null;
        try {
            a = (Local)b;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (a == null) {
            return false;
        }
        return this.compareTo(a) == 0;
    }

    @Override
    public int hashCode() {
        int h = this.ring.hashCode();
        h = 37 * h + this.num.hashCode();
        h = 37 * h + this.den.hashCode();
        return h;
    }

    @Override
    public Local<C> abs() {
        return new Local<C>(this.ring, this.num.abs(), this.den, true);
    }

    @Override
    public Local<C> sum(Local<C> S) {
        if (S == null || S.isZERO()) {
            return this;
        }
        GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>> n = this.num.multiply(S.den);
        n = n.sum((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)this.den.multiply(S.num));
        GenPolynomial<GenPolynomial<C>> d = this.den.multiply(S.den);
        return new Local<GenPolynomial<C>>(this.ring, n, d, false);
    }

    @Override
    public Local<C> negate() {
        return new Local<C>(this.ring, this.num.negate(), this.den, true);
    }

    @Override
    public int signum() {
        return this.num.signum();
    }

    @Override
    public Local<C> subtract(Local<C> S) {
        if (S == null || S.isZERO()) {
            return this;
        }
        GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>> n = this.num.multiply(S.den);
        n = n.subtract((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)this.den.multiply(S.num));
        GenPolynomial<GenPolynomial<C>> d = this.den.multiply(S.den);
        return new Local<GenPolynomial<C>>(this.ring, n, d, false);
    }

    @Override
    public Local<C> divide(Local<C> S) {
        return this.multiply((C)S.inverse());
    }

    @Override
    public Local<C> inverse() {
        if (this.isONE()) {
            return this;
        }
        if (this.isUnit()) {
            return new Local<C>(this.ring, this.den, this.num, true);
        }
        throw new ArithmeticException("element not invertible " + this);
    }

    @Override
    public Local<C> remainder(Local<C> S) {
        if (S.isUnit()) {
            return this.ring.getZERO();
        }
        throw new UnsupportedOperationException("remainder not implemented" + S);
    }

    @Override
    public Local<C> multiply(Local<C> S) {
        if (S == null || S.isZERO()) {
            return S;
        }
        if (this.num.isZERO()) {
            return this;
        }
        if (S.isONE()) {
            return this;
        }
        if (this.isONE()) {
            return S;
        }
        GenPolynomial<GenPolynomial<C>> n = this.num.multiply(S.num);
        GenPolynomial<GenPolynomial<C>> d = this.den.multiply(S.den);
        return new Local<GenPolynomial<C>>(this.ring, n, d, false);
    }

    @Override
    public Local<C> multiply(GenPolynomial<C> b) {
        if (b == null || b.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.num.isZERO()) {
            return this;
        }
        if (b.isONE()) {
            return this;
        }
        GenPolynomial<GenPolynomial<C>> n = this.num.multiply(b);
        return new Local<GenPolynomial<C>>(this.ring, n, this.den, false);
    }

    @Override
    public Local<C> multiply(C b) {
        if (b == null || b.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.num.isZERO()) {
            return this;
        }
        if (b.isONE()) {
            return this;
        }
        GenPolynomial<C> n = this.num.multiply(b);
        return new Local<C>(this.ring, n, this.den, false);
    }

    @Override
    public Local<C> multiply(ExpVector e) {
        if (e == null || e.isZERO()) {
            return this;
        }
        if (this.num.isZERO()) {
            return this;
        }
        GenPolynomial<C> n = this.num.multiply(e);
        return new Local<C>(this.ring, n, this.den, false);
    }

    public Local<C> monic() {
        if (this.num.isZERO()) {
            return this;
        }
        return this;
    }

    @Override
    public Local<C> gcd(Local<C> b) {
        GenPolynomial x = this.ring.engine.gcd(this.num, b.num);
        GenPolynomial y = this.ring.engine.gcd(this.den, b.den);
        return new Local<C>(this.ring, x, y, true);
    }

    public Local<C>[] egcd(Local<C> b) {
        throw new UnsupportedOperationException("egcd not implemented " + this.getClass().getName());
    }
}

