/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.ColorPolynomial;
import edu.jas.application.ColoredSystem;
import edu.jas.application.Condition;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.OrderedPolynomialList;
import edu.jas.poly.PolynomialList;
import edu.jas.structure.GcdRingElem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class GroebnerSystem<C extends GcdRingElem<C>> {
    private static final Logger logger = Logger.getLogger(GroebnerSystem.class);
    private final boolean debug = logger.isDebugEnabled();
    public final List<ColoredSystem<C>> list;
    protected List<Condition<C>> conds;
    protected PolynomialList<GenPolynomial<C>> cgb;

    public GroebnerSystem(List<ColoredSystem<C>> S) {
        this.list = S;
        this.conds = null;
        this.cgb = null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("GroebnerSystem: \n");
        boolean first = true;
        for (ColoredSystem<C> coloredSystem : this.list) {
            if (first) {
                first = false;
            } else {
                sb.append("\n");
            }
            sb.append(coloredSystem.toString());
        }
        sb.append("Conditions:\n");
        first = true;
        for (Condition condition : this.getConditions()) {
            if (first) {
                first = false;
            } else {
                sb.append("\n");
            }
            sb.append(condition.toString());
        }
        sb.append("\n");
        if (this.cgb == null) {
            sb.append("Comprehensive Groebner Base not jet computed\n");
        } else {
            sb.append("Comprehensive Groebner Base:\n");
            first = true;
            for (GenPolynomial genPolynomial : this.getCGB()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",\n");
                }
                sb.append(genPolynomial.toString());
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public boolean equals(Object c) {
        GroebnerSystem cs = null;
        try {
            cs = (GroebnerSystem)c;
        }
        catch (ClassCastException e) {
            return false;
        }
        if (cs == null) {
            return false;
        }
        boolean t = this.list.equals(cs.list);
        return t;
    }

    public int hashCode() {
        int h = this.list.hashCode();
        return h;
    }

    public boolean checkInvariant() {
        for (ColoredSystem<C> s : this.list) {
            if (s.checkInvariant()) continue;
            return false;
        }
        return true;
    }

    public boolean isDetermined() {
        for (ColoredSystem<C> s : this.list) {
            if (s.isDetermined()) continue;
            return false;
        }
        return true;
    }

    public List<Condition<C>> getConditions() {
        if (this.conds != null) {
            return this.conds;
        }
        ArrayList<Condition<C>> cd = new ArrayList<Condition<C>>(this.list.size());
        for (ColoredSystem<C> cs : this.list) {
            cd.add(cs.condition);
        }
        this.conds = cd;
        return this.conds;
    }

    public List<GenPolynomial<GenPolynomial<C>>> getCGB() {
        if (this.cgb != null) {
            return this.cgb.list;
        }
        List<Condition<C>> unused = this.getConditions();
        if (unused.isEmpty()) {
            logger.info((Object)"unused is empty");
        }
        HashSet Gs = new HashSet();
        for (ColoredSystem<C> cs : this.list) {
            if (this.debug) {
                if (!cs.isDetermined()) {
                    System.out.println("not determined, cs = " + cs);
                }
                if (!cs.checkInvariant()) {
                    System.out.println("not invariant, cs = " + cs);
                }
            }
            for (ColorPolynomial p : cs.list) {
                GenPolynomial f = p.getPolynomial();
                Gs.add(f);
            }
        }
        ArrayList<GenPolynomial<GenPolynomial<C>>> G = new ArrayList<GenPolynomial<GenPolynomial<C>>>(Gs);
        GenPolynomialRing ring = null;
        if (G.size() > 0) {
            ring = ((GenPolynomial)G.get((int)0)).ring;
        }
        this.cgb = new OrderedPolynomialList<GenPolynomial<C>>(ring, G);
        return G;
    }
}

