/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.FactorFactory;
import edu.jas.application.PolyUtilApp;
import edu.jas.application.RealAlgebraicNumber;
import edu.jas.application.RealAlgebraicRing;
import edu.jas.arith.Rational;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.GcdRingElem;
import edu.jas.ufd.FactorAbstract;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class FactorRealReal<C extends GcdRingElem<C> & Rational>
extends FactorAbstract<RealAlgebraicNumber<C>> {
    private static final Logger logger = Logger.getLogger(FactorRealReal.class);
    private final boolean debug = logger.isInfoEnabled();
    public final FactorAbstract<edu.jas.root.RealAlgebraicNumber<C>> factorAlgebraic;

    protected FactorRealReal() {
        throw new IllegalArgumentException("don't use this constructor");
    }

    public FactorRealReal(RealAlgebraicRing<C> fac) {
        this(fac, FactorFactory.getImplementation(fac.realRing));
    }

    public FactorRealReal(RealAlgebraicRing<C> fac, FactorAbstract<edu.jas.root.RealAlgebraicNumber<C>> factorAlgebraic) {
        super(fac);
        this.factorAlgebraic = factorAlgebraic;
    }

    @Override
    public List<GenPolynomial<RealAlgebraicNumber<C>>> baseFactorsSquarefree(GenPolynomial<RealAlgebraicNumber<C>> P) {
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        ArrayList<GenPolynomial<RealAlgebraicNumber<C>>> factors = new ArrayList<GenPolynomial<RealAlgebraicNumber<C>>>();
        if (P.isZERO()) {
            return factors;
        }
        if (P.isONE()) {
            factors.add(P);
            return factors;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException("only for univariate polynomials");
        }
        RealAlgebraicRing rere = (RealAlgebraicRing)pfac.coFac;
        edu.jas.root.RealAlgebraicRing rfac = rere.realRing;
        RealAlgebraicNumber<C> ldcf = P.leadingBaseCoefficient();
        if (!ldcf.isONE()) {
            P = P.monic();
            factors.add(((GenPolynomial)pfac.getONE()).multiply(ldcf));
        }
        GenPolynomialRing arfac = new GenPolynomialRing(rfac, pfac);
        GenPolynomial A = PolyUtilApp.realAlgFromRealCoefficients(arfac, P);
        List afactors = this.factorAlgebraic.baseFactorsSquarefree(A);
        for (GenPolynomial a : afactors) {
            GenPolynomial p = PolyUtilApp.realFromRealAlgCoefficients(pfac, a);
            factors.add(p);
        }
        if (this.debug) {
            logger.info((Object)("rafactors = " + factors));
        }
        return factors;
    }
}

