/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.ColorPolynomial;
import edu.jas.application.ColoredSystem;
import edu.jas.application.Condition;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CReductionSeq<C extends GcdRingElem<C>>
implements Serializable {
    private static final Logger logger = Logger.getLogger(CReductionSeq.class);
    private final boolean info = logger.isInfoEnabled();
    protected final GreatestCommonDivisor<C> engine;
    protected final RingFactory<C> cofac;
    protected boolean top = true;

    public CReductionSeq(RingFactory<C> rf) {
        this.cofac = rf;
        this.engine = GCDFactory.getImplementation(this.cofac);
    }

    public ColorPolynomial<C> SPolynomial(ColorPolynomial<C> Ap, ColorPolynomial<C> Bp) {
        GenPolynomial<C> b;
        if (Bp == null || Bp.isZERO()) {
            return Bp;
        }
        if (Ap == null || Ap.isZERO()) {
            return Ap;
        }
        Map.Entry ma = Ap.red.leadingMonomial();
        Map.Entry mb = Bp.red.leadingMonomial();
        ExpVector e = ma.getKey();
        ExpVector f = mb.getKey();
        ExpVector g = e.lcm(f);
        ExpVector e1 = g.subtract(e);
        ExpVector f1 = g.subtract(f);
        GenPolynomial<C> a = ma.getValue();
        GenPolynomial<C> c = this.engine.gcd(a, b = mb.getValue());
        if (!c.isONE()) {
            a = a.divide(c);
            b = b.divide(c);
        }
        ColorPolynomial<C> App = Ap.multiply(b, e1);
        ColorPolynomial<C> Bpp = Bp.multiply(a, f1);
        ColorPolynomial<C> Cp = App.subtract(Bpp);
        return Cp;
    }

    public boolean isTopReducible(List<ColorPolynomial<C>> P, ColorPolynomial<C> A) {
        if (P == null || P.isEmpty()) {
            return false;
        }
        if (A == null || A.isZERO()) {
            return false;
        }
        boolean mt = false;
        ExpVector e = A.leadingExpVector();
        for (ColorPolynomial<C> p : P) {
            if (p == null) {
                return false;
            }
            ExpVector f = p.leadingExpVector();
            if (f == null) {
                return false;
            }
            if (e == null) {
                return false;
            }
            mt = e.multipleOf(f);
            if (!mt) continue;
            return true;
        }
        return false;
    }

    public boolean isReducible(List<ColorPolynomial<C>> Pp, ColorPolynomial<C> Ap) {
        return !this.isNormalform(Pp, Ap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNormalform(List<ColorPolynomial<C>> Pp, ColorPolynomial<C> Ap) {
        int i;
        ColorPolynomial[] P;
        int l;
        if (Pp == null || Pp.isEmpty()) {
            return true;
        }
        if (Ap == null || Ap.isZERO()) {
            return true;
        }
        List<ColorPolynomial<C>> list = Pp;
        synchronized (list) {
            l = Pp.size();
            P = new ColorPolynomial[l];
            for (int i2 = 0; i2 < Pp.size(); ++i2) {
                P[i2] = Pp.get(i2);
            }
        }
        ExpVector[] htl = new ExpVector[l];
        ColorPolynomial[] p = new ColorPolynomial[l];
        int j = 0;
        for (i = 0; i < l; ++i) {
            p[i] = P[i];
            Map.Entry m = p[i].red.leadingMonomial();
            if (m == null) continue;
            p[j] = p[i];
            htl[j] = m.getKey();
            ++j;
        }
        l = j;
        boolean mt = false;
        for (ExpVector e : Ap.red.getMap().keySet()) {
            for (i = 0; i < l; ++i) {
                mt = e.multipleOf(htl[i]);
                if (!mt) continue;
                System.out.println("not normalform " + Ap + ", P[i] = " + P[i]);
                return false;
            }
            if (!this.top) continue;
            return true;
        }
        for (ExpVector e : Ap.white.getMap().keySet()) {
            for (i = 0; i < l; ++i) {
                mt = e.multipleOf(htl[i]);
                if (!mt) continue;
                System.out.println("not normalform " + Ap + ", P[i] = " + P[i]);
                return false;
            }
            if (!this.top) continue;
            return true;
        }
        return true;
    }

    public boolean isNormalform(List<ColorPolynomial<C>> Pp) {
        if (Pp == null || Pp.isEmpty()) {
            return true;
        }
        LinkedList<ColorPolynomial<C>> P = new LinkedList<ColorPolynomial<C>>(Pp);
        int s = P.size();
        for (int i = 0; i < s; ++i) {
            ColorPolynomial Ap = (ColorPolynomial)P.remove(i);
            if (!this.isNormalform(P, Ap)) {
                return false;
            }
            P.add(Ap);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColorPolynomial<C> normalform(Condition<C> cond, List<ColorPolynomial<C>> Pp, ColorPolynomial<C> Ap) {
        Map.Entry m;
        int i;
        ColorPolynomial[] P;
        int l;
        if (Pp == null || Pp.isEmpty()) {
            return Ap;
        }
        if (Ap == null || Ap.isZERO()) {
            return Ap;
        }
        List<ColorPolynomial<C>> list = Pp;
        synchronized (list) {
            l = Pp.size();
            P = new ColorPolynomial[l];
            for (int i2 = 0; i2 < Pp.size(); ++i2) {
                P[i2] = Pp.get(i2);
            }
        }
        ExpVector[] htl = new ExpVector[l];
        Object[] lbc = new Object[l];
        ColorPolynomial[] p = new ColorPolynomial[l];
        int j = 0;
        for (i = 0; i < l; ++i) {
            if (P[i] == null) continue;
            p[i] = P[i];
            m = p[i].red.leadingMonomial();
            if (m == null) continue;
            p[j] = p[i];
            htl[j] = m.getKey();
            lbc[j] = m.getValue();
            ++j;
        }
        l = j;
        boolean mt = false;
        AbelianGroupElem zero = p[0].red.ring.getZERO();
        ColorPolynomial<C> R = new ColorPolynomial<C>(zero, zero, zero);
        ColorPolynomial Q = null;
        ColorPolynomial S = Ap;
        while (S.length() > 0) {
            m = S.leadingMonomial();
            ExpVector e = m.getKey();
            GenPolynomial<C> a = m.getValue();
            Condition.Color col = cond.color(a);
            if (col == Condition.Color.GREEN) {
                GenPolynomial g = S.green.sum(a, e);
                GenPolynomial<GenPolynomial<GenPolynomial<C>>> r = S.red;
                GenPolynomial<GenPolynomial<GenPolynomial<C>>> w = S.white;
                if (S.red.isZERO()) {
                    w = w.subtract(a, e);
                } else {
                    logger.info((Object)("green_red = " + ((GenPolynomial)zero).sum(a, e)));
                    r = r.subtract(a, e);
                }
                S = new ColorPolynomial(g, r, w);
                continue;
            }
            for (i = 0; i < l && !(mt = e.multipleOf(htl[i])); ++i) {
            }
            if (!mt) {
                if (this.top) {
                    return S;
                }
                R = R.sum(a, e);
                S = S.subtract(a, e);
                continue;
            }
            e = e.subtract(htl[i]);
            GenPolynomial<C> c = (GenPolynomial<C>)lbc[i];
            GenPolynomial<C> g = this.engine.gcd(a, c);
            if (!g.isONE()) {
                a = a.divide(g);
                c = c.divide(g);
            }
            S = S.multiply(c);
            R = R.multiply(c);
            Q = p[i].multiply(a, e);
            S = S.subtract(Q);
        }
        return R;
    }

    public List<Condition<C>> caseDistinction(List<GenPolynomial<GenPolynomial<C>>> L) {
        List<Condition<C>> cd = new ArrayList<Condition<C>>();
        if (L == null || L.size() == 0) {
            return cd;
        }
        for (GenPolynomial<GenPolynomial<C>> A : L) {
            if (A == null || A.isZERO()) continue;
            cd = this.caseDistinction(cd, A);
        }
        return cd;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public List<Condition<C>> caseDistinction(List<Condition<C>> cd, GenPolynomial<GenPolynomial<C>> A) {
        if (A == null || A.isZERO()) {
            return cd;
        }
        if (cd == null) {
            cd = new ArrayList<Condition<C>>();
        }
        if (cd.size() == 0) {
            RingFactory ringFactory = A.ring.coFac;
            GenPolynomialRing cfac = (GenPolynomialRing)ringFactory;
            Condition sc = new Condition(cfac);
            cd.add(sc);
        }
        ArrayList<Condition<C>> C = new ArrayList<Condition<C>>();
        Iterator<Condition<C>> i$ = cd.iterator();
        while (i$.hasNext()) {
            void var3_6;
            Condition<C> cond;
            Condition<C> cz = cond = i$.next();
            GenPolynomial<GenPolynomial<C>> genPolynomial = A;
            block5: while (!var3_6.isZERO()) {
                GenPolynomial Bp;
                GenPolynomial c;
                block14: {
                    c = (GenPolynomial)var3_6.leadingBaseCoefficient();
                    Bp = var3_6.reductum();
                    switch (cz.color(c)) {
                        case GREEN: {
                            GenPolynomial genPolynomial2 = Bp;
                            continue block5;
                        }
                        case RED: {
                            C.add(cz);
                            AbelianGroupElem abelianGroupElem = A.ring.getZERO();
                            continue block5;
                        }
                    }
                    Condition<C> nc = cz.extendNonZero(c);
                    if (nc != null) {
                        if (!cz.equals(nc)) {
                            C.add(nc);
                            break block14;
                        } else {
                            cz = null;
                            AbelianGroupElem abelianGroupElem = A.ring.getZERO();
                            continue;
                        }
                    }
                    System.out.println("this should not be printed " + c);
                }
                Condition<C> ez = cz.extendZero(c);
                if (ez != null) {
                    cz = ez;
                    GenPolynomial genPolynomial3 = Bp;
                    continue;
                }
                cz = null;
                AbelianGroupElem abelianGroupElem = A.ring.getZERO();
            }
            if (cz == null || cz.isContradictory() || C.contains(cz)) continue;
            C.add(cz);
        }
        return C;
    }

    public List<Condition<C>> caseDistinction(Condition<C> cond, GenPolynomial<GenPolynomial<C>> A) {
        List<Condition<C>> cd = new ArrayList<Condition<C>>();
        if (A == null || A.isZERO()) {
            return cd;
        }
        cd.add(cond);
        cd = this.caseDistinction(cd, A);
        if (this.info) {
            StringBuffer s = new StringBuffer("extending condition: " + cond + "\n");
            s.append("case distinctions: [ \n");
            for (Condition<C> c : cd) {
                s.append(c.toString() + "\n");
            }
            s.append("]");
            logger.info((Object)s.toString());
        }
        return cd;
    }

    public List<ColoredSystem<C>> determine(List<GenPolynomial<GenPolynomial<C>>> H) {
        if (H == null || H.size() == 0) {
            ArrayList<ColoredSystem<C>> CS = new ArrayList<ColoredSystem<C>>();
            return CS;
        }
        Collections.reverse(H);
        List<Condition<C>> cd = this.caseDistinction(H);
        return this.determine(cd, H);
    }

    public List<ColoredSystem<C>> determine(List<Condition<C>> cd, List<GenPolynomial<GenPolynomial<C>>> H) {
        ArrayList<ColoredSystem<C>> CS = new ArrayList<ColoredSystem<C>>();
        if (H == null || H.size() == 0) {
            return CS;
        }
        for (Condition<C> cond : cd) {
            logger.info((Object)("determine wrt cond = " + cond));
            if (cond.zero.isONE()) {
                System.out.println("ideal is one = " + cond.zero);
            }
            List<ColorPolynomial<C>> S = cond.determine(H);
            ColoredSystem<C> cs = new ColoredSystem<C>(cond, S);
            CS.add(cs);
        }
        return CS;
    }
}

