/*
 * Decompiled with CFR 0.152.
 */
package jplot3dp;

import graph.RTextLine;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import javax.imageio.ImageIO;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.Timer;
import javax.swing.event.MouseInputAdapter;
import jplot.Translate;
import jplot3dp.MathParser.MathParser;
import jplot3dp.Printable;
import jplot3dp.Utils;
import jplot3dp.Vec;
import org.freehep.graphics2d.VectorGraphics;

public class ModelView
extends JPanel
implements Printable {
    private static final long serialVersionUID = 1L;
    String title = "";
    private Vec eyePosition;
    private Vec eyeDirection;
    private Vec up;
    private Vec screenUp;
    private Vec screenRight;
    private final double screenDistance = 1.0;
    private double fov = 90.0;
    private double scale;
    public int backCulling = 1;
    public Color bgColor;
    public boolean fogEnabled = true;
    public double fogStart = 0.0;
    public double fogEnd = 5.0;
    public boolean bShowAxes = true;
    private MathParser mathParser;
    private Timer timer;
    private KeyBoard keyBoard;
    public FunctionsList functions;
    public AxesDefinition axesDefinition;
    private JPopupMenu menu;
    public JMenuItem item1;
    public JMenuItem item2;
    public JMenuItem item3;
    public JMenuItem item4;
    public JMenuItem item5;
    public JMenuItem item6;
    public JMenuItem item7;
    public String[] as = new String[]{"X", "Z", "Y"};
    private double posd;
    private boolean showArrows = true;
    private Font labelFont = new Font("SansSerif", 1, 16);
    private Color labelColor = Color.black;
    private Font valueFont = new Font("SansSerif", 1, 14);

    @Override
    public void writeToStream(DataOutputStream dataoutputstream) throws IOException {
        dataoutputstream.writeUTF(this.title);
        this.eyePosition.writeToStream(dataoutputstream);
        this.eyeDirection.writeToStream(dataoutputstream);
        this.up.writeToStream(dataoutputstream);
        this.screenUp.writeToStream(dataoutputstream);
        this.screenRight.writeToStream(dataoutputstream);
        dataoutputstream.writeDouble(this.getFov());
        dataoutputstream.writeInt(this.backCulling);
        Utils.writeColor(dataoutputstream, this.bgColor);
        dataoutputstream.writeBoolean(this.fogEnabled);
        dataoutputstream.writeDouble(this.fogStart);
        dataoutputstream.writeDouble(this.fogEnd);
        this.functions.writeToStream(dataoutputstream);
        dataoutputstream.writeBoolean(this.bShowAxes);
        this.axesDefinition.writeToStream(dataoutputstream);
    }

    @Override
    public void readFromStream(DataInputStream datainputstream) throws IOException {
        this.title = datainputstream.readUTF();
        this.eyePosition.readFromStream(datainputstream);
        this.eyeDirection.readFromStream(datainputstream);
        this.up.readFromStream(datainputstream);
        this.screenUp.readFromStream(datainputstream);
        this.screenRight.readFromStream(datainputstream);
        this.setFov(datainputstream.readDouble());
        this.backCulling = datainputstream.readInt();
        this.bgColor = Utils.readColor(datainputstream);
        this.fogEnabled = datainputstream.readBoolean();
        this.fogStart = datainputstream.readDouble();
        this.fogEnd = datainputstream.readDouble();
        this.functions.readFromStream(datainputstream);
        this.bShowAxes = datainputstream.readBoolean();
        this.axesDefinition.readFromStream(datainputstream);
    }

    public void reInitializeVars() {
        this.title = "";
        this.eyePosition = new Vec(0.0, 1.0, -1.5);
        this.eyeDirection = new Vec(0.0, -1.0, 1.5).normalize();
        this.up = new Vec(0.0, 1.0, 0.0);
        this.recalcUpRight();
        this.fov = 90.0;
        this.recalcScale();
        this.backCulling = 1;
        this.bgColor = Color.white;
        this.fogEnabled = true;
        this.fogStart = 0.0;
        this.fogEnd = 5.0;
        this.functions.clear();
        this.bShowAxes = true;
    }

    public void setRangeX(double min, double max) {
        this.axesDefinition.min[0] = min;
        this.axesDefinition.max[0] = max;
    }

    public void setShowAxes(boolean x, boolean y, boolean z) {
        this.axesDefinition.shown[0] = x;
        this.axesDefinition.shown[1] = y;
        this.axesDefinition.shown[2] = z;
    }

    public void setRangeY(double min, double max) {
        this.axesDefinition.min[1] = min;
        this.axesDefinition.max[1] = max;
    }

    public void setEyePosition(double x, double y, double z) {
        this.eyePosition = new Vec(x, y, z);
        this.eyeDirection = new Vec(0.0, -1.0, 1.5).normalize();
    }

    public double[] getEyePosition() {
        double[] va = new double[]{this.eyePosition.x, this.eyePosition.y, this.eyePosition.z};
        return va;
    }

    public void setRangeZ(double min, double max) {
        this.axesDefinition.min[2] = min;
        this.axesDefinition.max[2] = max;
    }

    public void setNameX(String name) {
        this.as[0] = name;
    }

    public void setNameY(String name) {
        this.as[1] = name;
    }

    public void setNameZ(String name) {
        this.as[2] = name;
    }

    public void setLabelFont(Font name) {
        this.labelFont = name;
    }

    public void setLabelColor(Color color) {
        this.labelColor = color;
    }

    public void setValueFont(Font name) {
        this.valueFont = name;
    }

    public void setBackgroundFrame(Color c) {
        this.bgColor = c;
    }

    public void setAxesColor(Color c) {
        this.axesDefinition.color = c;
    }

    public void setFog(boolean fogEnabled) {
        this.fogEnabled = fogEnabled;
    }

    public void setAxisArrows(boolean showArrows) {
        this.showArrows = showArrows;
    }

    public void setAxes(boolean bShowAxes) {
        this.bShowAxes = bShowAxes;
    }

    public double getFov() {
        return this.fov;
    }

    public void setFov(double d) {
        this.fov = d;
        this.recalcScale();
    }

    private void recalcScale() {
        Dimension dimension = this.getSize();
        double d = Math.sqrt(dimension.height * dimension.height + dimension.width * dimension.width);
        this.scale = d / (2.0 * Math.tan(this.fov * Math.PI / 180.0 / 2.0) * 1.0);
    }

    public ModelView() {
        this.eyePosition = new Vec(0.0, 1.0, -1.5);
        this.eyeDirection = new Vec(0.0, -1.0, 1.5).normalize();
        this.up = new Vec(0.0, 1.0, 0.0);
        this.bgColor = Color.white;
        this.mathParser = new MathParser();
        this.keyBoard = new KeyBoard();
        this.functions = new FunctionsList();
        this.axesDefinition = new AxesDefinition();
        this.reInitializeVars();
        this.menu = new JPopupMenu();
        this.item1 = new JMenuItem("Edit");
        this.item2 = new JMenuItem("TogAxis");
        this.item3 = new JMenuItem("TogFill");
        this.item4 = new JMenuItem("Refresh");
        this.item5 = new JMenuItem("Save");
        this.item6 = new JMenuItem("Open");
        this.item7 = new JMenuItem("Help");
        this.menu.add(this.item1);
        this.menu.add(this.item2);
        this.menu.add(this.item3);
        this.menu.add(this.item4);
        this.menu.add(this.item5);
        this.menu.add(this.item7);
        this.addMouseListener(new PopupListener());
        this.setPreferredSize(new Dimension(320, 240));
        OnMouse onmouse = new OnMouse();
        this.addMouseListener(onmouse);
        this.addMouseMotionListener(onmouse);
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mousewheelevent) {
                ModelView.this.keyBoard.velForward = (double)mousewheelevent.getWheelRotation() * 0.5;
                ModelView.this.timer.start();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentevent) {
                ModelView.this.recalcScale();
            }
        });
        this.addKeyListener(new OnKey());
        this.recalcUpRight();
        this.timer = new Timer(50, new TimerListener());
    }

    private void recalcUpRight() {
        this.screenUp = new Vec(this.up);
        this.screenUp = this.screenUp.substract(this.eyeDirection.scalarMult(this.eyeDirection.dotProduct(this.up)));
        this.screenUp = this.screenUp.normalize();
        this.screenRight = this.screenUp.crossProduct(this.eyeDirection).normalize();
    }

    public void cameraForward(double d) {
        this.posd = d;
        this.eyePosition = this.eyePosition.add(this.eyeDirection.scalarMult(d));
        this.repaint();
    }

    public double getCameraPosition() {
        return this.posd;
    }

    private void cameraRotate(double d, double d1, boolean flag) {
        Vec vec = null;
        if (flag) {
            vec = new Vec(this.eyePosition.dotProduct(this.eyeDirection), this.eyePosition.dotProduct(this.screenUp), this.eyePosition.dotProduct(this.screenRight));
        }
        this.eyeDirection = this.eyeDirection.substract(this.screenRight.scalarMult(d));
        this.eyeDirection = this.eyeDirection.add(this.screenUp.scalarMult(d1));
        this.eyeDirection = this.eyeDirection.normalize();
        if (flag) {
            this.recalcUpRight();
            this.eyePosition = this.eyeDirection.scalarMult(vec.x).add(this.screenUp.scalarMult(vec.y)).add(this.screenRight.scalarMult(vec.z));
        }
        if (this.eyeDirection.y > -0.9 && this.eyeDirection.y < 0.9) {
            int i = this.up.y <= 0.0 ? -1 : 1;
            double d2 = (double)i * this.screenUp.y;
            double d3 = (double)i * this.eyeDirection.y;
            double d4 = Math.sqrt(d2 * d2 + d3 * d3);
            this.up = this.screenUp.scalarMult(d2 / d4).add(this.eyeDirection.scalarMult(d3 / d4));
            this.up = this.up.add(new Vec(0.0, 0.1 * (double)i, 0.0)).normalize();
        } else {
            this.up = this.screenUp;
        }
        this.recalcUpRight();
        this.repaint();
    }

    private void cameraTranslate(double d, double d1) {
        this.eyePosition = this.eyePosition.substract(this.screenRight.scalarMult(d));
        this.eyePosition = this.eyePosition.add(this.screenUp.scalarMult(d1));
        this.repaint();
    }

    private void cameraBank(double d) {
        this.up = this.screenUp.add(this.screenRight.scalarMult(d)).normalize();
        this.recalcUpRight();
        this.repaint();
    }

    private Vec project(Vec vec) {
        vec = vec.substract(this.eyePosition);
        double d = vec.dotProduct(this.eyeDirection);
        vec = vec.scalarMult(1.0 / d).substract(this.eyeDirection.scalarMult(1.0));
        Vec vec1 = new Vec(this.scale * this.screenRight.dotProduct(vec), this.scale * this.screenUp.dotProduct(vec), d);
        return vec1;
    }

    private void draw3DLine(Graphics2D graphics2d, Vec vec, Vec vec1) {
        if (vec == null || vec1 == null) {
            return;
        }
        if (vec.isNaN() || vec1.isNaN()) {
            return;
        }
        Vec vec2 = this.project(vec);
        Vec vec3 = this.project(vec1);
        if (vec2.z < 0.01 && vec3.z < 0.01) {
            return;
        }
        if (vec2.z < 0.01) {
            Vec vec4 = vec;
            vec = vec1;
            vec1 = vec4;
            vec4 = vec2;
            vec2 = vec3;
            vec3 = vec4;
        }
        if (vec3.z < 0.01) {
            vec1 = vec.scalarMult(0.01 - vec3.z).add(vec1.scalarMult(vec2.z - 0.01)).scalarDivide(vec2.z - vec3.z);
            vec3 = this.project(vec1);
        }
        graphics2d.drawLine((int)vec2.x, -((int)vec2.y), (int)vec3.x, -((int)vec3.y));
    }

    private void createAxes(LinkedList linkedlist) {
        for (int i = 0; i < 3; ++i) {
            if (!this.axesDefinition.shown[i]) continue;
            Vec vec = this.axesDefinition.axisVectors[i];
            double d = this.axesDefinition.min[i];
            double d1 = this.axesDefinition.max[i] + 0.05;
            double d2 = this.axesDefinition.incr;
            for (double d3 = d; d3 < d1 - 1.0E-8; d3 += d2) {
                linkedlist.add(new ElementCurve(vec.scalarMult(d3), vec.scalarMult(d3 + d2), this.axesDefinition.color, this.axesDefinition.width, true));
            }
            for (double d4 = Math.ceil(d / this.axesDefinition.tickDensity) * this.axesDefinition.tickDensity; d4 <= d1 + 1.0E-8; d4 += this.axesDefinition.tickDensity) {
                double d5 = (double)Math.round(d4 * 1000.0) / 1000.0;
                if (d5 == 0.0) continue;
                linkedlist.add(new ElementString(String.valueOf(d5), vec.scalarMult(d4), this.axesDefinition.color, vec));
            }
            if (this.showArrows) {
                Vec vec1 = this.axesDefinition.axisVectors[i != 0 ? 0 : 2];
                linkedlist.add(new ElementCurve(vec.scalarMult(d1), vec.scalarMult(d1 * 0.97).substract(vec1.scalarMult(0.03)), this.axesDefinition.color, this.axesDefinition.width, true));
                linkedlist.add(new ElementCurve(vec.scalarMult(d1), vec.scalarMult(d1 * 0.97).add(vec1.scalarMult(0.03)), this.axesDefinition.color, this.axesDefinition.width, true));
            }
            linkedlist.add(new ElementString(this.as[i], vec.scalarMult(d1 * 1.05), this.axesDefinition.color, null));
        }
    }

    private void paintAsSolid(VectorGraphics graphics2d) {
        LinkedList<Element> linkedlist = new LinkedList<Element>();
        if (this.bShowAxes) {
            this.createAxes(linkedlist);
        }
        for (int i = 0; i < this.functions.size(); ++i) {
            ModelFunction modelfunction = this.functions.getFunction(i);
            if (!modelfunction.visible) continue;
            Vec[][] avec = modelfunction.coords;
            int j = modelfunction.gridDivsU;
            int k = modelfunction.gridDivsV;
            for (int l = 0; l < j - 1; ++l) {
                if (modelfunction.isCurve) {
                    ElementCurve elementcurve = new ElementCurve(avec[l][0], avec[l + 1][0], modelfunction.curveColor, modelfunction.curveWidth, modelfunction.absoluteWidth);
                    if (!elementcurve.isRenderable()) continue;
                    linkedlist.add(elementcurve);
                    continue;
                }
                for (int i1 = 0; i1 < k - 1; ++i1) {
                    if (modelfunction.fillSurface) {
                        ElementRect elementrect = new ElementRect(avec[l][i1], avec[l + 1][i1], avec[l + 1][i1 + 1], avec[l][i1 + 1], modelfunction.curveColor, modelfunction.fillSurface ? modelfunction.surfaceColor : null);
                        if (!elementrect.isRenderable()) continue;
                        linkedlist.add(elementrect);
                        continue;
                    }
                    ElementCurve elementcurve1 = new ElementCurve(avec[l][i1], avec[l + 1][i1], modelfunction.curveColor, 0, true);
                    if (elementcurve1.isRenderable()) {
                        linkedlist.add(elementcurve1);
                    }
                    if ((elementcurve1 = new ElementCurve(avec[l][i1], avec[l][i1 + 1], modelfunction.curveColor, 0, true)).isRenderable()) {
                        linkedlist.add(elementcurve1);
                    }
                    if (l == j - 2 && (elementcurve1 = new ElementCurve(avec[l + 1][i1 + 1], avec[l + 1][i1], modelfunction.curveColor, 0, true)).isRenderable()) {
                        linkedlist.add(elementcurve1);
                    }
                    if (i1 != k - 2 || !(elementcurve1 = new ElementCurve(avec[l + 1][i1 + 1], avec[l][i1 + 1], modelfunction.curveColor, 0, true)).isRenderable()) continue;
                    linkedlist.add(elementcurve1);
                }
            }
        }
        Collections.sort(linkedlist);
        for (Element element : linkedlist) {
            element.render(graphics2d);
        }
    }

    private void paintAsWireframe(Graphics2D graphics2d) {
        graphics2d.setColor(Utils.blendColors(this.axesDefinition.color, Color.WHITE, 0.75));
        if (this.bShowAxes) {
            for (int i = 0; i < 3; ++i) {
                if (!this.axesDefinition.shown[i]) continue;
                this.draw3DLine(graphics2d, this.axesDefinition.axisVectors[i].scalarMult(this.axesDefinition.min[i]), this.axesDefinition.axisVectors[i].scalarMult(this.axesDefinition.max[i]));
            }
        }
        for (int j = 0; j < this.functions.size(); ++j) {
            ModelFunction modelfunction = this.functions.getFunction(j);
            if (!modelfunction.visible) continue;
            Vec[][] avec = modelfunction.coords;
            if (!modelfunction.isCurve && modelfunction.fillSurface) {
                graphics2d.setColor(Utils.blendColors(Color.BLACK, modelfunction.surfaceColor, 0.5));
            } else {
                graphics2d.setColor(Utils.blendColors(Color.BLACK, modelfunction.curveColor, 0.5));
            }
            if (modelfunction.isCurve) {
                for (int k = 0; k < modelfunction.gridDivsU - 1; ++k) {
                    this.draw3DLine(graphics2d, avec[k][0], avec[k + 1][0]);
                }
                continue;
            }
            for (int l = 0; l < modelfunction.gridDivsU; ++l) {
                for (int i1 = 0; i1 < modelfunction.gridDivsV; ++i1) {
                    if (i1 < avec[l].length - 1) {
                        this.draw3DLine(graphics2d, avec[l][i1], avec[l][i1 + 1]);
                    }
                    if (l >= avec.length - 1) continue;
                    this.draw3DLine(graphics2d, avec[l][i1], avec[l + 1][i1]);
                }
            }
        }
    }

    public void paintToGrphics(Graphics g, int i, int j) {
        VectorGraphics graphics2d = VectorGraphics.create((Graphics)g);
        if (this.backCulling == 0) {
            graphics2d.setColor(Color.WHITE);
        } else {
            graphics2d.setColor(this.bgColor);
        }
        graphics2d.fillRect(0, 0, i, j);
        graphics2d.translate(i / 2, j / 2);
        if (this.backCulling != 0) {
            this.paintAsSolid(graphics2d);
        } else {
            this.paintAsWireframe((Graphics2D)graphics2d);
        }
        if (!this.title.equals("")) {
            Graphics2D graphics2d1 = (Graphics2D)g.create();
            graphics2d1.setFont(graphics2d1.getFont().deriveFont(this.backCulling != 0 ? 1 : 0, 12.0f));
            Rectangle2D rectangle2d = graphics2d1.getFontMetrics().getStringBounds(this.title, graphics2d1);
            Rectangle rectangle = new Rectangle(i / 2 - (int)rectangle2d.getWidth() / 2, j - (int)rectangle2d.getHeight() - 10, (int)rectangle2d.getWidth(), (int)rectangle2d.getHeight());
            if (this.backCulling != 0) {
                graphics2d1.setColor(new Color(0, 0, 0, 32));
                graphics2d1.fillRect(0, rectangle.y + 3, i, rectangle.height + 2);
                graphics2d1.setColor(new Color(255, 255, 255, 128));
                graphics2d1.drawString(this.title, rectangle.x, rectangle.y + rectangle.height);
            }
            graphics2d1.setColor(new Color(0, 0, 0, 128));
            graphics2d1.drawString(this.title, rectangle.x + 1, rectangle.y + rectangle.height + 1);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        Dimension dimension = this.getSize();
        this.paintToGrphics(g, dimension.width, dimension.height);
    }

    public void saveImage(String s) throws IOException {
        BufferedImage bufferedimage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        Graphics g = bufferedimage.getGraphics();
        int i = bufferedimage.getWidth();
        int j = bufferedimage.getHeight();
        this.paintToGrphics(bufferedimage.getGraphics(), bufferedimage.getWidth(), bufferedimage.getHeight());
        Color color = this.backCulling == 0 ? Color.WHITE : this.bgColor;
        g.setColor(Utils.blendColors(Color.BLACK, color, 0.5));
        g.drawRect(1, 1, i - 3, j - 3);
        g.setColor(Utils.blendColors(Color.WHITE, color, 0.5));
        g.drawRect(0, 0, i - 1, j - 1);
        ImageIO.write((RenderedImage)bufferedimage, "png", new File(s));
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                ModelView.this.menu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private static class KeyBoard {
        private double targetForward = 0.0;
        private Point2D.Double targetTranslate = new Point2D.Double(0.0, 0.0);
        private Point2D.Double targetRotate = new Point2D.Double(0.0, 0.0);
        private double targetBank = 0.0;
        private Point2D.Double targetPivotRotate = new Point2D.Double(0.0, 0.0);
        private double velForward = 0.0;
        private Point2D.Double velTranslate = new Point2D.Double(0.0, 0.0);
        private Point2D.Double velRotate = new Point2D.Double(0.0, 0.0);
        private double velBank = 0.0;
        private Point2D.Double velPivotRotate = new Point2D.Double(0.0, 0.0);

        private KeyBoard() {
        }
    }

    public class ModelFunction
    implements Printable {
        public boolean visible = true;
        public String name;
        public String expression;
        boolean isCurve = false;
        int curveWidth = 2;
        double transparency;
        boolean absoluteWidth = false;
        public int gridDivsU = 21;
        public int gridDivsV = 21;
        public boolean fillSurface = true;
        public Color curveColor;
        public Color surfaceColor;
        private double area;
        private Vec[][] coords;

        @Override
        public void writeToStream(DataOutputStream dataoutputstream) throws IOException {
            dataoutputstream.writeBoolean(this.visible);
            dataoutputstream.writeUTF(this.name);
            dataoutputstream.writeUTF(this.expression);
            dataoutputstream.writeBoolean(this.isCurve);
            dataoutputstream.writeInt(this.curveWidth);
            dataoutputstream.writeBoolean(this.absoluteWidth);
            dataoutputstream.writeInt(this.gridDivsU);
            dataoutputstream.writeInt(this.gridDivsV);
            dataoutputstream.writeBoolean(this.fillSurface);
            Utils.writeColor(dataoutputstream, this.curveColor);
            Utils.writeColor(dataoutputstream, this.surfaceColor);
        }

        @Override
        public void readFromStream(DataInputStream datainputstream) throws IOException {
            this.visible = datainputstream.readBoolean();
            this.name = datainputstream.readUTF();
            this.expression = datainputstream.readUTF();
            this.isCurve = datainputstream.readBoolean();
            this.curveWidth = datainputstream.readInt();
            this.absoluteWidth = datainputstream.readBoolean();
            this.gridDivsU = datainputstream.readInt();
            this.gridDivsV = datainputstream.readInt();
            this.fillSurface = datainputstream.readBoolean();
            this.curveColor = Utils.readColor(datainputstream);
            this.surfaceColor = Utils.readColor(datainputstream);
            this.parseFunction();
        }

        public String toString() {
            return this.name;
        }

        public double getArea() {
            return this.area;
        }

        public void parseFunction() {
            this.coords = new Vec[this.gridDivsU][this.isCurve ? 1 : this.gridDivsV];
            this.area = 0.0;
            ModelView.this.mathParser.resetVariables();
            ModelView.this.mathParser.setVariable("uSteps", this.gridDivsU - 1);
            ModelView.this.mathParser.setVariable("tSteps", this.gridDivsU - 1);
            ModelView.this.mathParser.setVariable("vSteps", this.isCurve ? 0.0 : (double)(this.gridDivsV - 1));
            for (int i = 0; i < this.gridDivsU; ++i) {
                double d = (float)i / (float)(this.gridDivsU - 1);
                for (int j = 0; j < (this.isCurve ? 1 : this.gridDivsV); ++j) {
                    double d1 = (float)j / (float)(this.gridDivsV - 1);
                    ModelView.this.mathParser.setVariable("u", d);
                    ModelView.this.mathParser.setVariable("t", d);
                    ModelView.this.mathParser.setVariable("v", d1);
                    ModelView.this.mathParser.setVariable("x", this.isCurve ? 0.0 : 2.0 * d - 1.0);
                    ModelView.this.mathParser.setVariable("y", this.isCurve ? 0.0 : 2.0 * d1 - 1.0);
                    ModelView.this.mathParser.setVariable("z", 0.0);
                    try {
                        ModelView.this.mathParser.parseExpression(this.expression);
                        this.coords[i][j] = new Vec(ModelView.this.mathParser.getVariable("x"), ModelView.this.mathParser.getVariable("z"), ModelView.this.mathParser.getVariable("y"));
                        if (this.isCurve) {
                            if (i <= 0) continue;
                            this.area += this.coords[i][0].substract(this.coords[i - 1][0]).norm();
                            continue;
                        }
                        if (i <= 0 || j <= 0) continue;
                        this.area += this.coords[i][j - 1].substract(this.coords[i - 1][j - 1]).crossProduct(this.coords[i - 1][j].substract(this.coords[i - 1][j - 1])).norm() / 2.0 + this.coords[i][j - 1].substract(this.coords[i][j]).crossProduct(this.coords[i - 1][j].substract(this.coords[i][j])).norm() / 2.0;
                        continue;
                    }
                    catch (Exception exception) {
                        this.coords[i][j] = new Vec(Double.NaN, Double.NaN, Double.NaN);
                    }
                }
            }
        }
    }

    public class FunctionsList
    implements Printable {
        private ArrayList functions = new ArrayList();

        @Override
        public void writeToStream(DataOutputStream dataoutputstream) throws IOException {
            dataoutputstream.writeInt(this.size());
            for (int i = 0; i < this.size(); ++i) {
                this.getFunction(i).writeToStream(dataoutputstream);
            }
        }

        @Override
        public void readFromStream(DataInputStream datainputstream) throws IOException {
            int i = datainputstream.readInt();
            this.functions.clear();
            for (int j = 0; j < i; ++j) {
                ModelFunction modelfunction = this.addFunction();
                modelfunction.readFromStream(datainputstream);
            }
        }

        public ModelFunction addFunction() {
            String s;
            ModelFunction modelfunction = new ModelFunction();
            int i = 1;
            while (true) {
                int j;
                s = "Function " + i;
                for (j = 0; j < this.functions.size() && !((ModelFunction)this.functions.get((int)j)).name.equals(s); ++j) {
                }
                if (j == this.functions.size()) break;
                ++i;
            }
            modelfunction.name = s;
            modelfunction.expression = "z=0";
            modelfunction.curveColor = Color.BLACK;
            modelfunction.surfaceColor = new Color((float)Math.random(), (float)Math.random(), (float)Math.random());
            this.functions.add(modelfunction);
            return modelfunction;
        }

        public void removeFunction(int i) {
            this.functions.remove(i);
        }

        public void clear() {
            this.functions.clear();
        }

        public ModelFunction getFunction(int i) {
            return (ModelFunction)this.functions.get(i);
        }

        public int size() {
            return this.functions.size();
        }
    }

    private class OnKey
    extends KeyAdapter {
        @Override
        public void keyReleased(KeyEvent keyevent) {
            switch (keyevent.getKeyCode()) {
                case 65: 
                case 90: {
                    ModelView.this.keyBoard.targetForward = 0.0;
                    break;
                }
                case 38: 
                case 40: {
                    ((KeyBoard)((ModelView)ModelView.this).keyBoard).targetTranslate.y = 0.0;
                    ((KeyBoard)((ModelView)ModelView.this).keyBoard).targetPivotRotate.y = 0.0;
                    ((KeyBoard)((ModelView)ModelView.this).keyBoard).targetRotate.y = 0.0;
                    break;
                }
                case 37: 
                case 39: {
                    ((KeyBoard)((ModelView)ModelView.this).keyBoard).targetTranslate.x = 0.0;
                    ((KeyBoard)((ModelView)ModelView.this).keyBoard).targetPivotRotate.x = 0.0;
                    ((KeyBoard)((ModelView)ModelView.this).keyBoard).targetRotate.x = 0.0;
                    break;
                }
                case 34: 
                case 69: 
                case 81: 
                case 127: {
                    ModelView.this.keyBoard.targetBank = 0.0;
                }
            }
        }

        @Override
        public void keyPressed(KeyEvent keyevent) {
            boolean flag = true;
            switch (keyevent.getKeyCode()) {
                case 65: {
                    ModelView.this.keyBoard.targetForward = 0.15;
                    break;
                }
                case 90: {
                    ModelView.this.keyBoard.targetForward = -0.15;
                    break;
                }
                case 40: {
                    if (keyevent.isAltDown()) {
                        ((KeyBoard)((ModelView)ModelView.this).keyBoard).targetTranslate.y = -0.15;
                        break;
                    }
                    if (keyevent.isControlDown()) {
                        ((KeyBoard)((ModelView)ModelView.this).keyBoard).targetPivotRotate.y = 0.15;
                        break;
                    }
                    ((KeyBoard)((ModelView)ModelView.this).keyBoard).targetRotate.y = 0.15;
                    break;
                }
                case 38: {
                    if (keyevent.isAltDown()) {
                        ((KeyBoard)((ModelView)ModelView.this).keyBoard).targetTranslate.y = 0.15;
                        break;
                    }
                    if (keyevent.isControlDown()) {
                        ((KeyBoard)((ModelView)ModelView.this).keyBoard).targetPivotRotate.y = -0.15;
                        break;
                    }
                    ((KeyBoard)((ModelView)ModelView.this).keyBoard).targetRotate.y = -0.15;
                    break;
                }
                case 37: {
                    if (keyevent.isAltDown()) {
                        ((KeyBoard)((ModelView)ModelView.this).keyBoard).targetTranslate.x = 0.15;
                        break;
                    }
                    if (keyevent.isControlDown()) {
                        ((KeyBoard)((ModelView)ModelView.this).keyBoard).targetPivotRotate.x = 0.15;
                        break;
                    }
                    ((KeyBoard)((ModelView)ModelView.this).keyBoard).targetRotate.x = 0.15;
                    break;
                }
                case 39: {
                    if (keyevent.isAltDown()) {
                        ((KeyBoard)((ModelView)ModelView.this).keyBoard).targetTranslate.x = -0.15;
                        break;
                    }
                    if (keyevent.isControlDown()) {
                        ((KeyBoard)((ModelView)ModelView.this).keyBoard).targetPivotRotate.x = -0.15;
                        break;
                    }
                    ((KeyBoard)((ModelView)ModelView.this).keyBoard).targetRotate.x = -0.15;
                    break;
                }
                case 81: 
                case 127: {
                    ModelView.this.keyBoard.targetBank = -0.15;
                    break;
                }
                case 34: 
                case 69: {
                    ModelView.this.keyBoard.targetBank = 0.15;
                    break;
                }
                default: {
                    flag = false;
                }
            }
            if (flag) {
                ModelView.this.timer.start();
            }
        }

        private OnKey() {
        }
    }

    private class TimerListener
    implements ActionListener {
        private long lastTime = 0L;

        @Override
        public void actionPerformed(ActionEvent actionevent) {
            long l = System.currentTimeMillis();
            long l1 = l - this.lastTime;
            if (l1 <= 0L || l1 > (long)(2 * ModelView.this.timer.getDelay())) {
                l1 = ModelView.this.timer.getDelay();
            }
            double d = (double)l1 / 100.0;
            this.lastTime = l;
            boolean flag = true;
            double d1 = Math.pow(0.2, d);
            ModelView.this.keyBoard.velForward = ModelView.this.keyBoard.velForward * d1 + ModelView.this.keyBoard.targetForward * d * (1.0 - d1);
            if (Math.abs(ModelView.this.keyBoard.velForward) > 0.001) {
                flag = false;
                ModelView.this.cameraForward(ModelView.this.keyBoard.velForward);
            }
            ((KeyBoard)((ModelView)ModelView.this).keyBoard).velTranslate.x = ((KeyBoard)((ModelView)ModelView.this).keyBoard).velTranslate.x * d1 + ((KeyBoard)((ModelView)ModelView.this).keyBoard).targetTranslate.x * d * (1.0 - d1);
            ((KeyBoard)((ModelView)ModelView.this).keyBoard).velTranslate.y = ((KeyBoard)((ModelView)ModelView.this).keyBoard).velTranslate.y * d1 + ((KeyBoard)((ModelView)ModelView.this).keyBoard).targetTranslate.y * d * (1.0 - d1);
            if (Math.abs(((KeyBoard)((ModelView)ModelView.this).keyBoard).velTranslate.x) > 0.001 || Math.abs(((KeyBoard)((ModelView)ModelView.this).keyBoard).velTranslate.y) > 0.001) {
                flag = false;
                ModelView.this.cameraTranslate(((KeyBoard)((ModelView)ModelView.this).keyBoard).velTranslate.x, ((KeyBoard)((ModelView)ModelView.this).keyBoard).velTranslate.y);
            }
            ((KeyBoard)((ModelView)ModelView.this).keyBoard).velRotate.x = ((KeyBoard)((ModelView)ModelView.this).keyBoard).velRotate.x * d1 + ((KeyBoard)((ModelView)ModelView.this).keyBoard).targetRotate.x * d * (1.0 - d1);
            ((KeyBoard)((ModelView)ModelView.this).keyBoard).velRotate.y = ((KeyBoard)((ModelView)ModelView.this).keyBoard).velRotate.y * d1 + ((KeyBoard)((ModelView)ModelView.this).keyBoard).targetRotate.y * d * (1.0 - d1);
            if (Math.abs(((KeyBoard)((ModelView)ModelView.this).keyBoard).velRotate.x) > 0.001 || Math.abs(((KeyBoard)((ModelView)ModelView.this).keyBoard).velRotate.y) > 0.001) {
                flag = false;
                ModelView.this.cameraRotate(((KeyBoard)((ModelView)ModelView.this).keyBoard).velRotate.x, ((KeyBoard)((ModelView)ModelView.this).keyBoard).velRotate.y, false);
            }
            ModelView.this.keyBoard.velBank = ModelView.this.keyBoard.velBank * d1 + ModelView.this.keyBoard.targetBank * d * (1.0 - d1);
            if (Math.abs(ModelView.this.keyBoard.velBank) > 0.001) {
                flag = false;
                ModelView.this.cameraBank(ModelView.this.keyBoard.velBank);
            }
            ((KeyBoard)((ModelView)ModelView.this).keyBoard).velPivotRotate.x = ((KeyBoard)((ModelView)ModelView.this).keyBoard).velPivotRotate.x * d1 + ((KeyBoard)((ModelView)ModelView.this).keyBoard).targetPivotRotate.x * d * (1.0 - d1);
            ((KeyBoard)((ModelView)ModelView.this).keyBoard).velPivotRotate.y = ((KeyBoard)((ModelView)ModelView.this).keyBoard).velPivotRotate.y * d1 + ((KeyBoard)((ModelView)ModelView.this).keyBoard).targetPivotRotate.y * d * (1.0 - d1);
            if (Math.abs(((KeyBoard)((ModelView)ModelView.this).keyBoard).velPivotRotate.x) > 0.001 || Math.abs(((KeyBoard)((ModelView)ModelView.this).keyBoard).velPivotRotate.y) > 0.001) {
                flag = false;
                ModelView.this.cameraRotate(((KeyBoard)((ModelView)ModelView.this).keyBoard).velPivotRotate.x, ((KeyBoard)((ModelView)ModelView.this).keyBoard).velPivotRotate.y, true);
            }
            if (flag) {
                ModelView.this.timer.stop();
            } else {
                ModelView.this.timer.restart();
            }
        }

        private TimerListener() {
        }
    }

    private class OnMouse
    extends MouseInputAdapter {
        private Point lastPoint = new Point(0, 0);

        @Override
        public void mousePressed(MouseEvent mouseevent) {
            this.lastPoint = new Point(mouseevent.getX(), mouseevent.getY());
            ModelView.this.requestFocusInWindow();
        }

        @Override
        public void mouseDragged(MouseEvent mouseevent) {
            Point point = new Point(mouseevent.getX(), mouseevent.getY());
            double d = (float)(point.x - this.lastPoint.x) / 100.0f;
            double d1 = (float)(point.y - this.lastPoint.y) / 100.0f;
            if (mouseevent.isControlDown()) {
                ModelView.this.cameraRotate(d, d1, false);
            } else if ((mouseevent.getModifiersEx() & 0x1000) != 0) {
                ModelView.this.cameraForward(d1);
            } else if ((mouseevent.getModifiersEx() & 0x800) != 0) {
                ModelView.this.cameraTranslate(d, d1);
            } else if (mouseevent.isShiftDown()) {
                Rectangle rectangle = ModelView.this.getBounds();
                double d2 = point.x - (rectangle.x + rectangle.width / 2);
                double d3 = point.y - (rectangle.y + rectangle.height / 2);
                double d4 = Math.sqrt(d2 * d2 + d3 * d3);
                ModelView.this.cameraBank((d * d3 - d1 * d2) / d4);
            } else if (mouseevent.isAltDown()) {
                ModelView.this.cameraTranslate(d, d1);
            } else {
                ModelView.this.cameraRotate(-d, -d1, true);
            }
            this.lastPoint = point;
        }

        private OnMouse() {
        }
    }

    private abstract class Element
    implements Comparable {
        boolean renderable = true;
        protected double dist;

        boolean isRenderable() {
            return this.renderable;
        }

        public int compareTo(Object obj) {
            Element element = (Element)obj;
            if (this.dist > element.dist) {
                return -1;
            }
            return this.dist >= element.dist ? 0 : 1;
        }

        double getBlendAmt() {
            if (ModelView.this.fogEnabled) {
                double d = (this.dist - ModelView.this.fogStart) / (ModelView.this.fogEnd - ModelView.this.fogStart);
                if (d > 1.0) {
                    return 1.0;
                }
                if (d < 0.0) {
                    return 0.0;
                }
                return d;
            }
            return 0.0;
        }

        public abstract void render(VectorGraphics var1);

        private Element() {
        }
    }

    private class ElementRect
    extends Element {
        private double shineyNess;
        private double shineIntensity;
        private Polygon s;
        private Color curveColor;
        private Color surfaceColor;

        @Override
        public void render(VectorGraphics graphics2d) {
            if (!this.renderable) {
                return;
            }
            if (this.surfaceColor != null) {
                graphics2d.setColor(this.surfaceColor);
                graphics2d.fill((Shape)this.s);
            }
            graphics2d.setColor(this.curveColor);
            if (this.s != null) {
                graphics2d.draw((Shape)this.s);
            }
        }

        public ElementRect(Vec vec, Vec vec1, Vec vec2, Vec vec3, Color color, Color color1) {
            if (vec == null || vec1 == null || vec2 == null || vec3 == null) {
                return;
            }
            this.shineyNess = 0.25;
            this.shineIntensity = 0.35;
            double d = 0.0;
            Vec vec4 = vec1.substract(vec);
            Vec vec5 = vec2.substract(vec1);
            Vec vec6 = vec3.substract(vec2);
            Vec vec7 = vec.substract(vec3);
            vec = ModelView.this.project(vec);
            vec1 = ModelView.this.project(vec1);
            vec2 = ModelView.this.project(vec2);
            vec3 = ModelView.this.project(vec3);
            if (vec.z < 0.0 || vec1.z < 0.0 || vec2.z < 0.0 || vec3.z < 0.0) {
                this.renderable = false;
                return;
            }
            this.dist = (vec.z + vec1.z + vec2.z + vec3.z) / 4.0;
            double d1 = this.getBlendAmt();
            if (d1 >= 1.0) {
                this.renderable = false;
                return;
            }
            this.s = new Polygon();
            this.s.addPoint((int)vec.x, -((int)vec.y));
            this.s.addPoint((int)vec1.x, -((int)vec1.y));
            this.s.addPoint((int)vec2.x, -((int)vec2.y));
            this.s.addPoint((int)vec3.x, -((int)vec3.y));
            this.curveColor = Utils.blendColors(color, ModelView.this.bgColor, d1);
            if (this.shineIntensity > 0.0) {
                Vec vec8 = ModelView.this.eyeDirection;
                Vec vec9 = vec4.crossProduct(vec5);
                vec9 = vec9.add(vec6.crossProduct(vec7));
                d += vec9.normalize().dotProduct(vec8);
                d = Math.abs(d);
                if ((d = (d - 1.0) / (1.0 - this.shineyNess) + 1.0) < 0.0) {
                    d = 0.0;
                } else if (d > 1.0) {
                    d = 1.0;
                }
                color1 = Utils.blendColors(color1, Color.WHITE, d * this.shineIntensity);
            }
            this.surfaceColor = Utils.blendColors(color1, ModelView.this.bgColor, d1);
        }
    }

    private class ElementCurve
    extends Element {
        private int x1;
        private int y1;
        private int x2;
        private int y2;
        private Color curveColor;
        private int curveWidth;

        @Override
        public void render(VectorGraphics graphics2d) {
            if (!this.renderable) {
                return;
            }
            Stroke stroke = graphics2d.getStroke();
            graphics2d.setStroke((Stroke)new BasicStroke(this.curveWidth, 1, 1));
            graphics2d.setColor(this.curveColor);
            graphics2d.drawLine(this.x1, this.y1, this.x2, this.y2);
            graphics2d.setStroke(stroke);
        }

        public ElementCurve(Vec vec, Vec vec1, Color color, int i, boolean flag) {
            if (vec == null || vec1 == null) {
                return;
            }
            vec = ModelView.this.project(vec);
            vec1 = ModelView.this.project(vec1);
            if (vec.z < 0.0 || vec1.z < 0.0) {
                this.renderable = false;
                return;
            }
            this.dist = (vec.z + vec1.z) / 2.0;
            double d = this.getBlendAmt();
            if (d >= 1.0) {
                this.renderable = false;
                return;
            }
            this.x1 = (int)vec.x;
            this.y1 = -((int)vec.y);
            this.x2 = (int)vec1.x;
            this.y2 = -((int)vec1.y);
            this.curveColor = Utils.blendColors(color, ModelView.this.bgColor, d);
            this.curveWidth = flag ? i : (int)(1.0 / this.dist * (double)i);
        }
    }

    private class ElementString
    extends Element {
        private double x;
        private double y;
        private Color color;
        private String string;
        boolean tick = false;
        double tickX;
        double tickY;

        @Override
        public void render(VectorGraphics graphics2d) {
            if (!this.renderable) {
                return;
            }
            graphics2d.setColor(this.color);
            if (this.tick) {
                graphics2d.drawLine((int)(this.x - this.tickX * 3.0), (int)(this.y - this.tickY * 3.0), (int)(this.x + this.tickX * 3.0), (int)(this.y + this.tickY * 3.0));
                graphics2d.setFont(ModelView.this.valueFont);
                graphics2d.drawString(this.string, (int)this.x + 5, (int)this.y + 12);
            } else {
                RTextLine text = new RTextLine();
                text.setFont(ModelView.this.labelFont);
                text.setColor(ModelView.this.labelColor);
                String stext = Translate.decode(this.string);
                text.setText(stext);
                text.draw(graphics2d, (int)this.x - 5, (int)this.y + 5);
            }
        }

        public ElementString(String s, Vec vec, Color color1, Vec vec1) {
            vec = ModelView.this.project(vec);
            if (vec.z < 0.0) {
                this.renderable = false;
                return;
            }
            this.dist = vec.z;
            double d = this.getBlendAmt();
            if (d >= 1.0) {
                this.renderable = false;
                return;
            }
            this.x = vec.x;
            this.y = -vec.y;
            this.color = Utils.blendColors(color1, ModelView.this.bgColor, d);
            this.string = s;
            if (vec1 != null) {
                vec1 = ModelView.this.project(vec1).substract(ModelView.this.project(new Vec(0.0, 0.0, 0.0)));
                this.tickX = vec1.y;
                this.tickY = vec1.x;
                double d1 = Math.sqrt(this.tickX * this.tickX + this.tickY * this.tickY);
                this.tickX /= d1;
                this.tickY /= d1;
                this.tick = true;
            }
        }
    }

    public class AxesDefinition
    implements Printable {
        public final Vec[] axisVectors = new Vec[]{new Vec(1.0, 0.0, 0.0), new Vec(0.0, 1.0, 0.0), new Vec(0.0, 0.0, 1.0)};
        public final Vec[] axisVectorsFrame = new Vec[]{new Vec(-1.0, 0.0, 0.0), new Vec(0.0, -1.0, 0.0), new Vec(0.0, 0.0, -1.0)};
        boolean[] shown = new boolean[]{true, true, true};
        public double[] min = new double[]{0.0, 0.0, 0.0};
        public double[] max = new double[]{1.0, 1.0, 1.0};
        public double incr = 0.05;
        public double tickDensity = 0.2;
        public Color color = Color.BLACK;
        public int width = 2;

        @Override
        public void readFromStream(DataInputStream datainputstream) throws IOException {
            for (int i = 0; i < 3; ++i) {
                this.axisVectors[i].readFromStream(datainputstream);
                this.shown[i] = datainputstream.readBoolean();
                this.min[i] = datainputstream.readDouble();
                this.max[i] = datainputstream.readDouble();
            }
            this.incr = datainputstream.readDouble();
            this.tickDensity = datainputstream.readDouble();
            this.color = Utils.readColor(datainputstream);
            this.width = datainputstream.readInt();
        }

        @Override
        public void writeToStream(DataOutputStream dataoutputstream) throws IOException {
            for (int i = 0; i < 3; ++i) {
                this.axisVectors[i].writeToStream(dataoutputstream);
                dataoutputstream.writeBoolean(this.shown[i]);
                dataoutputstream.writeDouble(this.min[i]);
                dataoutputstream.writeDouble(this.max[i]);
            }
            dataoutputstream.writeDouble(this.incr);
            dataoutputstream.writeDouble(this.tickDensity);
            Utils.writeColor(dataoutputstream, this.color);
            dataoutputstream.writeInt(this.width);
        }
    }
}

