/*
 * Decompiled with CFR 0.152.
 */
package jplot3dp;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import jplot3dp.Utils;

class HelpDialog
extends JFrame {
    private static final long serialVersionUID = 1L;
    private URL contents;
    private JEditorPane ep;
    private ArrayList<URL> urlHistory = new ArrayList();
    private int historyIndex = -1;
    private JButton btnContents;
    private JButton btnBack;
    private JButton btnForward;

    private void enableButtons() {
        this.btnBack.setEnabled(this.historyIndex > 0);
        this.btnForward.setEnabled(this.historyIndex < this.urlHistory.size() - 1);
    }

    private void setURL(URL url) {
        try {
            this.ep.setPage(url);
            if (this.historyIndex < 0 || !url.equals(this.urlHistory.get(this.historyIndex))) {
                this.urlHistory.add(url);
                ++this.historyIndex;
                while (this.urlHistory.size() > this.historyIndex + 1) {
                    this.urlHistory.remove(this.historyIndex);
                }
                this.enableButtons();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void goBack() {
        if (this.historyIndex > 0) {
            this.setURL(this.urlHistory.get(--this.historyIndex));
        }
        this.enableButtons();
    }

    private void goForward() {
        if (this.historyIndex < this.urlHistory.size() - 1) {
            this.setURL(this.urlHistory.get(++this.historyIndex));
        }
        this.enableButtons();
    }

    public HelpDialog(String s, String s1) {
        super(s);
        Container container = this.getContentPane();
        this.ep = new JEditorPane();
        this.ep.setEditable(false);
        this.ep.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hyperlinkevent) {
                if (hyperlinkevent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    HelpDialog.this.setURL(hyperlinkevent.getURL());
                }
            }
        });
        ActionListener actionlistener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                String s2 = actionevent.getActionCommand();
                if (s2 == "Contents") {
                    HelpDialog.this.setURL(HelpDialog.this.contents);
                } else if (s2 == "Back") {
                    HelpDialog.this.goBack();
                } else if (s2 == "Forward") {
                    HelpDialog.this.goForward();
                }
            }
        };
        JToolBar jtoolbar = new JToolBar();
        this.btnContents = new JButton(Utils.loadIcon("home.gif"));
        Utils.makeHot(this.btnContents);
        jtoolbar.add(this.btnContents);
        this.btnContents.addActionListener(actionlistener);
        this.btnContents.setActionCommand("Contents");
        this.btnBack = new JButton(Utils.loadIcon("back.gif"));
        Utils.makeHot(this.btnBack);
        jtoolbar.add(this.btnBack);
        this.btnBack.addActionListener(actionlistener);
        this.btnBack.setActionCommand("Back");
        this.btnForward = new JButton(Utils.loadIcon("forward.gif"));
        Utils.makeHot(this.btnForward);
        jtoolbar.add(this.btnForward);
        this.btnForward.addActionListener(actionlistener);
        this.btnForward.setActionCommand("Forward");
        container.add((Component)jtoolbar, "North");
        container.add(new JScrollPane(this.ep));
        this.setSize(480, 560);
        this.setLocationRelativeTo(null);
        this.contents = Utils.getURL(s1);
        this.setURL(this.contents);
    }
}

