/*
 * Decompiled with CFR 0.152.
 */
package jplot3d.draw;

import jplot3d.JSurface;
import jplot3d.SurfaceVertex;

public class DrawSurface {
    public static final void run(JSurface sf) {
        int sy;
        int end_ly;
        int start_ly;
        int sx;
        int end_lx;
        int start_lx;
        float zx;
        float zi;
        boolean printing = sf.printing;
        boolean plotfunc1 = sf.plotfunc1;
        boolean plotfunc2 = sf.plotfunc2;
        boolean isBoxed = sf.isBoxed;
        try {
            zi = sf.model.getZMin();
            zx = sf.model.getZMax();
            if (zi >= zx) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            return;
        }
        int plot_density = sf.model.getDispDivisions();
        int multiple_factor = sf.calc_divisions / plot_density;
        Thread.yield();
        sf.zmin = zi;
        sf.zmax = zx;
        sf.color_factor = 1.0f / (sf.zmax - sf.zmin);
        if (!printing) {
            sf.graphics.setColor(sf.getSurfaceColor().getBackgroundColor());
            sf.graphics.fillRect(0, 0, sf.getBounds().width, sf.getBounds().height);
        }
        sf.drawBoxGridsTicksLabels(sf.graphics, false);
        if (!plotfunc1 && !plotfunc2) {
            if (isBoxed) {
                sf.drawBoundingBox();
            }
            return;
        }
        sf.projector.setZRange(sf.zmin, sf.zmax);
        float distance = sf.projector.getDistance() * sf.projector.getCosElevationAngle();
        sf.cop = new SurfaceVertex(distance * sf.projector.getSinRotationAngle(), distance * sf.projector.getCosRotationAngle(), sf.projector.getDistance() * sf.projector.getSinElevationAngle());
        sf.cop.transform(sf.projector);
        sf.projector = sf.cop.getProjector();
        boolean inc_x = sf.cop.x > 0.0f;
        boolean inc_y = sf.cop.y > 0.0f;
        sf.critical = false;
        if (inc_x) {
            start_lx = 0;
            end_lx = sf.calc_divisions;
            sx = multiple_factor;
        } else {
            start_lx = sf.calc_divisions;
            end_lx = 0;
            sx = -multiple_factor;
        }
        if (inc_y) {
            start_ly = 0;
            end_ly = sf.calc_divisions;
            sy = multiple_factor;
        } else {
            start_ly = sf.calc_divisions;
            end_ly = 0;
            sy = -multiple_factor;
        }
        if (sf.cop.x > 10.0f || sf.cop.x < -10.0f) {
            if (sf.cop.y > 10.0f || sf.cop.y < -10.0f) {
                sf.plotArea(start_lx, start_ly, end_lx, end_ly, sx, sy);
            } else {
                int split_y = (int)((sf.cop.y + 10.0f) * (float)plot_density / 20.0f) * multiple_factor;
                sf.plotArea(start_lx, 0, end_lx, split_y, sx, multiple_factor);
                sf.plotArea(start_lx, sf.calc_divisions, end_lx, split_y, sx, -multiple_factor);
            }
        } else if (sf.cop.y > 10.0f || sf.cop.y < -10.0f) {
            int split_x = (int)((sf.cop.x + 10.0f) * (float)plot_density / 20.0f) * multiple_factor;
            sf.plotArea(0, start_ly, split_x, end_ly, multiple_factor, sy);
            sf.plotArea(sf.calc_divisions, start_ly, split_x, end_ly, -multiple_factor, sy);
        } else {
            int split_x = (int)((sf.cop.x + 10.0f) * (float)plot_density / 20.0f) * multiple_factor;
            int split_y = (int)((sf.cop.y + 10.0f) * (float)plot_density / 20.0f) * multiple_factor;
            sf.critical = true;
            sf.plotArea(0, 0, split_x, split_y, multiple_factor, multiple_factor);
            sf.plotArea(0, sf.calc_divisions, split_x, split_y, multiple_factor, -multiple_factor);
            sf.plotArea(sf.calc_divisions, 0, split_x, split_y, -multiple_factor, multiple_factor);
            sf.plotArea(sf.calc_divisions, sf.calc_divisions, split_x, split_y, -multiple_factor, -multiple_factor);
        }
        if (isBoxed) {
            sf.drawBoundingBox();
        }
    }
}

