/*
 * Decompiled with CFR 0.152.
 */
package jplot3d;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JPanel;
import jhplot.F2D;
import jhplot.H2D;
import jhplot.P2D;
import jhplot.P3D;
import jplot3d.JSurface;
import jplot3d.OptionsDialog;
import jplot3d.SurfaceModel;
import jplot3d.SurfaceModelCanvas;

public class JSurfacePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private SurfaceModelCanvas sm;
    private JSurface surface = new JSurface();
    private OptionsDialog odialog;
    private ArrayList<P2D> p2d_hold = null;
    private ArrayList<P3D> p3d_hold = null;
    private ArrayList<F2D> f2d_hold = null;
    private ArrayList<H2D> h2d_hold = null;
    private boolean isEmpty = false;

    public JSurfacePanel() {
        super(new BorderLayout());
        this.add((Component)this.surface, "Center");
        final JSurfacePanel ff = this;
        this.surface.item1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSurfacePanel.this.odialog = new OptionsDialog(ff);
                JSurfacePanel.this.odialog.setGUI();
                JSurfacePanel.this.odialog.setVisible(true);
            }
        });
        this.surface.item2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSurfacePanel.this.evaluate();
            }
        });
    }

    public SurfaceModelCanvas createDefaultSurfaceModel() {
        this.sm = new SurfaceModelCanvas();
        this.sm.setPlotFunction2(false);
        this.sm.setCalcDivisions(50);
        this.sm.setDispDivisions(50);
        this.sm.setContourLines(10);
        this.sm.setXMin(0.0f);
        this.sm.setXMax(1.0f);
        this.sm.setYMin(0.0f);
        this.sm.setYMax(1.0f);
        this.sm.setBoxed(true);
        this.sm.setDisplayXY(true);
        this.sm.setExpectDelay(false);
        this.sm.setAutoScaleZ(true);
        this.sm.setDisplayZ(true);
        this.sm.setMesh(true);
        this.sm.setPlotType(SurfaceModel.PlotType.SURFACE);
        this.sm.setPlotColor(SurfaceModel.PlotColor.SPECTRUM);
        this.sm.set2DScaling(10.0f);
        this.sm.setPenWidth(1.0f);
        this.sm.setXlabel("X");
        this.sm.setYlabel("Y");
        this.sm.setZlabel("Z");
        Font fontAxis = new Font("SansSerif", 1, 12);
        this.sm.setAxisFont(fontAxis);
        Font fontLabel = new Font("SansSerif", 1, 16);
        this.sm.setLabelFont(fontLabel);
        this.sm.setLabelColor(Color.black);
        this.sm.setTicFont(new Font("SansSerif", 1, 10));
        this.sm.setLabelOffsetX(1.0f);
        this.sm.setLabelOffsetY(1.0f);
        this.sm.setLabelOffsetZ(1.0f);
        this.sm.setTicOffset(1.0f);
        this.sm.setAxesFontColor(Color.black);
        this.sm.setFontColorLabel(Color.black);
        this.sm.getFrameScale();
        this.sm.setFrameScale(1.0f);
        this.p2d_hold = new ArrayList();
        this.p3d_hold = new ArrayList();
        this.f2d_hold = new ArrayList();
        this.h2d_hold = new ArrayList();
        return this.sm;
    }

    public void evaluate() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                SurfaceModelCanvas.Plotter p = JSurfacePanel.this.sm.newPlotter(JSurfacePanel.this.sm.getCalcDivisions());
                if (JSurfacePanel.this.isEmpty) {
                    JSurfacePanel.this.sm.setPlotFunction1(true);
                    p.setEmpty();
                    return;
                }
                if (JSurfacePanel.this.h2d_hold.size() > 0 && JSurfacePanel.this.f2d_hold.size() > 0 && JSurfacePanel.this.p2d_hold.size() == 0) {
                    JSurfacePanel.this.sm.setPlotFunction1(true);
                    JSurfacePanel.this.sm.setPlotFunction2(true);
                    p.setH2DF2D(JSurfacePanel.this.h2d_hold, JSurfacePanel.this.f2d_hold);
                    return;
                }
                if (JSurfacePanel.this.h2d_hold.size() > 0 && JSurfacePanel.this.f2d_hold.size() == 0 && JSurfacePanel.this.p2d_hold.size() == 0) {
                    if (JSurfacePanel.this.h2d_hold.size() == 1) {
                        JSurfacePanel.this.sm.setPlotFunction1(true);
                    }
                    if (JSurfacePanel.this.h2d_hold.size() == 2) {
                        JSurfacePanel.this.sm.setPlotFunction2(true);
                    }
                    p.setH2D(JSurfacePanel.this.h2d_hold);
                    return;
                }
                if (JSurfacePanel.this.f2d_hold.size() > 0 && JSurfacePanel.this.h2d_hold.size() == 0 && JSurfacePanel.this.p2d_hold.size() == 0) {
                    if (JSurfacePanel.this.f2d_hold.size() == 1) {
                        JSurfacePanel.this.sm.setPlotFunction1(true);
                    }
                    if (JSurfacePanel.this.f2d_hold.size() == 2) {
                        JSurfacePanel.this.sm.setPlotFunction2(true);
                    }
                    p.setF2D(JSurfacePanel.this.f2d_hold);
                    return;
                }
                if (JSurfacePanel.this.p2d_hold.size() > 0 && JSurfacePanel.this.h2d_hold.size() == 0 && JSurfacePanel.this.f2d_hold.size() == 0) {
                    JSurfacePanel.this.sm.setPlotFunction1(true);
                    p.setP2D(JSurfacePanel.this.p2d_hold);
                }
                if (JSurfacePanel.this.p3d_hold.size() > 0) {
                    JSurfacePanel.this.sm.setPlotFunction1(true);
                    p.setP3D(JSurfacePanel.this.p3d_hold);
                }
            }
        }).start();
    }

    public void setSurface(SurfaceModel model) {
        this.surface.setModel(model);
    }

    public void setEmpty() {
        this.isEmpty = true;
    }

    public void setGUI() {
        this.odialog.setGUI();
    }

    public SurfaceModelCanvas getModel() {
        return this.sm;
    }

    public void setP2D(P2D h) {
        this.p2d_hold.add(h);
        this.isEmpty = false;
    }

    public void setP3D(P3D h) {
        this.p3d_hold.add(h);
        this.isEmpty = false;
    }

    public void setH2D(H2D h) {
        this.h2d_hold.add(h);
        this.isEmpty = false;
    }

    public void setF2D(F2D h) {
        this.f2d_hold.add(h);
        this.isEmpty = false;
    }

    public ArrayList<H2D> getH2D() {
        return this.h2d_hold;
    }

    public ArrayList<F2D> getF2D() {
        return this.f2d_hold;
    }

    public void clearF2D() {
        this.f2d_hold.clear();
    }

    public void clearH2D() {
        this.h2d_hold.clear();
    }

    public void clearP2D() {
        this.p2d_hold.clear();
    }

    public void clearP3D() {
        this.p3d_hold.clear();
    }

    public void setXlabel(String s) {
        this.sm.setXlabel(s);
    }

    public void setYlabel(String s) {
        this.sm.setYlabel(s);
    }

    public void setZlabel(String s) {
        this.sm.setZlabel(s);
    }

    public String getXlabel() {
        return this.sm.getXlabel();
    }

    public String getYlabel() {
        return this.sm.getYlabel();
    }

    public String getZlabel() {
        return this.sm.getZlabel();
    }

    public String getTitle() {
        return "";
    }

    public void setTitle(String s) {
    }
}

