/*
 * Decompiled with CFR 0.152.
 */
package jplot3d;

import java.awt.Color;
import jplot3d.ColorModel;
import jplot3d.SurfaceColor;
import jplot3d.SurfaceModel;

public class ColorModelSet
implements SurfaceColor {
    public static float RED_H = 0.941896f;
    public static float RED_S = 0.7517241f;
    public static float RED_B = 0.5686275f;
    public static float GOLD_H = 0.1f;
    public static float GOLD_S = 0.9497207f;
    public static float GOLD_B = 0.7019608f;
    protected ColorModel dualshade;
    protected ColorModel grayscale;
    protected ColorModel spectrum;
    protected ColorModel fog;
    protected ColorModel opaque;
    protected ColorModel alt_dualshade;
    protected ColorModel alt_grayscale;
    protected ColorModel alt_spectrum;
    protected ColorModel alt_fog;
    protected ColorModel alt_opaque;
    protected Color lineColor = Color.BLACK;
    protected Color lineboxColor = Color.BLACK;
    protected Color bkgColor = Color.WHITE;
    protected Color textColor = Color.BLACK;
    protected Color fillColor = Color.BLUE;
    protected Color boxColor = Color.getHSBColor(0.0f, 0.0f, 0.95f);
    protected SurfaceModel.PlotColor color_mode = SurfaceModel.PlotColor.SPECTRUM;
    protected SurfaceModel.PlotType plot_mode = SurfaceModel.PlotType.CONTOUR;

    public ColorModelSet() {
        this.dualshade = new ColorModel(0, RED_H, RED_S, RED_B, 0.4f, 1.0f);
        this.grayscale = new ColorModel(0, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        this.spectrum = new ColorModel(1, 0.0f, 1.0f, 1.0f, 0.0f, 0.6666f);
        this.fog = new ColorModel(2, RED_H, RED_S, RED_B, 0.0f, 1.0f);
        this.opaque = new ColorModel(3, RED_S, 0.1f, 1.0f, 0.0f, 0.0f);
        this.alt_dualshade = new ColorModel(0, GOLD_H, GOLD_S, GOLD_B, 0.4f, 1.0f);
        this.alt_grayscale = new ColorModel(0, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        this.alt_spectrum = new ColorModel(1, 0.0f, 1.0f, 0.8f, 0.0f, 0.6666f);
        this.alt_fog = new ColorModel(2, GOLD_H, 0.0f, GOLD_B, 0.0f, 1.0f);
        this.alt_opaque = new ColorModel(3, GOLD_H, 0.1f, 1.0f, 0.0f, 0.0f);
    }

    public void setPlotColor(SurfaceModel.PlotColor v) {
        this.color_mode = v;
    }

    public void setPlotType(SurfaceModel.PlotType type) {
        this.plot_mode = type;
    }

    @Override
    public Color getBackgroundColor() {
        return this.bkgColor;
    }

    @Override
    public Color getLineBoxColor() {
        return this.lineboxColor;
    }

    @Override
    public Color getBoxColor() {
        return this.boxColor;
    }

    @Override
    public Color getLineColor() {
        return this.lineColor;
    }

    @Override
    public Color getTextColor() {
        return this.textColor;
    }

    @Override
    public Color getFillColor() {
        return this.fillColor;
    }

    @Override
    public Color getLineColor(int curve, float z) {
        return this.lineColor;
    }

    @Override
    public Color getPolygonColor(int curve, float z) {
        if (curve == 1) {
            return this.getFirstPolygonColor(z);
        }
        if (curve == 2) {
            return this.getSecondPolygonColor(z);
        }
        return Color.blue;
    }

    @Override
    public Color getFirstPolygonColor(float z) {
        if ((this.plot_mode == SurfaceModel.PlotType.CONTOUR || this.plot_mode == SurfaceModel.PlotType.DENSITY) && this.color_mode == SurfaceModel.PlotColor.OPAQUE) {
            return this.dualshade.getPolygonColor(z);
        }
        switch (this.color_mode) {
            case OPAQUE: {
                return this.opaque.getPolygonColor(z);
            }
            case GRAYSCALE: {
                return this.grayscale.getPolygonColor(z);
            }
            case SPECTRUM: {
                return this.spectrum.getPolygonColor(z);
            }
            case DUALSHADE: {
                return this.dualshade.getPolygonColor(z);
            }
            case FOG: {
                return this.fog.getPolygonColor(z);
            }
        }
        return Color.blue;
    }

    @Override
    public Color getSecondPolygonColor(float z) {
        if ((this.plot_mode == SurfaceModel.PlotType.CONTOUR || this.plot_mode == SurfaceModel.PlotType.DENSITY) && this.color_mode == SurfaceModel.PlotColor.OPAQUE) {
            return this.alt_dualshade.getPolygonColor(z);
        }
        switch (this.color_mode) {
            case OPAQUE: {
                return this.alt_opaque.getPolygonColor(z);
            }
            case GRAYSCALE: {
                return this.alt_grayscale.getPolygonColor(z);
            }
            case SPECTRUM: {
                return this.alt_spectrum.getPolygonColor(z);
            }
            case DUALSHADE: {
                return this.alt_dualshade.getPolygonColor(z);
            }
            case FOG: {
                return this.alt_fog.getPolygonColor(z);
            }
        }
        return Color.blue;
    }

    @Override
    public void setBackgroundColor(Color c) {
        this.bkgColor = c;
    }

    @Override
    public void setBoxColor(Color c) {
        this.boxColor = c;
    }

    @Override
    public void setLineBoxColor(Color c) {
        this.lineboxColor = c;
    }

    @Override
    public void setLineColor(Color c) {
        this.lineColor = c;
    }

    @Override
    public void setTextColor(Color c) {
        this.textColor = c;
    }

    @Override
    public void setFillColor(Color c) {
        this.fillColor = c;
    }
}

