/*
 * Decompiled with CFR 0.152.
 */
package jplot.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import jplot.GraphSettings;
import jplot.JPlot;
import jplot.Utils;
import jplot.panels.PanelGridUI;

public class PanelScaling
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JDialog dialog;
    private JCheckBox[] cb_auto = new JCheckBox[2];
    private JCheckBox[] cb_manu = new JCheckBox[2];
    private JCheckBox[] cb_log = new JCheckBox[2];
    private JCheckBox[] cb_lin = new JCheckBox[2];
    private JTextField[] to = new JTextField[2];
    private JTextField[] from = new JTextField[2];
    private GraphSettings gs;
    private JPlot jplot;

    public PanelScaling(JPlot jp, GraphSettings gs) {
        this.gs = gs;
        this.jplot = jp;
        this.dialog = null;
        this.setLayout(new BoxLayout(this, 1));
        int k = 0;
        while (true) {
            if (k >= 2) break;
            this.add(this.getPanel(k));
            ++k;
        }
    }

    private PanelGridUI getPanel(final int axis) {
        String labelText = axis == 0 ? "X-scaling:" : "Y-scaling:";
        PanelGridUI p = new PanelGridUI();
        p.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        Dimension cbField = new Dimension(110, 20);
        Dimension shortField = new Dimension(80, 22);
        ButtonGroup bg = new ButtonGroup();
        this.cb_lin[axis] = new JCheckBox("linear", !this.gs.useLogScale(axis));
        this.cb_lin[axis].setPreferredSize(cbField);
        bg.add(this.cb_lin[axis]);
        this.cb_log[axis] = new JCheckBox("logarithmic", this.gs.useLogScale(axis));
        this.cb_log[axis].setPreferredSize(cbField);
        bg.add(this.cb_log[axis]);
        bg = new ButtonGroup();
        this.cb_auto[axis] = new JCheckBox("automatic", this.gs.autoRange(axis));
        this.cb_auto[axis].setPreferredSize(cbField);
        this.cb_auto[axis].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelScaling.this.from[axis].setEnabled(false);
                PanelScaling.this.to[axis].setEnabled(false);
            }
        });
        bg.add(this.cb_auto[axis]);
        this.cb_manu[axis] = new JCheckBox("manual", !this.gs.autoRange(axis));
        this.cb_manu[axis].setPreferredSize(cbField);
        this.cb_manu[axis].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelScaling.this.from[axis].setEnabled(true);
                PanelScaling.this.to[axis].setEnabled(true);
            }
        });
        bg.add(this.cb_manu[axis]);
        JPanel fromPanel = new JPanel(new BorderLayout());
        fromPanel.add((Component)Utils.makeLabel("from"), "West");
        this.from[axis] = new JTextField(new Float(this.gs.getMinValue(axis)).toString());
        this.from[axis].setEnabled(this.cb_manu[axis].isSelected());
        fromPanel.add((Component)this.from[axis], "Center");
        fromPanel.setPreferredSize(shortField);
        JPanel toPanel = new JPanel(new BorderLayout());
        toPanel.add((Component)Utils.makeLabel("to"), "West");
        this.to[axis] = new JTextField(new Float(this.gs.getMaxValue(axis)).toString());
        this.to[axis].setEnabled(this.cb_manu[axis].isSelected());
        toPanel.add((Component)this.to[axis], "Center");
        toPanel.setPreferredSize(shortField);
        EmptyBorder border = new EmptyBorder(new Insets(0, 0, 0, 10));
        JLabel label = new JLabel(labelText);
        label.setBorder(border);
        p.addComponent(label, 1, 1);
        p.addComponent(this.cb_lin[axis], 1, 2);
        p.addComponent(this.cb_log[axis], 1, 3);
        p.addComponent(this.cb_auto[axis], 4, 2);
        p.addComponent(this.cb_manu[axis], 4, 3);
        p.addFilledComponent(fromPanel, 5, 2);
        p.addFilledComponent(toPanel, 5, 3);
        return p;
    }

    public void showIt(Frame parent, int x, int y) {
        if (this.dialog == null) {
            this.dialog = new JDialog(parent, "Scaling options", false);
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    PanelScaling.this.dialog.dispose();
                }
            });
            JPanel p = new JPanel(new FlowLayout());
            p.setBorder(BorderFactory.createEtchedBorder());
            JButton b = new JButton("Apply");
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PanelScaling.this.setValues();
                    PanelScaling.this.gs.setDataChanged(true);
                    PanelScaling.this.jplot.updateGraphIfShowing();
                }
            });
            p.add(b);
            b = new JButton("Dismiss");
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PanelScaling.this.dialog.dispose();
                }
            });
            p.add(b);
            this.dialog.getContentPane().add((Component)this, "Center");
            this.dialog.getContentPane().add((Component)p, "South");
            this.dialog.setLocation(x, y);
            this.dialog.pack();
        }
        this.refresh();
        this.dialog.setVisible(true);
    }

    public void refresh() {
        int axis = 0;
        while (true) {
            if (axis >= 2) break;
            this.cb_auto[axis].setSelected(this.gs.autoRange(axis));
            this.cb_manu[axis].setSelected(!this.gs.autoRange(axis));
            this.from[axis].setText(Float.toString((float)this.gs.getMinValue(axis)));
            this.from[axis].setEnabled(!this.cb_auto[axis].isSelected());
            this.to[axis].setText(Float.toString((float)this.gs.getMaxValue(axis)));
            this.to[axis].setEnabled(!this.cb_auto[axis].isSelected());
            this.cb_log[axis].setSelected(this.gs.useLogScale(axis));
            this.cb_lin[axis].setSelected(!this.gs.useLogScale(axis));
            ++axis;
        }
    }

    public void setValues() {
        int k = 0;
        while (true) {
            if (k >= 2) break;
            this.gs.setAutoRange(k, this.cb_auto[k].isSelected());
            this.gs.setUseLogScale(k, this.cb_log[k].isSelected());
            if (!this.cb_auto[k].isSelected()) {
                if (!this.from[k].getText().equals("")) {
                    this.gs.setMinValue(k, new Double(this.from[k].getText()));
                }
                if (!this.to[k].getText().equals("")) {
                    this.gs.setMaxValue(k, new Double(this.to[k].getText()));
                }
                if (this.cb_log[k].isSelected() && (this.gs.getMinValue(k) <= 0.0 || this.gs.getMaxValue(k) <= 0.0)) {
                    Utils.bummer(this.jplot.frame, "Don't do this!\nLogarithmic axes require positive data.\n Ignoring...\n");
                    this.gs.setUseLogScale(k, false);
                }
            }
            ++k;
        }
    }
}

