/*
 * Decompiled with CFR 0.152.
 */
package jplot.panels;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import jplot.GraphSettings;
import jplot.Utils;
import jplot.panels.PanelSeeOption;

public class PanelColor
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Color result;
    private Color selectedColor;
    private SmallColorPreview smallColorPreview;
    private ColorSwatches swatches;
    private JDialog dialog;
    private JColorChooser colorChooser;
    private Frame parent;

    public PanelColor(Frame fr) {
        this.parent = fr;
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new TitledBorder(new EtchedBorder(), "Colors"));
        JPanel p = new JPanel();
        this.swatches = new ColorSwatches();
        p.add(this.swatches);
        this.add(p);
        this.colorChooser = Utils.getColorChooser();
        JButton ccButton = new JButton("Custom...");
        ccButton.setPreferredSize(new Dimension(65, 26));
        ccButton.setMargin(new Insets(1, 1, 1, 1));
        ccButton.setFont(new Font("SansSerif", 0, 11));
        ccButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelColor.this.colorChooser.setColor(PanelColor.this.selectedColor);
                Color c = JColorChooser.showDialog(PanelColor.this.parent, "Color Chooser", PanelColor.this.selectedColor);
                if (c != null) {
                    PanelColor.this.setSelectedColor(c);
                    PanelColor.this.swatches.resetBackgrounds();
                }
            }
        });
        p = new JPanel();
        p.add(ccButton);
        this.add(p);
        this.smallColorPreview = new SmallColorPreview(36, 17);
        p = new JPanel();
        p.add(this.smallColorPreview);
        this.add(p);
    }

    public PanelColor(Frame parent, Color c) {
        this(parent);
        this.refresh(c);
    }

    public void refresh(Color c) {
        this.setSelectedColor(c);
        int index = this.swatches.findSwatchIndex(c);
        if (index > -1) {
            this.swatches.setSelectedSwatch(index);
        }
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    public void setSelectedColor(Color c) {
        this.selectedColor = c;
        this.smallColorPreview.repaint();
    }

    public Color show(Frame parent, Color c, int x, int y) {
        if (this.dialog == null) {
            JPanel panel = new JPanel(new BorderLayout());
            this.dialog = new JDialog(parent, "Color chooser", true);
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    PanelColor.this.dialog.dispose();
                }
            });
            JPanel p = new JPanel(new FlowLayout());
            p.setBorder(BorderFactory.createEtchedBorder());
            JButton b = new JButton("Apply");
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PanelColor.this.result = PanelColor.this.selectedColor;
                    PanelColor.this.dialog.dispose();
                }
            });
            p.add(b);
            b = new JButton("Cancel");
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PanelColor.this.result = null;
                    PanelColor.this.dialog.dispose();
                }
            });
            p.add(b);
            panel.add((Component)this, "Center");
            panel.add((Component)p, "South");
            this.dialog.getContentPane().add(panel);
            this.dialog.setLocation(x, y);
            this.dialog.pack();
        }
        this.refresh(c);
        this.dialog.setVisible(true);
        return this.result;
    }

    class SmallColorPreview
    extends JPanel {
        private static final long serialVersionUID = 1L;
        protected Dimension panelSize;
        int height;
        int width;

        public SmallColorPreview(int width, int height) {
            this.setOpaque(true);
            this.setRequestFocusEnabled(false);
            this.width = width;
            this.height = height;
        }

        @Override
        public void paintComponent(Graphics g) {
            g.setColor(PanelColor.this.getSelectedColor());
            g.fillRect(0, 0, this.width, this.height);
            g.setColor(Color.white);
            g.drawLine(0, this.height - 1, this.width - 1, this.height - 1);
            g.drawLine(this.width - 1, 0, this.width - 1, this.height - 1);
            g.setColor(Color.black);
            g.drawLine(0, 0, this.width - 1, 0);
            g.drawLine(0, 0, 0, this.height - 1);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.width, this.height);
        }
    }

    class ColorSwatches
    extends PanelSeeOption {
        private static final long serialVersionUID = 1L;
        int index;

        public ColorSwatches() {
            if (PanelColor.this.selectedColor != null) {
                this.index = this.findSwatchIndex(PanelColor.this.selectedColor);
                if (this.index > -1) {
                    this.setSelectedSwatch(this.index);
                }
            }
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 1) {
                        ColorSwatches.this.index = ColorSwatches.this.getIndex(e.getX(), e.getY());
                        ColorSwatches.this.setSelectedSwatch(ColorSwatches.this.index);
                        Color[] cc = GraphSettings.getColors();
                        PanelColor.this.setSelectedColor(cc[ColorSwatches.this.index]);
                    }
                }
            });
        }

        public int findSwatchIndex(Color c) {
            for (int i = 0; i < GraphSettings.getColors().length; ++i) {
                Color[] cc = GraphSettings.getColors();
                if (!c.equals(cc[i])) continue;
                return i;
            }
            return -1;
        }

        @Override
        protected void initValues() {
            this.soptionSize = new Dimension(14, 14);
            this.numSOption = new Dimension(4, 5);
        }

        @Override
        protected void paintIt(Graphics2D g2, int column, int row, int x, int y) {
            Color[] cc = GraphSettings.getColors();
            g2.setColor(cc[this.getIndex(x, y)]);
            g2.fillRect(x, y, this.soptionSize.width, this.soptionSize.height);
        }

        @Override
        public String getToolTipText(MouseEvent e) {
            int i = this.getIndex(e.getX(), e.getY());
            Color[] cc = GraphSettings.getColors();
            if (i >= 0 && i < this.Ns) {
                return cc[i].getRed() + "," + cc[i].getGreen() + "," + cc[i].getBlue();
            }
            return "";
        }
    }
}

