/*
 * Decompiled with CFR 0.152.
 */
package jplot;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.net.URL;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jplot.JPlot;
import jplot.LinePars;
import jplot.LineStyle;
import jplot.MyUtils;
import jplot.SmallColorPreview;
import jplot.SmallScrollPane;
import jplot.SmallToggleButton;
import jplot.Utils;
import jplot.panels.PanelColor;
import jplot.panels.PanelDash;
import jplot.panels.PanelGridUI;
import jplot.panels.PanelPoint;

public class StyleChooser
implements Serializable {
    private static final long serialVersionUID = 1L;
    private LinePars lp;
    private LineStyle lineStyle;
    private JDialog chooser;
    private SmallToggleButton b1;
    private SmallToggleButton b2;
    private SmallToggleButton b3;
    private SmallToggleButton b4;
    private ImageIcon icon1;
    private ImageIcon icon2;
    private ImageIcon icon3;
    private PanelDash dashPanel;
    private PanelPoint pointPanel;
    private PanelColor colorPanel;
    private PanelColor popupColorPanel;
    private JPanel chooserPanel;
    private JPlot jplot;
    private SmallColorPreview startColorPreview;
    private SmallColorPreview endColorPreview;
    private SmallColorPreview fillColorPreview;
    private JButton b_startColor;
    private JButton b_endColor;
    private JButton b_fillColor;
    private JRadioButton rb_slideColor;
    boolean actionNeeded;
    private SmallScrollPane ssp;
    private SmallScrollPane sspSys;
    String[] ten = new String[]{"10", "9", "8", "7", "6", "5", "4", "3", "2", "1"};
    private JCheckBox cb_show;
    private JCheckBox cb_hide;
    private JCheckBox errX_show;
    private JCheckBox errX_hide;
    private JCheckBox errY_show;
    private JCheckBox errY_hide;
    private JCheckBox errSysX_show;
    private JCheckBox errSysX_hide;
    private JCheckBox errSysY_show;
    private JCheckBox errSysY_hide;
    private Color selectedColor;
    private JColorChooser colorChooser;
    private JTextField legendName;
    private JTextField divider;
    private JTextField additioner;
    private Frame frame;
    private String title;
    private boolean isGlobal;

    public StyleChooser(Frame f, String title, LinePars lp, JPlot jp, boolean global) {
        this.frame = f;
        this.title = title;
        this.isGlobal = global;
        this.jplot = jp;
        this.lp = lp != null ? lp : new LinePars();
        this.chooser = null;
    }

    public StyleChooser(Frame f, String title, LinePars lp) {
        this(f, title, lp, null, false);
    }

    public StyleChooser(Frame f, String title, boolean global) {
        this(f, title, null, null, global);
    }

    public StyleChooser(Frame f, String title) {
        this(f, title, null, null, false);
    }

    private ImageIcon getImageIcon(String name) {
        ImageIcon im = null;
        try {
            URL imageURL = this.getClass().getResource("/images/" + name);
            Toolkit tk = Toolkit.getDefaultToolkit();
            im = new ImageIcon(tk.createImage(imageURL));
        }
        catch (Exception e) {
            Utils.oops(null, "Impossible to load JPlot's icon '" + name + "'.\nSomething's wrong with the installation.");
        }
        return im;
    }

    private void getChooserPanel() {
        this.chooserPanel = new JPanel(new BorderLayout());
        Insets insets = new Insets(0, 0, 0, 0);
        JPanel mainPanel = new JPanel(new BorderLayout());
        JPanel north = new JPanel(new BorderLayout());
        JPanel p = new JPanel();
        north.setBorder(new TitledBorder(new EtchedBorder(), "Styles"));
        ImageIcon icon = this.getImageIcon("plot1.png");
        this.b1 = new SmallToggleButton(false, icon, null, "Line connecting points");
        this.b1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StyleChooser.this.lp;
                StyleChooser.this.setGraphStyles(0);
            }
        });
        this.b1.setMargin(insets);
        p.add(this.b1);
        icon = this.getImageIcon("plot2.png");
        this.b2 = new SmallToggleButton(false, icon, null, "Histogram");
        this.b2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StyleChooser.this.lp;
                StyleChooser.this.setGraphStyles(1);
            }
        });
        this.b2.setMargin(insets);
        p.add(this.b2);
        icon = this.getImageIcon("plot3.png");
        this.b3 = new SmallToggleButton(false, icon, null, "Bar graph");
        this.b3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StyleChooser.this.lp;
                StyleChooser.this.setGraphStyles(2);
            }
        });
        this.b3.setMargin(insets);
        p.add(this.b3);
        north.add((Component)p, "West");
        icon = this.getImageIcon("plot4.png");
        this.b4 = new SmallToggleButton(false, icon, null, "Fill color");
        this.b4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StyleChooser.this.b_fillColor.setEnabled(StyleChooser.this.b4.isSelected());
            }
        });
        this.b4.setMargin(insets);
        p = new JPanel();
        p.add(this.b4);
        this.fillColorPreview = new SmallColorPreview(this.lp.getFillColor(), 32, 17);
        p.add(this.fillColorPreview);
        this.b_fillColor = new JButton(this.getImageIcon("color.jpg"));
        this.b_fillColor.setMargin(insets);
        this.b_fillColor.setToolTipText("Text color");
        this.b_fillColor.setSelected(false);
        this.b_fillColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color;
                if (StyleChooser.this.popupColorPanel == null) {
                    StyleChooser.this.popupColorPanel = new PanelColor(StyleChooser.this.frame);
                }
                if ((color = StyleChooser.this.popupColorPanel.show(StyleChooser.this.frame, StyleChooser.this.lp.getFillColor(), 100, 100)) != null) {
                    StyleChooser.this.fillColorPreview.setColor(color);
                }
            }
        });
        p.add(this.b_fillColor);
        north.add((Component)p, "East");
        mainPanel.add((Component)north, "North");
        this.dashPanel = new PanelDash(this.lp);
        mainPanel.add((Component)this.dashPanel, "West");
        this.pointPanel = new PanelPoint(this.lp);
        mainPanel.add((Component)this.pointPanel, "Center");
        this.colorPanel = new PanelColor(this.frame, this.lp.getColor());
        mainPanel.add((Component)this.colorPanel, "East");
        PanelGridUI legend = null;
        PanelGridUI global = null;
        if (!this.isGlobal) {
            legend = new PanelGridUI();
            legend.setBorder(new TitledBorder(new EtchedBorder(), "Legend label"));
            this.legendName = new JTextField(this.lp.getName());
            legend.addFilledComponent(this.legendName, 1, 1, 2, 1, 2);
            ButtonGroup bg = new ButtonGroup();
            this.cb_show = this.createCheckBox("show ", this.lp.drawLegend());
            bg.add(this.cb_show);
            legend.addComponent(this.cb_show, 1, 3);
            this.cb_hide = this.createCheckBox("hide ", !this.lp.drawLegend());
            bg.add(this.cb_hide);
            legend.addComponent(this.cb_hide, 1, 4);
        } else {
            global = new PanelGridUI();
            global.setBorder(new TitledBorder(new EtchedBorder(), "Global options"));
            this.rb_slideColor = new JRadioButton("slide color");
            this.rb_slideColor.setSelected(false);
            this.rb_slideColor.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StyleChooser.this.b_startColor.setEnabled(StyleChooser.this.rb_slideColor.isSelected());
                    StyleChooser.this.b_endColor.setEnabled(StyleChooser.this.rb_slideColor.isSelected());
                }
            });
            global.addComponent(this.rb_slideColor, 1, 1);
            this.b_startColor = new JButton(this.getImageIcon("color.jpg"));
            this.b_startColor.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color color;
                    if (StyleChooser.this.popupColorPanel == null) {
                        StyleChooser.this.popupColorPanel = new PanelColor(StyleChooser.this.frame);
                    }
                    if ((color = StyleChooser.this.popupColorPanel.show(StyleChooser.this.frame, StyleChooser.this.lp.getStartColor(), 100, 100)) != null) {
                        StyleChooser.this.startColorPreview.setColor(color);
                    }
                }
            });
            this.b_startColor.setMargin(new Insets(0, 0, 0, 0));
            this.b_startColor.setToolTipText("Change the start color");
            this.startColorPreview = new SmallColorPreview(this.lp.getStartColor(), 40, 18);
            p = new JPanel(new FlowLayout());
            p.add(this.startColorPreview);
            p.add(this.b_startColor);
            JLabel label = new JLabel("Start:");
            global.addComponent(label, 1, 2);
            global.addComponent(p, 1, 3);
            this.b_endColor = new JButton(this.getImageIcon("color.jpg"));
            this.b_endColor.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color color;
                    if (StyleChooser.this.popupColorPanel == null) {
                        StyleChooser.this.popupColorPanel = new PanelColor(StyleChooser.this.frame);
                    }
                    if ((color = StyleChooser.this.popupColorPanel.show(StyleChooser.this.frame, StyleChooser.this.lp.getEndColor(), 100, 100)) != null) {
                        StyleChooser.this.endColorPreview.setColor(color);
                    }
                }
            });
            this.b_endColor.setMargin(new Insets(0, 0, 0, 0));
            this.b_endColor.setToolTipText("Change the end color");
            this.endColorPreview = new SmallColorPreview(this.lp.getEndColor(), 40, 18);
            p = new JPanel(new FlowLayout());
            p.add(this.endColorPreview);
            p.add(this.b_endColor);
            label = new JLabel("End:");
            global.addComponent(label, 1, 4);
            global.addComponent(p, 1, 5);
        }
        JPanel scaling = new JPanel(new FlowLayout());
        scaling.setBorder(new TitledBorder(new EtchedBorder(), "Scaling"));
        this.divider = new JTextField(Float.toString(1.0f / this.lp.getMultiplier()));
        this.divider.setPreferredSize(new Dimension(65, 24));
        scaling.add(new JLabel("divide by:"));
        scaling.add(this.divider);
        this.additioner = new JTextField(Float.toString(this.lp.getAdditioner()));
        this.additioner.setPreferredSize(new Dimension(50, 24));
        scaling.add(new JLabel("offset:"));
        scaling.add(this.additioner);
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        if (!this.isGlobal) {
            p.add(legend);
        } else {
            p.add(global);
        }
        JPanel errors = new JPanel(new FlowLayout());
        errors.setBorder(new TitledBorder(new EtchedBorder(), "1st level errors"));
        errors.setLayout(new GridLayout(3, 1));
        JPanel errors1 = new JPanel(new FlowLayout());
        JPanel errors2 = new JPanel(new FlowLayout());
        JPanel errors3 = new JPanel(new FlowLayout());
        errors.add(errors1);
        errors.add(errors2);
        errors.add(errors3);
        errors1.add(MyUtils.getLabel("pen width"));
        errors1.add(Box.createHorizontalStrut(4));
        this.ssp = new SmallScrollPane(this.ten);
        this.ssp.setSelectedIndex(this.ten.length - (int)this.lp.getPenWidthErr());
        this.ssp.getViewport().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                StyleChooser.this.lp.setPenWidthErr(Float.parseFloat(StyleChooser.this.ten[StyleChooser.this.ssp.getSelectedIndex()]));
            }
        });
        errors1.add(this.ssp);
        final Color colX = this.lp.getColorErrorsX();
        JButton cButton = new JButton("Custom...");
        cButton.setPreferredSize(new Dimension(65, 26));
        cButton.setMargin(new Insets(1, 1, 1, 1));
        cButton.setFont(new Font("SansSerif", 0, 11));
        cButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c = JColorChooser.showDialog(StyleChooser.this.frame, "Dialog Title", colX);
                if (c != null) {
                    StyleChooser.this.lp.setColorErrorsX(c);
                    StyleChooser.this.lp.setColorErrorsY(c);
                }
            }
        });
        errors1.add(cButton);
        ButtonGroup errX_bg = new ButtonGroup();
        this.errX_show = this.createCheckBox("show on X", this.lp.errorsShowX);
        errX_bg.add(this.errX_show);
        errors2.add(this.errX_show);
        this.errX_hide = this.createCheckBox("hide on X", !this.lp.errorsShowX);
        errX_bg.add(this.errX_hide);
        errors2.add(this.errX_hide);
        ButtonGroup errY_bg = new ButtonGroup();
        this.errY_show = this.createCheckBox("show on Y", this.lp.errorsShowY);
        errY_bg.add(this.errY_show);
        errors3.add(this.errY_show);
        this.errY_hide = this.createCheckBox("hide on Y", !this.lp.errorsShowY);
        errY_bg.add(this.errY_hide);
        errors3.add(this.errY_hide);
        p.add(errors);
        JPanel errorsSys = new JPanel(new FlowLayout());
        errorsSys.setBorder(new TitledBorder(new EtchedBorder(), "2nd level errors"));
        errorsSys.setLayout(new GridLayout(3, 1));
        JPanel errorsSys1 = new JPanel(new FlowLayout());
        JPanel errorsSys2 = new JPanel(new FlowLayout());
        JPanel errorsSys3 = new JPanel(new FlowLayout());
        errorsSys.add(errorsSys1);
        errorsSys.add(errorsSys2);
        errorsSys.add(errorsSys3);
        errorsSys1.add(MyUtils.getLabel("pen width"));
        errorsSys1.add(Box.createHorizontalStrut(4));
        this.sspSys = new SmallScrollPane(this.ten);
        this.sspSys.setSelectedIndex(this.ten.length - (int)this.lp.getPenWidthErrSys());
        this.sspSys.getViewport().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                StyleChooser.this.lp.setPenWidthErrSys(Float.parseFloat(StyleChooser.this.ten[StyleChooser.this.sspSys.getSelectedIndex()]));
            }
        });
        errorsSys1.add(this.sspSys);
        final Color colSysX = this.lp.getColorErrorsSysX();
        JButton ccButton = new JButton("Custom...");
        ccButton.setPreferredSize(new Dimension(65, 26));
        ccButton.setMargin(new Insets(1, 1, 1, 1));
        ccButton.setFont(new Font("SansSerif", 0, 11));
        ccButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c = JColorChooser.showDialog(StyleChooser.this.frame, "Dialog Title", colSysX);
                if (c != null) {
                    StyleChooser.this.lp.setColorErrorsSysX(c);
                    StyleChooser.this.lp.setColorErrorsSysY(c);
                }
            }
        });
        errorsSys1.add(ccButton);
        ButtonGroup errSysX_bg = new ButtonGroup();
        this.errSysX_show = this.createCheckBox("show on X", this.lp.errorsShowX);
        errSysX_bg.add(this.errSysX_show);
        errorsSys2.add(this.errSysX_show);
        this.errSysX_hide = this.createCheckBox("hide on X", !this.lp.errorsShowX);
        errSysX_bg.add(this.errSysX_hide);
        errorsSys2.add(this.errSysX_hide);
        ButtonGroup errSysY_bg = new ButtonGroup();
        this.errSysY_show = this.createCheckBox("show on Y", this.lp.errorsShowSysY);
        errSysY_bg.add(this.errSysY_show);
        errorsSys3.add(this.errSysY_show);
        this.errSysY_hide = this.createCheckBox("hide on Y", !this.lp.errorsShowSysY);
        errSysY_bg.add(this.errSysY_hide);
        errorsSys3.add(this.errSysY_hide);
        p.add(errorsSys);
        mainPanel.add((Component)p, "South");
        this.chooserPanel.add((Component)mainPanel, "Center");
        p = new JPanel();
        p.setBorder(new EtchedBorder());
        JPanel buttons = new JPanel(new GridLayout(1, 2));
        JButton b = new JButton("Apply");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StyleChooser.this.lp.setColor(StyleChooser.this.colorPanel.getSelectedColor());
                if (StyleChooser.this.b4.isSelected()) {
                    StyleChooser.this.lp.fill(true);
                    StyleChooser.this.lp.setFillColor(StyleChooser.this.fillColorPreview.getColor());
                } else {
                    StyleChooser.this.lp.fill(false);
                }
                if (!StyleChooser.this.isGlobal) {
                    StyleChooser.this.lp.setName(StyleChooser.this.legendName.getText());
                    if (StyleChooser.this.cb_show.isSelected()) {
                        StyleChooser.this.lp.setDrawLegend(true);
                    } else {
                        StyleChooser.this.lp.setDrawLegend(false);
                    }
                    StyleChooser.this.lp.errorsX(false);
                    StyleChooser.this.lp.errorsY(false);
                    StyleChooser.this.lp.errorsSysX(false);
                    StyleChooser.this.lp.errorsSysY(false);
                    if (StyleChooser.this.errX_show.isSelected()) {
                        StyleChooser.this.lp.errorsX(true);
                    }
                    if (StyleChooser.this.errY_show.isSelected()) {
                        StyleChooser.this.lp.errorsY(true);
                    }
                    if (StyleChooser.this.errSysX_show.isSelected()) {
                        StyleChooser.this.lp.errorsSysX(true);
                    }
                    if (StyleChooser.this.errSysY_show.isSelected()) {
                        StyleChooser.this.lp.errorsSysY(true);
                    }
                    StyleChooser.this.lp.setDataChanged(true);
                } else if (StyleChooser.this.rb_slideColor.isSelected()) {
                    StyleChooser.this.lp.setSlideColor(StyleChooser.this.startColorPreview.getColor(), StyleChooser.this.endColorPreview.getColor());
                }
                if (!StyleChooser.this.divider.getText().equals("")) {
                    StyleChooser.this.lp.setMultiplier(1.0f / Float.parseFloat(StyleChooser.this.divider.getText()));
                } else {
                    StyleChooser.this.lp.setMultiplier(1.0f);
                }
                if (!StyleChooser.this.additioner.getText().equals("")) {
                    StyleChooser.this.lp.setAdditioner(Float.parseFloat(StyleChooser.this.additioner.getText()));
                } else {
                    StyleChooser.this.lp.setAdditioner(0.0f);
                }
                StyleChooser.this.lp.setDataChanged(true);
                if (StyleChooser.this.jplot != null) {
                    StyleChooser.this.jplot.updateGraphIfShowing();
                }
                StyleChooser.this.chooser.dispose();
            }
        });
        buttons.add(b);
        b = new JButton("Cancel");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StyleChooser.this.lp = null;
                StyleChooser.this.chooser.dispose();
            }
        });
        buttons.add(b);
        p.add(buttons);
        this.chooserPanel.add((Component)p, "South");
    }

    private JLabel makeLabel(String txt) {
        JLabel label = new JLabel(txt + " ");
        label.setVerticalAlignment(3);
        label.setHorizontalAlignment(0);
        label.setFont(new Font("SansSerif", 2, 11));
        label.setForeground(Color.black);
        return label;
    }

    private JCheckBox createCheckBox(String s, boolean b) {
        JCheckBox cb = new JCheckBox(" " + s + " ", b);
        cb.setFont(new Font("serif", 0, 12));
        cb.setHorizontalAlignment(2);
        return cb;
    }

    private void setGraphStyles(int type) {
        this.lp.setGraphStyle(type);
        this.b1.setSelected(type == 0);
        this.b2.setSelected(type == 1);
        this.b3.setSelected(type == 2);
        this.chooserPanel.repaint();
    }

    private void refresh() {
        this.setGraphStyles(this.lp.getGraphStyle());
        this.b4.setSelected(this.lp.fill());
        this.b_fillColor.setEnabled(this.lp.fill());
        this.dashPanel.refresh(this.lp);
        this.pointPanel.refresh(this.lp);
        this.colorPanel.refresh(this.lp.getColor());
        this.fillColorPreview.setColor(this.lp.getFillColor());
        this.divider.setText(Double.toString(1.0 / (double)this.lp.getMultiplier()));
        this.additioner.setText(Double.toString(this.lp.getAdditioner()));
        if (!this.isGlobal) {
            this.cb_show.setSelected(this.lp.drawLegend());
            this.cb_hide.setSelected(!this.lp.drawLegend());
            this.legendName.setText(this.lp.getName());
        } else {
            this.startColorPreview.setColor(this.lp.getStartColor());
            this.endColorPreview.setColor(this.lp.getEndColor());
            this.rb_slideColor.setSelected(this.lp.slideColor());
            this.b_startColor.setEnabled(this.rb_slideColor.isSelected());
            this.b_endColor.setEnabled(this.rb_slideColor.isSelected());
        }
    }

    public LinePars show(int x, int y, LinePars initLinePars) {
        this.lp = initLinePars == null ? new LinePars() : new LinePars(initLinePars);
        if (this.chooser == null) {
            this.chooser = new JDialog(this.frame, this.title, true);
            this.chooser.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    StyleChooser.this.lp = null;
                    StyleChooser.this.chooser.dispose();
                }
            });
            this.getChooserPanel();
            this.chooser.setLocation(x, y);
            this.chooser.getContentPane().add(this.chooserPanel);
            this.chooser.pack();
        }
        this.refresh();
        this.chooser.pack();
        this.chooser.setVisible(true);
        return this.lp;
    }
}

