/*
 * Decompiled with CFR 0.152.
 */
package jplot;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import jplot.GraphSettings;
import jplot.JPlot;
import jplot.Utils;
import jplot.panels.PanelGridUI;

public class PiperOptions
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JDialog dialog;
    private JCheckBox cb_showTds;
    private JCheckBox cb_hideTds;
    private JTextField scalingField;
    private GraphSettings gs;
    private JPlot jplot;

    public PiperOptions(JPlot jp, GraphSettings gs) {
        this.gs = gs;
        this.jplot = jp;
        this.dialog = null;
        PanelGridUI p = new PanelGridUI();
        p.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        Dimension cbField = new Dimension(110, 20);
        ButtonGroup bg = new ButtonGroup();
        this.cb_showTds = new JCheckBox("Show");
        bg.add(this.cb_showTds);
        this.cb_hideTds = new JCheckBox("Hide");
        bg.add(this.cb_hideTds);
        this.scalingField = new JTextField();
        this.scalingField.setColumns(6);
        JPanel scalingPanel = new JPanel(new BorderLayout());
        scalingPanel.add((Component)Utils.makeLabel("scaling"), "West");
        scalingPanel.add((Component)this.scalingField, "Center");
        EmptyBorder border = new EmptyBorder(new Insets(0, 0, 0, 10));
        JLabel label = new JLabel("Total Dissolved Solids:");
        label.setBorder(border);
        p.addComponent(label, 1, 1);
        p.addComponent(this.cb_showTds, 1, 2);
        p.addComponent(this.cb_hideTds, 1, 3);
        p.addComponent(scalingPanel, 2, 2);
        this.add(p);
    }

    public void refresh() {
        this.cb_showTds.setSelected(this.gs.drawTds());
        this.cb_hideTds.setSelected(!this.gs.drawTds());
        this.scalingField.setText(Float.toString(this.gs.getTdsFactor()));
    }

    public void setValues() {
        this.gs.setDrawTds(this.cb_showTds.isSelected());
        this.gs.setTdsFactor(Float.parseFloat(this.scalingField.getText()));
    }

    public void show(Frame parent, int x, int y) {
        if (this.dialog == null) {
            this.dialog = new JDialog(parent, "Piper diagram options", true);
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    PiperOptions.this.dialog.dispose();
                }
            });
            JPanel p = new JPanel(new FlowLayout());
            p.setBorder(BorderFactory.createEtchedBorder());
            JButton b = new JButton("Apply");
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PiperOptions.this.setValues();
                    PiperOptions.this.gs.setDataChanged(true);
                    PiperOptions.this.jplot.updateGraphIfShowing();
                    PiperOptions.this.dialog.dispose();
                }
            });
            p.add(b);
            b = new JButton("Dismiss");
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PiperOptions.this.dialog.dispose();
                }
            });
            p.add(b);
            this.dialog.getContentPane().add((Component)this, "Center");
            this.dialog.getContentPane().add((Component)p, "South");
            this.dialog.setLocation(x, y);
            this.dialog.pack();
        }
        this.refresh();
        this.dialog.setVisible(true);
    }
}

