/*
 * Decompiled with CFR 0.152.
 */
package jplot;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import jplot.LinePars;
import jplot.PlotPoint2D;
import jplot.Utils;

public class DataArray2D
extends LinePars {
    private static final long serialVersionUID = 1L;
    protected String title = " ";
    protected double meanX = 0.0;
    protected double meanY = 0.0;
    protected double meanZ = 0.0;
    protected int Ntot = 0;
    protected ArrayList<PlotPoint2D> points;
    protected double[] maxValue = new double[3];
    protected double[] minValue = new double[3];
    protected double[] lowestNonZeroValue = new double[3];

    public DataArray2D() {
        this.points = new ArrayList();
    }

    public DataArray2D(int size) {
        this.points = new ArrayList(size);
    }

    public void updateMinMax(double x, double y, double z) {
        if (x > this.maxValue[0]) {
            this.maxValue[0] = x;
        }
        if (x < this.minValue[0]) {
            this.minValue[0] = x;
        }
        if (x < this.lowestNonZeroValue[0] && x > 0.0) {
            this.lowestNonZeroValue[0] = x;
        }
        if (y > this.maxValue[1]) {
            this.maxValue[1] = y;
        }
        if (y < this.minValue[1]) {
            this.minValue[1] = y;
        }
        if (y < this.lowestNonZeroValue[1] && y > 0.0) {
            this.lowestNonZeroValue[1] = y;
        }
        if (z > this.maxValue[2]) {
            this.maxValue[2] = z;
        }
        if (z < this.minValue[2]) {
            this.minValue[2] = z;
        }
        if (z < this.lowestNonZeroValue[2] && z > 0.0) {
            this.lowestNonZeroValue[2] = z;
        }
    }

    public void updateMean(double x, double y, double z) {
        this.meanX += x;
        this.meanY += y;
        this.meanZ += z;
        ++this.Ntot;
    }

    public double meanX() {
        return this.meanX / (double)this.Ntot;
    }

    public double meanY() {
        return this.meanY / (double)this.Ntot;
    }

    public double meanZ() {
        return this.meanZ / (double)this.Ntot;
    }

    public void addPoint(double x, double y, double z) {
        this.updateMinMax(x, y, z);
        this.updateMean(x, y, z);
        this.points.add(new PlotPoint2D(x, y, z));
    }

    public void setPoint(int i, double x, double y, double z) {
        if (i >= 0 && i < this.points.size()) {
            this.updateMinMax(x, y, z);
            this.points.add(i, new PlotPoint2D(x, y, z));
        }
    }

    public PlotPoint2D getPoint(int i) {
        if (i >= 0 && i < this.points.size()) {
            return this.points.get(i);
        }
        return null;
    }

    public int size() {
        return this.points.size();
    }

    public ArrayList getData() {
        return this.points;
    }

    public double getX(int i) {
        if (i >= 0 && i < this.size()) {
            return this.points.get(i).getX();
        }
        return 1.0E300;
    }

    public double getY(int i) {
        if (i >= 0 && i < this.size()) {
            return this.points.get(i).getY();
        }
        return 1.0E300;
    }

    public double getZ(int i) {
        if (i >= 0 && i < this.size()) {
            return this.points.get(i).getZ();
        }
        return 1.0E300;
    }

    public double getMaxValue(int axis) {
        return this.maxValue[axis];
    }

    public double getMinValue(int axis) {
        return this.minValue[axis];
    }

    public double getLowestNonZeroValue(int axis) {
        return this.lowestNonZeroValue[axis];
    }

    public void clear() {
        if (this.points.size() > 0) {
            this.Ntot = 0;
            this.points.clear();
            for (int k = 0; k < 3; ++k) {
                this.maxValue[k] = -1.0E300;
                this.minValue[k] = 1.0E300;
                this.lowestNonZeroValue[k] = 1.0E300;
            }
        }
    }

    public void toFile(String name, String title) {
        DecimalFormat dfb = new DecimalFormat("##.########E00");
        Date dat = new Date();
        String today = String.valueOf(dat);
        this.title = title;
        try {
            FileOutputStream f1 = new FileOutputStream(new File(name));
            PrintStream tx = new PrintStream(f1);
            tx.println("# 3");
            tx.println("# jhplot: output data from P1D:" + title);
            tx.println("# jhplot: created at " + today);
            tx.println("# x,y,z");
            tx.println("#");
            for (int i = 0; i < this.size(); ++i) {
                String x = dfb.format(this.getX(i));
                String y = dfb.format(this.getY(i));
                String z = dfb.format(this.getZ(i));
                tx.println(x + " " + y + " " + z);
            }
            f1.close();
        }
        catch (IOException e) {
            System.out.println("Error in the output file");
            e.printStackTrace();
        }
    }

    public String getTitle() {
        return this.title;
    }

    public boolean parse(File file) {
        boolean res = false;
        try {
            BufferedReader in = new BufferedReader(new FileReader(file));
            res = this.parse(in);
            if (!res) {
                return false;
            }
        }
        catch (IOException e) {
            Utils.oops(null, "Can't parse data file " + file.toString());
            return false;
        }
        return true;
    }

    public boolean parse(BufferedReader in) {
        this.clear();
        try {
            String s;
            while ((s = in.readLine()) != null) {
                if ((s = s.trim()).length() < 1 || s.startsWith("#") || s.startsWith("*")) continue;
                StringTokenizer st = new StringTokenizer(s);
                int ncount = st.countTokens();
                double[] snum = new double[ncount];
                int mm = 0;
                while (st.hasMoreTokens()) {
                    String tmp = st.nextToken();
                    double dd = 0.0;
                    try {
                        dd = Double.parseDouble(tmp.trim());
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Error in reading the line " + Integer.toString(mm + 1));
                    }
                    snum[mm] = dd;
                    ++mm;
                }
                if (ncount != 3) continue;
                this.addPoint(snum[0], snum[1], snum[2]);
            }
        }
        catch (IOException e) {
            Utils.oops(null, "Can't parse data from BufferedReader");
            return false;
        }
        return true;
    }

    @Override
    public void print() {
        DecimalFormat dfb = new DecimalFormat("##.#####E00");
        Date dat = new Date();
        String today = String.valueOf(dat);
        System.out.println("");
        System.out.println("# jhplot: output from P2D " + this.title);
        System.out.println("# jhplot: created at " + today);
        System.out.println("# x,y,z");
        System.out.println("#");
        for (int i = 0; i < this.size(); ++i) {
            String x = dfb.format(this.getX(i));
            String y = dfb.format(this.getY(i));
            String z = dfb.format(this.getZ(i));
            System.out.println(x + "  " + y + "  " + z);
        }
    }
}

