/*
 * Decompiled with CFR 0.152.
 */
package jhplot.v3d;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Event;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import jhplot.v3d.Canvas3d;
import jhplot.v3d.Cone;
import jhplot.v3d.Cube;
import jhplot.v3d.Cylinder;
import jhplot.v3d.Matrix3d;
import jhplot.v3d.Model3d;
import jhplot.v3d.Prism;
import jhplot.v3d.Pyramid;
import jhplot.v3d.Sphere;
import jhplot.v3d.Vector3d;

class HViewPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Canvas3d canv;
    private Button[] but;
    private Matrix3d orot;
    private Matrix3d otrans;
    private Matrix3d oscale;
    private float ominScale;
    private float omaxScale;
    Model3d md = null;

    public HViewPanel() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder());
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        this.md = new Model3d(null, 400, 300);
        this.orot = new Matrix3d(this.md.rot);
        this.otrans = new Matrix3d(this.md.trans);
        this.oscale = new Matrix3d(this.md.scale);
        this.ominScale = this.md.minScale;
        this.omaxScale = this.md.maxScale;
        Vector3d vcyl = new Vector3d(40.0f, 0.0f, 0.0f);
        Cube cb3 = new Cube(this.md, 40.0f);
        cb3.setRot(45.0f, 45.0f, 45.0f);
        cb3.setTrans(vcyl.x, vcyl.y, vcyl.z);
        this.md.addObject(cb3);
        cb3 = new Cube(this.md, 40.0f);
        cb3.setRot(-25.0f, 25.0f, 40.0f);
        cb3.setTrans(10.0f, 10.0f, 10.0f);
        this.md.addObject(cb3);
        Sphere oo = new Sphere(this.md, 30.0f, 20, 20);
        oo.setTrans(vcyl.x, vcyl.y, vcyl.z);
        this.md.addObject(oo);
        Cone o = new Cone(this.md, 30.0f, 100, 50.0f);
        o.setTrans(-20.0f, 40.0f, 0.0f);
        o.setColor(Color.red);
        this.md.addObject(o);
        Vector3d[] v = new Vector3d[]{new Vector3d(0.0f, 0.0f, 0.0f), new Vector3d(6.0f, 0.0f, 0.0f), new Vector3d(6.0f, 1.0f, 0.0f), new Vector3d(0.0f, 1.0f, 0.0f)};
        Vector3d d = new Vector3d(0.0f, 6.0f, 6.0f);
        Prism o1 = new Prism(this.md, v, 4, d);
        o1.setTrans(-50.0f, 40.0f, 0.0f);
        this.md.addObject(o1);
        v[0] = new Vector3d(0.0f, 0.0f, 2.0f);
        v[1] = new Vector3d(6.0f, 0.0f, 2.0f);
        v[2] = new Vector3d(6.0f, 1.0f, 2.0f);
        v[3] = new Vector3d(0.0f, 1.0f, 2.0f);
        d = new Vector3d(3.0f, 0.5f, 4.0f);
        Pyramid p3 = new Pyramid(this.md, v, 4, d);
        p3.setTrans(30.0f, 20.0f, 0.0f);
        this.md.addObject(p3);
        Cylinder o3 = new Cylinder(this.md, 40.0f, 100, 2.0f);
        o3.setTrans(-1.0f, 0.0f, 0.0f);
        o3.setRot(0.0f, 90.0f, 0.0f);
        o3.setColor(Color.yellow);
        this.md.addObject(o3);
        this.canv = new Canvas3d(this.md);
        this.add("Center", this.canv);
        this.validate();
    }

    @Override
    public boolean action(Event evt, Object what) {
        if (this.md == null) {
            return false;
        }
        String s = (String)evt.arg;
        if (s.equals("Home")) {
            this.md.rot.copy(this.orot);
            this.md.trans.copy(this.otrans);
            if (this.md.persp) {
                this.md.minScale = this.ominScale;
                this.md.maxScale = this.omaxScale;
                this.md.computeMatrix();
            } else {
                this.md.scale.copy(this.oscale);
            }
        } else if (s.equals("XRot")) {
            this.md.incRot(10.0f, 0.0f, 0.0f);
        } else if (s.equals("YRot")) {
            this.md.incRot(0.0f, 10.0f, 0.0f);
        } else if (s.equals("ZRot")) {
            this.md.incRot(0.0f, 0.0f, 10.0f);
        } else if (s.equals("Left")) {
            this.md.incTrans(this.md.bb.getWidth() / 10.0f, 0.0f, 0.0f);
        } else if (s.equals("Right")) {
            this.md.incTrans(-this.md.bb.getWidth() / 10.0f, 0.0f, 0.0f);
        } else if (s.equals("Up")) {
            this.md.incTrans(0.0f, -this.md.bb.getHeight() / 10.0f, 0.0f);
        } else if (s.equals("Down")) {
            this.md.incTrans(0.0f, this.md.bb.getHeight() / 10.0f, 0.0f);
        } else if (s.equals("ZoomIn")) {
            if (this.md.persp) {
                this.md.minScale /= 1.1f;
                this.md.maxScale /= 1.1f;
                this.md.computeMatrix();
            } else {
                float f = 0.9090909f;
                this.md.incScale(f, f, f);
            }
        } else if (s.equals("ZoomOut")) {
            if (this.md.persp) {
                this.md.minScale *= 1.1f;
                this.md.maxScale *= 1.1f;
                this.md.computeMatrix();
            } else {
                float f = 1.1f;
                this.md.incScale(f, f, f);
            }
        } else {
            return false;
        }
        this.canv.repaint();
        return true;
    }
}

