/*
 * Decompiled with CFR 0.152.
 */
package jhplot.v3d;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import jhplot.v3d.Editor3d;
import jhplot.v3d.Matrix3d;
import jhplot.v3d.Model3d;
import jhplot.v3d.Vector3d;

public class Canvas3d
extends Canvas {
    private static final long serialVersionUID = 1L;
    private Model3d md;
    Image backBuffer;
    Graphics backGC;
    Dimension prefSize;
    Dimension minSize;
    boolean painted;
    private Color c = Color.white;
    private SelectionChangeMouseListener scml;
    protected JPopupMenu menu;
    public Matrix3d orot;
    public Matrix3d otrans;
    public Matrix3d oscale;
    public float ominScale;
    public float omaxScale;

    public Canvas3d(Model3d md) {
        if (md == null) {
            return;
        }
        this.md = md;
        this.prefSize = new Dimension(md.width, md.height);
        this.minSize = new Dimension(md.width / 2, md.height / 2);
        this.menu = new JPopupMenu();
        this.scml = new SelectionChangeMouseListener();
        this.addMouseListener(this.scml);
        this.addMouseMotionListener(this.scml);
        this.orot = new Matrix3d(md.rot);
        this.otrans = new Matrix3d(md.trans);
        this.oscale = new Matrix3d(md.scale);
        this.ominScale = md.minScale;
        this.omaxScale = md.maxScale;
        JMenuItem iedit = new JMenuItem("Edit ");
        this.menu.add(iedit);
        final Canvas3d cic = this;
        final Model3d mdm = md;
        iedit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new Editor3d(cic, mdm);
            }
        });
    }

    @Override
    public Dimension minimumSize() {
        return this.minSize;
    }

    @Override
    public Dimension preferredSize() {
        return this.prefSize;
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        this.backGC.setColor(this.c);
        this.backGC.fillRect(0, 0, this.size().width, this.size().height);
        if (this.md != null) {
            this.md.paint(this.backGC);
        }
        g.drawImage(this.backBuffer, 0, 0, this);
        this.setPainted();
    }

    synchronized void setPainted() {
        this.painted = true;
        this.notifyAll();
    }

    public void setColorBack(Color c) {
        this.c = c;
    }

    public Color getColorBack() {
        return this.c;
    }

    synchronized void waitPainted() {
        while (!this.painted) {
            try {
                this.wait();
            }
            catch (Exception exception) {}
        }
        this.painted = false;
    }

    @Override
    public void reshape(int x, int y, int width, int height) {
        super.reshape(x, y, width, height);
        this.backBuffer = this.createImage(width, height);
        this.backGC = this.backBuffer.getGraphics();
        if (this.md != null) {
            this.md.resize(width, height);
        }
    }

    void releaseModel() {
        this.md = null;
    }

    private class SelectionChangeMouseListener
    implements MouseMotionListener,
    MouseListener {
        private SelectionChangeMouseListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            Canvas3d.this.md.incTrans(((Canvas3d)Canvas3d.this).md.bb.getWidth() / 10.0f, 0.0f, 0.0f);
            Vector3d c = ((Canvas3d)Canvas3d.this).md.bb.getCenter();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if ((e.getModifiers() & 4) != 0 && e.getClickCount() == 1) {
                Canvas3d.this.menu.show(e.getComponent(), e.getX(), e.getY());
                return;
            }
        }
    }
}

