/*
 * Decompiled with CFR 0.152.
 */
package jhplot.stat;

import java.text.DecimalFormat;

class Spline {
    int n;
    int last_interval;
    double[] x;
    double[] f;
    double[] b;
    double[] c;
    double[] d;
    boolean uniform;
    boolean debug;

    public Spline(double[] xx, double[] ff) {
        int k;
        int i;
        double zero = 0.0;
        double two = 2.0;
        double three = 3.0;
        DecimalFormat f1 = new DecimalFormat("00.00000");
        boolean sorted = true;
        this.uniform = true;
        this.debug = false;
        this.last_interval = 0;
        this.n = xx.length;
        if (this.n <= 3) {
            System.out.println("not enough points to build spline, n=" + this.n);
            return;
        }
        if (this.n != ff.length) {
            System.out.println("not same number of x and f(x)");
            return;
        }
        this.x = new double[this.n];
        this.f = new double[this.n];
        this.b = new double[this.n];
        this.c = new double[this.n];
        this.d = new double[this.n];
        for (i = 0; i < this.n; ++i) {
            this.x[i] = xx[i];
            this.f[i] = ff[i];
            if (this.debug) {
                System.out.println("Spline data x[" + i + "]=" + this.x[i] + ", f[]=" + this.f[i]);
            }
            if (i < 1 || !(this.x[i] < this.x[i - 1])) continue;
            sorted = false;
        }
        if (!sorted) {
            if (this.debug) {
                System.out.println("sorting");
            }
            Spline.dHeapSort(this.x, this.f);
        }
        this.b[0] = this.x[1] - this.x[0];
        this.c[0] = (this.f[1] - this.f[0]) / this.b[0];
        if (this.n == 2) {
            this.b[0] = this.c[0];
            this.c[0] = 0.0;
            this.d[0] = 0.0;
            this.b[1] = this.b[0];
            this.c[1] = 0.0;
            return;
        }
        this.d[0] = 2.0 * this.b[0];
        for (i = 1; i < this.n - 1; ++i) {
            this.b[i] = this.x[i + 1] - this.x[i];
            if (Math.abs(this.b[i] - this.b[0]) / this.b[0] > 1.0E-5) {
                this.uniform = false;
            }
            this.c[i] = (this.f[i + 1] - this.f[i]) / this.b[i];
            this.d[i] = 2.0 * (this.b[i] + this.b[i - 1]);
        }
        this.d[this.n - 1] = 2.0 * this.b[this.n - 2];
        double fp1 = this.c[0] - this.b[0] * (this.c[1] - this.c[0]) / (this.b[0] + this.b[1]);
        if (this.n > 3) {
            fp1 += this.b[0] * ((this.b[0] + this.b[1]) * (this.c[2] - this.c[1]) / (this.b[1] + this.b[2]) - this.c[1] + this.c[0]) / (this.x[3] - this.x[0]);
        }
        double fpn = this.c[this.n - 2] + this.b[this.n - 2] * (this.c[this.n - 2] - this.c[this.n - 3]) / (this.b[this.n - 3] + this.b[this.n - 2]);
        if (this.n > 3) {
            fpn += this.b[this.n - 2] * (this.c[this.n - 2] - this.c[this.n - 3] - (this.b[this.n - 3] + this.b[this.n - 2]) * (this.c[this.n - 3] - this.c[this.n - 4]) / (this.b[this.n - 3] + this.b[this.n - 4])) / (this.x[this.n - 1] - this.x[this.n - 4]);
        }
        this.c[this.n - 1] = 3.0 * (fpn - this.c[this.n - 2]);
        for (i = this.n - 2; i > 0; --i) {
            this.c[i] = 3.0 * (this.c[i] - this.c[i - 1]);
        }
        this.c[0] = 3.0 * (this.c[0] - fp1);
        for (k = 1; k < this.n; ++k) {
            double p = this.b[k - 1] / this.d[k - 1];
            this.d[k] = this.d[k] - p * this.b[k - 1];
            this.c[k] = this.c[k] - p * this.c[k - 1];
        }
        this.c[this.n - 1] = this.c[this.n - 1] / this.d[this.n - 1];
        for (k = this.n - 2; k >= 0; --k) {
            this.c[k] = (this.c[k] - this.b[k] * this.c[k + 1]) / this.d[k];
        }
        double h = this.x[1] - this.x[0];
        for (i = 0; i < this.n - 1; ++i) {
            h = this.x[i + 1] - this.x[i];
            this.d[i] = (this.c[i + 1] - this.c[i]) / (3.0 * h);
            this.b[i] = (this.f[i + 1] - this.f[i]) / h - h * (this.c[i] + h * this.d[i]);
        }
        this.b[this.n - 1] = this.b[this.n - 2] + h * (2.0 * this.c[this.n - 2] + h * 3.0 * this.d[this.n - 2]);
        if (this.debug) {
            System.out.println("spline coefficients");
        }
        for (i = 0; i < this.n; ++i) {
            if (!this.debug) continue;
            System.out.println("i=" + i + ", b[i]=" + f1.format(this.b[i]) + ", c[i]=" + f1.format(this.c[i]) + ", d[i]=" + f1.format(this.d[i]));
        }
    }

    public double spline_value(double t) {
        if (this.n <= 1) {
            System.out.println("not enough points to compute value");
            return 0.0;
        }
        int interval = this.last_interval;
        if (t < this.x[0]) {
            System.out.println("requested point below Spline region");
            return 0.0;
        }
        if (t > this.x[this.n - 1]) {
            System.out.println("requested point above Spline region");
            return 0.0;
        }
        if (t > this.x[this.n - 2]) {
            interval = this.n - 2;
        } else if (t >= this.x[this.last_interval]) {
            int j = this.last_interval;
            while (j < this.n && t >= this.x[j]) {
                interval = j++;
            }
        } else {
            int j = this.last_interval;
            while (t < this.x[j]) {
                interval = j - 1;
                --j;
            }
        }
        this.last_interval = interval;
        if (this.debug) {
            System.out.println("interval=" + interval + ", x[interval]=" + this.x[interval] + ", t=" + t);
        }
        double dt = t - this.x[interval];
        double s = this.f[interval] + dt * (this.b[interval] + dt * (this.c[interval] + dt * this.d[interval]));
        return s;
    }

    public double integrate() {
        if (this.n <= 3) {
            System.out.println("not enough data to integrate");
            return 0.0;
        }
        if (!this.uniform) {
            if (this.debug) {
                System.out.println("non uniform spacing integration");
            }
            double t = 0.0;
            for (int i = 0; i < this.n - 1; ++i) {
                double dx = this.x[i + 1] - this.x[i];
                t += (this.f[i] + (this.b[i] / 2.0 + (this.c[i] / 3.0 + dx * this.d[i] / 4.0) * dx) * dx) * dx;
            }
            return t;
        }
        double suma = 0.0;
        double sumb = 0.0;
        double sumc = 0.0;
        double sumd = 0.0;
        for (int i = 0; i < this.n; ++i) {
            suma += this.d[i];
            sumb += this.c[i];
            sumc += this.b[i];
            sumd += this.f[i];
        }
        double dx = this.x[1] - this.x[0];
        double t = (sumd + (sumc / 2.0 + (sumb / 3.0 + dx * suma / 4.0) * dx) * dx) * dx;
        if (this.debug) {
            System.out.println("suma=" + suma + ", sumb=" + sumb + ",\n sumc=" + sumc + ", sumd=" + sumd);
        }
        return t;
    }

    static void dHeapSort(double[] key, double[] trail) {
        int index_val;
        int last_parent_pos;
        int nkey = key.length;
        int last_parent_index = last_parent_pos = (nkey - 2) / 2;
        if (nkey <= 1) {
            return;
        }
        for (index_val = last_parent_index; index_val >= 0; --index_val) {
            Spline.dremake_heap(key, trail, index_val, nkey - 1);
        }
        double tkey = key[0];
        key[0] = key[nkey - 1];
        key[nkey - 1] = tkey;
        double ttrail = trail[0];
        trail[0] = trail[nkey - 1];
        trail[nkey - 1] = ttrail;
        for (index_val = nkey - 2; index_val > 0; --index_val) {
            Spline.dremake_heap(key, trail, 0, index_val);
            tkey = key[0];
            key[0] = key[index_val];
            key[index_val] = tkey;
            ttrail = trail[0];
            trail[0] = trail[index_val];
            trail[index_val] = ttrail;
        }
    }

    static void dremake_heap(double[] key, double[] trail, int parent_index, int last_index) {
        int r_child;
        int l_child;
        int max_child_index;
        int last_parent_pos;
        int last_parent_index = last_parent_pos = (last_index - 1) / 2;
        int parent_temp = parent_index;
        while (parent_temp <= last_parent_index && key[max_child_index = (l_child = parent_temp * 2 + 1) == last_index ? l_child : (key[l_child] > key[r_child = l_child + 1] ? l_child : r_child)] > key[parent_temp]) {
            double tkey = key[max_child_index];
            key[max_child_index] = key[parent_temp];
            key[parent_temp] = tkey;
            double ttrail = trail[max_child_index];
            trail[max_child_index] = trail[parent_temp];
            trail[parent_temp] = ttrail;
            parent_temp = max_child_index;
        }
    }

    public static void main(String[] args) {
        double t;
        int n = 11;
        double[] xx = new double[n];
        double[] ff = new double[n];
        DecimalFormat f1 = new DecimalFormat("00.00000");
        System.out.println("Spline.java function definition");
        for (int i = 0; i < n; ++i) {
            xx[i] = -2.0 + 0.4 * (double)i;
            ff[i] = Math.pow(Math.cos(xx[i]), 4.0);
            System.out.println("i=" + i + ", x[i]=" + f1.format(xx[i]) + ", f(x[i])=" + f1.format(ff[i]));
        }
        Spline s11 = new Spline(xx, ff);
        System.out.println("interpolated values");
        for (int i = 0; i < 41; ++i) {
            t = -2.0 + 0.09999999999 * (double)i;
            double s = s11.spline_value(t);
            System.out.println("x=" + f1.format(t) + ",  f(x)=" + f1.format(s));
        }
        t = s11.integrate();
        System.out.println("integral=" + t);
        System.out.println("expect  =1.183433");
    }
}

