/*
 * Decompiled with CFR 0.152.
 */
package jhplot.stat;

import jhplot.stat.Entropy;
import jhplot.stat.JointProbabilityState;
import jhplot.stat.ProbabilityState;

public abstract class MutualInformation {
    private MutualInformation() {
    }

    public static strictfp double calculateMutualInformation(double[] firstVector, double[] secondVector) {
        JointProbabilityState state = new JointProbabilityState(firstVector, secondVector);
        int numFirstStates = state.firstMaxVal;
        double mutualInformation = 0.0;
        for (Integer key : state.jointProbMap.keySet()) {
            double jointValue = state.jointProbMap.get(key);
            double firstValue = state.firstProbMap.get(key % numFirstStates);
            double secondValue = state.secondProbMap.get(key / numFirstStates);
            if (!(jointValue > 0.0) || !(firstValue > 0.0) || !(secondValue > 0.0)) continue;
            mutualInformation += jointValue * Math.log(jointValue / firstValue / secondValue);
        }
        return mutualInformation /= Math.log(Entropy.LOG_BASE);
    }

    public static double calculateConditionalMutualInformation(double[] firstVector, double[] secondVector, double[] conditionVector) {
        double[] mergedVector = new double[firstVector.length];
        ProbabilityState.mergeArrays(firstVector, conditionVector, mergedVector);
        double firstCondEnt = Entropy.calculateConditionalEntropy(secondVector, conditionVector);
        double secondCondEnt = Entropy.calculateConditionalEntropy(secondVector, mergedVector);
        double answer = firstCondEnt - secondCondEnt;
        return answer;
    }
}

