/*
 * Decompiled with CFR 0.152.
 */
package jhplot.stat;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.text.NumberFormat;
import jhplot.F1D;
import jhplot.P1D;
import jhplot.gui.HelpBrowser;

public class LinReg {
    private double[] x;
    private double[] y;
    private double sumX = 0.0;
    private double sumY = 0.0;
    private double sumXY = 0.0;
    private double sumXsquared = 0.0;
    private double sumYsquared = 0.0;
    private double Sxx;
    private double Sxy;
    private double Syy;
    private double n;
    private double a = 0.0;
    private double b = 0.0;
    private int dataLength;
    private double[][] residual;
    private double maxAbsoluteResidual = 0.0;
    private double SSR = 0.0;
    private double SSE = 0.0;
    private double MSE = 0.0;
    private double sP0 = 0.0;
    private double sP1 = 0.0;
    private double sCorr = 0.0;
    private double minX = Double.POSITIVE_INFINITY;
    private double maxX = Double.NEGATIVE_INFINITY;
    private double minY = Double.POSITIVE_INFINITY;
    private double maxY = Double.NEGATIVE_INFINITY;
    private NumberFormat nf;
    boolean showResidualLines;
    boolean showConfidenceBand = false;
    boolean showPredictionBand = false;
    private static final int CONFIDENCE = 0;
    private static final int PREDICTION = 1;
    private double xRangeLow;
    private double yRangeLow;
    private double xRangeHigh;
    private double yRangeHigh;
    protected boolean autoscaleX = true;
    protected boolean autoscaleY = true;
    static double[] t005 = new double[]{Double.NaN, 63.657, 9.925, 5.841, 4.604, 4.032, 3.707, 3.499, 3.355, 3.25, 3.169, 3.106, 3.055, 3.012, 2.977, 2.947, 2.921, 2.898, 2.878, 2.861, 2.845, 2.831, 2.819, 2.807, 2.797, 2.787, 2.779, 2.771, 2.763, 2.756, 2.756};
    static double[] t025 = new double[]{Double.NaN, 12.706, 4.303, 3.182, 2.776, 2.571, 2.447, 2.365, 2.306, 2.262, 2.228, 2.201, 2.179, 2.16, 2.145, 2.131, 2.12, 2.11, 2.101, 2.093, 2.086, 2.08, 2.075, 2.069, 2.064, 2.06, 2.056, 2.052, 2.048, 2.045, 1.96};

    public LinReg(double[] aX, double[] aY) {
        this.x = aX;
        this.y = aY;
        if (this.x.length != this.y.length) {
            System.out.println("x, y vectors must be of same length");
        } else {
            this.dataLength = this.x.length;
        }
        this.doStatistics();
    }

    public LinReg(P1D aXY) {
        this(aXY.getArrayX(), aXY.getArrayY());
    }

    private void doStatistics() {
        for (int i = 0; i < this.dataLength; ++i) {
            this.minX = Math.min(this.minX, this.x[i]);
            this.maxX = Math.max(this.maxX, this.x[i]);
            this.minY = Math.min(this.minY, this.y[i]);
            this.maxY = Math.max(this.maxY, this.y[i]);
            this.sumX += this.x[i];
            this.sumY += this.y[i];
            this.sumXsquared += this.x[i] * this.x[i];
            this.sumYsquared += this.y[i] * this.y[i];
            this.sumXY += this.x[i] * this.y[i];
        }
        this.n = this.dataLength;
        this.Sxx = this.sumXsquared - this.sumX * this.sumX / this.n;
        this.Syy = this.sumYsquared - this.sumY * this.sumY / this.n;
        this.Sxy = this.sumXY - this.sumX * this.sumY / this.n;
        this.b = this.Sxy / this.Sxx;
        this.a = (this.sumY - this.b * this.sumX) / this.n;
        this.SSR = this.Sxy * this.Sxy / this.Sxx;
        this.SSE = this.Syy - this.SSR;
        this.sCorr = this.Sxy / Math.sqrt(this.Sxx * this.Syy);
        this.MSE = 0.0;
        if (this.n > 2.0) {
            this.MSE = this.SSE / (this.n - 2.0);
        }
        double sMSE = Math.sqrt(this.MSE);
        this.sP0 = sMSE * Math.sqrt(1.0 / this.n + this.getXBar() * this.getXBar() / this.Sxx);
        this.sP1 = sMSE / Math.sqrt(this.Sxx);
        this.xRangeLow = this.getMinX();
        this.yRangeLow = this.getMinY();
        this.xRangeHigh = this.getMaxX();
        this.yRangeHigh = this.getMaxY();
        this.calculateResiduals();
    }

    private void calculateResiduals() {
        this.residual = new double[this.dataLength][];
        this.maxAbsoluteResidual = 0.0;
        for (int i = 0; i < this.dataLength; ++i) {
            this.residual[i] = new double[2];
            this.residual[i][0] = this.x[i];
            this.residual[i][1] = this.y[i] - (this.a + this.b * this.x[i]);
            this.maxAbsoluteResidual = Math.max(this.maxAbsoluteResidual, Math.abs(this.y[i] - (this.a + this.b * this.x[i])));
        }
    }

    private void updateStatistics(double xValue, double yValue) {
        this.n += 1.0;
        this.sumX += xValue;
        this.sumY += yValue;
        this.sumXsquared += xValue * xValue;
        this.sumYsquared += yValue * yValue;
        this.sumXY += xValue * yValue;
        this.n = this.dataLength;
        this.Sxx = this.sumXsquared - this.sumX * this.sumX / this.n;
        this.Syy = this.sumYsquared - this.sumY * this.sumY / this.n;
        this.Sxy = this.sumXY - this.sumX * this.sumY / this.n;
        this.b = this.Sxy / this.Sxx;
        this.a = (this.sumY - this.b * this.sumX) / this.n;
        this.SSR = this.Sxy * this.Sxy / this.Sxx;
        this.SSE = this.Syy - this.SSR;
        this.sCorr = this.Sxy / Math.sqrt(this.Sxx * this.Syy);
        this.MSE = 0.0;
        if (this.n > 2.0) {
            this.MSE = this.SSE / (this.n - 2.0);
        }
        double sMSE = Math.sqrt(this.MSE);
        this.sP0 = sMSE * Math.sqrt(1.0 / this.n + this.getXBar() * this.getXBar() / this.Sxx);
        this.sP1 = sMSE / Math.sqrt(this.Sxx);
        this.xRangeLow = this.getMinX();
        this.yRangeLow = this.getMinY();
        this.xRangeHigh = this.getMaxX();
        this.yRangeHigh = this.getMaxY();
        this.calculateResiduals();
    }

    public void reset() {
        this.x = new double[0];
        this.y = new double[0];
        this.dataLength = 0;
        this.n = 0.0;
        this.residual = new double[0][];
        this.sumX = 0.0;
        this.sumXsquared = 0.0;
        this.sumY = 0.0;
        this.sumYsquared = 0.0;
        this.sumXY = 0.0;
    }

    public double getCorrelation() {
        return this.sCorr;
    }

    public double getIntercept() {
        return this.a;
    }

    public double getInterceptError() {
        return this.sP0;
    }

    public double getSlopeError() {
        return this.sP1;
    }

    public double getSlope() {
        return this.b;
    }

    public P1D getResiduals() {
        P1D p = new P1D("residuals");
        for (int i = 0; i < this.dataLength; ++i) {
            p.add(this.residual[i][0], this.residual[i][1]);
        }
        return p;
    }

    public double[] getDataX() {
        return this.x;
    }

    public double[] getDataY() {
        return this.y;
    }

    public void addPoint(double xValue, double yValue) {
        ++this.dataLength;
        double[] xNew = new double[this.dataLength];
        double[] yNew = new double[this.dataLength];
        System.arraycopy(this.x, 0, xNew, 0, this.dataLength - 1);
        System.arraycopy(this.y, 0, yNew, 0, this.dataLength - 1);
        xNew[this.dataLength - 1] = xValue;
        yNew[this.dataLength - 1] = yValue;
        this.x = xNew;
        this.y = yNew;
        this.updateStatistics(xValue, yValue);
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public double getMaxAbsoluteResidual() {
        return this.maxAbsoluteResidual;
    }

    public double getSxx() {
        return this.Sxx;
    }

    public double getSyy() {
        return this.Syy;
    }

    public double getSSR() {
        return this.SSR;
    }

    public double getSSE() {
        return this.SSE;
    }

    public double getMSE() {
        return this.MSE;
    }

    public double getXBar() {
        return this.sumX / this.n;
    }

    public double getYBar() {
        return this.sumY / this.n;
    }

    public int getDataLength() {
        return this.x.length;
    }

    public double getPearsonR() {
        return this.Sxy / Math.sqrt(this.Sxx * this.Syy);
    }

    public double getSumXSquared() {
        return this.sumXsquared;
    }

    public F1D getResult() {
        F1D tmp = new F1D("p0+(p1*x)", "p0+(p1*x)", this.xRangeLow, this.xRangeHigh, false);
        tmp.setColor(Color.blue);
        tmp.setTitle("p0+(p1*x)");
        tmp.setPar("p0", this.getIntercept());
        tmp.setPar("p1", this.getSlope());
        tmp.parse();
        return tmp;
    }

    public P1D[] getConfidence() {
        return this.getConfidence(Color.magenta);
    }

    public P1D[] getConfidence(Color color) {
        return this.getConfPred(0, 100, color);
    }

    public P1D[] getPrediction() {
        return this.getPrediction(Color.red);
    }

    public P1D[] getPrediction(Color color) {
        return this.getConfPred(1, 100, color);
    }

    private P1D[] getConfPred(int A, int Npoints, Color c) {
        int i;
        P1D[] pp = new P1D[2];
        String s1 = "Confidence level (upper)";
        String s2 = "Confidence level (lower)";
        if (A == 1) {
            s1 = "Prediction (upper)";
            s2 = "Prediction (lower)";
        }
        pp[0] = new P1D(s1);
        pp[1] = new P1D(s2);
        for (int i2 = 0; i2 < pp.length; ++i2) {
            pp[i2].setColor(c);
            pp[i2].setStyle("l");
            pp[i2].setErr(false);
            pp[i2].setDrawSymbol(false);
            pp[i2].setPenDash(5);
        }
        double n = this.x.length;
        double S = Math.sqrt(this.getMSE());
        this.Sxx = this.getSxx();
        double xBar = this.getXBar();
        double t = this.x.length < 32 ? t025[this.x.length - 2] : t025[30];
        double xs = this.xRangeLow;
        double ys = this.a + this.b * xs;
        double sError = S * Math.sqrt((double)A + 1.0 / n + (xs - xBar) * (xs - xBar) / this.Sxx);
        double deltaX = (this.xRangeHigh - this.xRangeLow) / (double)Npoints;
        for (i = 0; i <= Npoints; ++i) {
            pp[0].add(xs, ys + t * sError);
            ys = this.a + this.b * (xs += deltaX);
            sError = S * Math.sqrt((double)A + 1.0 / n + (xs - xBar) * (xs - xBar) / this.Sxx);
        }
        for (i = Npoints; i >= 0; --i) {
            ys = this.a + this.b * (xs -= deltaX);
            sError = S * Math.sqrt((double)A + 1.0 / n + (xs - xBar) * (xs - xBar) / this.Sxx);
            pp[1].add(xs, ys - t * sError);
        }
        return pp;
    }

    public P1D getConfidenceBand(Color color, double transparency) {
        return this.getConfidenceBand(100, color, transparency);
    }

    public P1D getConfidenceBand(int Npoints, Color color, double transparency) {
        P1D pp = new P1D("Confidence band");
        pp.setColor(color);
        pp.setSymbolSize(1);
        double n = this.x.length;
        double S = Math.sqrt(this.getMSE());
        this.Sxx = this.getSxx();
        double xBar = this.getXBar();
        double t = this.x.length < 32 ? t025[this.x.length - 2] : t025[30];
        double xs = this.xRangeLow;
        double ys = this.a + this.b * xs;
        double sError = S * Math.sqrt(1.0 / n + (xs - xBar) * (xs - xBar) / this.Sxx);
        double deltaX = (this.xRangeHigh - this.xRangeLow) / (double)Npoints;
        for (int i = 0; i <= Npoints; ++i) {
            pp.add(xs, ys, t * sError);
            ys = this.a + this.b * (xs += deltaX);
            sError = S * Math.sqrt(1.0 / n + (xs - xBar) * (xs - xBar) / this.Sxx);
        }
        return pp;
    }

    public P1D getPredictionBand() {
        return this.getPredictionBand(50, Color.green, 1.0);
    }

    public P1D getPredictionBand(Color color) {
        return this.getPredictionBand(50, color, 1.0);
    }

    public P1D getPredictionBand(Color color, double transparency) {
        return this.getPredictionBand(50, color, transparency);
    }

    public P1D getPredictionBand(int Npoints, Color color, double transparency) {
        P1D pp = new P1D("Prediction band");
        pp.setColor(color);
        pp.setSymbolSize(1);
        double n = this.x.length;
        double S = Math.sqrt(this.getMSE());
        this.Sxx = this.getSxx();
        double xBar = this.getXBar();
        double t = this.x.length < 32 ? t025[this.x.length - 2] : t025[30];
        double xs = this.xRangeLow;
        double ys = this.a + this.b * xs;
        double sError = S * Math.sqrt(1.0 + 1.0 / n + (xs - xBar) * (xs - xBar) / this.Sxx);
        double deltaX = (this.xRangeHigh - this.xRangeLow) / (double)Npoints;
        for (int i = 0; i <= Npoints; ++i) {
            pp.add(xs, ys, t * sError);
            ys = this.a + this.b * (xs += deltaX);
            sError = S * Math.sqrt(1.0 + 1.0 / n + (xs - xBar) * (xs - xBar) / this.Sxx);
        }
        return pp;
    }

    private int scaleX(double a) {
        return (int)a;
    }

    private int scaleY(double a) {
        return (int)a;
    }

    private void showConf(Graphics g) {
        this.nf = NumberFormat.getNumberInstance();
        this.nf.setMaximumFractionDigits(3);
        int iy = 0;
        this.xRangeLow = this.getMinX();
        this.yRangeLow = this.getMinY();
        this.xRangeHigh = this.getMaxX();
        this.yRangeHigh = this.getMaxY();
        for (int i = 0; i < this.dataLength; ++i) {
            int ix = this.scaleX(this.x[i]);
            iy = this.scaleY(this.y[i]);
            g.fillOval(ix - 3, iy - 3, 6, 6);
        }
        if (this.showResidualLines) {
            g.setColor(Color.blue);
            g.drawLine(this.scaleX(this.xRangeLow), this.scaleY(this.yRangeLow), this.scaleX(this.xRangeHigh), this.scaleY(this.yRangeHigh));
        }
        g.setColor(Color.red);
        if (this.dataLength > 1) {
            g.drawLine(this.scaleX(this.xRangeLow), this.scaleY(this.b * this.xRangeLow + this.a), this.scaleX(this.xRangeHigh), this.scaleY(this.b * this.xRangeHigh + this.a));
        }
        if (this.showConfidenceBand && this.x.length > 2) {
            this.drawBand(g, 0);
        }
        if (this.showPredictionBand && this.x.length > 2) {
            this.drawBand(g, 1);
        }
    }

    private void drawBand(Graphics g, int type) {
        int i;
        Color bandColor;
        double A;
        double n = this.x.length;
        double S = Math.sqrt(this.getMSE());
        Graphics2D g2d = (Graphics2D)g;
        this.Sxx = this.getSxx();
        double xBar = this.getXBar();
        double t = this.x.length < 32 ? t025[this.x.length - 2] : t025[30];
        if (type == 0) {
            A = 0.0;
            bandColor = new Color(100, 0, 0);
        } else {
            A = 1.0;
            bandColor = new Color(0, 0, 100);
        }
        double xs = this.xRangeLow;
        double ys = this.a + this.b * xs;
        double sError = S * Math.sqrt(A + 1.0 / n + (xs - xBar) * (xs - xBar) / this.Sxx);
        double deltaX = (this.xRangeHigh - this.xRangeLow) / 10.0;
        for (i = 1; i <= 10; ++i) {
            ys = this.a + this.b * (xs += deltaX);
            sError = S * Math.sqrt(A + 1.0 / n + (xs - xBar) * (xs - xBar) / this.Sxx);
        }
        for (i = 9; i >= 0; --i) {
            ys = this.a + this.b * (xs -= deltaX);
            sError = S * Math.sqrt(A + 1.0 / n + (xs - xBar) * (xs - xBar) / this.Sxx);
        }
        g2d.setPaint(Color.gray);
        g2d.setPaint(bandColor);
        AlphaComposite c = AlphaComposite.getInstance(3, 0.2f);
        g2d.setComposite(c);
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }
}

